/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.impl;

import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.ee.IRS1095B;
import gov.va.med.esr.common.model.ee.MECPeriod;
import gov.va.med.esr.common.model.lookup.TransmissionStatus;
import gov.va.med.esr.common.model.messaging.IrsTransmissionLogData;
import gov.va.med.esr.common.model.messaging.IrsTransmissionLogDetailEntry;
import gov.va.med.esr.common.model.messaging.IrsTransmissionLogEntry;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKeyImpl;
import gov.va.med.esr.common.persistent.messaging.IrsTransmissionLogDetailEntryDAO;
import gov.va.med.esr.common.persistent.messaging.IrsTransmissionLogEntryDAO;
import gov.va.med.esr.common.persistent.person.MECPeriodDAO;
import gov.va.med.esr.service.CommsEmailBulletinService;
import gov.va.med.esr.service.IRSTransmissionService;
import gov.va.med.esr.service.IRSWebServiceDelegate;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.PersonService;
import gov.va.med.esr.service.SystemParameterService;
import gov.va.med.esr.service.UnknownLookupCodeException;
import gov.va.med.esr.service.UnknownLookupTypeException;
import gov.va.med.esr.service.trigger.BulletinTrigger;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.ServiceException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.hibernate.Hibernate;
import org.springframework.transaction.annotation.Transactional;

public class IRSTransmissionServiceImpl
extends AbstractComponent
implements IRSTransmissionService {
    private static final long serialVersionUID = 8534341803323475694L;
    private static final String SUBMIT_ORIGINAL = "O";
    private static final String SUBMIT_CORRECTION = "C";
    private static final String SUBMIT_REPLACEMENT = "R";
    private static final String SUBMIT_REJECTED = "Rejected";
    private static final String VETERANS_TYPE = "V";
    private static final String BENE_TYPE = "B";
    private static final String IRS_ACK_EXPIRE = "IRS Ack Expiration";
    private static final String POSITION = "1";
    private static final String APP_ID = "SYS12";
    private static final String TYPE_CODE = "T";
    private static final String DELIM = "|";
    private static final String NO_RECEIPT = "No Receipt ID Provided in Submission Response";
    private static final String NO_ACK = "Acknowledgement of IRS Processing Never Received";
    private SystemParameterService systemParameterService = null;
    private IRSWebServiceDelegate irsServiceDelegate = null;
    private LookupService lookupService = null;
    private IrsTransmissionLogEntryDAO irsTransmissionLogEntryDAO = null;
    private IrsTransmissionLogDetailEntryDAO irsTransmissionLogDetailEntryDAO = null;
    private MECPeriodDAO mecPeriodDAO = null;
    private PersonService personService = null;
    private CommsEmailBulletinService bulletinService = null;
    private String transmissionControlCode = null;

    @Override
    public void sendSubmit(ArrayList<IRS1095B> batch, String batchType, String correctionInd, String taxYear) throws ServiceException {
        if (taxYear == null) {
            Calendar prevYear = Calendar.getInstance();
            prevYear.add(1, -1);
            taxYear = Integer.toString(prevYear.get(1));
        }
        try {
            if (correctionInd == null || SUBMIT_ORIGINAL.equalsIgnoreCase(correctionInd)) {
                this.processOriginal(batch, batchType, taxYear);
            } else if (SUBMIT_CORRECTION.equalsIgnoreCase(correctionInd) || SUBMIT_REPLACEMENT.equalsIgnoreCase(correctionInd)) {
                this.processCorrectReplace(batch, batchType, taxYear, correctionInd);
            } else {
                this.logger.error((Object)"Failed to submit IRS batch transmission due to invalid Correction Indicator");
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)("ERROR in IRS Submission for batchType:" + batchType + " ,size: " + batch.size() + " , correctionInd: " + correctionInd + ex));
            ex.printStackTrace();
        }
    }

    @Override
    public void submitCustomFile(String xmlFile, String correctionInd) {
        IrsTransmissionLogDetailEntry cur = new IrsTransmissionLogDetailEntry();
        try {
            ArrayList<IRS1095B> listing = new ArrayList();
            listing = this.getIrsServiceDelegate().convertAllEntries(xmlFile);
            Calendar prevYear = Calendar.getInstance();
            prevYear.add(1, -1);
            String taxYear = Integer.toString(prevYear.get(1));
            IrsTransmissionLogData dataFile = new IrsTransmissionLogData();
            dataFile.setRequestData(xmlFile);
            IrsTransmissionLogEntry entry = this.buildLogEntry(listing, dataFile, "M", taxYear, correctionInd, null);
            this.getIrsTransmissionLogEntryDAO().insertObject((Object)entry);
            this.getIrsTransmissionLogEntryDAO().flush();
            this.handleTransmit(entry, false, null);
        }
        catch (DAOException e) {
            this.logger.error((Object)("Error processing IRS Manual File entry " + (Object)((Object)e)));
        }
        catch (ServiceException ex) {
            this.logger.error((Object)("Error processing IRS Manual File entry" + (Object)((Object)ex)));
        }
    }

    @Override
    @Transactional
    public void requestAcknowledgment(String receiptId) throws ServiceException {
        this.logger.debug((Object)("requesting IRS ack for receiptId:" + receiptId));
        int batchSize = 0;
        try {
            IrsTransmissionLogEntry original = this.getIrsTransmissionLogEntryDAO().getByReceiptId(receiptId);
            if (original != null) {
                Hibernate.initialize(original.getIrsTransmissionLogDetails());
                Hibernate.initialize(original.getIrsTransmissionLogData());
                this.getIrsServiceDelegate().requestProcessingStatus(original);
                if (this.isExpired(original)) {
                    batchSize = original.getIrsTransmissionLogDetails().size();
                    original.setTransmissionStatus((TransmissionStatus)this.lookupService.getByCode(TransmissionStatus.class, TransmissionStatus.EXPIRED.getCode()));
                    original.setErrorDescription(NO_ACK);
                    this.sendNotifyAckExpired(batchSize);
                }
                this.getIrsTransmissionLogEntryDAO().saveObject((Object)original);
                this.getIrsTransmissionLogEntryDAO().flush();
            } else {
                this.logger.error((Object)("Could not find ReceiptID for requested IRS ack:" + receiptId));
            }
        }
        catch (DAOException e) {
            this.logger.error((Object)("Failed to retrieve transmission by receipt Id for receipt:" + receiptId + ", message: " + (Object)((Object)e)));
        }
        catch (ServiceException ex) {
            this.logger.error((Object)("Service Excpetion during IRS acknowledgement request for receipt:" + receiptId + " , message: " + (Object)((Object)ex)));
        }
    }

    private boolean isExpired(IrsTransmissionLogEntry original) {
        boolean expired = false;
        try {
            if (original.getTransmissionStatus().getCode().equals(TransmissionStatus.PROCESSING.getCode())) {
                int expirationHours = Integer.valueOf(this.getSystemParameterService().getByName(IRS_ACK_EXPIRE).getValue());
                Calendar expirationDate = Calendar.getInstance();
                expirationDate.setTime(original.getTransmissionDate());
                expirationDate.add(10, expirationHours);
                Calendar now = Calendar.getInstance();
                if (now.after(expirationDate)) {
                    expired = true;
                }
            }
        }
        catch (ServiceException e) {
            this.logger.error((Object)("Exception checking log entry expiration: " + (Object)((Object)e)));
        }
        return expired;
    }

    @Override
    @Transactional
    public void retransmitFailedSubmission(BigDecimal identifier) throws ServiceException {
        try {
            IrsTransmissionLogEntry transmission = this.getIrsTransmissionLogEntryDAO().getById(identifier);
            Hibernate.initialize(transmission.getIrsTransmissionLogDetails());
            Hibernate.initialize(transmission.getIrsTransmissionLogData());
            if (transmission != null) {
                transmission.setAckDate(null);
                transmission.setAckId(null);
                transmission.setErrorDescription(null);
                transmission.setTransmissionDate(new Date());
                transmission.setTransmissionStatus((TransmissionStatus)this.lookupService.getByCode(TransmissionStatus.class, TransmissionStatus.PROCESSING.getCode()));
                if (transmission.getReceiptId() != null && transmission.getReceiptId().length() > 0) {
                    transmission.setCorrectionInd(SUBMIT_REPLACEMENT);
                    this.getIrsTransmissionLogEntryDAO().saveObject((Object)transmission);
                    this.handleTransmit(transmission, true, transmission.getReceiptId());
                } else {
                    transmission.setCorrectionInd(SUBMIT_ORIGINAL);
                    this.getIrsTransmissionLogEntryDAO().saveObject((Object)transmission);
                    this.handleTransmit(transmission, true, null);
                }
            }
        }
        catch (DAOException e) {
            this.logger.error((Object)("Unexpected Error in IRS batch retransmission:" + e.getMessage()));
        }
    }

    @Override
    @Transactional
    public void retransmitFailedPersonSubmission(BigDecimal identifier) throws ServiceException {
        try {
            IrsTransmissionLogDetailEntry prevTransmission = this.getIrsTransmissionLogDetailEntryDAO().getById(identifier);
            if (prevTransmission != null) {
                Hibernate.initialize(prevTransmission.getBatchTransmissionEntry().getIrsTransmissionLogData());
                String originalReceipt = this.getUniqueId(prevTransmission);
                IRS1095B prevSubmission = this.getIrsServiceDelegate().convertSingleEntry(prevTransmission.getBatchTransmissionEntry().getIrsTransmissionLogData().iterator().next(), prevTransmission.getRecordSequence());
                if (prevSubmission != null) {
                    Person onFile = this.getPersonService().getPerson(CommonEntityKeyFactory.createPersonIdEntityKey(prevTransmission.getPersonId()));
                    IRS1095B newSubmission = new IRS1095B(onFile);
                    newSubmission.setMecPeriod(prevSubmission.getMecPeriod());
                    ArrayList<IRS1095B> ls = new ArrayList<IRS1095B>();
                    ArrayList<IRS1095B> errorList = new ArrayList<IRS1095B>();
                    ls.add(newSubmission);
                    IrsTransmissionLogData dataFile = this.getIrsServiceDelegate().buildRequestDataFile(ls, SUBMIT_CORRECTION, prevTransmission.getBatchTransmissionEntry().getTaxYear(), originalReceipt, errorList);
                    IrsTransmissionLogEntry entry = this.buildLogEntry(ls, dataFile, VETERANS_TYPE, prevTransmission.getBatchTransmissionEntry().getTaxYear(), SUBMIT_CORRECTION, errorList);
                    this.getIrsTransmissionLogEntryDAO().insertObject((Object)entry);
                    this.getIrsTransmissionLogEntryDAO().flush();
                    this.handleTransmit(entry, false, originalReceipt);
                } else {
                    this.logger.error((Object)("No previous Entry found to retransmit detail entry:" + identifier.toString()));
                }
            }
        }
        catch (DAOException e) {
            this.logger.error((Object)("Unexepected Error in Retransmit IRS Person Record:" + e.getMessage()));
        }
    }

    private String getUniqueId(IrsTransmissionLogDetailEntry transmission) {
        int sequence = transmission.getRecordSequence();
        String receiptId = transmission.getBatchTransmissionEntry().getReceiptId();
        String originalReceipt = receiptId + DELIM + POSITION + DELIM + Integer.toString(sequence);
        return originalReceipt;
    }

    private void processOriginal(ArrayList<IRS1095B> batch, String batchType, String taxYear) throws ServiceException {
        IrsTransmissionLogDetailEntry cur = new IrsTransmissionLogDetailEntry();
        ArrayList<IRS1095B> errorList = new ArrayList<IRS1095B>();
        try {
            IrsTransmissionLogData dataFile = this.getIrsServiceDelegate().buildRequestDataFile(batch, SUBMIT_ORIGINAL, taxYear, null, errorList);
            IrsTransmissionLogEntry entry = this.buildLogEntry(batch, dataFile, batchType, taxYear, SUBMIT_ORIGINAL, errorList);
            this.getIrsTransmissionLogEntryDAO().insertObject((Object)entry);
            this.getIrsTransmissionLogEntryDAO().flush();
            this.handleTransmit(entry, false, null);
        }
        catch (DAOException e) {
            this.logger.error((Object)("Error processing IRS Correction entry " + (Object)((Object)e)));
        }
        catch (ServiceException ex) {
            this.logger.error((Object)("Error processing IRS Correction entry" + (Object)((Object)ex)));
        }
    }

    private IrsTransmissionLogEntry buildLogEntry(ArrayList<IRS1095B> batch, IrsTransmissionLogData dataFile, String batchType, String taxYear, String correctionInd, ArrayList<IRS1095B> errorList) throws UnknownLookupTypeException, UnknownLookupCodeException {
        IRS1095B l;
        int i;
        if (errorList != null && errorList.size() > 0) {
            try {
                IrsTransmissionLogEntry errEntry = new IrsTransmissionLogEntry();
                HashSet<IrsTransmissionLogDetailEntry> errDetails = new HashSet<IrsTransmissionLogDetailEntry>();
                for (i = 0; i < errorList.size(); ++i) {
                    l = errorList.get(i);
                    IrsTransmissionLogDetailEntry errDetail = new IrsTransmissionLogDetailEntry();
                    errDetail.setIen(l.getIEN());
                    if (batchType.equalsIgnoreCase(VETERANS_TYPE)) {
                        try {
                            errDetail.setPersonId((BigDecimal)this.getPersonService().getPersonIdByVPID(CommonEntityKeyFactory.createVPIDEntityKey(l.getIEN())).getKeyValue());
                        }
                        catch (Exception e) {
                            this.logger.error((Object)("failed to retrieve person key by vpid for icn: " + l.getIEN()));
                            errDetail.setPersonId(null);
                        }
                    }
                    errDetail.setIen(l.getIEN());
                    if (l.getIEN() == null || l.getIEN().isEmpty()) {
                        if (l.getSSN() != null && !l.getSSN().isEmpty()) {
                            errDetail.setIen(l.getSSN());
                        } else {
                            errDetail.setIen(l.getDOB());
                        }
                    }
                    errDetail.setRecordSequence(i + 1);
                    errDetail.setBatchTransmissionEntry(errEntry);
                    if (l.getErrorText() != null) {
                        if (l.getErrorText().length() > 900) {
                            errDetail.setErrorDescription(l.getErrorText().substring(0, 900));
                        } else {
                            errDetail.setErrorDescription(l.getErrorText());
                        }
                    } else {
                        errDetail.setErrorDescription("Unknown Error");
                    }
                    errDetails.add(errDetail);
                }
                errEntry.setIrsTransmissionLogDetails(errDetails);
                errEntry.setBatchTypeInd(batchType);
                errEntry.setCorrectionInd(correctionInd);
                errEntry.setTaxYear(taxYear);
                errEntry.setTransmissionDate(new Date());
                errEntry.setTransmissionStatus((TransmissionStatus)this.lookupService.getByCode(TransmissionStatus.class, TransmissionStatus.ACCEPTED_WITH_ERRORS.getCode()));
                errEntry.setErrorDescription("ES Records Cannot be Transmitted due to Internal Errors");
                this.getIrsTransmissionLogEntryDAO().saveObject((Object)errEntry);
            }
            catch (Exception ex) {
                this.logger.error((Object)ex.getMessage());
            }
        }
        IrsTransmissionLogEntry entry = new IrsTransmissionLogEntry();
        dataFile.setBatchTransmissionEntry(entry);
        HashSet<IrsTransmissionLogDetailEntry> details = new HashSet<IrsTransmissionLogDetailEntry>();
        for (i = 0; i < batch.size(); ++i) {
            l = batch.get(i);
            IrsTransmissionLogDetailEntry detail = new IrsTransmissionLogDetailEntry();
            detail.setIen(l.getIEN());
            if (batchType.equalsIgnoreCase(VETERANS_TYPE)) {
                try {
                    detail.setPersonId((BigDecimal)this.getPersonService().getPersonIdByVPID(CommonEntityKeyFactory.createVPIDEntityKey(l.getIEN())).getKeyValue());
                }
                catch (Exception e) {
                    this.logger.error((Object)("failed to retrieve person key by vpid for icn: " + l.getIEN()));
                    detail.setPersonId(null);
                }
            }
            detail.setIen(l.getIEN());
            if (l.getIEN() == null || l.getIEN().isEmpty()) {
                if (l.getSSN() != null && !l.getSSN().isEmpty()) {
                    detail.setIen(l.getSSN());
                } else {
                    detail.setIen(l.getDOB());
                }
            }
            detail.setRecordSequence(i + 1);
            detail.setBatchTransmissionEntry(entry);
            details.add(detail);
        }
        HashSet<IrsTransmissionLogData> data = new HashSet<IrsTransmissionLogData>();
        data.add(dataFile);
        entry.setIrsTransmissionLogDetails(details);
        entry.setIrsTransmissionLogData(data);
        entry.setBatchTypeInd(batchType);
        entry.setCorrectionInd(correctionInd);
        entry.setTaxYear(taxYear);
        entry.setTransmissionDate(new Date());
        entry.setTransmissionStatus((TransmissionStatus)this.lookupService.getByCode(TransmissionStatus.class, TransmissionStatus.PROCESSING.getCode()));
        return entry;
    }

    private void processCorrectReplace(ArrayList<IRS1095B> batch, String batchType, String taxYear, String correctionInd) {
        IrsTransmissionLogDetailEntry cur = new IrsTransmissionLogDetailEntry();
        String originalReceipt = null;
        ArrayList<IRS1095B> errorList = new ArrayList<IRS1095B>();
        if (batch != null && batch.size() == 1) {
            IRS1095B l = batch.get(0);
            try {
                cur = this.getIrsTransmissionLogDetailEntryDAO().findOriginalForYear(l.getIEN(), taxYear);
                if (correctionInd.equalsIgnoreCase(SUBMIT_CORRECTION) && batchType.equalsIgnoreCase(VETERANS_TYPE)) {
                    PersonIdEntityKeyImpl key = new PersonIdEntityKeyImpl(cur.getPersonId());
                    cur = this.getMostRecentTransmissionForYear(key, taxYear, false);
                }
                if (cur != null) {
                    if (cur.getBatchTransmissionEntry().getReceiptId() == null || cur.getBatchTransmissionEntry().getReceiptId().isEmpty()) {
                        correctionInd = SUBMIT_ORIGINAL;
                    } else {
                        originalReceipt = this.getUniqueId(cur);
                    }
                    IrsTransmissionLogData dataFile = this.getIrsServiceDelegate().buildRequestDataFile(batch, correctionInd, taxYear, originalReceipt, errorList);
                    IrsTransmissionLogEntry entry = this.buildLogEntry(batch, dataFile, batchType, taxYear, correctionInd, errorList);
                    this.getIrsTransmissionLogEntryDAO().insertObject((Object)entry);
                    this.getIrsTransmissionLogEntryDAO().flush();
                    this.handleTransmit(entry, false, originalReceipt);
                } else {
                    this.logger.error((Object)("No Entry found for allowable correction submission for IEN  and year:" + taxYear));
                }
            }
            catch (DAOException e) {
                this.logger.error((Object)("Error processing IRS Correction/Replacement entry " + (Object)((Object)e)));
            }
            catch (ServiceException ex) {
                this.logger.error((Object)("Error processing IRS Correction/Replacement entry" + (Object)((Object)ex)));
            }
        }
    }

    @Override
    public MECPeriod combineAllPeriods(BigDecimal personId, int calYear) {
        MECPeriod period = new MECPeriod();
        period.setPersonId(personId);
        HashMap coverageMap = new HashMap();
        SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy");
        Calendar cal = Calendar.getInstance();
        Calendar year = Calendar.getInstance();
        year.set(1, calYear);
        String calendarYear = Integer.toString(year.get(1));
        try {
            List allPeriods = this.getMecPeriodDAO().getByPersonId(personId);
            Calendar start = Calendar.getInstance();
            start.clear();
            start.set(1, Integer.valueOf(calendarYear));
            start.set(2, 0);
            start.set(5, 1);
            Calendar nextTaxYear = Calendar.getInstance();
            nextTaxYear.clear();
            nextTaxYear.set(1, Integer.valueOf(calendarYear) + 1);
            nextTaxYear.set(2, 0);
            nextTaxYear.set(5, 1);
            boolean notEnded = false;
            if (allPeriods != null) {
                for (int i = 0; i < allPeriods.size(); ++i) {
                    int monthEnd;
                    int monthStart;
                    MECPeriod partial = (MECPeriod)((Object)allPeriods.get(i));
                    if (partial.getMecEndDate() != null && partial.getMecEndDate().before(start.getTime()) || partial.getMecStartDate() != null && partial.getMecStartDate().after(nextTaxYear.getTime()) || partial.getMecEndDate() != null && partial.getMecEndDate().before(partial.getMecStartDate())) continue;
                    if (partial.getMecStartDate().before(start.getTime()) && partial.getMecEndDate() == null) {
                        period.setCoveredAll12Months(true);
                        period.setCoverageMonths(this.completeMap());
                        if (period.getMecStartDate() == null) {
                            period.setMecStartDate(partial.getMecStartDate());
                        } else if (partial.getMecStartDate().before(period.getMecStartDate())) {
                            period.setMecStartDate(partial.getMecStartDate());
                        }
                        period.setMecEndDate(null);
                        break;
                    }
                    if (partial.getMecStartDate().before(start.getTime())) {
                        cal.setTime(partial.getMecStartDate());
                        monthStart = 1;
                        if (partial.getMecEndDate() == null || partial.getMecEndDate().after(nextTaxYear.getTime())) {
                            monthEnd = 12;
                        } else {
                            cal.setTime(partial.getMecEndDate());
                            monthEnd = cal.get(2) + 1;
                        }
                        if (period.getMecStartDate() == null) {
                            period.setMecStartDate(partial.getMecStartDate());
                        } else if (partial.getMecStartDate().before(period.getMecStartDate())) {
                            period.setMecStartDate(partial.getMecStartDate());
                        }
                        if (period.getMecEndDate() == null) {
                            period.setMecEndDate(partial.getMecEndDate());
                        } else if (partial.getMecEndDate().after(period.getMecEndDate())) {
                            period.setMecEndDate(partial.getMecEndDate());
                        }
                        this.buildMap(monthStart, monthEnd, coverageMap);
                        continue;
                    }
                    cal.setTime(partial.getMecStartDate());
                    monthStart = cal.get(2) + 1;
                    if (partial.getMecEndDate() == null || partial.getMecEndDate().after(nextTaxYear.getTime())) {
                        monthEnd = 12;
                    } else {
                        cal.setTime(partial.getMecEndDate());
                        monthEnd = cal.get(2) + 1;
                    }
                    if (period.getMecStartDate() == null) {
                        period.setMecStartDate(partial.getMecStartDate());
                    } else if (partial.getMecStartDate().before(period.getMecStartDate())) {
                        period.setMecStartDate(partial.getMecStartDate());
                    }
                    if (partial.getMecEndDate() != null) {
                        if (period.getMecEndDate() == null) {
                            period.setMecEndDate(partial.getMecEndDate());
                        } else if (partial.getMecEndDate().after(period.getMecEndDate())) {
                            period.setMecEndDate(partial.getMecEndDate());
                        }
                    } else {
                        notEnded = true;
                    }
                    this.buildMap(monthStart, monthEnd, coverageMap);
                }
            }
            if (notEnded) {
                period.setMecEndDate(null);
            }
            boolean all = true;
            for (int i = 1; i <= 12; ++i) {
                if (coverageMap.containsKey(Integer.toString(i))) continue;
                all = false;
            }
            if (all) {
                period.setCoveredAll12Months(true);
            }
            period.setCoverageMonths(coverageMap);
        }
        catch (Exception ex) {
            this.logger.error((Object)("GenerateIRSSubmitProcess Failed to combine MECPeriods for person: " + personId + " reason:" + ex.getMessage()));
        }
        return period;
    }

    @Override
    public List<MECPeriod> getAllPeriods(BigDecimal personId) {
        List allPeriods = null;
        try {
            allPeriods = this.getMecPeriodDAO().getByPersonId(personId);
        }
        catch (Exception ex) {
            this.logger.error((Object)ex.getMessage());
        }
        return allPeriods;
    }

    @Override
    public MECPeriod combineAllPeriods(BigDecimal personId) {
        MECPeriod period = new MECPeriod();
        period.setPersonId(personId);
        SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy");
        boolean notEnded = false;
        try {
            List allPeriods = this.getMecPeriodDAO().getByPersonId(personId);
            if (allPeriods != null) {
                for (int i = 0; i < allPeriods.size(); ++i) {
                    MECPeriod partial = (MECPeriod)((Object)allPeriods.get(i));
                    if (partial.getMecEndDate() == null) {
                        notEnded = true;
                    }
                    if (period.getMecStartDate() == null) {
                        period.setMecStartDate(partial.getMecStartDate());
                    } else if (partial.getMecStartDate().before(period.getMecStartDate())) {
                        period.setMecStartDate(partial.getMecStartDate());
                    }
                    if (period.getMecEndDate() == null) {
                        period.setMecEndDate(partial.getMecEndDate());
                        continue;
                    }
                    if (partial.getMecEndDate() == null || !partial.getMecEndDate().after(period.getMecEndDate())) continue;
                    period.setMecEndDate(partial.getMecEndDate());
                }
            }
            if (notEnded) {
                period.setMecEndDate(null);
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)("combine periods Failed to combine MECPeriods for person: " + personId + " reason:" + ex.getMessage()));
        }
        return period;
    }

    private void buildMap(int start, int end, HashMap coverageMap) {
        for (int i = start; i <= end; ++i) {
            coverageMap.put(Integer.toString(i), true);
        }
    }

    private HashMap completeMap() {
        HashMap<String, Boolean> fullYear = new HashMap<String, Boolean>();
        for (int i = 1; i <= 12; ++i) {
            fullYear.put(Integer.toString(i), true);
        }
        return fullYear;
    }

    private void handleTransmit(IrsTransmissionLogEntry transmission, boolean entireBatch, String originalReceipt) throws UnknownLookupTypeException, UnknownLookupCodeException {
        String receiptId = null;
        String status = null;
        String errMsg = null;
        String responseMsg = null;
        try {
            responseMsg = transmission.getCorrectionInd().equalsIgnoreCase(SUBMIT_REPLACEMENT) || entireBatch ? this.getIrsServiceDelegate().retransmitBatchSubmission(transmission, originalReceipt) : (transmission.getCorrectionInd().equalsIgnoreCase(SUBMIT_CORRECTION) ? this.getIrsServiceDelegate().retransmitPersonSubmission(transmission, originalReceipt) : this.getIrsServiceDelegate().transmitOriginal(transmission));
            if (responseMsg != null) {
                String[] values = responseMsg.split("\\^");
                receiptId = values[0];
                if (values != null && values.length > 1) {
                    status = values[1];
                }
                if (values != null && values.length > 2) {
                    errMsg = values[2];
                }
            } else {
                transmission.setTransmissionStatus((TransmissionStatus)this.lookupService.getByCode(TransmissionStatus.class, TransmissionStatus.FAILED.getCode()));
                transmission.setErrorDescription(NO_RECEIPT);
                this.sendNotifySubmissionFailed(transmission.getIrsTransmissionLogDetails().size());
                throw new ServiceException("Transmit Returned with NULL response");
            }
            if (receiptId != null && receiptId.length() > 0) {
                if (!transmission.getCorrectionInd().equalsIgnoreCase(SUBMIT_REPLACEMENT)) {
                    transmission.setReceiptId(receiptId);
                }
                if (status != null && status.equalsIgnoreCase(SUBMIT_REJECTED)) {
                    transmission.setTransmissionStatus((TransmissionStatus)this.lookupService.getByCode(TransmissionStatus.class, TransmissionStatus.REJECTED.getCode()));
                    transmission.setErrorDescription(errMsg);
                    this.sendNotifySubmissionFailed(transmission.getIrsTransmissionLogDetails().size());
                }
            } else {
                transmission.setTransmissionStatus((TransmissionStatus)this.lookupService.getByCode(TransmissionStatus.class, TransmissionStatus.FAILED.getCode()));
                transmission.setErrorDescription(NO_RECEIPT);
                this.sendNotifySubmissionFailed(transmission.getIrsTransmissionLogDetails().size());
            }
        }
        catch (ServiceException e) {
            transmission.setTransmissionStatus((TransmissionStatus)this.lookupService.getByCode(TransmissionStatus.class, TransmissionStatus.FAILED.getCode()));
            transmission.setErrorDescription(e.getMessage());
            this.sendNotifySubmissionFailed(transmission.getIrsTransmissionLogDetails().size());
        }
        try {
            this.getIrsTransmissionLogEntryDAO().saveObject((Object)transmission);
            this.getIrsTransmissionLogEntryDAO().flush();
        }
        catch (DAOException e) {
            this.logger.error((Object)("Error saving IRS Log entry:" + (Object)((Object)e)));
        }
    }

    private void sendNotifySubmissionFailed(int size) {
        this.logger.debug((Object)("in sendNotifySubmissionFailed() size: " + size));
        CommsEmailBulletinService emailSrv = this.getBulletinService();
        HashMap<String, Integer> bulletinData = new HashMap<String, Integer>();
        bulletinData.put("RecordCount", size);
        try {
            emailSrv.sendEmailBulletin(BulletinTrigger.DataType.IRS_SUBMISSION_FAILURE, bulletinData, null);
        }
        catch (ServiceException ex) {
            this.logger.error((Object)("sendNotifySubmissionFailed - cannot send email notification" + ex.getMessage()));
        }
    }

    private void sendNotifyAckExpired(int size) {
        this.logger.debug((Object)("in sendNotifyAckExpired() size: " + size));
        CommsEmailBulletinService emailSrv = this.getBulletinService();
        HashMap<String, Integer> bulletinData = new HashMap<String, Integer>();
        bulletinData.put("RecordCount", size);
        try {
            emailSrv.sendEmailBulletin(BulletinTrigger.DataType.IRS_ACKNOWLEDGEMENT_EXPIRY, bulletinData, null);
        }
        catch (ServiceException ex) {
            this.logger.error((Object)("sendNotifyAckExpired - cannot send email notification" + ex.getMessage()));
        }
    }

    @Override
    @Transactional
    public List getTransmissionsByPersonId(PersonEntityKey personID) throws ServiceException {
        List<Object> ls = new ArrayList();
        try {
            ls = this.getIrsTransmissionLogDetailEntryDAO().findByPersonId((EntityKey)personID);
            if (ls != null) {
                for (IrsTransmissionLogDetailEntry irsTransmissionLogDetailEntry : ls) {
                    Hibernate.initialize(irsTransmissionLogDetailEntry.getBatchTransmissionEntry().getIrsTransmissionLogData());
                    IrsTransmissionLogData dataEntry = null;
                    if (irsTransmissionLogDetailEntry.getBatchTransmissionEntry().getIrsTransmissionLogData() != null && irsTransmissionLogDetailEntry.getBatchTransmissionEntry().getIrsTransmissionLogData().iterator().hasNext()) {
                        dataEntry = irsTransmissionLogDetailEntry.getBatchTransmissionEntry().getIrsTransmissionLogData().iterator().next();
                        irsTransmissionLogDetailEntry.setSubmittedData(this.getIrsServiceDelegate().convertSingleEntry(dataEntry, irsTransmissionLogDetailEntry.getRecordSequence()));
                        dataEntry = null;
                        continue;
                    }
                    irsTransmissionLogDetailEntry.setSubmittedData(new IRS1095B());
                }
            }
        }
        catch (DAOException e) {
            this.logger.error((Object)("Faile to retreive IRS transmissions for person:" + personID.getKeyValueAsString() + (Object)((Object)e)));
        }
        return ls;
    }

    @Override
    @Transactional
    public IrsTransmissionLogDetailEntry getMostRecentTransmissionForYear(PersonEntityKey personId, String taxYear, boolean dataRequired) {
        IrsTransmissionLogDetailEntry result = null;
        try {
            result = this.getIrsTransmissionLogDetailEntryDAO().findMostRecentEntry(personId, taxYear);
            if (result != null && dataRequired) {
                Hibernate.initialize(result.getBatchTransmissionEntry().getIrsTransmissionLogData());
                IrsTransmissionLogData dataEntry = null;
                Iterator<IrsTransmissionLogData> i = result.getBatchTransmissionEntry().getIrsTransmissionLogData().iterator();
                if (i.hasNext()) {
                    dataEntry = i.next();
                    result.setSubmittedData(this.getIrsServiceDelegate().convertSingleEntry(dataEntry, result.getRecordSequence()));
                    dataEntry = null;
                }
            }
        }
        catch (DAOException e1) {
            this.logger.error((Object)("Failed to get recent trannsmission for person:" + personId.getKeyValueAsString() + (Object)((Object)e1)));
        }
        catch (ServiceException ex) {
            this.logger.error((Object)("Failed to convert data entry for person:" + personId.getKeyValueAsString() + (Object)((Object)ex)));
        }
        return result;
    }

    @Override
    public List getAllowedCorrectionYears(PersonEntityKey personId) {
        ArrayList<String> taxYearList = new ArrayList<String>();
        ArrayList<String> allyears = new ArrayList<String>();
        try {
            List<IrsTransmissionLogDetailEntry> results = this.getIrsTransmissionLogDetailEntryDAO().findAllowedCorrectionYears((EntityKey)personId);
            if (results != null) {
                for (int i = 0; i < results.size(); ++i) {
                    allyears.add(results.get(i).getBatchTransmissionEntry().getTaxYear());
                }
            }
        }
        catch (DAOException e) {
            this.logger.error((Object)("Failed to get IRS correction years for person:" + personId.getKeyValueAsString() + (Object)((Object)e)));
        }
        HashSet uniques = new HashSet(allyears);
        for (String value : uniques) {
            taxYearList.add(value);
        }
        return taxYearList;
    }

    @Override
    public List getFailedBatchTransmissions() {
        try {
            List rejectedBatches = this.getIrsTransmissionLogEntryDAO().getFailedBatchTransmissions();
            return rejectedBatches;
        }
        catch (DAOException e1) {
            this.logger.error((Object)("Failed to retrieve batch transmission failure listing" + (Object)((Object)e1)));
            return null;
        }
    }

    @Override
    @Transactional
    public List getFailedPersonTransmissions() {
        List<Object> errorList = new ArrayList();
        ArrayList<IrsTransmissionLogDetailEntry> failedList = new ArrayList<IrsTransmissionLogDetailEntry>();
        try {
            errorList = this.getIrsTransmissionLogDetailEntryDAO().getFailedPersonTransmissions();
            if (errorList != null) {
                for (int i = 0; i < errorList.size(); ++i) {
                    IrsTransmissionLogDetailEntry mostRecent;
                    IrsTransmissionLogDetailEntry cur = (IrsTransmissionLogDetailEntry)((Object)errorList.get(i));
                    String curId = cur.getEntityKey().getKeyValueAsString();
                    if (cur == null || cur.getPersonId() == null || (mostRecent = this.getMostRecentTransmissionForYear(CommonEntityKeyFactory.createPersonIdEntityKey(cur.getPersonId().toString()), cur.getBatchTransmissionEntry().getTaxYear(), false)) == null || mostRecent.getEntityKey() == null || !curId.equals(mostRecent.getEntityKey().getKeyValueAsString())) continue;
                    failedList.add(cur);
                }
            }
        }
        catch (DAOException e) {
            this.logger.error((Object)("Failed to retrieve current person failure listing " + (Object)((Object)e)));
        }
        return failedList;
    }

    public SystemParameterService getSystemParameterService() {
        return this.systemParameterService;
    }

    public void setSystemParameterService(SystemParameterService systemParameterService) {
        this.systemParameterService = systemParameterService;
    }

    public IRSWebServiceDelegate getIrsServiceDelegate() {
        return this.irsServiceDelegate;
    }

    public void setIrsServiceDelegate(IRSWebServiceDelegate irsServiceDelegate) {
        this.irsServiceDelegate = irsServiceDelegate;
    }

    public LookupService getLookupService() {
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    public IrsTransmissionLogEntryDAO getIrsTransmissionLogEntryDAO() {
        return this.irsTransmissionLogEntryDAO;
    }

    public void setIrsTransmissionLogEntryDAO(IrsTransmissionLogEntryDAO irsTransmissionLogEntryDAO) {
        this.irsTransmissionLogEntryDAO = irsTransmissionLogEntryDAO;
    }

    public IrsTransmissionLogDetailEntryDAO getIrsTransmissionLogDetailEntryDAO() {
        return this.irsTransmissionLogDetailEntryDAO;
    }

    public MECPeriodDAO getMecPeriodDAO() {
        return this.mecPeriodDAO;
    }

    public void setMecPeriodDAO(MECPeriodDAO mecPeriodDAO) {
        this.mecPeriodDAO = mecPeriodDAO;
    }

    public void setIrsTransmissionLogDetailEntryDAO(IrsTransmissionLogDetailEntryDAO irsTransmissionLogDetailEntryDAO) {
        this.irsTransmissionLogDetailEntryDAO = irsTransmissionLogDetailEntryDAO;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public CommsEmailBulletinService getBulletinService() {
        return this.bulletinService;
    }

    public void setBulletinService(CommsEmailBulletinService bulletinService) {
        this.bulletinService = bulletinService;
    }

    public String getTransmissionControlCode() {
        return this.transmissionControlCode;
    }

    public void setTransmissionControlCode(String transmissionControlCode) {
        this.transmissionControlCode = transmissionControlCode;
    }
}

