/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.impl;

import gov.va.med.esr.common.model.hbp.HealthBenefitPlanName;
import gov.va.med.esr.common.persistent.hbp.HBPDefinitionDAO;
import gov.va.med.esr.common.persistent.history.HistoryDAO;
import gov.va.med.esr.service.HBPDefinitionService;
import gov.va.med.esr.service.impl.AbstractRuleAwareServiceImpl;
import gov.va.med.esr.service.impl.ChangeEvent;
import gov.va.med.esr.service.impl.HistoricalInfo;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.service.ServiceException;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HBPDefinitionServiceImpl
extends AbstractRuleAwareServiceImpl
implements HBPDefinitionService {
    private Map<String, HistoryDAO> historyDAOs;
    private HBPDefinitionDAO hbpDefinitionDAO;
    private HistoryDAO hbpNamesFullHistoryDAO;

    public Map<String, HistoryDAO> getHistoryDAOs() {
        return this.historyDAOs;
    }

    public void setHistoryDAOs(Map<String, HistoryDAO> historyDAOs) {
        this.historyDAOs = historyDAOs;
    }

    public HBPDefinitionDAO getHbpDefinitionDAO() {
        return this.hbpDefinitionDAO;
    }

    public void setHbpDefinitionDAO(HBPDefinitionDAO hbpDefinitionDAO) {
        this.hbpDefinitionDAO = hbpDefinitionDAO;
    }

    public HistoryDAO getHbpNamesFullHistoryDAO() {
        return this.hbpNamesFullHistoryDAO;
    }

    public void setHbpNamesFullHistoryDAO(HistoryDAO hbpNamesFullHistoryDAO) {
        this.hbpNamesFullHistoryDAO = hbpNamesFullHistoryDAO;
    }

    public Set getHistoryChangeTimes(EntityKey entityKey) throws ServiceException {
        try {
            HistoryDAO historyDAO = this.getHistoryDAO(entityKey.getEntityClass().getName());
            return historyDAO.getHistoryChangeTimes(entityKey);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public HistoricalInfo getHistoryByChangeTime(ChangeEvent event) throws ServiceException {
        try {
            HistoryDAO historyDAO = this.getHistoryDAO(event.getEntityKey().getEntityClass().getName());
            return historyDAO.getHistoryByChangeTime(event);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    private HistoryDAO getHistoryDAO(String entityClassName) {
        return this.getHistoryDAOs().get(entityClassName);
    }

    @Override
    public Set getFullHistoryChangeTimes(EntityKey entityKey) throws ServiceException {
        try {
            return this.hbpNamesFullHistoryDAO.getHistoryChangeTimes(entityKey);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public HistoricalInfo getFullHistoryByChangeTime(ChangeEvent event) throws ServiceException {
        try {
            return this.hbpNamesFullHistoryDAO.getHistoryByChangeTime(event);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public HealthBenefitPlanName addHealthBenefitPlanName(HealthBenefitPlanName incoming) throws ServiceException {
        return this.updateHealthBenefitPlanName(incoming);
    }

    @Override
    public HealthBenefitPlanName updateHealthBenefitPlanName(HealthBenefitPlanName incoming) throws ServiceException {
        return null;
    }

    @Override
    public List<HealthBenefitPlanName> getAllHealthBenefitPlanNames() throws ServiceException {
        try {
            return this.hbpDefinitionDAO.findAllHealthBenefitPlanNames();
        }
        catch (DAOException daoe) {
            throw new ServiceException(" Could not retrive HealthBenefitPlanNames ", (Throwable)daoe);
        }
    }

    @Override
    public HealthBenefitPlanName getHealthBenefitPlanNameByID(EntityKey entityKey) throws ServiceException {
        try {
            return this.hbpDefinitionDAO.getHealthBenefitPlanNameById(entityKey);
        }
        catch (DAOException daoe) {
            throw new ServiceException(" Could not retrive HealthBenefitPlanName ", (Throwable)daoe);
        }
    }
}

