/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.impl;

import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.service.EnvironmentParamService;
import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.util.InvalidConfigurationException;
import java.util.Map;
import org.apache.commons.lang.Validate;

public class EnvironmentParamServiceImpl
extends AbstractComponent
implements EnvironmentParamService {
    private boolean isDataClean = false;
    private boolean isSupportedSiteCheck = true;
    private String esrEnv = "";
    private static final String EDEV_KEY = "DEV";
    private static final String LOCAL_KEY = "LOC";
    private static final String PREPROD_KEY = "PRE";
    private static final String STAGING_KEY = "STG";
    private static final String SQA_KEY = "SQA";
    private static final String TRAINING_KEY = "TRN";
    private Map supportedSites = null;
    private Map sitesForEnvironment = null;

    @Override
    public boolean isDataClean() {
        return this.isDataClean;
    }

    @Override
    public boolean isProdEnv() {
        return "Production".equalsIgnoreCase(this.esrEnv);
    }

    @Override
    public boolean isStagingEnv() {
        return "Staging".equalsIgnoreCase(this.esrEnv);
    }

    @Override
    public boolean isSqaEnv() {
        return "ESQA".equalsIgnoreCase(this.esrEnv);
    }

    @Override
    public boolean isPreProdEnv() {
        return "Troubleshooting".equalsIgnoreCase(this.esrEnv);
    }

    @Override
    public boolean isTrainingEnv() {
        return "Training".equalsIgnoreCase(this.esrEnv);
    }

    public boolean isLocalEnv() {
        return "Local".equalsIgnoreCase(this.esrEnv);
    }

    public boolean isDevEnv() {
        return "EDEV".equalsIgnoreCase(this.esrEnv);
    }

    public void setIsDataClean(boolean isDataClean) {
        this.isDataClean = isDataClean;
    }

    public void setEsrEnv(String esrEnv) {
        this.esrEnv = esrEnv;
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.supportedSites, (String)"supportedSites map must be configured");
        if ((this.sitesForEnvironment == null || this.sitesForEnvironment.size() == 0) && this.isSupportedSiteCheck) {
            throw new InvalidConfigurationException("No supported sites defined for the " + this.esrEnv + " environment.  Set isSupportedSiteCheck to false.");
        }
    }

    @Override
    public boolean isSupportedFacility(VAFacility facility) {
        if (this.isProdEnv()) {
            return true;
        }
        if (this.isSupportedSiteCheck) {
            return this.supportedInEnvironment(facility);
        }
        return true;
    }

    private void setSitesForEnvironment() {
        if (this.isPreProdEnv()) {
            this.sitesForEnvironment = (Map)this.supportedSites.get(PREPROD_KEY);
        } else if (this.isSqaEnv()) {
            this.sitesForEnvironment = (Map)this.supportedSites.get(SQA_KEY);
        } else if (this.isStagingEnv()) {
            this.sitesForEnvironment = (Map)this.supportedSites.get(STAGING_KEY);
        } else if (this.isTrainingEnv()) {
            this.sitesForEnvironment = (Map)this.supportedSites.get(TRAINING_KEY);
        } else if (this.isLocalEnv()) {
            this.sitesForEnvironment = (Map)this.supportedSites.get(LOCAL_KEY);
        } else if (this.isDevEnv()) {
            this.sitesForEnvironment = (Map)this.supportedSites.get(EDEV_KEY);
        }
    }

    private boolean supportedInEnvironment(VAFacility facility) {
        if (facility == null) {
            return false;
        }
        if (this.sitesForEnvironment != null && this.sitesForEnvironment.containsKey(facility.getStationNumber())) {
            String emailDomainName = (String)this.sitesForEnvironment.get(facility.getStationNumber());
            if (emailDomainName != null) {
                facility.setEmailDomainName(emailDomainName);
            }
            return true;
        }
        return false;
    }

    public void setSupportedSites(Map supportedSites) {
        this.supportedSites = supportedSites;
        this.setSitesForEnvironment();
    }

    public Map getSupportedSites() {
        return this.supportedSites;
    }

    public void setIsSupportedSiteCheck(boolean isSupportedSiteCheck) {
        this.isSupportedSiteCheck = isSupportedSiteCheck;
    }
}

