/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.impl;

import gov.va.med.esr.common.clock.Clock;
import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.ee.AgentOrangeExposure;
import gov.va.med.esr.common.model.ee.CDCondition;
import gov.va.med.esr.common.model.ee.CDDescriptor;
import gov.va.med.esr.common.model.ee.CDDiagnosis;
import gov.va.med.esr.common.model.ee.CDProcedure;
import gov.va.med.esr.common.model.ee.CampLejeuneVerification;
import gov.va.med.esr.common.model.ee.CatastrophicDisability;
import gov.va.med.esr.common.model.ee.EnrollmentDetermination;
import gov.va.med.esr.common.model.ee.EnrollmentOverride;
import gov.va.med.esr.common.model.ee.EnvironmentalContaminationExposure;
import gov.va.med.esr.common.model.ee.IneligibilityFactor;
import gov.va.med.esr.common.model.ee.MedicaidFactor;
import gov.va.med.esr.common.model.ee.MilitaryService;
import gov.va.med.esr.common.model.ee.MilitaryServiceSiteRecord;
import gov.va.med.esr.common.model.ee.MonetaryBenefit;
import gov.va.med.esr.common.model.ee.MonetaryBenefitAward;
import gov.va.med.esr.common.model.ee.Pension;
import gov.va.med.esr.common.model.ee.PrisonerOfWar;
import gov.va.med.esr.common.model.ee.PurpleHeart;
import gov.va.med.esr.common.model.ee.RadiationExposure;
import gov.va.med.esr.common.model.ee.SHAD;
import gov.va.med.esr.common.model.ee.ServiceConnectionAward;
import gov.va.med.esr.common.model.lookup.DecorationStatus;
import gov.va.med.esr.common.model.lookup.EligibilityType;
import gov.va.med.esr.common.model.lookup.Indicator;
import gov.va.med.esr.common.model.lookup.RejectionRemark;
import gov.va.med.esr.common.model.lookup.ServicePeriod;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.common.persistent.history.HistoryDAO;
import gov.va.med.esr.common.persistent.history.RulesEnrollmentHistoryDAO;
import gov.va.med.esr.common.rule.service.EventRuleService;
import gov.va.med.esr.service.EEResultInfo;
import gov.va.med.esr.service.EligibilityEnrollmentService;
import gov.va.med.esr.service.FinancialsHelperService;
import gov.va.med.esr.service.PersonService;
import gov.va.med.esr.service.RegistryService;
import gov.va.med.esr.service.external.person.EligibilitySummary;
import gov.va.med.esr.service.external.person.VPIDEntityKey;
import gov.va.med.esr.service.impl.AbstractHistoricalInfoServiceImpl;
import gov.va.med.esr.service.impl.ChangeEvent;
import gov.va.med.esr.service.impl.HistoricalInfo;
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;
import gov.va.med.fw.validation.ValidationServiceException;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;

public class EligibilityEnrollmentServiceImpl
extends AbstractHistoricalInfoServiceImpl
implements EligibilityEnrollmentService {
    private PersonService personServiceWithNoUpdateIdTraits = null;
    private static final long serialVersionUID = 3485681593834139471L;
    private RegistryService registryService = null;
    private Map diagnosisMap;
    private Map procedureMap;
    private Map conditionMap;
    private FinancialsHelperService financialsHelperService = null;
    private HistoryDAO eligibilityHistoryDAO = null;
    private HistoryDAO powHistoryDAO = null;
    private HistoryDAO enrollmentHistoryDAO = null;
    private RulesEnrollmentHistoryDAO rulesEnrollmentHistoryDAO = null;
    private Builder eligibilitySummaryBuilder;
    public static final String INVALID_MILITARY_DISABILITY_RETIREMENT_WITH_NSC = "INVALID_MILITARY_DISABILITY_RETIREMENT_WITH_NSC";
    public static final String MILITARY_DISABILITY_RETIREMENT_FIELD = "disabilityRetirementIndicator";

    @Override
    public Person assessEEImpact(Person incoming) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"The incoming veteran can not be null.");
        Person onFile = this.getPersonService().getPerson((PersonEntityKey)incoming.getEntityKey());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("EESvcImpl assessEEImpact 1 : incoming: " + (Object)((Object)incoming)));
        }
        this.ensureEntityChanged((AbstractEntity)incoming, (AbstractEntity)onFile);
        this.getEnrollmentRuleService().processServiceConnectedIndicator(incoming);
        this.removeAllEligibilityFactorsFromNonVet(incoming);
        this.getEligibilityFactorRuleService().validateMonetaryBenefit(incoming.getMonetaryBenefitAward(), onFile);
        Person calculated = this.assessEEImpact(incoming, true, true, null);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("EESvcImpl assessEEImpact calculated : calc: " + (Object)((Object)calculated)));
        }
        this.validateMilitaryServiceForEE(calculated);
        return calculated;
    }

    @Override
    public Person assessEEImpact(Person incoming, boolean isReviewOnly) throws ServiceException {
        return this.assessEEImpact(incoming, true, isReviewOnly, null);
    }

    @Override
    public Person assessEEImpact(Person incoming, boolean isReviewOnly, Clock.Type clockType) throws ServiceException {
        return this.assessEEImpact(incoming, true, isReviewOnly, true, clockType, null);
    }

    @Override
    public Person assessEEImpact(Person incoming, boolean isDataFromGUI, boolean isReviewOnly) throws ServiceException {
        return this.assessEEImpact(incoming, isDataFromGUI, isReviewOnly, true, null, null);
    }

    @Override
    public Person assessEEImpact(Person incoming, boolean isDataFromGUI, boolean isReviewOnly, boolean shouldTriggerHBP) throws ServiceException {
        return this.assessEEImpact(incoming, isDataFromGUI, isReviewOnly, shouldTriggerHBP, null, null);
    }

    @Override
    public Person assessEEImpact(Person incoming, boolean isDataFromGUI, boolean isReviewOnly, VAFacility sendingFacility) throws ServiceException {
        return this.assessEEImpact(incoming, isDataFromGUI, isReviewOnly, true, null, sendingFacility);
    }

    private Person assessEEImpact(Person incoming, boolean isDataFromGUI, boolean isReviewOnly, boolean shouldTriggerHBP, Clock.Type clockType, VAFacility sendingFacility) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"The incoming veteran can not be null.");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("EESvcImpl assessEEImpact main : incoming: " + (Object)((Object)incoming)));
        }
        return this.doEECalculation(incoming, isDataFromGUI, isReviewOnly, shouldTriggerHBP, clockType, sendingFacility);
    }

    @Override
    public boolean processExpiredMeansTestForBatchProcess(PersonEntityKey key) throws ServiceException {
        Person person = this.getPersonServiceWithNoUpdateIdTraits().getPerson(key);
        if (this.getFinancialsHelperService().isSubjectToMeansTestForBatchProcess(person)) {
            this.assessEEImpact(person, false, false, null);
            EventRuleService eventRuleService = this.getEventRuleService();
            eventRuleService.manageMessageEvents(person);
            eventRuleService.manageHandBookEvents(person);
            this.getPersonServiceWithNoUpdateIdTraits().save(person);
            return true;
        }
        return false;
    }

    @Override
    public Person processCalculateEEForCleanup(PersonEntityKey key, boolean savePerson, boolean triggerEvents) throws ServiceException {
        Person person = this.getPersonService().getPerson(key);
        this.getEnrollmentRuleService().calculateEEForCleanup(person);
        if (triggerEvents) {
            EventRuleService eventRuleService = this.getEventRuleService();
            eventRuleService.manageMessageEvents(person);
            eventRuleService.manageHandBookEvents(person);
        }
        if (savePerson) {
            return this.getPersonService().save(person);
        }
        return person;
    }

    @Override
    public Person processCalculateEE(PersonEntityKey key, boolean savePerson, boolean triggerEvents) throws ServiceException {
        Person person = this.getPersonService().getPerson(key);
        this.assessEEImpact(person, false, false, null);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("EESvcImpl procCalcEE : person: " + (Object)((Object)person)));
        }
        if (triggerEvents) {
            EventRuleService eventRuleService = this.getEventRuleService();
            eventRuleService.manageMessageEvents(person);
            eventRuleService.manageHandBookEvents(person);
        }
        if (savePerson) {
            return this.getPersonService().save(person);
        }
        return person;
    }

    @Override
    public Person processCalculateEEOverride(PersonEntityKey key, boolean savePerson, boolean triggerEvents) throws ServiceException {
        Boolean override = new Boolean(true);
        Person person = this.getPersonService().getPerson(key);
        if (person.getEnrollmentOverride() != null) {
            person.getEnrollmentOverride().setOverride(override);
            person.getEnrollmentOverride().setOverrideBy("Batch ReprocessCERec");
            person.getEnrollmentOverride().setOverrideDate(new Date());
        } else {
            EnrollmentOverride eo = new EnrollmentOverride();
            eo.setOverride(override);
            eo.setOverrideBy("Batch ReprocessCERec");
            eo.setOverrideDate(new Date());
            person.setEnrollmentOverride(eo);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("EESvcImpl procCalcEEOverride : person: " + (Object)((Object)person)));
        }
        this.assessEEImpact(person, false, false, null);
        if (triggerEvents) {
            EventRuleService eventRuleService = this.getEventRuleService();
            eventRuleService.manageMessageEvents(person);
            eventRuleService.manageHandBookEvents(person);
        }
        if (savePerson) {
            return this.getPersonService().save(person);
        }
        return person;
    }

    @Override
    public Person updateEligibilityData(Person incoming) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"A veteran must not be null");
        Person onFile = this.getPersonService().getPerson((PersonEntityKey)incoming.getEntityKey());
        this.getEligibilityFactorRuleService().manageEligibilityVerification(incoming.getEligibilityVerification(), onFile);
        return this.getPersonService().save(onFile);
    }

    private boolean recalculatePOS(Person incoming, Person onFile) throws ServiceException {
        boolean isSuccess = false;
        if (incoming != null && onFile != null) {
            ServicePeriod servicePeriod;
            MilitaryService militaryService = incoming.getMilitaryService();
            MilitaryServiceSiteRecord hecSite = militaryService.getHECMilitaryServiceSiteRecord();
            ServicePeriod servicePeriod2 = servicePeriod = hecSite != null ? hecSite.getServicePeriod() : null;
            if (servicePeriod == null || servicePeriod.getCode() == null) {
                this.getMilitaryRuleService().calculatePeriodOfServiceForUI(incoming, onFile, "MS");
                militaryService = onFile.getMilitaryService();
                hecSite = militaryService.getHECMilitaryServiceSiteRecord();
                ServicePeriod servicePeriod3 = servicePeriod = hecSite != null ? hecSite.getServicePeriod() : null;
                if (servicePeriod != null) {
                    String posCode = servicePeriod.getCode();
                    this.logger.info((Object)("Recalculated POS is " + posCode + ":" + servicePeriod.getName() + servicePeriod.getDescription()));
                }
            }
        }
        return isSuccess;
    }

    @Override
    public Person updateEnrollmentData(Person incoming) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"A veteran must not be null");
        Person onFile = this.getPersonService().getPerson((PersonEntityKey)incoming.getEntityKey());
        this.ensureEntityChanged((AbstractEntity)incoming, (AbstractEntity)onFile);
        this.validateEnrollmentDetermination(onFile);
        this.getEnrollmentRuleService().manageApplication(incoming.getApplication(), onFile);
        this.getEnrollmentRuleService().processCancelDecline(incoming.getCancelDecline(), onFile);
        this.getEligibilityFactorRuleService().manageEnrollmentOverride(incoming.getEnrollmentOverride(), onFile);
        Person calculatedPerson = this.assessEEImpact(onFile, false);
        EventRuleService eventRuleService = this.getEventRuleService();
        eventRuleService.manageMessageEvents(calculatedPerson);
        eventRuleService.managePersonEvents(calculatedPerson);
        eventRuleService.manageHandBookEvents(calculatedPerson);
        return this.getPersonService().save(calculatedPerson);
    }

    @Override
    public boolean isServicePeriodNeeded(Person incoming) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"A veteran must not be null");
        if (incoming.getEnrollmentDetermination() != null && incoming.getEnrollmentDetermination().getPrimaryEligibility() != null) {
            String code;
            EligibilityType type = incoming.getEnrollmentDetermination().getPrimaryEligibility().getType();
            String string = code = type == null ? null : type.getCode();
            if (code != null && (code.equals(EligibilityType.ALLIED_VETERAN.getCode()) || code.equals(EligibilityType.OTHER_FEDERAL_AGENCY.getCode()) || code.equals(EligibilityType.COLLATERAL_OF_VETERAN.getCode()) || code.equals(EligibilityType.CHAMPVA.getCode()) || code.equals(EligibilityType.EMPLOYEE.getCode()) || code.equals(EligibilityType.SHARING_AGREEMENT.getCode()) || code.equals(EligibilityType.TRICARE_CHAMPUS.getCode()))) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Set getEligibilityHistoryChangeTimes(EntityKey personID) throws ServiceException {
        try {
            return this.eligibilityHistoryDAO.getHistoryChangeTimes(personID);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public HistoricalInfo getEligibilityHistoryByChangeTime(ChangeEvent event) throws ServiceException {
        try {
            return this.eligibilityHistoryDAO.getHistoryByChangeTime(event);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Set getEnrollmentHistoryChangeTimes(EntityKey personID) throws ServiceException {
        try {
            return this.enrollmentHistoryDAO.getHistoryChangeTimes(personID);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public HistoricalInfo getEnrollmentHistoryByChangeTime(ChangeEvent event) throws ServiceException {
        try {
            return this.enrollmentHistoryDAO.getHistoryByChangeTime(event);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Date getAppDateFromEarliestUnverifiedEnrollment(EntityKey personId) throws ServiceException {
        try {
            return this.rulesEnrollmentHistoryDAO.getEnrollmentApplicationDateForEarliestSpecifiedStatusUnlessCancelledOrRejectedBelowThreshold(personId);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean hasAnyEnrollmentRecordBeforeDate(EntityKey personId, Date beforeDate) throws ServiceException {
        try {
            return this.rulesEnrollmentHistoryDAO.hasAnyEnrollmentRecordBeforeDate(personId, beforeDate);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Date getFirstNotNullEffDate(EntityKey personId) throws ServiceException {
        try {
            return this.rulesEnrollmentHistoryDAO.getFirstNotNullEffDate(personId);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Person getPersonForPriorEnrollment(EntityKey personId) throws ServiceException {
        try {
            return this.rulesEnrollmentHistoryDAO.getPersonForPriorEnrollment(personId);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Object[] getStatusAndAppDateForEarliest(EntityKey personId) throws ServiceException {
        try {
            return this.rulesEnrollmentHistoryDAO.getStatusAndAppDateForEarliest(personId);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String[] getPriorityGrpsForMostRecent(EntityKey personId) throws ServiceException {
        try {
            return this.rulesEnrollmentHistoryDAO.getPriorityGrpsForMostRecent(personId);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Date getEnrollmentDateForEarliestVerifiedUnlessCancelled(EntityKey personId) throws ServiceException {
        try {
            return this.rulesEnrollmentHistoryDAO.getEnrollmentDateForEarliestVerifiedUnlessCancelled(personId);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Date getEffectiveDateForEarliestVerifiedUnlessCancelledOrRejectedBelowEnrollmentThreshold(EntityKey personId) throws ServiceException {
        try {
            return this.rulesEnrollmentHistoryDAO.getEffectiveDateForEarliestVerifiedUnlessCancelledOrRejectedBelowEnrollmentThreshold(personId);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public EnrollmentDetermination getEnrollmentDeterminationForEarliestVerifiedUnlessCancelledOrRejectedBelowEnrollmentGroupThreshold(EntityKey personId) throws ServiceException {
        try {
            return this.rulesEnrollmentHistoryDAO.getEnrollmentDeterminationForEarliestVerifiedUnlessCancelledOrRejectedBelowEnrollmentGroupThreshold(personId);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Date getEarliestEnrollmentEffectiveDatewithAOWatDMZ(EntityKey personId) throws ServiceException {
        try {
            return this.rulesEnrollmentHistoryDAO.getEarliestEnrollmentEffectiveDatewithAOWatDMZ(personId);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean isApplicationDatePriortoEGTEffectiveDate(EntityKey personId) throws ServiceException {
        try {
            return this.rulesEnrollmentHistoryDAO.isApplicationDatePriortoEGTEffectiveDate(personId);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean isVerifiedEnrollmentExistsforCombatVeteran(EntityKey personId) throws ServiceException {
        try {
            return this.rulesEnrollmentHistoryDAO.isVerifiedEnrollmentExistsforCombatVeteran(personId);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean isVerifiedEnrollmentExists(EntityKey personId) throws ServiceException {
        try {
            return this.rulesEnrollmentHistoryDAO.isVerifiedEnrollmentExists(personId);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean isVerifiedEnrollmentExistsForEligibilityCode(EntityKey personId, String eligiblityTypeCode) throws ServiceException {
        try {
            return this.rulesEnrollmentHistoryDAO.isVerifiedEnrollmentExistsForEligibilityCode(personId, eligiblityTypeCode);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean isVerifiedEnrollmentExistsForMedicaidEligibility(EntityKey personId) throws ServiceException {
        try {
            return this.rulesEnrollmentHistoryDAO.isVerifiedEnrollmentExistsForMedicaidEligibility(personId);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Integer getIncomeYearForVerifiedMT(EntityKey personId) throws ServiceException {
        try {
            return this.rulesEnrollmentHistoryDAO.getIncomeYearForVerifiedMT(personId);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public List getIncomeYearsForVerifiedMT(EntityKey personId) throws ServiceException {
        try {
            return this.rulesEnrollmentHistoryDAO.getIncomeYearsForVerifiedMT(personId);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public List getIncomeYearsFromVerifiedEnrollmentDueToP8(EntityKey personId) throws ServiceException {
        try {
            return this.rulesEnrollmentHistoryDAO.getIncomeYearsForVerifiedP8(personId);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String[] getMostRecentVerifiedEnrollmentPriorityGroups(EntityKey personId) throws ServiceException {
        try {
            return this.rulesEnrollmentHistoryDAO.getMostRecentVerifiedEnrollmentPriorityGroups(personId);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean hasIncomeTestMeetingP8RecheckCriteria(EntityKey personId, float relaxPercent) throws ServiceException {
        try {
            return this.rulesEnrollmentHistoryDAO.hasIncomeTestMeetingP8RecheckCriteria(personId, relaxPercent);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public List getHistoricalIncomeYearsForVerifiedMT(EntityKey personId) throws ServiceException {
        try {
            return this.rulesEnrollmentHistoryDAO.getHistoricalIncomeYearsForVerifiedMT(personId);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean isVerifiedEnrollmentExistsforSvcConnPercent(EntityKey personId, Integer percent) throws ServiceException {
        try {
            return this.rulesEnrollmentHistoryDAO.isVerifiedEnrollmentExistsforSvcConnPercent(personId, percent);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public EnrollmentDetermination getMostRecentEnrollmentforContinuousEnrollment(EntityKey personId) throws ServiceException {
        try {
            EnrollmentDetermination e = new EnrollmentDetermination();
            EEResultInfo results = this.rulesEnrollmentHistoryDAO.getMostRecentEnrollmentforContinuousEnrollment(personId);
            if (results != null) {
                e.setEffectiveDate(results.getEffectiveDate());
                Integer flag = results.getOverrideFlag();
                e.setOverridden(new Boolean(flag != null && flag.equals(new Integer(1))));
                e.setEnrollmentStatus(results.getStatusCode() != null ? this.getLookupService().getEnrollmentStatusByCode(results.getStatusCode()) : null);
                e.setPriorityGroup(results.getGroupCode() != null ? this.getLookupService().getEnrollmentPriorityGroupByCode(results.getGroupCode()) : null);
                return e;
            }
            return null;
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String[] getEnrollmentPriorityBeforePH(EntityKey personId) throws ServiceException {
        try {
            return this.rulesEnrollmentHistoryDAO.getEnrollmentPriorityBeforePH(personId);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String getMostRecentNonNullPriorityCode(EntityKey personId) throws ServiceException {
        try {
            return this.rulesEnrollmentHistoryDAO.getMostRecentNonNullPriorityCode(personId);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String getMostRecentNonNullPriorityLevelByDate(EntityKey personId, Date beforeDate) throws ServiceException {
        try {
            return this.rulesEnrollmentHistoryDAO.getMostRecentNonNullPriorityLevelByDate(personId, beforeDate);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void removeAllEligibilityFactorsFromNonVet(Person incoming) throws ServiceException {
        ServiceConnectionAward scw;
        IneligibilityFactor inelig;
        if (incoming != null && (inelig = incoming.getIneligibilityFactor()) != null && inelig.getIneligibleDate() != null && inelig.getReason() != null && ((scw = incoming.getServiceConnectionAward()) == null || scw != null && (scw.getServiceConnectedIndicator() == null || scw.getServiceConnectedIndicator() != null && !scw.getServiceConnectedIndicator().booleanValue()))) {
            this.removeAllEligibilityFactors(incoming);
            incoming.setVeteran(Boolean.FALSE);
        }
    }

    @Override
    public void removeAllEligibilityFactors(Person incoming) throws ServiceException {
        if (incoming != null) {
            CampLejeuneVerification clv;
            EnvironmentalContaminationExposure ecx;
            RadiationExposure re;
            AgentOrangeExposure aoe;
            MedicaidFactor mf;
            MilitaryService ms;
            ServiceConnectionAward scw;
            MonetaryBenefitAward mba;
            SHAD shad;
            PurpleHeart ph;
            Indicator noIndicator = this.getLookupService().getIndicatorByCode(Indicator.NO);
            PrisonerOfWar pow = incoming.getPrisonerOfWar();
            if (pow != null) {
                pow.setPowIndicator(noIndicator);
                pow.removeAllEpisodes();
                pow.setIcn(null);
                pow.setDateEntered(null);
                pow.setUser(null);
            }
            if ((ph = incoming.getPurpleHeart()) != null && ph.getPhIndicator() != null) {
                if (ph.getPhIndicator().booleanValue()) {
                    ph.setPhIndicator(Boolean.FALSE);
                    ph.setRejectionRemark(this.getLookupService().getRejectionRemarkByCode(RejectionRemark.CODE_ENTERED_IN_ERROR.getCode()));
                    ph.setStatus(this.getLookupService().getDecorationStatusByCode(DecorationStatus.CODE_REJECTED.getCode()));
                } else {
                    ph.setRejectionRemark(this.getLookupService().getRejectionRemarkByCode(RejectionRemark.CODE_ENTERED_IN_ERROR.getCode()));
                }
            }
            if ((shad = incoming.getShad()) != null) {
                shad.setShadIndicator(noIndicator);
            }
            if ((mba = incoming.getMonetaryBenefitAward()) != null) {
                MonetaryBenefit dc;
                MonetaryBenefit va;
                MonetaryBenefit hb;
                MonetaryBenefit aa = mba.getAidAndAttendance();
                if (aa != null) {
                    aa.setMonetaryBenefitIndicator(noIndicator);
                }
                if ((hb = mba.getHouseBound()) != null) {
                    hb.setMonetaryBenefitIndicator(noIndicator);
                }
                if ((va = mba.getVAPension()) != null) {
                    va.setMonetaryBenefitIndicator(noIndicator);
                    Pension pension = va.getPension();
                    if (pension != null) {
                        pension.setAwardReasonCode(null);
                        pension.setEffectiveDate(null);
                    }
                }
                if ((dc = mba.getDisabilityCompensation()) != null) {
                    dc.setMonetaryBenefitIndicator(noIndicator);
                }
                mba.setCheckAmount(null);
            }
            if ((scw = incoming.getServiceConnectionAward()) != null) {
                scw.setUnemployable(Boolean.FALSE);
                scw.setPermanentAndTotal(Boolean.FALSE);
                scw.setPermanentAndTotalEffectiveDate(null);
                scw.setServiceConnectedPercentage(null);
                scw.setServiceConnectedIndicator(Boolean.FALSE);
                scw.removeAllRatedDisability();
            }
            if ((ms = incoming.getMilitaryService()) != null) {
                ms.setDisabilityRetirementIndicator(Boolean.FALSE);
                ms.setDischargeDueToDisability(Boolean.FALSE);
                ms.setCombatVeteranEligibilityEndDate(null);
            }
            if ((mf = incoming.getMedicaidFactor()) != null) {
                mf.setEligibleForMedicaid(Boolean.FALSE);
                mf.setLastUpdateDate(new Date());
            }
            if ((aoe = incoming.getAgentOrangeExposure()) != null) {
                aoe.setAgentOrangeExposureIndicator(noIndicator);
                aoe.setLocation(null);
            }
            if ((re = incoming.getRadiationExposure()) != null) {
                re.setRadiationExposureIndicator(noIndicator);
                re.setExposureMethod(null);
            }
            if ((ecx = incoming.getEnvironmentalContaminationExposure()) != null) {
                ecx.setEnvironmentalContaminationExposureIndicator(noIndicator);
            }
            if ((clv = incoming.getCampLejeuneVerification()) != null) {
                clv.setSpecialFactorIndicator(noIndicator);
            }
        }
    }

    private Person doEECalculation(Person incoming, boolean isDataFromGUI, boolean isReviewOnly, boolean shouldTriggerHBP, Clock.Type clockType, VAFacility sendingFacility) throws ServiceException {
        CatastrophicDisability cd = incoming.getCatastrophicDisability();
        if (cd != null && cd.isCatastrophicallyDisabled() != null && cd.isCatastrophicallyDisabled().booleanValue() && cd.getCDDescriptors().isEmpty()) {
            this.convertCDOnly(incoming);
        }
        this.getEnrollmentRuleService().calculateEE(incoming, isDataFromGUI, isReviewOnly, shouldTriggerHBP, clockType, sendingFacility);
        return incoming;
    }

    public boolean convertCDOnly(Person person) throws ServiceException {
        CatastrophicDisability cd = person.getCatastrophicDisability();
        HashSet<CDDescriptor> descriptorsToAdd = new HashSet<CDDescriptor>();
        boolean existsAlready = false;
        if (cd != null) {
            Set<CDDescriptor> descriptors = cd.getCDDescriptors();
            if (descriptors.size() > 0) {
                existsAlready = true;
            }
            Set conditions = cd.getConditions();
            for (CDCondition cdCondition : conditions) {
                String code = cdCondition.getCondition().getCode();
                String translated = (String)this.getConditionMap().get(code);
                if (translated == null) continue;
                descriptorsToAdd.add(this.buildCDDescriptor(translated));
            }
            Set procedures = cd.getProcedures();
            for (CDProcedure cdProcedure : procedures) {
                String code = cdProcedure.getProcedure().getCode();
                String translated = (String)this.getProcedureMap().get(code);
                if (translated == null) continue;
                descriptorsToAdd.add(this.buildCDDescriptor(translated));
            }
            Set diagnoses = cd.getDiagnoses();
            for (CDDiagnosis cdDiagnosis : diagnoses) {
                String code = cdDiagnosis.getDiagnosis().getCode();
                String translated = (String)this.getDiagnosisMap().get(code);
                if (translated == null) continue;
                descriptorsToAdd.add(this.buildCDDescriptor(translated));
            }
            for (CDDescriptor descriptorToAdd : descriptorsToAdd) {
                boolean exists = false;
                for (CDDescriptor descriptor : descriptors) {
                    if (!descriptor.getDescriptorType().getCode().equals(descriptorToAdd.getDescriptorType().getCode())) continue;
                    exists = true;
                    break;
                }
                if (exists) continue;
                cd.addCDDescriptor(descriptorToAdd);
            }
        }
        return descriptorsToAdd.size() > 0 || existsAlready;
    }

    private CDDescriptor buildCDDescriptor(String code) throws ServiceException {
        CDDescriptor cdd = new CDDescriptor();
        cdd.setDescriptorType(this.getLookupService().getDescriptorTypeByCode(code));
        return cdd;
    }

    public HistoryDAO getEligibilityHistoryDAO() {
        return this.eligibilityHistoryDAO;
    }

    public void setEligibilityHistoryDAO(HistoryDAO eligibilityHistoryDAO) {
        this.eligibilityHistoryDAO = eligibilityHistoryDAO;
    }

    public HistoryDAO getPowHistoryDAO() {
        return this.powHistoryDAO;
    }

    public void setPowHistoryDAO(HistoryDAO powHistoryDAO) {
        this.powHistoryDAO = powHistoryDAO;
    }

    public HistoryDAO getEnrollmentHistoryDAO() {
        return this.enrollmentHistoryDAO;
    }

    public void setEnrollmentHistoryDAO(HistoryDAO enrollmentHistoryDAO) {
        this.enrollmentHistoryDAO = enrollmentHistoryDAO;
    }

    public RulesEnrollmentHistoryDAO getRulesEnrollmentHistoryDAO() {
        return this.rulesEnrollmentHistoryDAO;
    }

    public void setRulesEnrollmentHistoryDAO(RulesEnrollmentHistoryDAO rulesEnrollmentHistoryDAO) {
        this.rulesEnrollmentHistoryDAO = rulesEnrollmentHistoryDAO;
    }

    public RegistryService getRegistryService() {
        return this.registryService;
    }

    public void setRegistryService(RegistryService registryService) {
        this.registryService = registryService;
    }

    public FinancialsHelperService getFinancialsHelperService() {
        return this.financialsHelperService;
    }

    public void setFinancialsHelperService(FinancialsHelperService financialsHelperService) {
        this.financialsHelperService = financialsHelperService;
    }

    private void validateMilitaryServiceForEE(Person calculated) throws ValidationServiceException {
        Boolean dri;
        MilitaryService ms = calculated.getMilitaryService();
        if (ms != null && (dri = ms.getDisabilityRetirementIndicator()) != null && dri.booleanValue()) {
            String primary = calculated.getEnrollmentDetermination() != null && calculated.getEnrollmentDetermination().getPrimaryEligibility() != null && calculated.getEnrollmentDetermination().getPrimaryEligibility().getType() != null ? calculated.getEnrollmentDetermination().getPrimaryEligibility().getType().getCode() : null;
        }
    }

    @Override
    public EligibilitySummary getEligibilitySummary(VPIDEntityKey vpid) throws ServiceException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Received an external request to getEligibilitySummary for VPID: " + vpid.getVPID()));
        }
        gov.va.med.esr.common.model.person.id.VPIDEntityKey internalVpid = CommonEntityKeyFactory.createVPIDEntityKey(vpid);
        Person person = this.getPersonService().getPerson(internalVpid);
        try {
            return (EligibilitySummary)this.eligibilitySummaryBuilder.build((Object)person);
        }
        catch (BuilderException e) {
            throw new ServiceException("Unable to get EligibilitySummary", (Throwable)e);
        }
    }

    public Builder getEligibilitySummaryBuilder() {
        return this.eligibilitySummaryBuilder;
    }

    public void setEligibilitySummaryBuilder(Builder eligibilitySummaryBuilder) {
        this.eligibilitySummaryBuilder = eligibilitySummaryBuilder;
    }

    @Override
    public Set getPOWHistoryChangeTimes(EntityKey personID) throws ServiceException {
        try {
            return this.powHistoryDAO.getHistoryChangeTimes(personID);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public HistoricalInfo getPOWHistoryByChangeTime(ChangeEvent event) throws ServiceException {
        try {
            return this.powHistoryDAO.getHistoryByChangeTime(event);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public PersonService getPersonServiceWithNoUpdateIdTraits() {
        return this.personServiceWithNoUpdateIdTraits;
    }

    public void setPersonServiceWithNoUpdateIdTraits(PersonService personServiceWithNoUpdateIdTraits) {
        this.personServiceWithNoUpdateIdTraits = personServiceWithNoUpdateIdTraits;
    }

    @Override
    public List getEnrollmentDeterminationHistory(EntityKey personId) throws ServiceException {
        try {
            return this.rulesEnrollmentHistoryDAO.getPersonEnrollmentDeterminationHistory(personId);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public Map getDiagnosisMap() {
        return this.diagnosisMap;
    }

    public void setDiagnosisMap(Map diagnosisMap) {
        this.diagnosisMap = diagnosisMap;
    }

    public Map getProcedureMap() {
        return this.procedureMap;
    }

    public void setProcedureMap(Map procedureMap) {
        this.procedureMap = procedureMap;
    }

    public Map getConditionMap() {
        return this.conditionMap;
    }

    public void setConditionMap(Map conditionMap) {
        this.conditionMap = conditionMap;
    }

    @Override
    public boolean getPriorToEnrDetermHistory(EntityKey personId, Date beforeDate, Date recModifiedDate) throws ServiceException {
        try {
            return this.rulesEnrollmentHistoryDAO.getPriorToEnrDetermHistory(personId, beforeDate, recModifiedDate);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }
}

