/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.impl;

import gov.va.med.esr.common.model.comms.AacLetterRequest;
import gov.va.med.esr.common.model.comms.CommsLogEntry;
import gov.va.med.esr.common.model.comms.CommsTemplate;
import gov.va.med.esr.common.model.comms.MailingStatusLink;
import gov.va.med.esr.common.model.lookup.ComLetterTemplateType;
import gov.va.med.esr.common.model.lookup.ComLetterType;
import gov.va.med.esr.common.model.lookup.ComMailingStatusType;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.persistent.comms.AacLetterRequestDAO;
import gov.va.med.esr.common.persistent.comms.CommsLogEntryDAO;
import gov.va.med.esr.common.persistent.comms.CommsTemplateDAO;
import gov.va.med.esr.common.persistent.comms.PrintRequestDuplicationException;
import gov.va.med.esr.common.util.LetterFormatHelper;
import gov.va.med.esr.service.CommsLetterRequestService;
import gov.va.med.esr.service.DemographicService;
import gov.va.med.esr.service.DuplicatePrintRequestServiceException;
import gov.va.med.esr.service.impl.AbstractRuleAwareServiceImpl;
import gov.va.med.esr.service.trigger.LetterTrigger;
import gov.va.med.esr.service.trigger.LetterTriggerEvent;
import gov.va.med.esr.service.trigger.LetterTriggerIdentity;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.validation.ValidationMessage;
import gov.va.med.fw.validation.ValidationMessages;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public class CommsLetterRequestServiceImpl
extends AbstractRuleAwareServiceImpl
implements Serializable,
CommsLetterRequestService {
    private static final long serialVersionUID = -1259201288293567373L;
    private List manualMailingLst;
    private CommsLogEntryDAO commsLogDAO = null;
    private AacLetterRequestDAO aacRequestDAO = null;
    private CommsTemplateDAO templDAO = null;

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.commsLogDAO, (String)"A Comms Log Entry DAO must be configured");
        Validate.notNull((Object)this.aacRequestDAO, (String)"An AAC Letter Request DAO must be configured");
        Validate.notNull((Object)this.templDAO, (String)"An Comms Letter Template DAO must be configured");
    }

    @Override
    public List requestAacLetter(Person person, LetterTriggerIdentity letterType, String workflowCaseId, LetterTriggerEvent.MailType mailType, Boolean override) throws ServiceException {
        return this.doRequestLetter(person, letterType, workflowCaseId, mailType, override, null, null);
    }

    @Override
    public List requestAacLetter(Person person, LetterTriggerIdentity letterType, String workflowCaseId, LetterTriggerEvent.MailType mailType, Boolean override, String actionComment) throws ServiceException {
        return this.doRequestLetter(person, letterType, workflowCaseId, mailType, override, actionComment, null);
    }

    @Override
    public List requestLetter(Person person, LetterTriggerIdentity letterType, LetterTriggerEvent letterTriggerEvent) throws ServiceException {
        return this.doRequestLetter(person, letterType, letterTriggerEvent.getWorkflowCaseId(), letterTriggerEvent.getMailType(), null, null, letterTriggerEvent);
    }

    private List doRequestLetter(Person person, LetterTriggerIdentity letterType, String workflowCaseId, LetterTriggerEvent.MailType mailType, Boolean override, String actionComment, LetterTriggerEvent letterTriggerEvent) throws ServiceException {
        ComLetterTemplateType formNum = letterType.getDataType();
        if (formNum == null || formNum.getName() == null) {
            ServiceException ex = new ServiceException("Can not send a letter with an empty form number!!!");
            this.logger.error((Object)"Error empty form number while requesting an AAC letter", (Throwable)ex);
            throw ex;
        }
        String formNumberStr = formNum.getCode();
        CommsTemplate templ = null;
        try {
            templ = (CommsTemplate)this.templDAO.findTemplateListByFormNumber(formNumberStr).get(0);
        }
        catch (DAOException dex) {
            this.logger.error((Object)"ERROR to find a Comms Template with form number ", (Throwable)dex);
            throw new ServiceException("Excption when find a Comms Template with form number=" + formNumberStr + ". Error Message: " + dex.getMessage(), (Throwable)dex);
        }
        String personId = person.getEntityKey().getKeyValueAsString();
        String code = this.createUniqueCode(personId, letterType);
        try {
            AacLetterRequest curr = this.aacRequestDAO.findAacLetterRequestByUniqueCode(code);
            if (curr != null) {
                return null;
            }
        }
        catch (DAOException dex) {
            this.logger.error((Object)"ERROR finding a print request with unique code ", (Throwable)dex);
            throw new ServiceException("ERROR finding a print request with unique code = " + code + "  Error Message: " + dex.getMessage(), (Throwable)dex);
        }
        DemographicService demoSrv = (DemographicService)this.getComponent("demographicService");
        Address mailingAddress = demoSrv.getLetterAddress(person);
        mailingAddress.setCounty(StringUtils.remove((String)mailingAddress.getCounty(), (String)"AMP;"));
        mailingAddress.setCity(StringUtils.remove((String)mailingAddress.getCity(), (String)"AMP;"));
        mailingAddress.setLine1(StringUtils.remove((String)mailingAddress.getLine1(), (String)"AMP;"));
        mailingAddress.setLine2(StringUtils.remove((String)mailingAddress.getLine2(), (String)"AMP;"));
        mailingAddress.setLine3(StringUtils.remove((String)mailingAddress.getLine3(), (String)"AMP;"));
        CommsLogEntry logEntry = null;
        List errMsgList = null;
        try {
            logEntry = this.createLogEntry(person, templ, workflowCaseId, mailType, letterType.getCategoryType(), override, mailingAddress, actionComment, letterTriggerEvent);
            errMsgList = this.processLetterRules(person, formNum, workflowCaseId, mailType, override, logEntry, letterType.getCategoryType() != null ? letterType.getCategoryType().getName() : null);
            this.commsLogDAO.insert(logEntry);
        }
        catch (Exception dex) {
            this.logger.error((Object)"ERROR to insert a new log entry with status \"Send to AAC\" while requesting an AAC letter", (Throwable)dex);
            throw new ServiceException("Excption when inserting a log entry!" + dex.getMessage(), (Throwable)dex);
        }
        AacLetterRequest req = this.createAacLetterRequest(letterType, logEntry, person, errMsgList);
        try {
            this.aacRequestDAO.insert(req);
        }
        catch (PrintRequestDuplicationException dupEx) {
            throw new DuplicatePrintRequestServiceException("Duplicate Print Reqeust Entry Found!" + dupEx.getMessage(), (Exception)((Object)dupEx));
        }
        catch (DAOException dex) {
            this.logger.error((Object)"ERROR to insert a new AAC letter request while requesting an AAC letter", (Throwable)dex);
            throw new ServiceException("Data Access Object: AacLetterRequestDAO.insert() error: " + dex.getMessage(), (Throwable)dex);
        }
        return errMsgList;
    }

    @Override
    public List processLetterRules(Person person, ComLetterTemplateType formNum, String workflowCaseId, LetterTriggerEvent.MailType mailType, Boolean override, CommsLogEntry logEntry, String categoryType) throws ServiceException {
        return this.doProcessLetterRules(person, formNum, workflowCaseId, mailType, override, logEntry, categoryType, "REQUEST_LETTER");
    }

    @Override
    public List processLetterRulesForAACExport(Person person, ComLetterTemplateType formNum, String workflowCaseId, LetterTriggerEvent.MailType mailType, Boolean override, CommsLogEntry logEntry, String categoryType) throws ServiceException {
        return this.doProcessLetterRules(person, formNum, workflowCaseId, mailType, override, logEntry, categoryType, "AAC_EXPORT");
    }

    private List doProcessLetterRules(Person person, ComLetterTemplateType formNum, String workflowCaseId, LetterTriggerEvent.MailType mailType, Boolean override, CommsLogEntry logEntry, String categoryType, String context) throws ServiceException {
        List logs = null;
        try {
            logs = this.commsLogDAO.findCommsLogListByPersonId(person.getEntityKey().getKeyValueAsString());
        }
        catch (DAOException dex) {
            this.logger.error((Object)("ERROR to find comms log list with this person" + (Object)((Object)dex)));
            throw new ServiceException("Excption when find Comms log list for a person" + dex.getMessage(), (Throwable)dex);
        }
        ValidationMessages errMsgs1 = this.getRuleValidationService().validateLetterMailing(logEntry, person);
        List errMsgLst1 = this.convertErrorMessages(errMsgs1);
        ValidationMessages errMsgs2 = null;
        if (override == null || override.equals(Boolean.FALSE)) {
            errMsgs2 = this.getRuleValidationService().validateLetterSendRequest(person, formNum, workflowCaseId, mailType, override, logs, categoryType, context);
        }
        List errMsgLst2 = this.convertErrorMessages(errMsgs2);
        ArrayList<List> errMsgList = new ArrayList<List>();
        errMsgList.add(errMsgLst1);
        errMsgList.add(errMsgLst2);
        this.updateLogEntryInMemory(errMsgList, logEntry);
        return errMsgList;
    }

    @Override
    public Boolean cancelLetterRequest(CommsLogEntry commsLogEntry) throws ServiceException {
        Validate.notNull((Object)((Object)commsLogEntry), (String)"commsLogEntry is required");
        Boolean result = Boolean.FALSE;
        try {
            boolean validScenario = false;
            MailingStatusLink latestMailingStatus = commsLogEntry.getLatestMailingStatus();
            if (latestMailingStatus == null || ComMailingStatusType.SEND_TO_AAC.getCode().equals(latestMailingStatus.getMailingStatus().getCode()) || ComMailingStatusType.SEND_TO_CMS.getCode().equals(latestMailingStatus.getMailingStatus().getCode())) {
                validScenario = true;
                commsLogEntry.addMailingStatus(this.getLookupService().getComMailingStatusTypeByCode(ComMailingStatusType.CANCEL_BY_HEC.getCode()));
                this.setSentToIVM(commsLogEntry);
            } else if (ComMailingStatusType.CANCEL_BY_HEC.getCode().equals(latestMailingStatus.getMailingStatus().getCode())) {
                validScenario = true;
            }
            if (validScenario) {
                result = Boolean.TRUE;
                this.commsLogDAO.update(commsLogEntry);
                String commsLogEntryId = commsLogEntry.getEntityKey().getKeyValueAsString();
                List reqs = this.aacRequestDAO.findAacLetterRequestsByLogId(new BigDecimal(commsLogEntryId));
                if (reqs != null && !reqs.isEmpty()) {
                    AacLetterRequest req = null;
                    String dupChk = null;
                    for (int i = 0; i < reqs.size(); ++i) {
                        req = (AacLetterRequest)((Object)reqs.get(i));
                        dupChk = req.getCommsPrintRequestDupeCheck();
                        if (dupChk != null && dupChk.equals(commsLogEntryId)) continue;
                        req.setCommsPrintRequestDupeCheck(commsLogEntryId);
                        this.aacRequestDAO.saveObject((Object)req);
                    }
                }
            }
        }
        catch (DAOException dex) {
            this.logger.error((Object)"ERROR to cancel a AAC letter request", (Throwable)dex);
            throw new ServiceException("Exception trying to cancel a AAC letter request: " + dex.getMessage(), (Throwable)dex);
        }
        return result;
    }

    @Override
    public synchronized List getAvailableLettersForMailing() throws ServiceException {
        if (this.manualMailingLst == null) {
            try {
                return this.initTemplateList();
            }
            catch (DAOException e) {
                throw new ServiceException("Unable to retrieve static list of letters for manual mailing", (Throwable)e);
            }
        }
        return this.manualMailingLst;
    }

    public AacLetterRequestDAO getAacRequestDAO() {
        return this.aacRequestDAO;
    }

    public void setAacRequestDAO(AacLetterRequestDAO aacRequestDAO) {
        this.aacRequestDAO = aacRequestDAO;
    }

    public CommsLogEntryDAO getCommsLogDAO() {
        return this.commsLogDAO;
    }

    public void setCommsLogDAO(CommsLogEntryDAO commsLogDAO) {
        this.commsLogDAO = commsLogDAO;
    }

    public CommsTemplateDAO getTemplDAO() {
        return this.templDAO;
    }

    public void setTemplDAO(CommsTemplateDAO templDAO) {
        this.templDAO = templDAO;
    }

    private List convertErrorMessages(ValidationMessages errMsgs) {
        ArrayList<String> lst = new ArrayList<String>();
        if (errMsgs == null || errMsgs.isEmpty()) {
            return lst;
        }
        Iterator it = errMsgs.get();
        while (it.hasNext()) {
            lst.add(((ValidationMessage)it.next()).getKey());
        }
        return lst;
    }

    private AacLetterRequest createAacLetterRequest(LetterTriggerIdentity letterType, CommsLogEntry logEntry, Person person, List errMsgList) {
        AacLetterRequest req = new AacLetterRequest();
        req.setCommsLogEntry(logEntry);
        req.setCommsTemplateFormNumber(letterType.getDataType().getCode());
        String personId = person.getEntityKey().getKeyValueAsString();
        if (this.isRejectAtHec(errMsgList)) {
            req.setCommsPrintRequestDupeCheck(logEntry.getCommsLogIdString());
        } else {
            req.setCommsPrintRequestDupeCheck(this.createUniqueCode(personId, letterType));
        }
        return req;
    }

    private String createUniqueCode(String personId, LetterTriggerIdentity letterType) {
        StringBuffer buf = new StringBuffer();
        buf.append(LetterFormatHelper.padLeft(personId, 21, '0')).append(":");
        buf.append(letterType.getDataType().getCode()).append(":");
        buf.append(letterType.getCategoryType().getName());
        return buf.toString();
    }

    private CommsLogEntry createLogEntry(Person person, CommsTemplate templ, String workflowCaseId, LetterTriggerEvent.MailType mailType, LetterTrigger.CategoryType categoryType, Boolean override, Address mailingAddress, String actionComment, LetterTriggerEvent letterTriggerEvent) throws Exception {
        CommsLogEntry mostRecent;
        CommsLogEntry logEntry = new CommsLogEntry();
        String formNumber = templ.getCommsTemplateFormNumber();
        String recipient = "Veteran";
        if (formNumber.equals(ComLetterTemplateType.FORM_NUMBER_298.getCode()) || formNumber.equals(ComLetterTemplateType.FORM_NUMBER_299.getCode()) || LetterTrigger.CategoryType.SPOUSE_LETTER.getName().equals(categoryType.getName())) {
            recipient = "Spouse";
        } else if (LetterTrigger.CategoryType.DEPENDENT_LETTER.getName().equals(categoryType.getName())) {
            recipient = "Dependent";
        }
        logEntry.setPersonId(new BigDecimal(person.getPersonEntityKey().getKeyValueAsString()));
        logEntry.setRecipient(recipient);
        logEntry.setTemplate(templ);
        logEntry.setLetterType(templ.getLetterType());
        logEntry.setAddress(mailingAddress);
        logEntry.setOverrideIndicator(override);
        logEntry.setName(person.getLegalName());
        logEntry.setSsn(person.getOfficialSsn());
        logEntry.addActionComment(actionComment);
        if (mailType.equals((Object)LetterTriggerEvent.REMAIL_MAIL)) {
            logEntry.setRemailIndicator("RESEND");
        }
        logEntry.setComMailingTriggerType(this.getLookupService().getComMailingTriggerTypeByCode(mailType.getName()));
        if (workflowCaseId != null && workflowCaseId.length() > 0) {
            logEntry.setWorkflowCaseId(new BigDecimal(workflowCaseId));
        }
        if (letterTriggerEvent != null && ComLetterType.CODE_IVM.getCode().equals(templ.getLetterType().getCode())) {
            logEntry.setIvmCaseClosureDate(letterTriggerEvent.getIvmCaseClosureDate());
            logEntry.setIvmCaseNumber(letterTriggerEvent.getIvmCaseNumber());
        } else if (letterTriggerEvent == null && ComLetterType.CODE_IVM.getCode().equals(templ.getLetterType().getCode()) && !ComLetterTemplateType.FORM_NUMBER_683A.getCode().equals(formNumber) && (mostRecent = this.getMostRecentCommsLogByFormWithCompleteIvmData(person, formNumber)) != null) {
            logEntry.setIvmCaseClosureDate(mostRecent.getIvmCaseClosureDate());
            logEntry.setIvmCaseNumber(mostRecent.getIvmCaseNumber());
        }
        this.setSentToIVM(logEntry);
        return logEntry;
    }

    private CommsLogEntry getMostRecentCommsLogByFormWithCompleteIvmData(Person person, String form) throws ServiceException {
        if (form == null) {
            return null;
        }
        List list = null;
        try {
            list = this.commsLogDAO.findCommsLogListByPersonId(person.getEntityKey().getKeyValueAsString());
        }
        catch (DAOException dex) {
            this.logger.error((Object)("ERROR to find comms log list with this person" + (Object)((Object)dex)));
            throw new ServiceException("Excption when find Comms log list for a person" + dex.getMessage(), (Throwable)dex);
        }
        ArrayList<CommsLogEntry> filteredList = new ArrayList<CommsLogEntry>();
        for (CommsLogEntry entry : list) {
            if (!form.equals(entry.getFormNumber()) || entry.getIvmCaseClosureDate() == null || entry.getIvmCaseNumber() == null) continue;
            filteredList.add(entry);
        }
        Comparator comparator = new Comparator(){

            public int compare(Object pObject1, Object pObject2) {
                CommsLogEntry entry1 = (CommsLogEntry)((Object)pObject1);
                CommsLogEntry entry2 = (CommsLogEntry)((Object)pObject2);
                if (entry1 == null || entry1.getModifiedOn() == null) {
                    return -1;
                }
                if (entry2 == null || entry2.getModifiedOn() == null) {
                    return 1;
                }
                return entry2.getModifiedOn().compareTo(entry1.getModifiedOn());
            }
        };
        ArrayList orderedEntries = new ArrayList(filteredList);
        Collections.sort(orderedEntries, comparator);
        CommsLogEntry recent = null;
        if (orderedEntries.size() > 0) {
            recent = (CommsLogEntry)((Object)orderedEntries.get(0));
        }
        return recent;
    }

    private void updateLogEntryInMemory(List errMsgs, CommsLogEntry logEntry) throws ServiceException {
        if (this.isRejectAtHec(errMsgs)) {
            logEntry.addMailingStatus(this.getLookupService().getComMailingStatusTypeByCode(ComMailingStatusType.REJECT_AT_HEC.getCode()));
            List msgLst = null;
            for (int j = 0; j < 2; ++j) {
                msgLst = (List)errMsgs.get(j);
                for (int i = 0; i < msgLst.size(); ++i) {
                    logEntry.addHecRejectReason((String)msgLst.get(i));
                }
            }
        } else if (logEntry.getEntityKey() == null) {
            ComMailingStatusType.Code type = ComMailingStatusType.SEND_TO_AAC;
            if (logEntry.getTemplate().getLetterType().getCode().equals(ComLetterType.CODE_HANDBOOK.getCode())) {
                type = ComMailingStatusType.SEND_TO_CMS;
            } else if (logEntry.getTemplate().getLetterType().getCode().equals(ComLetterType.CODE_IVM.getCode())) {
                type = ComMailingStatusType.SEND_TO_CMS;
            }
            logEntry.addMailingStatus(this.getLookupService().getComMailingStatusTypeByCode(type.getCode()));
        } else {
            ComMailingStatusType.Code type = ComMailingStatusType.SENT_TO_AAC;
            if (logEntry.getTemplate().getLetterType().getCode().equals(ComLetterType.CODE_HANDBOOK.getCode())) {
                type = ComMailingStatusType.SENT_TO_CMS;
            } else if (logEntry.getTemplate().getLetterType().getCode().equals(ComLetterType.CODE_IVM.getCode())) {
                type = ComMailingStatusType.SENT_TO_CMS;
            }
            logEntry.addMailingStatus(this.getLookupService().getComMailingStatusTypeByCode(type.getCode()));
        }
        this.setSentToIVM(logEntry);
    }

    private boolean isRejectAtHec(List errMsgs) {
        return !((List)errMsgs.get(0)).isEmpty() || !((List)errMsgs.get(1)).isEmpty();
    }

    protected List initTemplateList() throws DAOException {
        this.manualMailingLst = new ArrayList();
        this.manualMailingLst.add(this.templDAO.findTemplateListByFormNumber(ComLetterTemplateType.FORM_NUMBER_290.getCode()).get(0));
        this.manualMailingLst.add(this.templDAO.findTemplateListByFormNumber(ComLetterTemplateType.FORM_NUMBER_291.getCode()).get(0));
        this.manualMailingLst.add(this.templDAO.findTemplateListByFormNumber(ComLetterTemplateType.FORM_NUMBER_292.getCode()).get(0));
        this.manualMailingLst.add(this.templDAO.findTemplateListByFormNumber(ComLetterTemplateType.FORM_NUMBER_293.getCode()).get(0));
        this.manualMailingLst.add(this.templDAO.findTemplateListByFormNumber(ComLetterTemplateType.FORM_NUMBER_600C.getCode()).get(0));
        this.manualMailingLst.add(this.templDAO.findTemplateListByFormNumber(ComLetterTemplateType.FORM_NUMBER_600D.getCode()).get(0));
        this.manualMailingLst.add(this.templDAO.findTemplateListByFormNumber(ComLetterTemplateType.FORM_NUMBER_620A.getCode()).get(0));
        this.manualMailingLst.add(this.templDAO.findTemplateListByFormNumber(ComLetterTemplateType.FORM_NUMBER_623C.getCode()).get(0));
        this.manualMailingLst.add(this.templDAO.findTemplateListByFormNumber(ComLetterTemplateType.FORM_NUMBER_623D.getCode()).get(0));
        this.manualMailingLst.add(this.templDAO.findTemplateListByFormNumber(ComLetterTemplateType.FORM_NUMBER_640B.getCode()).get(0));
        this.manualMailingLst.add(this.templDAO.findTemplateListByFormNumber(ComLetterTemplateType.FORM_NUMBER_640C.getCode()).get(0));
        this.manualMailingLst.add(this.templDAO.findTemplateListByFormNumber(ComLetterTemplateType.FORM_NUMBER_640V.getCode()).get(0));
        this.manualMailingLst.add(this.templDAO.findTemplateListByFormNumber(ComLetterTemplateType.FORM_NUMBER_640D.getCode()).get(0));
        this.manualMailingLst.add(this.templDAO.findTemplateListByFormNumber(ComLetterTemplateType.FORM_NUMBER_640G.getCode()).get(0));
        this.manualMailingLst.add(this.templDAO.findTemplateListByFormNumber(ComLetterTemplateType.FORM_NUMBER_640H.getCode()).get(0));
        this.manualMailingLst.add(this.templDAO.findTemplateListByFormNumber(ComLetterTemplateType.FORM_NUMBER_640I.getCode()).get(0));
        this.manualMailingLst.add(this.templDAO.findTemplateListByFormNumber(ComLetterTemplateType.FORM_NUMBER_640K.getCode()).get(0));
        return this.manualMailingLst;
    }

    private void setSentToIVM(CommsLogEntry logEntry) {
        if (ComLetterType.CODE_IVM.getCode().equals(logEntry.getLetterType().getCode())) {
            logEntry.setSentToIVM(Boolean.TRUE);
        }
    }
}

