/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.impl;

import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.financials.IncomeTestStatus;
import gov.va.med.esr.common.model.lookup.IncomeTestType;
import gov.va.med.esr.common.model.lookup.MeansTestStatus;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.common.persistent.history.HistoryDAO;
import gov.va.med.esr.common.rule.service.EventRuleService;
import gov.va.med.esr.service.ClinicalDeterminationService;
import gov.va.med.esr.service.impl.AbstractHistoricalInfoServiceImpl;
import gov.va.med.esr.service.impl.ChangeEvent;
import gov.va.med.esr.service.impl.HistoricalInfo;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.service.ServiceException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;

public class ClinicalDeterminationServiceImpl
extends AbstractHistoricalInfoServiceImpl
implements ClinicalDeterminationService {
    private static final long serialVersionUID = 6807451026344643378L;
    private HistoryDAO retiredCDHistoryDAO = null;

    @Override
    public Person processCdForCleanup(PersonEntityKey key) throws ServiceException {
        Validate.notNull((Object)key, (String)"A veteran key must not be null");
        Person person = this.getPersonService().getPerson(key);
        this.adjustFutureAndSecondaryTestsWithCd(person);
        this.getEnrollmentRuleService().calculateEE(person, true, false);
        EventRuleService eventRuleService = this.getEventRuleService();
        eventRuleService.manageMessageEvents(person);
        eventRuleService.manageHandBookEvents(person);
        return this.getPersonService().save(person);
    }

    private void adjustFutureAndSecondaryTestsWithCd(Person person) throws ServiceException {
        IncomeTest current = this.getHelperService().getCurrentIncomeTest(person);
        if (current != null && current.getType() != null) {
            Map incomeTests;
            ArrayList incomeYears;
            IncomeTestStatus incomeTestStatus;
            Boolean cdIndicator;
            Boolean bl = cdIndicator = person.getCatastrophicDisability() != null ? person.getCatastrophicDisability().isCatastrophicallyDisabled() : null;
            if (cdIndicator == null || !cdIndicator.booleanValue()) {
                return;
            }
            if (IncomeTestType.CODE_MEANS_TEST.getCode().equals(current.getType().getCode()) && (incomeTestStatus = current.getPharmacyCoPayStatus()) != null && incomeTestStatus.getType() != null && IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST.getCode().equals(incomeTestStatus.getType().getCode())) {
                incomeTestStatus.setStatus(this.getLookupService().getMeansTestStatusByCode(MeansTestStatus.MT_STATUS_NP_LONGER_APPLICABLE_RX_COPAY_ONLY.getName()));
            }
            if ((incomeYears = new ArrayList((incomeTests = person.getIncomeTests()).keySet())) == null || incomeYears.isEmpty()) {
                return;
            }
            Collections.sort(incomeYears);
            for (int i = incomeYears.size() - 1; i >= 0; --i) {
                MeansTestStatus meansTestStatus;
                Integer incomeYear = (Integer)incomeYears.get(i);
                IncomeTest incomeTest = (IncomeTest)((Object)incomeTests.get(incomeYear));
                if (incomeTest.isFutureTest() == null || !incomeTest.isFutureTest().booleanValue() || (meansTestStatus = incomeTest.getStatus()) == null || MeansTestStatus.MT_STATUS_NO_LONGER_REQUIRED.getName().equals(meansTestStatus.getCode()) || MeansTestStatus.MT_STATUS_NP_LONGER_APPLICABLE_RX_COPAY_ONLY.getName().equals(meansTestStatus.getCode())) continue;
                IncomeTestType type = incomeTest.getType();
                if (type != null && IncomeTestType.CODE_MEANS_TEST.getCode().equals(type.getCode())) {
                    incomeTest.setMeansTestStatus(this.getLookupService().getMeansTestStatusByCode(MeansTestStatus.MT_STATUS_NO_LONGER_REQUIRED.getName()));
                    continue;
                }
                if (type == null || !IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST.getCode().equals(type.getCode())) continue;
                incomeTest.setMeansTestStatus(this.getLookupService().getMeansTestStatusByCode(MeansTestStatus.MT_STATUS_NP_LONGER_APPLICABLE_RX_COPAY_ONLY.getName()));
            }
        }
    }

    @Override
    public HistoricalInfo getClinicalDeterminationHistoryByChangeTime(ChangeEvent event) throws ServiceException {
        try {
            return this.getHistoryDAO().getHistoryByChangeTime(event);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Set getClinicalDeterminationHistoryChangeTimes(EntityKey personID) throws ServiceException {
        try {
            return this.getHistoryDAO().getHistoryChangeTimes(personID);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public HistoricalInfo getRetiredCDHistoryByChangeTime(ChangeEvent event) throws ServiceException {
        try {
            return this.getRetiredCDHistoryDAO().getHistoryByChangeTime(event);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Set getRetiredCDHistoryChangeTimes(EntityKey personID) throws ServiceException {
        try {
            return this.getRetiredCDHistoryDAO().getHistoryChangeTimes(personID);
        }
        catch (DAOException e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    public HistoryDAO getRetiredCDHistoryDAO() {
        return this.retiredCDHistoryDAO;
    }

    public void setRetiredCDHistoryDAO(HistoryDAO retiredCDHistoryDAO) {
        this.retiredCDHistoryDAO = retiredCDHistoryDAO;
    }
}

