/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service.external.demographics;

import gov.va.med.caip.client.businessdelegate.BusinessDelegateInfo;
import gov.va.med.esr.service.external.ESRException;
import gov.va.med.esr.service.external.ExternalServiceImpl;
import gov.va.med.esr.service.external.demographics.DemographicsChangeEvent;
import gov.va.med.esr.service.external.demographics.DemographicsChangeSummary;
import gov.va.med.esr.service.external.demographics.DemographicsChangeType;
import gov.va.med.esr.service.external.demographics.DemographicsService;
import gov.va.med.esr.service.external.demographics.DemographicsServiceInfo;
import gov.va.med.esr.service.external.demographics.ejb.DemographicsServiceHome;
import gov.va.med.esr.service.external.demographics.ejb.RemoteDemographicsService;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.Set;
import javax.ejb.CreateException;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;

public class DemographicsServiceImpl
extends ExternalServiceImpl
implements DemographicsService {
    private static final long serialVersionUID = -4415928048589042271L;

    @Override
    public void notifyOfDemographicsChange(DemographicsChangeSummary changeSummary) throws ESRException {
        this.validate(changeSummary);
        try {
            ((RemoteDemographicsService)this.getEJB()).notifyOfDemographicsChange(changeSummary);
        }
        catch (Exception e) {
            throw new ESRException("Unable to handle demographics change", e);
        }
    }

    private void validate(DemographicsChangeSummary changeSummary) throws ESRException {
        DemographicsChangeEvent event = null;
        Set events = null;
        DemographicsChangeType[] changeTypesThatRequireEntityKeys = new DemographicsChangeType[]{DemographicsChangeType.ADDRESS_CHANGE, DemographicsChangeType.GUARDIAN_INFO_CHANGE, DemographicsChangeType.PHONE_CHANGE, DemographicsChangeType.EMAIL_CHANGE, DemographicsChangeType.PERSON_RELATION_SSN_VALIDATION_INFO_CHANGE};
        for (int i = 0; i < changeTypesThatRequireEntityKeys.length; ++i) {
            Iterator itr;
            if (!changeSummary.containsChangeEventsByType(changeTypesThatRequireEntityKeys[i])) continue;
            events = changeSummary.getChangeEventsByType(changeTypesThatRequireEntityKeys[i]);
            Iterator iterator = itr = events != null ? events.iterator() : null;
            while (itr != null && itr.hasNext()) {
                event = (DemographicsChangeEvent)itr.next();
                if (event.getEntityKey() != null) continue;
                throw new ESRException("Illegal DemographicsChangeEvent.  This type requires an EntityKey: " + changeTypesThatRequireEntityKeys[i]);
            }
        }
    }

    @Override
    public BusinessDelegateInfo getBusinessDelegateInterfaceInfo() {
        return new DemographicsServiceInfo();
    }

    @Override
    protected EJBObject createEJB(EJBHome home) throws RemoteException, CreateException {
        return ((DemographicsServiceHome)home).create();
    }
}

