/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.service;

import gov.va.med.fw.service.AbstractComponent;
import gov.va.med.fw.service.trigger.Log4jTriggerEvent;
import gov.va.med.fw.service.trigger.TriggerEvent;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class Log4jConfigService
extends AbstractComponent {
    protected Log logger = LogFactory.getLog((String)"ALWAYS_LOGGER");
    private Map loggerLogLevels = null;

    public void init() {
        this.loggerLogLevels = new HashMap();
        Enumeration loggers = LogManager.getCurrentLoggers();
        while (loggers.hasMoreElements()) {
            Logger logger = (Logger)loggers.nextElement();
            if (!logger.getName().startsWith("gov")) continue;
            this.loggerLogLevels.put(logger.getName(), logger.getEffectiveLevel().toString().toLowerCase());
        }
        this.logger.info((Object)("Cached : " + this.loggerLogLevels.size() + " Logger log default levels."));
    }

    public void updateLogLevel(TriggerEvent triggerEvent) {
        if (this.loggerLogLevels == null) {
            this.init();
        }
        Log4jTriggerEvent log4jTriggerEvent = (Log4jTriggerEvent)triggerEvent;
        Map logLevels = null;
        if (Log4jTriggerEvent.UPDATE.equals((Object)log4jTriggerEvent.getTriggerEventType())) {
            Object[] payLoad = (Object[])log4jTriggerEvent.getPayload();
            logLevels = payLoad != null && payLoad.length > 0 ? (Map)payLoad[0] : null;
        } else if (Log4jTriggerEvent.RESET_TO_DEFAULT.equals((Object)log4jTriggerEvent.getTriggerEventType())) {
            logLevels = this.loggerLogLevels;
        }
        this.updateLogLevel(logLevels);
    }

    public void updateLogLevel(Map logConfigs) {
        Logger selectedLogger = null;
        int noLoggers = 0;
        if (logConfigs == null) {
            return;
        }
        for (String loggerName : logConfigs.keySet()) {
            String logLevel = (String)logConfigs.get(loggerName);
            selectedLogger = LogManager.getLogger((String)loggerName);
            Level currentLevel = selectedLogger.getEffectiveLevel();
            if (currentLevel.toString().equalsIgnoreCase(logLevel)) continue;
            selectedLogger.setLevel(Level.toLevel((String)logLevel));
            ++noLoggers;
            this.logger.info((Object)("Updated Logger: " + loggerName + " from log level " + currentLevel + "  to log level " + logLevel.toUpperCase()));
        }
        this.logger.info((Object)("Updated : " + noLoggers + " Logger log levels."));
    }
}

