/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.util;

import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.person.Association;
import gov.va.med.esr.common.model.person.Name;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.lang.StringUtils;

public class LetterFormatHelper {
    public static final String BARCODE_POA_TOKEN = "-@barCode@-";
    private static final String FOUR_SPACES = "    ";
    private static final String FIVE_SPACES = "     ";
    private static final String AAC_FORM_PREFIX = "F";
    private static final String DATE_SEPARATOR = "/";
    private static final String SSN_SEPARATOR = "-";
    private static final String US_STATE_CODE = "US-";
    private static final char DATE_PADDING = '0';

    public static String addDays(Date startDate, int days, SimpleDateFormat sdf) {
        return sdf.format(LetterFormatHelper.addDays(startDate, days));
    }

    public static Date addDays(Date startDate, int days) {
        if (startDate == null) {
            return null;
        }
        if (days == 0) {
            return startDate;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(startDate);
        ((Calendar)cal).add(5, days);
        return cal.getTime();
    }

    public static String ToDollarAmount(BigDecimal amt, int decimalDigits, int roundingMode) {
        if (amt == null) {
            return "";
        }
        String strNumber = amt.setScale(decimalDigits, roundingMode).toString();
        boolean isNegtive = false;
        if (strNumber.startsWith(SSN_SEPARATOR)) {
            isNegtive = true;
            strNumber = strNumber.substring(1);
        }
        for (int index = (index = strNumber.indexOf(".")) > 0 ? strNumber.length() - 3 - index : strNumber.length() - 3; index > 0; index -= 3) {
            strNumber = strNumber.substring(0, index) + "," + strNumber.substring(index);
        }
        strNumber = "$" + strNumber;
        if (isNegtive) {
            strNumber = SSN_SEPARATOR + strNumber;
        }
        return strNumber;
    }

    public static String padRight(String str, int length) {
        return LetterFormatHelper.padRight(str, length, ' ');
    }

    private static String getRepeatedChar(int len, char ch) {
        StringBuffer strBuf = new StringBuffer(ch);
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                strBuf.append(ch);
            }
        }
        return strBuf.toString();
    }

    public static String padRight(String str, int length, char ch) {
        if (str == null || str.length() == 0) {
            return LetterFormatHelper.getRepeatedChar(length, ch);
        }
        int len = str.length();
        if (len >= length) {
            return str;
        }
        return str + LetterFormatHelper.getRepeatedChar(length - len, ch);
    }

    public static String padLeft(String str, int length) {
        return LetterFormatHelper.padLeft(str, length, ' ');
    }

    public static String padLeft(String str, int length, char ch) {
        if (str == null || str.length() == 0) {
            return LetterFormatHelper.getRepeatedChar(length, ch);
        }
        int len = str.length();
        if (len >= length) {
            return str;
        }
        return LetterFormatHelper.getRepeatedChar(length - len, ch) + str;
    }

    public static String toAACFormNumber(String formNumber) {
        if (formNumber == null || formNumber.length() == 0) {
            return FIVE_SPACES;
        }
        return LetterFormatHelper.padRight(formNumber.replaceAll("742-", AAC_FORM_PREFIX), 5);
    }

    public static String toAACVerNumber(String aacVerNum) {
        if (aacVerNum == null || aacVerNum.length() == 0) {
            return FOUR_SPACES;
        }
        return LetterFormatHelper.padLeft(aacVerNum, 4, '0');
    }

    public static String toAACSsn(String ssn) {
        if (ssn == null || ssn.length() == 0) {
            return "         ";
        }
        return ssn.replaceAll(SSN_SEPARATOR, "");
    }

    public static String toAACDate(String dtString) {
        if (dtString == null || dtString.length() == 0) {
            return "";
        }
        String[] dates = dtString.split(DATE_SEPARATOR);
        if (dates.length == 1 && dtString.length() == 8) {
            return dtString.substring(4) + dtString.substring(0, 4);
        }
        if (dates.length == 3) {
            return LetterFormatHelper.padLeft(dates[0], 2, '0') + LetterFormatHelper.padLeft(dates[1], 2, '0') + LetterFormatHelper.padLeft(dates[2], 4, '0');
        }
        return dtString;
    }

    public static String toAACDate(Date dTime) {
        if (dTime == null) {
            return "";
        }
        SimpleDateFormat aacDateFormat = new SimpleDateFormat("MMddyyyy");
        return aacDateFormat.format(dTime);
    }

    public static String toAACState(String state) {
        if (state == null || state.length() == 0) {
            return "  ";
        }
        return state.replaceAll(US_STATE_CODE, "");
    }

    public static String getString(String str) {
        return str == null ? "" : str;
    }

    public static String getMailingAddressLine2and3(Address address) {
        String addressLine2 = address.getLine2();
        String addressLine3 = address.getLine3();
        String combinedAddressLine2 = addressLine2;
        if (addressLine2 != null && addressLine3 != null) {
            combinedAddressLine2 = combinedAddressLine2 + " " + addressLine3;
        } else if (addressLine2 == null && addressLine3 != null) {
            combinedAddressLine2 = addressLine3;
        }
        return LetterFormatHelper.getString(combinedAddressLine2);
    }

    public static String getMailingAddressState(Address address) {
        String val = null;
        if (address.isUSAddress()) {
            val = address.getState();
        }
        return val;
    }

    public static String getMailingAddressZipOrPostal(Address address) {
        String val = null;
        if (address.isUSAddress()) {
            if (StringUtils.isNotBlank((String)address.getZipCode())) {
                val = StringUtils.isNotBlank((String)address.getZipPlus4()) ? address.getZipCode() + SSN_SEPARATOR + address.getZipPlus4() : address.getZipCode();
            }
        } else {
            val = address.getPostalCode();
        }
        return val;
    }

    public static String getMailingAddressCountyOrProvince(Address address) {
        String val = null;
        val = address.isUSAddress() ? address.getCounty() : address.getProvince();
        return val;
    }

    public static String getMailingAddressCountry(Address address) {
        return address.getCountryObject() != null && StringUtils.isNotBlank((String)address.getCountryObject().getPostalName()) ? address.getCountryObject().getPostalName() : address.getCountry();
    }

    public static String getPOAName(Association poa) {
        String poaName = null;
        if (poa.getOrganizationName() != null) {
            poaName = poa.getOrganizationName();
        } else if (poa.getRepresentativeName() != null) {
            poaName = poa.getRepresentativeName().getFormattedName(Name.NAME_FORMAT_FIRST_SPACE_LAST);
        }
        return LetterFormatHelper.getString(poaName);
    }

    public static String formatBarcode(String barcode) {
        return LetterFormatHelper.padRight(barcode, 21, ' ');
    }
}

