/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.util;

import java.io.File;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import org.apache.commons.io.IOUtils;
import org.apache.cxf.headers.Header;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.cxf.io.CacheAndWriteOutputStream;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.io.CachedOutputStreamCallback;
import org.apache.cxf.message.Message;
import us.gov.treasury.irs.ext.aca.air._7.ACABulkBusinessHeaderRequestType;
import us.gov.treasury.irs.ext.aca.air._7.ACATrnsmtManifestReqDtlType;
import weblogic.xml.security.wsse.Security;

public class CxfOutInterceptor
extends LoggingOutInterceptor {
    String soapXml = "";
    StringBuilder builder = new StringBuilder();

    public CxfOutInterceptor() {
        super("pre-stream");
    }

    public void handleMessage(Message message) throws Fault {
        this.setPrettyLogging(true);
        this.setShowBinaryContent(true);
        this.setShowMultipartContent(true);
        OutputStream out = (OutputStream)message.getContent(OutputStream.class);
        CacheAndWriteOutputStream newOut = new CacheAndWriteOutputStream(out);
        message.setContent(OutputStream.class, (Object)newOut);
        this.getHeader(message, this.builder);
        this.getAttach(message, this.builder);
        newOut.registerCallback((CachedOutputStreamCallback)new LoggingCallback());
    }

    protected String getHeader(Message message, StringBuilder builder) {
        List headers = (List)message.get((Object)Header.HEADER_LIST);
        if (headers != null) {
            for (Header header : headers) {
                String m;
                if (header.getName().getLocalPart().equalsIgnoreCase(ACATrnsmtManifestReqDtlType.class.getName())) {
                    m = this.buildXmlDocument(new JAXBElement(new QName(ACATrnsmtManifestReqDtlType.class.getSimpleName()), ACATrnsmtManifestReqDtlType.class, header.getObject()));
                    builder.append(m);
                }
                if (header.getName().getLocalPart().equalsIgnoreCase(ACABulkBusinessHeaderRequestType.class.getName())) {
                    m = this.buildXmlDocument(new JAXBElement(new QName(ACABulkBusinessHeaderRequestType.class.getSimpleName()), ACABulkBusinessHeaderRequestType.class, header.getObject()));
                    builder.append(m);
                }
                if (!header.getName().getLocalPart().equalsIgnoreCase(Security.class.getName())) continue;
                m = this.buildXmlDocument(new JAXBElement(new QName(Security.class.getSimpleName()), Security.class, header.getObject()));
                builder.append(m);
            }
        } else {
            builder.append("HEADERS ARE NULL");
        }
        return null;
    }

    protected String getAttach(Message message, StringBuilder builder) {
        try {
            Collection att = message.getAttachments();
            if (att != null) {
                for (Object o : att) {
                    builder.append(o.toString());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private String buildXmlDocument(JAXBElement document) {
        Class<?> clazz = document.getValue().getClass();
        try {
            JAXBContext context = JAXBContext.newInstance((String)clazz.getPackage().getName());
            Marshaller m = context.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            StringWriter sw = new StringWriter();
            m.marshal((Object)document, (Writer)sw);
            String xml = sw.toString();
            return xml;
        }
        catch (JAXBException jAXBException) {
            return null;
        }
    }

    public class LoggingCallback
    implements CachedOutputStreamCallback {
        public void onFlush(CachedOutputStream cos) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void onClose(CachedOutputStream cos) {
            try {
                cos.writeCacheTo(CxfOutInterceptor.this.builder, (long)CxfOutInterceptor.this.limit);
                String soapXml = CxfOutInterceptor.this.builder.toString();
                FileWriter f = null;
                try {
                    f = new FileWriter(new File("cxf.intercept.txt"));
                    f.append(soapXml);
                    if (f == null) return;
                }
                catch (Exception ex) {
                    if (f == null) return;
                    IOUtils.closeQuietly(f);
                    return;
                    catch (Throwable throwable) {
                        if (f == null) throw throwable;
                        IOUtils.closeQuietly(f);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((Writer)f);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

