/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.ui.conversion;

import gov.va.med.esr.common.model.financials.DependentFinancials;
import gov.va.med.esr.common.model.financials.RelationFinancials;
import gov.va.med.esr.common.model.financials.SpouseFinancials;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.person.Employment;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.Relation;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.common.model.person.Spouse;
import gov.va.med.esr.common.ui.conversion.CommonConversionServiceImpl;
import gov.va.med.esr.common.ui.form.DependentFinancialInfoBean;
import gov.va.med.esr.common.ui.form.RelationFinancialInfoBean;
import gov.va.med.esr.common.ui.form.SpouseFinancialInfoBean;
import gov.va.med.esr.common.util.CommonDateUtils;
import gov.va.med.esr.common.util.CommonJspUtils;
import gov.va.med.fw.conversion.ConversionServiceException;
import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.util.StringUtils;
import java.math.BigDecimal;

public class CommonFinancialsDependentConversionService
extends CommonConversionServiceImpl {
    public static final String LIVED_WITH_VETERAN = "Lived with veteran last calendar year";
    public static final String DIDNT_LIVE_WITH_VETERAN = "Did not live with veteran last calendar year";

    protected void convertBean(Object source, Object target) throws ConversionServiceException {
    }

    public void convertSpouseFinancialsToBean(SpouseFinancials spFins, SpouseFinancialInfoBean bean) {
        StringBuffer dependencyFactors = new StringBuffer();
        if (spFins != null) {
            BigDecimal spouseAmt;
            this.convertFinancialsId(spFins, bean);
            this.convertValidDependent(spFins, bean);
            this.convertLivedWithVeteran(spFins, bean, dependencyFactors);
            BigDecimal bigDecimal = spouseAmt = spFins.getFinancialStatement() != null ? spFins.getFinancialStatement().getContributionToSpouse() : null;
            if (spouseAmt != null) {
                bean.setContributedToSupport(spouseAmt.toString());
            }
            if (spFins.getFinancialStatement() != null) {
                bean.setContributedToSpouseInd(this.getYesNoNoData(spFins.getFinancialStatement().getContributedToSpouseInd()));
            }
            bean.setDependencyFactors(dependencyFactors.toString());
            bean.setActive(spFins.isActive());
            this.convertRelationToBean(spFins.getReportedOn(), bean);
        }
    }

    public void convertDependentFinancialsToBean(DependentFinancials depFin, DependentFinancialInfoBean bean) {
        StringBuffer dependencyFactors = new StringBuffer();
        if (depFin != null) {
            this.convertFinancialsId(depFin, bean);
            this.convertValidDependent(depFin, bean);
            bean.setIncapableOfSelfSupport(this.getYesNoNoData(depFin.getIncapableOfSelfSupport()));
            if (Boolean.TRUE.equals(depFin.getIncapableOfSelfSupport())) {
                dependencyFactors.append("Child incapable of self support").append("<br>");
            }
            bean.setHasIncome(this.getYesNoNoData(depFin.getHasIncome()));
            if (Boolean.TRUE.equals(depFin.getHasIncome())) {
                dependencyFactors.append("Child has Income").append("<br>");
            }
            bean.setContributedToSupport(this.getYesNoNoData(depFin.getContributedToSupport()));
            if (Boolean.TRUE.equals(depFin.getContributedToSupport())) {
                dependencyFactors.append("Contributed to child support").append("<br>");
            }
            bean.setAttendedSchool(this.getYesNoNoData(depFin.getAttendedSchool()));
            if (Boolean.TRUE.equals(depFin.getAttendedSchool())) {
                dependencyFactors.append("Child in school").append("<br>");
            }
            this.convertLivedWithVeteran(depFin, bean, dependencyFactors);
            bean.setIncomeAvailableToPatient(this.getYesNoNoData(depFin.getIncomeAvailableToPatient()));
            if (Boolean.TRUE.equals(depFin.getIncomeAvailableToPatient())) {
                dependencyFactors.append("Child has available income").append("<br>");
            }
            if (depFin.getAmountContributedToSupport() != null) {
                bean.setAmtContributed(depFin.getAmountContributedToSupport().toString());
            }
            bean.setDependencyFactors(dependencyFactors.toString());
            bean.setActive(depFin.isActive());
            this.convertRelationToBean(depFin.getReportedOn(), bean);
        }
    }

    private void convertFinancialsId(RelationFinancials ftmt, RelationFinancialInfoBean bean) {
        bean.setFinancialsId(ftmt.getEntityKey() == null ? null : ftmt.getEntityKey().getKeyValueAsString());
    }

    private void convertValidDependent(RelationFinancials fin, RelationFinancialInfoBean bean) {
        Boolean validDep = fin.getValidDependent();
        bean.setValidDependent(validDep == null ? "Undetermined" : (validDep != false ? "Yes" : "No"));
    }

    private void convertLivedWithVeteran(RelationFinancials fin, RelationFinancialInfoBean bean, StringBuffer dependencyFactors) {
        bean.setLivedWithVeteran(this.getYesNoNoData(fin.getLivedWithPatient()));
        if (Boolean.TRUE.equals(fin.getLivedWithPatient())) {
            dependencyFactors.append(LIVED_WITH_VETERAN).append("<br>");
        } else if (Boolean.FALSE.equals(fin.getLivedWithPatient())) {
            dependencyFactors.append(LIVED_WITH_VETERAN).append("<br>");
        }
    }

    private void convertRelationToBean(Relation relation, RelationFinancialInfoBean bean) {
        if (relation != null && bean != null) {
            this.convertIdentifier(relation, bean);
            this.convertNames(relation, bean);
            this.convertDates(relation, bean);
            this.convertRelationship(relation, bean);
            this.convertGender(relation, bean);
            this.convertSsns(relation, bean);
            if (relation instanceof Spouse) {
                this.convertSpouseToBean((Spouse)relation, (SpouseFinancialInfoBean)bean);
            }
        }
    }

    private void convertSpouseToBean(Spouse spouse, SpouseFinancialInfoBean spouseInfoBean) {
        spouseInfoBean.setMaidenName(spouse.getMaidenName());
        Employment employment = spouse.getEmployment();
        if (employment != null) {
            spouseInfoBean.setEmploymentStatus(this.getLookupCode((Lookup)employment.getEmploymentStatus()));
            spouseInfoBean.setOnFileEmploymentStatus(this.getLookupCode((Lookup)employment.getEmploymentStatus()));
            spouseInfoBean.setOccupation(employment.getOccupation());
            spouseInfoBean.setEmployerName(employment.getEmployerName());
            spouseInfoBean.setEmployerAddress(CommonJspUtils.displayAddress(employment.getEmployerAddress()));
            spouseInfoBean.setEmployerPhone(employment.getEmployerPhone());
            spouseInfoBean.setRetirementDate(CommonDateUtils.format(employment.getRetirementDate(), null));
        }
        Address address = spouse.getAddress();
        spouseInfoBean.setAddress(CommonJspUtils.displayAddress(address));
        if (address != null && address.getChangeDate() != null) {
            spouseInfoBean.setAddressChangeDate(CommonDateUtils.formatWithTime(address.getChangeDate(), null));
        }
        spouseInfoBean.setPhone(CommonJspUtils.displayPhone(spouse.getHomePhone()));
    }

    private void convertIdentifier(Relation relation, RelationFinancialInfoBean bean) {
        bean.setIdentifier(relation.getEntityKey() == null ? null : relation.getEntityKey().getKeyValueAsString());
    }

    private void convertDates(Relation relation, RelationFinancialInfoBean bean) {
        if (relation.getDob() != null) {
            bean.setDateOfBirth(CommonJspUtils.displayValue(relation.getDob(), "MM/dd/yyyy"));
        }
        if (relation.getStartDate() != null) {
            bean.setEffectiveDate(CommonJspUtils.displayValue(relation.getStartDate(), "MM/dd/yyyy"));
        }
        if (relation.getEndDate() != null) {
            bean.setInactiveDate(CommonJspUtils.displayValue(relation.getEndDate(), "MM/dd/yyyy"));
        }
    }

    private void convertNames(Relation relation, RelationFinancialInfoBean bean) {
        Name name = relation.getName();
        if (name != null) {
            bean.setFirstName(name.getGivenName());
            bean.setLastName(name.getFamilyName());
            bean.setMiddleName(name.getMiddleName());
            bean.setPrefix(name.getPrefix());
            bean.setSuffix(name.getSuffix());
        }
    }

    private void convertSsns(Relation relation, RelationFinancialInfoBean bean) {
        SSN pssn;
        SSN ssn = relation.getOfficialSsn();
        if (ssn != null) {
            bean.setSsn(CommonJspUtils.displaySSN(ssn.getSsnText()));
            if (ssn.getSsaMessage() != null) {
                bean.setSsaMessage(ssn.getSsaMessage().getDescription());
            }
            bean.setSsaVerificationDate(CommonDateUtils.format(ssn.getSsaVerificationDate(), "MM/dd/yyyy h:mm:ssa"));
            if (ssn.getSsaVerificationStatus() != null) {
                bean.setSsaVerificationStatus(ssn.getSsaVerificationStatus().getCode());
            }
            if (ssn.getSourceOfChange() != null) {
                bean.setSsnSourceOfChange(ssn.getSourceOfChange().getCode());
            }
        }
        if ((pssn = relation.getPseudoSsn()) != null) {
            bean.setPseudoSsn(CommonJspUtils.displaySSN(pssn.getSsnText()));
            if (pssn.getPseudoSSNReason() != null) {
                bean.setPseudoSsnReason(pssn.getPseudoSSNReason().getCode());
            }
        }
        if (bean.getSsn() != null && StringUtils.isNotEmpty((String)bean.getSsn())) {
            bean.setDisplaySSN(bean.getSsn());
        } else {
            bean.setDisplaySSN(bean.getPseudoSsn());
        }
    }

    private void convertRelationship(Relation relation, RelationFinancialInfoBean bean) {
        if (relation.getRelationship() != null) {
            bean.setRelationshipCode(relation.getRelationship().getCode());
            bean.setRelationship(relation.getRelationship().getDescription());
        }
    }

    private void convertGender(Relation relation, RelationFinancialInfoBean bean) {
        if (relation.getGender() != null) {
            bean.setGenderCode(relation.getGender().getCode());
            bean.setGender(relation.getGender().getDescription());
        }
    }
}

