/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.rule.service.impl;

import gov.va.med.esr.common.model.comms.CommsLogEntry;
import gov.va.med.esr.common.model.ee.CombatEpisode;
import gov.va.med.esr.common.model.ee.ConflictExperience;
import gov.va.med.esr.common.model.ee.Document;
import gov.va.med.esr.common.model.ee.EGTSetting;
import gov.va.med.esr.common.model.ee.MilitaryService;
import gov.va.med.esr.common.model.ee.MilitaryServiceEpisode;
import gov.va.med.esr.common.model.ee.POWEpisode;
import gov.va.med.esr.common.model.ee.PurpleHeartDocument;
import gov.va.med.esr.common.model.financials.DependentFinancials;
import gov.va.med.esr.common.model.financials.SpouseFinancials;
import gov.va.med.esr.common.model.insurance.InsurancePolicy;
import gov.va.med.esr.common.model.lookup.ComLetterTemplateType;
import gov.va.med.esr.common.model.lookup.RegistryType;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.person.Association;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.registry.Registry;
import gov.va.med.esr.common.rule.data.AddressInputData;
import gov.va.med.esr.common.rule.data.AssociationInputData;
import gov.va.med.esr.common.rule.data.CommsInputData;
import gov.va.med.esr.common.rule.data.DependentFinancialsInputData;
import gov.va.med.esr.common.rule.data.EgtInputData;
import gov.va.med.esr.common.rule.data.FinancialInputData;
import gov.va.med.esr.common.rule.data.InsuranceInputData;
import gov.va.med.esr.common.rule.data.MilitaryServiceInputData;
import gov.va.med.esr.common.rule.data.PHInputData;
import gov.va.med.esr.common.rule.data.POWInputData;
import gov.va.med.esr.common.rule.data.PersonInputData;
import gov.va.med.esr.common.rule.data.RegistryInputData;
import gov.va.med.esr.common.rule.data.SpouseFinancialsInputData;
import gov.va.med.esr.common.rule.service.RuleValidationService;
import gov.va.med.esr.service.trigger.LetterTriggerEvent;
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.rule.AbstractRuleValidationService;
import gov.va.med.fw.rule.RuleDataAware;
import gov.va.med.fw.rule.RuleParameters;
import gov.va.med.fw.rule.SimpleValidatableRule;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.validation.Validatable;
import gov.va.med.fw.validation.ValidationMessages;
import java.util.List;
import org.apache.commons.lang.Validate;

public class RuleValidationServiceImpl
extends AbstractRuleValidationService
implements RuleValidationService {
    private static final long serialVersionUID = 3587897087412351790L;
    private String demographicRuleParameters = null;
    private String insuranceRuleParameters = null;
    private String associationRuleParameters = null;
    private String addressRuleParameters = null;
    private String msValidationRuleParameters = null;
    private String mseValidationRuleParameters = null;
    private String combatEpisodeValidationRuleParameters = null;
    private String conflictExperienceValidationRuleParameters = null;
    private String veteranFinancialValidationRuleParameters = null;
    private String spouseValidationRuleParameters = null;
    private String dependentValidationRuleParameters = null;
    private String enrollmentValidationRuleParameters = null;
    private String ineligibilityValidationRuleParameters = null;
    private String powValidationRuleParameters = null;
    private String letterMailingValidationRuleParameters = null;
    private String registryValidationRuleParameters = null;
    private String registryDocumentValidationRuleParameters = null;
    private String processLetterSendRequestRuleParameters = null;
    private String purpleHeartValidationRuleParameters = null;
    private String egtValidationRuleParameters = null;
    private String identityTraitsValidationRuleParameters = null;

    @Override
    public ValidationMessages validateDemographic(Person person, boolean isDataFromGUI) throws ServiceException {
        return this.validate(this.createDemographicInput(person, isDataFromGUI), this.getRuleParameters(this.getDemographicRuleParameters()), isDataFromGUI);
    }

    @Override
    public ValidationMessages validateAssociation(Association association, Person onFile, Person pristine, boolean isDataFromGUI) throws ServiceException {
        return this.validate(this.createAssociationInput(association, onFile, pristine, isDataFromGUI), this.getRuleParameters(this.getAssociationRuleParameters()), isDataFromGUI);
    }

    @Override
    public ValidationMessages validateCombatEpisode(CombatEpisode ce, Person onFile, Person pristine, boolean isDataFromGUI) throws ServiceException {
        return this.validate(this.createCombatEpisodeInput(ce, onFile, pristine), this.getRuleParameters(this.getCombatEpisodeValidationRuleParameters()), isDataFromGUI);
    }

    @Override
    public ValidationMessages validateConflictExperience(ConflictExperience ce, Person onFile, Person pristine, boolean isDataFromGUI) throws ServiceException {
        return this.validate(this.createConflictExperienceInput(ce, onFile, pristine), this.getRuleParameters(this.getConflictExperienceValidationRuleParameters()), isDataFromGUI);
    }

    @Override
    public ValidationMessages validateVeteranFinancials(Integer incomeYear, Person incoming, Person onFile, Person pristine, boolean isDemographicUpdate, boolean isDataFromGUI) throws ServiceException {
        return this.validate(this.createFinancialsInput(incomeYear, incoming, onFile, pristine, isDemographicUpdate, isDataFromGUI), this.getRuleParameters(this.getVeteranFinancialValidationRuleParameters()), isDataFromGUI);
    }

    @Override
    public ValidationMessages validateSpouseFinancials(Integer incomeYear, SpouseFinancials spouseFinancials, Person incoming, Person onFile, boolean isDemographicUpdate, boolean isDataFromGUI) throws ServiceException {
        SpouseFinancialsInputData data = new SpouseFinancialsInputData(spouseFinancials, incoming, onFile, isDemographicUpdate);
        data.setIncomingIncomeYear(incomeYear);
        return this.validate((RuleDataAware)data, this.getRuleParameters(this.getSpouseValidationRuleParameters()), isDataFromGUI);
    }

    @Override
    public ValidationMessages validateDependentFinancials(Integer incomeYear, DependentFinancials depenentFinancials, Person incoming, Person onFile, boolean isDemographicUpdate, boolean isDataFromGUI) throws ServiceException {
        return this.validate(this.createDependentFinancialsInput(depenentFinancials, incoming, onFile, isDemographicUpdate), this.getRuleParameters(this.getDependentValidationRuleParameters()), isDataFromGUI);
    }

    @Override
    public ValidationMessages validateInsurancePolicy(InsurancePolicy insurancePolicy, Person result, Person pristine, boolean isDataFromGUI) throws ServiceException {
        return this.validate(this.createInsurancePolicyInput(insurancePolicy, result, pristine), this.getRuleParameters(this.getInsuranceRuleParameters()), isDataFromGUI);
    }

    @Override
    public ValidationMessages validateMS(MilitaryService ms, Person onFile, Person pristine, boolean isDataFromGUI, String useCaseName) throws ServiceException {
        return this.validate(this.createMilitaryServiceInput(ms, onFile, pristine, isDataFromGUI, useCaseName), this.getRuleParameters(this.getMsValidationRuleParameters()), isDataFromGUI);
    }

    @Override
    public ValidationMessages validateMSE(MilitaryServiceEpisode mse, Person onFile, Person pristine, boolean isDataFromGUI) throws ServiceException {
        return this.validate(this.createMilitaryServiceInput(mse, onFile, pristine), this.getRuleParameters(this.getMseValidationRuleParameters()), isDataFromGUI);
    }

    @Override
    public ValidationMessages validateReceivedEnrollment(Person incoming, Person onFile, Person pristine, boolean isDataFromGUI) throws ServiceException {
        PersonInputData personInputData = new PersonInputData(incoming, onFile, pristine, isDataFromGUI);
        return this.validate((RuleDataAware)personInputData, this.getRuleParameters(this.getEnrollmentValidationRuleParameters()), isDataFromGUI);
    }

    @Override
    public ValidationMessages validateIneligibility(Person incoming, boolean isDataFromGUI) throws ServiceException {
        return this.validate(this.createPersonInput(incoming, isDataFromGUI), this.getRuleParameters(this.getIneligibilityValidationRuleParameters()), isDataFromGUI);
    }

    @Override
    public ValidationMessages validatePOW(POWEpisode powEpisode, Person incoming, boolean isDataFromGUI) throws ServiceException {
        return this.validate(this.createPOWInput(powEpisode, incoming, isDataFromGUI), this.getRuleParameters(this.getPowValidationRuleParameters()), isDataFromGUI);
    }

    @Override
    public ValidationMessages validateLetterMailing(CommsLogEntry letterMailing, Person incoming) throws ServiceException {
        Validate.notNull((Object)((Object)letterMailing), (String)"A letter mailing must not be null");
        return this.validate(this.createCommsInput(letterMailing, letterMailing.getAddress(), incoming), this.getRuleParameters(this.getLetterMailingValidationRuleParameters()), true);
    }

    @Override
    public ValidationMessages validateLetterSendRequest(Person person, ComLetterTemplateType formNumber, String workflowCaseId, LetterTriggerEvent.MailType mailType, Boolean override, List logs, String categoryType, String context) throws ServiceException {
        return this.validate((RuleDataAware)this.createCommsInput(person, formNumber, workflowCaseId, mailType, override, logs, categoryType, context), this.getRuleParameters(this.getProcessLetterSendRequestRuleParameters()), true);
    }

    @Override
    public ValidationMessages validateRegistry(Registry registry, boolean isDataFromGUI) throws ServiceException {
        return this.validate(this.createRegistryInput(registry, isDataFromGUI), this.getRuleParameters(this.getRegistryValidationRuleParameters()), isDataFromGUI);
    }

    @Override
    public ValidationMessages validateRegistryDocument(Registry registry, Document document, boolean isDataFromGUI) throws ServiceException {
        return this.validate(this.createRegistryInput(registry, document, isDataFromGUI), this.getRuleParameters(this.getRegistryDocumentValidationRuleParameters()), isDataFromGUI);
    }

    @Override
    public ValidationMessages validatePurpleHeartDocument(PurpleHeartDocument purpleHeartDocument, Person incoming, boolean isDataFromGUI) throws ServiceException {
        return this.validate(this.createPHInput(incoming, purpleHeartDocument, isDataFromGUI), this.getRuleParameters(this.getPurpleHeartValidationRuleParameters()), isDataFromGUI);
    }

    @Override
    public ValidationMessages validateEgtSetting(EGTSetting egtSetting, EGTSetting onFile) throws ServiceException {
        return this.validate((RuleDataAware)this.createEgtInput(egtSetting, onFile), this.getRuleParameters(this.getEgtValidationRuleParameters()), true);
    }

    @Override
    public ValidationMessages validateIdentityTraits(Person person, boolean isDataFromGUI) throws ServiceException {
        return this.validate(this.createIdentityTraitsInput(person, isDataFromGUI), this.getRuleParameters(this.getIdentityTraitsValidationRuleParameters()), isDataFromGUI);
    }

    protected RuleDataAware createPHInput(Person incoming, PurpleHeartDocument purpleHeartDocument, boolean isUpdateFromGUI) {
        return new PHInputData(incoming, purpleHeartDocument, isUpdateFromGUI);
    }

    protected RuleDataAware createAddressInput(Address address) {
        AddressInputData data = new AddressInputData(address);
        return data;
    }

    protected RuleDataAware createInsurancePolicyInput(InsurancePolicy insurancePolicy, Person result, Person pristine) throws ServiceException {
        InsuranceInputData data = new InsuranceInputData(insurancePolicy);
        data.setIncomingData((AbstractEntity)insurancePolicy.getPerson());
        data.setResultData((AbstractEntity)result);
        data.setPristineData((AbstractEntity)pristine);
        return data;
    }

    protected RuleDataAware createMilitaryServiceInput(MilitaryService ms, Person onFile, Person pristine, boolean isDataFromGUI, String useCaseName) throws ServiceException {
        MilitaryServiceInputData data = new MilitaryServiceInputData(ms, onFile, pristine, isDataFromGUI);
        data.setUseCaseName(useCaseName);
        return data;
    }

    protected RuleDataAware createMilitaryServiceInput(MilitaryServiceEpisode mse, Person onFile, Person pristine) throws ServiceException {
        MilitaryServiceInputData data = new MilitaryServiceInputData(mse, onFile, pristine);
        return data;
    }

    protected RuleDataAware createCombatEpisodeInput(CombatEpisode ce, Person onFile, Person pristine) throws ServiceException {
        MilitaryServiceInputData data = new MilitaryServiceInputData(ce, onFile, pristine);
        return data;
    }

    protected RuleDataAware createConflictExperienceInput(ConflictExperience ce, Person onFile, Person pristine) throws ServiceException {
        MilitaryServiceInputData data = new MilitaryServiceInputData(ce, onFile, pristine);
        return data;
    }

    protected RuleDataAware createAssociationInput(Association association, Person onFile, Person pristine, boolean isDataFromGUI) throws ServiceException {
        AssociationInputData data = new AssociationInputData(association, onFile, pristine, isDataFromGUI, null);
        return data;
    }

    protected RuleDataAware createDemographicInput(Person incoming, boolean isDataFromGUI) throws ServiceException {
        return new PersonInputData(incoming, isDataFromGUI);
    }

    protected RuleDataAware createIdentityTraitsInput(Person incoming, boolean isDataFromGUI) throws ServiceException {
        return new PersonInputData(incoming, isDataFromGUI);
    }

    protected RuleDataAware createPersonInput(Person incoming, boolean isDataFromGUI) throws ServiceException {
        return new PersonInputData(incoming, isDataFromGUI);
    }

    protected RuleDataAware createCommsInput(CommsLogEntry letterMailing, Address mailingAddress, Person incoming) throws ServiceException {
        return new CommsInputData(incoming, letterMailing, mailingAddress);
    }

    protected CommsInputData createCommsInput(Person person, ComLetterTemplateType formNumber, String workflowCaseId, LetterTriggerEvent.MailType mailType, Boolean override, List logs, String categoryType, String context) throws ServiceException {
        CommsInputData cid = new CommsInputData(person, formNumber, workflowCaseId, mailType, override);
        cid.setCommsLogEntries(logs);
        cid.setSubject(categoryType);
        cid.setRuleContext(context);
        return cid;
    }

    protected RuleDataAware createPOWInput(POWEpisode powEpisode, Person incoming, boolean isDataFromGUI) throws ServiceException {
        return new POWInputData(powEpisode, incoming, isDataFromGUI);
    }

    protected RuleDataAware createFinancialsInput(Integer incomeYear, Person incoming, Person onFile, Person pristine, boolean isDemographicUpdate, boolean isDataFromGUI) throws ServiceException {
        return new FinancialInputData(incoming, onFile, pristine, incomeYear, isDemographicUpdate, isDataFromGUI);
    }

    protected RuleDataAware createSpouseFinancialsInput(SpouseFinancials spouseFinancials, Person incoming, Person onFile, boolean isDemographicUpdate) throws ServiceException {
        return new SpouseFinancialsInputData(spouseFinancials, incoming, onFile, isDemographicUpdate);
    }

    protected RuleDataAware createDependentFinancialsInput(DependentFinancials dependentFinancials, Person incoming, Person onFile, boolean isDemographicUpdate) throws ServiceException {
        return new DependentFinancialsInputData(dependentFinancials, incoming, onFile, isDemographicUpdate);
    }

    protected RuleDataAware createRegistryInput(Registry incoming, boolean isDataFromGUI) throws ServiceException {
        RegistryType regTYpe = incoming.getRegistryTrait() != null ? incoming.getRegistryTrait().getRegistryType() : null;
        return new RegistryInputData(incoming, isDataFromGUI, regTYpe);
    }

    protected RuleDataAware createRegistryInput(Registry incoming, Document document, boolean isDataFromGUI) throws ServiceException {
        RegistryType regType = incoming.getRegistryTrait() != null ? incoming.getRegistryTrait().getRegistryType() : null;
        return new RegistryInputData(incoming, document, isDataFromGUI, regType);
    }

    private EgtInputData createEgtInput(EGTSetting incoming, EGTSetting onFile) throws ServiceException {
        return new EgtInputData(incoming, onFile);
    }

    protected ValidationMessages validate(RuleDataAware data, RuleParameters parameters, boolean isDataFromGUI) throws ServiceException {
        String mode = isDataFromGUI ? "EXHAUSTIVE" : "ELIMINATION";
        return this.validate((Validatable)new SimpleValidatableRule(mode, parameters, data));
    }

    public String getDemographicRuleParameters() {
        return this.demographicRuleParameters;
    }

    public void setDemographicRuleParameters(String demographicRuleParameters) {
        this.demographicRuleParameters = demographicRuleParameters;
    }

    public String getInsuranceRuleParameters() {
        return this.insuranceRuleParameters;
    }

    public void setInsuranceRuleParameters(String insuranceRuleParameters) {
        this.insuranceRuleParameters = insuranceRuleParameters;
    }

    public String getAssociationRuleParameters() {
        return this.associationRuleParameters;
    }

    public void setAssociationRuleParameters(String associationRuleParameters) {
        this.associationRuleParameters = associationRuleParameters;
    }

    public String getAddressRuleParameters() {
        return this.addressRuleParameters;
    }

    public void setAddressRuleParameters(String addressRuleParameters) {
        this.addressRuleParameters = addressRuleParameters;
    }

    public String getMsValidationRuleParameters() {
        return this.msValidationRuleParameters;
    }

    public void setMsValidationRuleParameters(String msValidationRuleParameters) {
        this.msValidationRuleParameters = msValidationRuleParameters;
    }

    public String getMseValidationRuleParameters() {
        return this.mseValidationRuleParameters;
    }

    public void setMseValidationRuleParameters(String mseValidationRuleParameters) {
        this.mseValidationRuleParameters = mseValidationRuleParameters;
    }

    public String getCombatEpisodeValidationRuleParameters() {
        return this.combatEpisodeValidationRuleParameters;
    }

    public void setCombatEpisodeValidationRuleParameters(String combatEpisodeValidationRuleParameters) {
        this.combatEpisodeValidationRuleParameters = combatEpisodeValidationRuleParameters;
    }

    public String getConflictExperienceValidationRuleParameters() {
        return this.conflictExperienceValidationRuleParameters;
    }

    public void setConflictExperienceValidationRuleParameters(String conflictExperienceValidationRuleParameters) {
        this.conflictExperienceValidationRuleParameters = conflictExperienceValidationRuleParameters;
    }

    public String getVeteranFinancialValidationRuleParameters() {
        return this.veteranFinancialValidationRuleParameters;
    }

    public void setVeteranFinancialValidationRuleParameters(String veteranFinancialValidationRuleParameters) {
        this.veteranFinancialValidationRuleParameters = veteranFinancialValidationRuleParameters;
    }

    public String getSpouseValidationRuleParameters() {
        return this.spouseValidationRuleParameters;
    }

    public void setSpouseValidationRuleParameters(String spouseValidationRuleParameters) {
        this.spouseValidationRuleParameters = spouseValidationRuleParameters;
    }

    public String getDependentValidationRuleParameters() {
        return this.dependentValidationRuleParameters;
    }

    public void setDependentValidationRuleParameters(String dependentValidationRuleParameters) {
        this.dependentValidationRuleParameters = dependentValidationRuleParameters;
    }

    public String getEnrollmentValidationRuleParameters() {
        return this.enrollmentValidationRuleParameters;
    }

    public void setEnrollmentValidationRuleParameters(String enrollmentValidationRuleParameters) {
        this.enrollmentValidationRuleParameters = enrollmentValidationRuleParameters;
    }

    public String getIneligibilityValidationRuleParameters() {
        return this.ineligibilityValidationRuleParameters;
    }

    public void setIneligibilityValidationRuleParameters(String ineligibilityValidationRuleParameters) {
        this.ineligibilityValidationRuleParameters = ineligibilityValidationRuleParameters;
    }

    public String getPowValidationRuleParameters() {
        return this.powValidationRuleParameters;
    }

    public void setPowValidationRuleParameters(String powValidationRuleParameters) {
        this.powValidationRuleParameters = powValidationRuleParameters;
    }

    public String getLetterMailingValidationRuleParameters() {
        return this.letterMailingValidationRuleParameters;
    }

    public void setLetterMailingValidationRuleParameters(String letterMailingValidationRuleParameters) {
        this.letterMailingValidationRuleParameters = letterMailingValidationRuleParameters;
    }

    public String getRegistryValidationRuleParameters() {
        return this.registryValidationRuleParameters;
    }

    public void setRegistryValidationRuleParameters(String registryValidationRuleParameters) {
        this.registryValidationRuleParameters = registryValidationRuleParameters;
    }

    public String getRegistryDocumentValidationRuleParameters() {
        return this.registryDocumentValidationRuleParameters;
    }

    public void setRegistryDocumentValidationRuleParameters(String registryDocumentValidationRuleParameters) {
        this.registryDocumentValidationRuleParameters = registryDocumentValidationRuleParameters;
    }

    public String getProcessLetterSendRequestRuleParameters() {
        return this.processLetterSendRequestRuleParameters;
    }

    public void setProcessLetterSendRequestRuleParameters(String processLetterSendRequestRuleParameters) {
        this.processLetterSendRequestRuleParameters = processLetterSendRequestRuleParameters;
    }

    public String getPurpleHeartValidationRuleParameters() {
        return this.purpleHeartValidationRuleParameters;
    }

    public void setPurpleHeartValidationRuleParameters(String purpleHeartValidationRuleParameters) {
        this.purpleHeartValidationRuleParameters = purpleHeartValidationRuleParameters;
    }

    public String getEgtValidationRuleParameters() {
        return this.egtValidationRuleParameters;
    }

    public void setEgtValidationRuleParameters(String egtValidationRuleParameters) {
        this.egtValidationRuleParameters = egtValidationRuleParameters;
    }

    public String getIdentityTraitsValidationRuleParameters() {
        return this.identityTraitsValidationRuleParameters;
    }

    public void setIdentityTraitsValidationRuleParameters(String identityTraitsValidationRuleParameters) {
        this.identityTraitsValidationRuleParameters = identityTraitsValidationRuleParameters;
    }
}

