/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.rule.service.impl;

import gov.va.med.esr.common.model.ee.VerificationInfo;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.rule.data.AssociationInputData;
import gov.va.med.esr.common.rule.data.BaseData;
import gov.va.med.esr.common.rule.data.EEInputData;
import gov.va.med.esr.common.rule.data.IneligibilityInputData;
import gov.va.med.esr.common.rule.data.PersonInputData;
import gov.va.med.esr.common.rule.service.ProcessVBARuleService;
import gov.va.med.esr.common.rule.service.impl.AbstractRuleValidationServiceAwareImpl;
import gov.va.med.fw.rule.RuleParameters;
import gov.va.med.fw.service.ServiceException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.Validate;

public class ProcessVBARuleServiceImpl
extends AbstractRuleValidationServiceAwareImpl
implements ProcessVBARuleService {
    private static final long serialVersionUID = -4624827103975543507L;
    private String processVBARuleParameters = null;
    private String processVBADataRuleParameters = null;
    private String personRuleParameterName = null;
    private String communicationsRuleParameterName = null;
    private String associationRuleParameterName = null;
    private String demographicRuleParameterName = null;
    private String eligibleVerificationRuleParameterName = null;
    private String enrollmentRuleParameterName = null;
    private String ineligibleRuleParameterName = null;
    private String monetaryAwardRuleParameterName = null;
    private String militaryServiceRuleParameter = null;
    private String serviceConnectionRuleParameterName = null;
    private String facilityRuleParameterName = null;
    private String workloadRuleParameterName = null;

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.processVBARuleParameters, (String)"processVBARuleParameters property is required");
    }

    public String getMilitaryServiceRuleParameter() {
        return this.militaryServiceRuleParameter;
    }

    public void setMilitaryServiceRuleParameter(String militaryServiceRuleParameter) {
        this.militaryServiceRuleParameter = militaryServiceRuleParameter;
    }

    @Override
    public Person verifyEligibility(Person incoming, Person updated, VerificationInfo info) throws ServiceException {
        Validate.notNull((Object)((Object)updated), (String)"A person being updated must not be NULL");
        Validate.notNull((Object)((Object)incoming), (String)"An incoming person must not be NULL");
        Validate.notNull((Object)((Object)info), (String)"A verification information must not be NULL");
        Person pristine = this.getPristinePerson(updated);
        RuleParameters parameters = this.getRuleParameters(this.getProcessVBARuleParameters());
        this.invokeRuleFlow(parameters, this.initializeVBARuleParameters(incoming, updated, pristine, info));
        return updated;
    }

    @Override
    public Person processVBAData(Person incoming, VAFacility sendingFacility, Person updated, VerificationInfo info) throws ServiceException {
        Validate.notNull((Object)((Object)updated), (String)"A person being updated must not be NULL");
        Validate.notNull((Object)((Object)incoming), (String)"An incoming person must not be NULL");
        Person pristine = this.getPristinePerson(updated);
        RuleParameters parameters = this.getRuleParameters(this.getProcessVBADataRuleParameters());
        this.invokeRuleFlow(parameters, this.initializeVBADataParameters(incoming, sendingFacility, updated, pristine, info));
        return updated;
    }

    public String getProcessVBADataRuleParameters() {
        return this.processVBADataRuleParameters;
    }

    public void setProcessVBADataRuleParameters(String processVBADataRuleParameters) {
        this.processVBADataRuleParameters = processVBADataRuleParameters;
    }

    public String getProcessVBARuleParameters() {
        return this.processVBARuleParameters;
    }

    public void setProcessVBARuleParameters(String processVBARuleParameters) {
        this.processVBARuleParameters = processVBARuleParameters;
    }

    public String getCommunicationsRuleParameterName() {
        return this.communicationsRuleParameterName;
    }

    public void setCommunicationsRuleParameterName(String communicationsRuleParameterName) {
        this.communicationsRuleParameterName = communicationsRuleParameterName;
    }

    public String getDemographicRuleParameterName() {
        return this.demographicRuleParameterName;
    }

    public void setDemographicRuleParameterName(String demographicRuleParameterName) {
        this.demographicRuleParameterName = demographicRuleParameterName;
    }

    public String getEligibleVerificationRuleParameterName() {
        return this.eligibleVerificationRuleParameterName;
    }

    public void setEligibleVerificationRuleParameterName(String eligibleVerificationRuleParameterName) {
        this.eligibleVerificationRuleParameterName = eligibleVerificationRuleParameterName;
    }

    public String getEnrollmentRuleParameterName() {
        return this.enrollmentRuleParameterName;
    }

    public void setEnrollmentRuleParameterName(String enrollmentRuleParameterName) {
        this.enrollmentRuleParameterName = enrollmentRuleParameterName;
    }

    public String getIneligibleRuleParameterName() {
        return this.ineligibleRuleParameterName;
    }

    public void setIneligibleRuleParameterName(String ineligibleRuleParameterName) {
        this.ineligibleRuleParameterName = ineligibleRuleParameterName;
    }

    public String getMonetaryAwardRuleParameterName() {
        return this.monetaryAwardRuleParameterName;
    }

    public void setMonetaryAwardRuleParameterName(String monetaryAwardRuleParameterName) {
        this.monetaryAwardRuleParameterName = monetaryAwardRuleParameterName;
    }

    public String getPersonRuleParameterName() {
        return this.personRuleParameterName;
    }

    public void setPersonRuleParameterName(String personRuleParameterName) {
        this.personRuleParameterName = personRuleParameterName;
    }

    public String getServiceConnectionRuleParameterName() {
        return this.serviceConnectionRuleParameterName;
    }

    public void setServiceConnectionRuleParameterName(String serviceConnectionRuleParameterName) {
        this.serviceConnectionRuleParameterName = serviceConnectionRuleParameterName;
    }

    public String getFacilityRuleParameterName() {
        return this.facilityRuleParameterName;
    }

    public void setFacilityRuleParameterName(String facilityRuleParameterName) {
        this.facilityRuleParameterName = facilityRuleParameterName;
    }

    public String getWorkloadRuleParameterName() {
        return this.workloadRuleParameterName;
    }

    public void setWorkloadRuleParameterName(String workloadRuleParameterName) {
        this.workloadRuleParameterName = workloadRuleParameterName;
    }

    public String getAssociationRuleParameterName() {
        return this.associationRuleParameterName;
    }

    public void setAssociationRuleParameterName(String associationRuleParameterName) {
        this.associationRuleParameterName = associationRuleParameterName;
    }

    private Map initializeVBARuleParameters(Person incoming, Person onFile, Person pristine, VerificationInfo info) throws ServiceException {
        HashMap<String, BaseData> data = new HashMap<String, BaseData>();
        AssociationInputData associationData = new AssociationInputData(incoming, onFile, pristine);
        data.put(this.getAssociationRuleParameterName(), associationData);
        PersonInputData ruleData = new PersonInputData(incoming, onFile, pristine, info);
        ruleData.setPersonService(this.getPersonService());
        data.put(this.getCommunicationsRuleParameterName(), ruleData);
        ruleData = new PersonInputData(incoming, onFile, pristine, info);
        ruleData.setPersonService(this.getPersonService());
        data.put(this.getDemographicRuleParameterName(), ruleData);
        ruleData = new EEInputData(incoming, onFile, pristine, info);
        ruleData.setPersonService(this.getPersonService());
        data.put(this.getEligibleVerificationRuleParameterName(), ruleData);
        ruleData = new EEInputData(incoming, onFile, pristine, info);
        ruleData.setPersonService(this.getPersonService());
        data.put(this.getEnrollmentRuleParameterName(), ruleData);
        ruleData = new IneligibilityInputData(incoming, onFile, pristine, false, info);
        ruleData.setPersonService(this.getPersonService());
        data.put(this.getIneligibleRuleParameterName(), ruleData);
        ruleData = new PersonInputData(incoming, onFile, pristine, info);
        ruleData.setPersonService(this.getPersonService());
        data.put(this.getMilitaryServiceRuleParameter(), ruleData);
        ruleData = new PersonInputData(incoming, onFile, pristine, info);
        ruleData.setPersonService(this.getPersonService());
        data.put(this.getMonetaryAwardRuleParameterName(), ruleData);
        ruleData = new PersonInputData(incoming, onFile, pristine, info);
        ruleData.setPersonService(this.getPersonService());
        data.put(this.getPersonRuleParameterName(), ruleData);
        ruleData = new PersonInputData(incoming, onFile, pristine, info);
        ruleData.setPersonService(this.getPersonService());
        data.put(this.getServiceConnectionRuleParameterName(), ruleData);
        ruleData = new PersonInputData(incoming, onFile, pristine, info);
        ruleData.setPersonService(this.getPersonService());
        data.put(this.getWorkloadRuleParameterName(), ruleData);
        return data;
    }

    private Map initializeVBADataParameters(Person incoming, VAFacility sendingFacility, Person updated, Person pristine, VerificationInfo info) {
        HashMap<String, PersonInputData> data = new HashMap<String, PersonInputData>();
        PersonInputData ruleData = new PersonInputData(incoming, updated, pristine, sendingFacility, info);
        ruleData.setPersonService(this.getPersonService());
        data.put(this.getCommunicationsRuleParameterName(), ruleData);
        ruleData = new EEInputData(incoming, updated, pristine, info);
        ruleData.setPersonService(this.getPersonService());
        data.put(this.getEligibleVerificationRuleParameterName(), ruleData);
        ruleData = new EEInputData(incoming, updated, pristine, info);
        ruleData.setPersonService(this.getPersonService());
        data.put(this.getEnrollmentRuleParameterName(), ruleData);
        ruleData = new PersonInputData(incoming, updated, pristine, info);
        ruleData.setPersonService(this.getPersonService());
        data.put(this.getFacilityRuleParameterName(), ruleData);
        ruleData = new IneligibilityInputData(incoming, updated, pristine, false, info);
        ruleData.setPersonService(this.getPersonService());
        data.put(this.getIneligibleRuleParameterName(), ruleData);
        ruleData = new PersonInputData(incoming, updated, pristine, info);
        ruleData.setPersonService(this.getPersonService());
        data.put(this.getMonetaryAwardRuleParameterName(), ruleData);
        ruleData = new PersonInputData(incoming, updated, pristine, info);
        ruleData.setPersonService(this.getPersonService());
        data.put(this.getMilitaryServiceRuleParameter(), ruleData);
        ruleData = new PersonInputData(incoming, updated, pristine, info);
        ruleData.setPersonService(this.getPersonService());
        data.put(this.getPersonRuleParameterName(), ruleData);
        ruleData = new PersonInputData(incoming, updated, pristine, info);
        ruleData.setPersonService(this.getPersonService());
        data.put(this.getServiceConnectionRuleParameterName(), ruleData);
        return data;
    }
}

