/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.rule.service.impl;

import gov.va.med.esr.common.model.ee.POWEpisode;
import gov.va.med.esr.common.model.ee.PrisonerOfWar;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.rule.data.POWInputData;
import gov.va.med.esr.common.rule.service.POWRuleService;
import gov.va.med.esr.common.rule.service.impl.AbstractRuleValidationServiceAwareImpl;
import gov.va.med.fw.rule.RuleDataAware;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.validation.ValidationMessages;
import gov.va.med.fw.validation.ValidationServiceException;
import java.util.Set;
import org.apache.commons.lang.Validate;

public class POWRuleServiceImpl
extends AbstractRuleValidationServiceAwareImpl
implements POWRuleService {
    private static final long serialVersionUID = 2593357573979544087L;
    private String powRuleParameters = null;

    @Override
    public void processPOW(Person incoming, Person onFile) throws ServiceException {
        this.doProcessPOW(incoming, onFile, false, null);
    }

    @Override
    public void processPOW(Person incoming, Person onFile, VAFacility sendingFacility) throws ServiceException {
        this.doProcessPOW(incoming, onFile, false, sendingFacility);
    }

    @Override
    public void managePOW(Person incoming, Person onFile) throws ServiceException {
        this.doProcessPOW(incoming, onFile, true, null);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.powRuleParameters, (String)"powRuleParameters property is required");
    }

    public String getPowRuleParameters() {
        return this.powRuleParameters;
    }

    public void setPowRuleParameters(String powRuleParameters) {
        this.powRuleParameters = powRuleParameters;
    }

    private void doProcessPOW(Person incoming, Person onFile, boolean ui, VAFacility sendingFacility) throws ServiceException {
        PrisonerOfWar pow;
        Validate.notNull((Object)((Object)onFile), (String)"A veteran on file must not be null");
        Validate.notNull((Object)((Object)incoming), (String)"The incoming must not be null");
        Person pristine = this.getPristinePerson(onFile);
        if (ui) {
            this.doValidation(incoming, true);
        }
        if ((pow = incoming.getPrisonerOfWar()) == null) {
            onFile.setPrisonerOfWar(null);
        } else {
            this.invokeRuleFlow(this.getRuleParameters(this.getPowRuleParameters()), (RuleDataAware)new POWInputData(incoming, onFile, pristine, ui, sendingFacility));
        }
    }

    private void doValidation(Person incoming, boolean isUpdateFromGUI) throws ServiceException {
        Set episodes;
        PrisonerOfWar pow = incoming.getPrisonerOfWar();
        Set set = episodes = pow != null ? pow.getEpisodes() : null;
        if (episodes != null) {
            for (POWEpisode powe : episodes) {
                ValidationMessages messages = this.getRuleValidationService().validatePOW(powe, incoming, true);
                if (messages == null || messages.isEmpty()) continue;
                throw new ValidationServiceException(messages);
            }
        }
    }
}

