/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.rule.service.impl;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.SiteYear;
import gov.va.med.esr.common.model.ee.Activation;
import gov.va.med.esr.common.model.ee.Application;
import gov.va.med.esr.common.model.ee.CDCondition;
import gov.va.med.esr.common.model.ee.CDDescriptor;
import gov.va.med.esr.common.model.ee.CDDiagnosis;
import gov.va.med.esr.common.model.ee.CDProcedure;
import gov.va.med.esr.common.model.ee.CampLejeuneVerification;
import gov.va.med.esr.common.model.ee.CampLejeuneVerificationMethod;
import gov.va.med.esr.common.model.ee.CancelDecline;
import gov.va.med.esr.common.model.ee.CatastrophicDisability;
import gov.va.med.esr.common.model.ee.CombatEpisode;
import gov.va.med.esr.common.model.ee.CombatService;
import gov.va.med.esr.common.model.ee.ConflictExperience;
import gov.va.med.esr.common.model.ee.Deployment;
import gov.va.med.esr.common.model.ee.EGTProcessStatistic;
import gov.va.med.esr.common.model.ee.EGTSetting;
import gov.va.med.esr.common.model.ee.EGTSiteStatistic;
import gov.va.med.esr.common.model.ee.Eligibility;
import gov.va.med.esr.common.model.ee.EligibilityVerification;
import gov.va.med.esr.common.model.ee.EnrollmentDetermination;
import gov.va.med.esr.common.model.ee.EnrollmentOverride;
import gov.va.med.esr.common.model.ee.FeeBasis;
import gov.va.med.esr.common.model.ee.HealthBenefitPlan;
import gov.va.med.esr.common.model.ee.HealthBenefitProfile;
import gov.va.med.esr.common.model.ee.IncompetenceRuling;
import gov.va.med.esr.common.model.ee.IneligibilityFactor;
import gov.va.med.esr.common.model.ee.MedalOfHonor;
import gov.va.med.esr.common.model.ee.MedicaidFactor;
import gov.va.med.esr.common.model.ee.MilitaryService;
import gov.va.med.esr.common.model.ee.MilitaryServiceEpisode;
import gov.va.med.esr.common.model.ee.MilitaryServiceSiteRecord;
import gov.va.med.esr.common.model.ee.MilitarySexualTrauma;
import gov.va.med.esr.common.model.ee.MonetaryBenefit;
import gov.va.med.esr.common.model.ee.MonetaryBenefitAward;
import gov.va.med.esr.common.model.ee.NoseThroatRadium;
import gov.va.med.esr.common.model.ee.POWEpisode;
import gov.va.med.esr.common.model.ee.Pension;
import gov.va.med.esr.common.model.ee.PrisonerOfWar;
import gov.va.med.esr.common.model.ee.PurpleHeart;
import gov.va.med.esr.common.model.ee.PurpleHeartDocument;
import gov.va.med.esr.common.model.ee.RatedDisability;
import gov.va.med.esr.common.model.ee.ReceivedEligibility;
import gov.va.med.esr.common.model.ee.ReceivedEnrollment;
import gov.va.med.esr.common.model.ee.SHAD;
import gov.va.med.esr.common.model.ee.SHADDocument;
import gov.va.med.esr.common.model.ee.ServiceConnectionAward;
import gov.va.med.esr.common.model.ee.SpecialFactor;
import gov.va.med.esr.common.model.financials.Asset;
import gov.va.med.esr.common.model.financials.BeneficiaryTravel;
import gov.va.med.esr.common.model.financials.Debt;
import gov.va.med.esr.common.model.financials.DependentFinancials;
import gov.va.med.esr.common.model.financials.Expense;
import gov.va.med.esr.common.model.financials.FinancialInformation;
import gov.va.med.esr.common.model.financials.FinancialStatement;
import gov.va.med.esr.common.model.financials.Hardship;
import gov.va.med.esr.common.model.financials.Income;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.financials.IncomeTestStatus;
import gov.va.med.esr.common.model.financials.PatientVisitSummary;
import gov.va.med.esr.common.model.financials.SpouseFinancials;
import gov.va.med.esr.common.model.insurance.InsurancePolicy;
import gov.va.med.esr.common.model.lookup.AssetType;
import gov.va.med.esr.common.model.lookup.CampLejeuneVerificationType;
import gov.va.med.esr.common.model.lookup.EligibilityType;
import gov.va.med.esr.common.model.lookup.ExpenseType;
import gov.va.med.esr.common.model.lookup.IncomeType;
import gov.va.med.esr.common.model.lookup.PensionReasonCode;
import gov.va.med.esr.common.model.lookup.Relationship;
import gov.va.med.esr.common.model.lookup.SSAMessage;
import gov.va.med.esr.common.model.lookup.SSAVerificationStatus;
import gov.va.med.esr.common.model.lookup.SensitivityChangeSource;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.party.ConfidentialAddressCategory;
import gov.va.med.esr.common.model.party.Email;
import gov.va.med.esr.common.model.party.Phone;
import gov.va.med.esr.common.model.person.Association;
import gov.va.med.esr.common.model.person.BirthRecord;
import gov.va.med.esr.common.model.person.DeathRecord;
import gov.va.med.esr.common.model.person.Dependent;
import gov.va.med.esr.common.model.person.EmergencyResponseIndicator;
import gov.va.med.esr.common.model.person.Employment;
import gov.va.med.esr.common.model.person.Ethnicity;
import gov.va.med.esr.common.model.person.HealthCareProvider;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.PatientProviderAssignmentLite;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.PreferredFacility;
import gov.va.med.esr.common.model.person.PreferredLanguage;
import gov.va.med.esr.common.model.person.Race;
import gov.va.med.esr.common.model.person.Relation;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.common.model.person.SignatureImage;
import gov.va.med.esr.common.model.person.Spouse;
import gov.va.med.esr.common.model.registry.RegistryTrait;
import gov.va.med.esr.common.model.registry.RegistryTraitDetail;
import gov.va.med.esr.common.model.report.ReportParameterSet;
import gov.va.med.esr.common.model.report.ReportSchedule;
import gov.va.med.esr.common.model.report.ReportSetup;
import gov.va.med.esr.common.model.security.ESRUserPrincipalImpl;
import gov.va.med.esr.common.rule.service.MatchRuleService;
import gov.va.med.esr.common.rule.service.MergeRuleService;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.UnknownLookupCodeException;
import gov.va.med.esr.service.UnknownLookupTypeException;
import gov.va.med.fw.conversion.CopyService;
import gov.va.med.fw.conversion.CopyServiceException;
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.rule.AbstractRuleFlowAwareService;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.Validate;

public class MergeRuleServiceImpl
extends AbstractRuleFlowAwareService
implements MergeRuleService {
    private static final long serialVersionUID = 4783737960515226873L;
    private MatchRuleService matchRuleService = null;
    private CopyService copyService = null;
    private LookupService lookupService = null;

    @Override
    public IneligibilityFactor mergeIneligibilityFactor(IneligibilityFactor incoming, Person onFile) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"An on file person must not be null");
        IneligibilityFactor updated = incoming;
        if (incoming != null) {
            updated = onFile.getIneligibilityFactor();
            if (updated == null) {
                updated = new IneligibilityFactor();
                onFile.setIneligibilityFactor(updated);
            }
            this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)updated);
        } else {
            onFile.setIneligibilityFactor(incoming);
        }
        return updated;
    }

    @Override
    public InsurancePolicy mergeInsuranceAddress(Address incoming, InsurancePolicy onFile) throws ServiceException {
        Validate.notNull((Object)onFile, (String)"An insurance policy on file must not be null");
        Address currentAddress = onFile.getAddress();
        if (incoming == null) {
            onFile.setAddress(null);
        } else if (currentAddress != null) {
            this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)currentAddress);
        } else {
            Address newAddress = new Address();
            this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)newAddress);
            onFile.setAddress(newAddress);
        }
        return onFile;
    }

    public InsurancePolicy mergeInsurancePreCertificationPhone(Phone incoming, InsurancePolicy onFile) throws ServiceException {
        Validate.notNull((Object)onFile, (String)"An insurance policy on file must not be null");
        Phone currentPhone = onFile.getPreCertificationPhone();
        if (incoming == null) {
            onFile.setPreCertificationPhone(null);
        } else if (currentPhone != null) {
            this.mergePhone(incoming, currentPhone);
        } else {
            currentPhone = new Phone();
            this.mergePhone(incoming, currentPhone);
            onFile.setPreCertificationPhone(currentPhone);
        }
        return onFile;
    }

    public InsurancePolicy mergeInsuranceBusinessPhone(Phone incoming, InsurancePolicy onFile) throws ServiceException {
        Validate.notNull((Object)onFile, (String)"An insurance policy on file must not be null");
        Phone currentPhone = onFile.getBusinessPhone();
        if (incoming == null) {
            onFile.setBusinessPhone(null);
        } else if (currentPhone != null) {
            this.mergePhone(incoming, currentPhone);
        } else {
            currentPhone = new Phone();
            this.mergePhone(incoming, currentPhone);
            onFile.setBusinessPhone(currentPhone);
        }
        return onFile;
    }

    public InsurancePolicy mergeInsuranceFax(Phone incoming, InsurancePolicy onFile) throws ServiceException {
        Validate.notNull((Object)onFile, (String)"An insurance policy on file must not be null");
        Phone currentFax = onFile.getFax();
        if (incoming == null) {
            onFile.setFax(null);
        } else if (currentFax != null) {
            this.mergePhone(incoming, currentFax);
        } else {
            currentFax = new Phone();
            this.mergePhone(incoming, currentFax);
            onFile.setFax(currentFax);
        }
        return onFile;
    }

    @Override
    public InsurancePolicy mergeInsurancePolicy(InsurancePolicy incoming, Person onFile) throws ServiceException {
        Validate.notNull((Object)incoming, (String)"An insurance policy must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"A person on file must not be null");
        Set policies = onFile.getInsurances();
        InsurancePolicy match = incoming;
        for (AbstractEntity obj : policies) {
            if (!this.getMatchRuleService().match(obj, (AbstractEntity)incoming)) continue;
            match = (InsurancePolicy)obj;
            this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)match);
            this.mergeInsuranceAddress(incoming.getAddress(), match);
            this.mergeInsurancePreCertificationPhone(incoming.getPreCertificationPhone(), match);
            this.mergeInsuranceBusinessPhone(incoming.getBusinessPhone(), match);
            this.mergeInsuranceFax(incoming.getFax(), match);
            break;
        }
        return match;
    }

    @Override
    public InsurancePolicy mergeInsurancePolicy(InsurancePolicy incoming, InsurancePolicy onFile) throws ServiceException {
        Validate.notNull((Object)incoming, (String)"An incoming InsurancePolicy must not be null");
        Validate.notNull((Object)onFile, (String)"An incoming on file  InsurancePolicy must not be null");
        this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
        this.mergeInsuranceAddress(incoming.getAddress(), onFile);
        this.mergeInsurancePreCertificationPhone(incoming.getPreCertificationPhone(), onFile);
        this.mergeInsuranceBusinessPhone(incoming.getBusinessPhone(), onFile);
        this.mergeInsuranceFax(incoming.getFax(), onFile);
        return onFile;
    }

    public Association mergeAssociationAddress(Address incoming, Association onFile) throws ServiceException {
        if (incoming == null) {
            onFile.setAddress(null);
        } else {
            Address currentAddress = onFile.getAddress();
            if (currentAddress == null) {
                currentAddress = new Address();
                this.mergeAddress(incoming, currentAddress);
                onFile.setAddress(currentAddress);
            } else {
                this.mergeAddress(incoming, currentAddress);
            }
        }
        return onFile;
    }

    @Override
    public Association mergeAssociation(Association incoming, Person onFile) throws ServiceException {
        Validate.notNull((Object)incoming, (String)"An association must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"A person on file must not be null");
        Set policies = onFile.getAssociations();
        Association match = incoming;
        for (AbstractEntity obj : policies) {
            if (!this.getMatchRuleService().match(obj, (AbstractEntity)incoming)) continue;
            match = (Association)obj;
            this.mergeAssociation(incoming, match);
            break;
        }
        return match;
    }

    @Override
    public Association mergeAssociation(Association incoming, Association onFile) throws ServiceException {
        Validate.notNull((Object)incoming, (String)"An association must not be null");
        Validate.notNull((Object)onFile, (String)"A person on file must not be null");
        this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
        this.mergeAssociationAddress(incoming.getAddress(), onFile);
        return onFile;
    }

    @Override
    public Person mergeDemographic(Person incoming, Person onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"An incoming person must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"A person on file must not be null");
        this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
        Set mergedConfidentialAddressCategories = this.mergeSets(incoming.getConfidentialAddressCategories(), onFile.getConfidentialAddressCategories());
        onFile.removeAllConfidentialAddressCategories();
        for (ConfidentialAddressCategory category : mergedConfidentialAddressCategories) {
            onFile.addConfidentialAddressCategory(category.getType());
        }
        this.mergeOtherTraits(incoming, onFile);
        this.mergeEmployment(incoming, onFile);
        this.mergePreferredLanguage(incoming, onFile);
        return onFile;
    }

    @Override
    public void mergeEmployment(Person incoming, Person onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"An incoming person must not be null ");
        Validate.notNull((Object)((Object)onFile), (String)"An onFile person must not be null ");
        Employment incomingEM = incoming.getEmployment();
        Employment onFileEM = onFile.getEmployment();
        if (incomingEM != null) {
            if (onFileEM == null) {
                onFileEM = new Employment();
                this.mergeEmployment(incomingEM, onFileEM);
                onFile.setEmployment(onFileEM);
            } else {
                this.mergeEmployment(incomingEM, onFileEM);
            }
        } else {
            onFile.setEmployment(null);
        }
    }

    public PreferredLanguage mergePreferredLanguage(PreferredLanguage incoming, PreferredLanguage onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"An incoming  preferred language not be null");
        Validate.notNull((Object)((Object)onFile), (String)"An incoming on file preferred language must not be null");
        this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
        return onFile;
    }

    public void mergePreferredLanguage(Person incoming, Person onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"An incoming person must not be null ");
        Validate.notNull((Object)((Object)onFile), (String)"An onFile person must not be null ");
        PreferredLanguage incomingPL = incoming.getPreferredLanguage();
        PreferredLanguage onFilePL = onFile.getPreferredLanguage();
        if (incomingPL != null) {
            if (onFilePL == null) {
                onFilePL = new PreferredLanguage();
                this.mergePreferredLanguage(incomingPL, onFilePL);
                onFile.setPreferredLanguage(onFilePL);
            } else {
                this.mergePreferredLanguage(incomingPL, onFilePL);
            }
        } else {
            onFile.setPreferredLanguage(null);
        }
    }

    public void mergeOtherTraits(Person incoming, Person onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"An incoming person must not be null ");
        Validate.notNull((Object)((Object)onFile), (String)"An onFile person must not be null ");
        Set races = incoming.getRaces();
        if (races != null && races.size() > 0) {
            Set merged = this.mergeSets(races, onFile.getRaces());
            onFile.removeAllRaces();
            for (Race race : merged) {
                onFile.addRace(race);
            }
        } else {
            onFile.removeAllRaces();
        }
        Ethnicity incomingEthnicity = incoming.getEthnicity();
        if (incomingEthnicity != null) {
            Ethnicity onFileEthnicity = onFile.getEthnicity();
            if (onFileEthnicity == null) {
                onFileEthnicity = new Ethnicity();
                onFile.setEthnicity(onFileEthnicity);
            }
            this.getCopyService().copy((AbstractEntity)incomingEthnicity, (AbstractEntity)onFileEthnicity);
        } else {
            onFile.setEthnicity(null);
        }
        onFile.setMaritalStatus(incoming.getMaritalStatus());
        onFile.setReligion(incoming.getReligion());
        Relation incomingMother = incoming.getMother();
        Relation onFileMother = onFile.getMother();
        if (incomingMother != null) {
            this.mergeMotherName(incomingMother, onFile);
        } else if (onFileMother != null) {
            onFile.removeRelation(onFileMother);
        }
        Relation incomingFather = incoming.getFather();
        Relation onFileFather = onFile.getFather();
        if (incomingFather != null) {
            this.mergeFatherName(incomingFather, onFile);
        } else if (onFileFather != null) {
            onFile.removeRelation(onFileFather);
        }
    }

    public Person mergeMotherName(Relation incoming, Person onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"A Relation must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"A Person must not be null");
        Relation onFileMother = onFile.getMother();
        Name incomingMotherName = incoming.getName();
        if (incomingMotherName != null) {
            Name onFileMotherName;
            if (onFileMother == null) {
                onFileMother = new Relation();
                onFileMother.setRelationship(this.getLookupService().getRelationshipByCode(Relationship.CODE_MOTHER.getCode()));
                onFile.setMother(onFileMother);
            }
            if ((onFileMotherName = onFileMother.getName()) == null) {
                onFileMotherName = new Name();
                onFileMother.setName(onFileMotherName);
            }
            this.getCopyService().copy((AbstractEntity)incomingMotherName, (AbstractEntity)onFileMotherName);
        } else {
            onFile.removeRelation(onFileMother);
        }
        return onFile;
    }

    public Person mergeFatherName(Relation incoming, Person onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"A Relation must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"A Person must not be null");
        Relation onFileFather = onFile.getFather();
        Name incomingFatherName = incoming.getName();
        if (incomingFatherName != null) {
            Name onFileFatherName;
            if (onFileFather == null) {
                onFileFather = new Relation();
                onFileFather.setRelationship(this.getLookupService().getRelationshipByCode(Relationship.CODE_FATHER.getCode()));
                onFile.setFather(onFileFather);
            }
            if ((onFileFatherName = onFileFather.getName()) == null) {
                onFileFatherName = new Name();
                onFileFather.setName(onFileFatherName);
            }
            this.getCopyService().copy((AbstractEntity)incomingFatherName, (AbstractEntity)onFileFatherName);
        } else {
            onFile.removeRelation(onFileFather);
        }
        return onFile;
    }

    @Override
    public Email mergeEmail(Email incoming, Person onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"An email must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"A person on file must not be null");
        Set emails = onFile.getEmails();
        Email match = null;
        HashSet<Email> remove = new HashSet<Email>();
        int matchCount = 0;
        for (AbstractEntity obj : emails) {
            if (!this.getMatchRuleService().match(obj, (AbstractEntity)incoming)) continue;
            ++matchCount;
            match = (Email)obj;
            remove.add(match);
        }
        if (matchCount == 1) {
            this.getCopyService().copy((AbstractEntity)incoming, match);
        } else {
            if (matchCount > 1) {
                for (Email emailToRemove : remove) {
                    onFile.removeEmail(emailToRemove);
                }
            }
            match = new Email();
            this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)match);
            onFile.addEmail(match);
        }
        return match;
    }

    @Override
    public Phone mergePhone(Phone incoming, Person onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"A phone must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"A person on file must not be null");
        Set phones = onFile.getPhones();
        Phone match = null;
        HashSet<Phone> remove = new HashSet<Phone>();
        int matchCount = 0;
        for (AbstractEntity obj : phones) {
            if (!this.getMatchRuleService().match(obj, (AbstractEntity)incoming)) continue;
            ++matchCount;
            match = (Phone)obj;
            remove.add(match);
        }
        if (matchCount == 1) {
            this.getCopyService().copy((AbstractEntity)incoming, match);
        } else {
            if (matchCount > 1) {
                for (Phone phoneToRemove : remove) {
                    onFile.removePhone(phoneToRemove);
                }
            }
            match = new Phone();
            this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)match);
            onFile.addPhone(match);
        }
        return match;
    }

    @Override
    public Address mergeAddress(Address incoming, Address onFile) throws ServiceException {
        Validate.notNull((Object)incoming, (String)"An incoming address must not be null");
        Validate.notNull((Object)onFile, (String)"An incoming on file address must not be null");
        this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
        return onFile;
    }

    @Override
    public Email mergeEmail(Email incoming, Email onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"An email must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"An email on file must not be null");
        this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
        return onFile;
    }

    @Override
    public Phone mergePhone(Phone incoming, Phone onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"A phone must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"A phone on file must not be null");
        this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
        return onFile;
    }

    @Override
    public void mergeMilitaryServiceSiteRecord(MilitaryServiceSiteRecord incoming, MilitaryServiceSiteRecord onFile) {
        EntityKey key;
        Validate.notNull((Object)((Object)incoming), (String)"A MilitaryServiceSiteRecord must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"A MilitaryServiceSiteRecord on file must not be null");
        try {
            this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
            HashSet<MilitaryServiceEpisode> toAddMSEs = new HashSet<MilitaryServiceEpisode>();
            for (MilitaryServiceEpisode incomingEpisode : incoming.getMilitaryServiceEpisodes()) {
                key = incomingEpisode.getEntityKey();
                if (key == null) {
                    MilitaryServiceEpisode mse = new MilitaryServiceEpisode();
                    this.mergeMilitaryServiceEpisode(incomingEpisode, mse);
                    toAddMSEs.add(mse);
                    continue;
                }
                MilitaryServiceEpisode onFileEpisode = onFile.getMilitaryServiceEpisodeByEntityKey(key);
                if (onFileEpisode == null) {
                    onFileEpisode = new MilitaryServiceEpisode();
                }
                this.mergeMilitaryServiceEpisode(incomingEpisode, onFileEpisode);
                toAddMSEs.add(onFileEpisode);
            }
            onFile.removeAllMilitaryServiceEpisodes();
            if (!toAddMSEs.isEmpty()) {
                onFile.addAllMilitaryServiceEpisodes(toAddMSEs);
            }
        }
        catch (ServiceException ex) {
            this.logger.debug((Object)"Failed to merge an MilitaryServiceEpisode", (Throwable)ex);
            throw new RuntimeException("Failed to merge an MilitaryServiceEpisode", ex);
        }
        try {
            HashSet onFileCEs = new HashSet(onFile.getConflictExperiences());
            for (ConflictExperience ce : onFileCEs) {
                if (incoming.getConflictExperienceByEntityKey(ce.getEntityKey()) != null) continue;
                onFile.removeConflictExperience(ce);
            }
            for (ConflictExperience incomingCE : incoming.getConflictExperiences()) {
                key = incomingCE.getEntityKey();
                if (key == null) {
                    ConflictExperience ce = new ConflictExperience();
                    this.mergeConflictExperience(incomingCE, ce);
                    onFile.addConflictExperience(ce);
                    continue;
                }
                ConflictExperience onFileCE = onFile.getConflictExperienceByEntityKey(key);
                this.mergeConflictExperience(incomingCE, onFileCE);
            }
        }
        catch (ServiceException ex) {
            this.logger.debug((Object)"Failed to merge a Combat Experience", (Throwable)ex);
            throw new RuntimeException("Failed to merge a Combat Experience", ex);
        }
    }

    private void mergeMilitaryServiceSiteRecordNoDeletes(MilitaryServiceSiteRecord incoming, MilitaryServiceSiteRecord onFile) {
        Validate.notNull((Object)((Object)incoming), (String)"A MilitaryServiceSiteRecord must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"A MilitaryServiceSiteRecord on file must not be null");
        try {
            this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
            for (MilitaryServiceEpisode incomingEpisode : incoming.getMilitaryServiceEpisodes()) {
                EntityKey key = incomingEpisode.getEntityKey();
                MilitaryServiceEpisode mse = null;
                if (key == null) {
                    Set episodes = onFile.getMilitaryServiceEpisodes();
                    for (MilitaryServiceEpisode obj : episodes) {
                        if (!this.getMatchRuleService().match((AbstractEntity)obj, (AbstractEntity)incomingEpisode)) continue;
                        mse = obj;
                        break;
                    }
                } else {
                    mse = onFile.getMilitaryServiceEpisodeByEntityKey(key);
                }
                if (mse == null) {
                    mse = new MilitaryServiceEpisode();
                    onFile.addMilitaryServiceEpisode(mse);
                }
                this.mergeMilitaryServiceEpisode(incomingEpisode, mse);
            }
        }
        catch (ServiceException ex) {
            this.logger.debug((Object)"Failed to merge an MilitaryServiceEpisode", (Throwable)ex);
            throw new RuntimeException("Failed to merge an MilitaryServiceEpisode", ex);
        }
        try {
            Set conflictExps = incoming.getConflictExperiences();
            HashSet currentConflictExps = new HashSet(onFile.getConflictExperiences());
            Set mergedConflictExps = this.mergeSets(conflictExps, currentConflictExps);
            onFile.removeAllConflictExperiences();
            onFile.addAllConflictExperiences(mergedConflictExps);
            for (ConflictExperience currCE : currentConflictExps) {
                boolean match = false;
                for (ConflictExperience obj : mergedConflictExps) {
                    if (!this.getMatchRuleService().match((AbstractEntity)obj, (AbstractEntity)currCE)) continue;
                    match = true;
                    break;
                }
                if (match) continue;
                onFile.addConflictExperience(currCE);
            }
        }
        catch (ServiceException ex) {
            this.logger.debug((Object)"Failed to merge a Combat Experience", (Throwable)ex);
            throw new RuntimeException("Failed to merge a Combat Experience", ex);
        }
    }

    @Override
    public void mergeMilitaryServiceNoDeletes(Person incoming, Person onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"An incoming person must not be null ");
        Validate.notNull((Object)((Object)onFile), (String)"An onFile person must not be null ");
        if (incoming.getMilitaryService() != null) {
            MilitaryService militaryService = onFile.getMilitaryService();
            if (militaryService == null) {
                militaryService = new MilitaryService();
                onFile.setMilitaryService(militaryService);
            }
            this.getCopyService().copy((AbstractEntity)incoming.getMilitaryService(), (AbstractEntity)militaryService);
            Set combatEpisodes = incoming.getMilitaryService().getCombatEpisodes();
            HashSet currentCombatEpisodes = new HashSet(onFile.getMilitaryService().getCombatEpisodes());
            Set mergedCombatEpisodes = this.mergeSets(combatEpisodes, currentCombatEpisodes);
            onFile.getMilitaryService().removeAllCombatEpisodes();
            onFile.getMilitaryService().addAllCombatEpisodes(mergedCombatEpisodes);
            for (CombatEpisode currCE : currentCombatEpisodes) {
                boolean match = false;
                for (CombatEpisode obj : mergedCombatEpisodes) {
                    if (!this.getMatchRuleService().match((AbstractEntity)obj, (AbstractEntity)currCE)) continue;
                    match = true;
                    break;
                }
                if (match) continue;
                onFile.getMilitaryService().addCombatEpisode(currCE);
            }
            Set combatServices = incoming.getMilitaryService().getCombatServices();
            HashSet currentCombatServices = new HashSet(onFile.getMilitaryService().getCombatServices());
            Set mergedCombatServices = this.mergeSets(combatServices, currentCombatServices);
            onFile.getMilitaryService().removeAllCombatServices();
            onFile.getMilitaryService().addAllCombatServices(mergedCombatServices);
            for (CombatService currCS : currentCombatServices) {
                boolean match = false;
                for (CombatService obj : mergedCombatServices) {
                    if (!this.getMatchRuleService().match((AbstractEntity)obj, (AbstractEntity)currCS)) continue;
                    match = true;
                    break;
                }
                if (match) continue;
                onFile.getMilitaryService().addCombatService(currCS);
            }
            HashSet<Activation> toAddActs = new HashSet<Activation>();
            Set activations = incoming.getMilitaryService().getActivations();
            HashSet currentActivations = new HashSet(onFile.getMilitaryService().getActivations());
            Set mergedActivations = this.mergeSets(activations, currentActivations);
            onFile.getMilitaryService().removeAllActivations();
            onFile.getMilitaryService().addAllActivations(mergedActivations);
            for (Activation currAct : currentActivations) {
                Activation merge = null;
                for (Activation obj : mergedActivations) {
                    if (!this.getMatchRuleService().match((AbstractEntity)obj, (AbstractEntity)currAct)) continue;
                    merge = obj;
                    break;
                }
                if (merge == null) {
                    toAddActs.add(currAct);
                    continue;
                }
                this.mergeActivation(currAct, merge);
            }
            if (!toAddActs.isEmpty()) {
                onFile.getMilitaryService().addAllActivations(toAddActs);
            }
            for (Activation merge : mergedActivations) {
                Activation incomingAct2 = null;
                for (Activation incomingAct2 : activations) {
                    if (!this.getMatchRuleService().match((AbstractEntity)incomingAct2, (AbstractEntity)merge)) continue;
                }
                if (incomingAct2 == null) continue;
                this.mergeActivation(incomingAct2, merge);
            }
            Set siteRecords = incoming.getMilitaryService().getMilitaryServiceSiteRecords();
            HashSet currentSiteRecords = new HashSet(onFile.getMilitaryService().getMilitaryServiceSiteRecords());
            Set merged = this.mergeSets(siteRecords, currentSiteRecords);
            onFile.getMilitaryService().removeAllMilitaryServiceSiteRecords();
            HashSet<MilitaryServiceSiteRecord> toAdd = new HashSet<MilitaryServiceSiteRecord>();
            for (MilitaryServiceSiteRecord record : currentSiteRecords) {
                MilitaryServiceSiteRecord merge = null;
                for (MilitaryServiceSiteRecord obj : merged) {
                    if (!record.getSite().getCode().equals(obj.getSite().getCode())) continue;
                    merge = obj;
                    break;
                }
                if (merge == null) {
                    toAdd.add(record);
                    continue;
                }
                this.mergeMilitaryServiceSiteRecordNoDeletes(record, merge);
            }
            if (!toAdd.isEmpty()) {
                onFile.getMilitaryService().addAllMilitaryServiceSiteRecords(toAdd);
            }
            for (MilitaryServiceSiteRecord merge : merged) {
                MilitaryServiceSiteRecord incomingSite = incoming.getMilitaryService().getMilitaryServiceSiteRecordsBySite(merge.getSite());
                this.mergeMilitaryServiceSiteRecordNoDeletes(incomingSite, merge);
                onFile.getMilitaryService().addMilitaryServiceSiteRecord(merge);
            }
        }
    }

    @Override
    public MilitaryServiceEpisode mergeMilitaryServiceEpisode(MilitaryServiceEpisode incoming, MilitaryServiceEpisode onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"A MilitaryServiceEpisode must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"A MilitaryServiceEpisode on file must not be null");
        this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
        return onFile;
    }

    @Override
    public CombatEpisode mergeCombatEpisode(CombatEpisode incoming, CombatEpisode onFile) {
        Validate.notNull((Object)((Object)incoming), (String)"A CombatEpisode must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"A CombatEpisode on file must not be null");
        try {
            this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
        }
        catch (ServiceException ex) {
            this.logger.debug((Object)"Failed to merge an CombatEpisode", (Throwable)ex);
            throw new RuntimeException("Failed to merge an CombatEpisode", ex);
        }
        return onFile;
    }

    @Override
    public CombatService mergeCombatService(CombatService incoming, CombatService onFile) {
        Validate.notNull((Object)((Object)incoming), (String)"A CombatService must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"A CombatService on file must not be null");
        try {
            this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
        }
        catch (ServiceException ex) {
            this.logger.debug((Object)"Failed to merge an CombatService", (Throwable)ex);
            throw new RuntimeException("Failed to merge an CombatService", ex);
        }
        return onFile;
    }

    @Override
    public Deployment mergeDeployment(Deployment incoming, Deployment onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"A Deployment must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"A Deployment on file must not be null");
        try {
            this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
        }
        catch (ServiceException ex) {
            this.logger.debug((Object)"Failed to merge an Deployment", (Throwable)ex);
            throw new RuntimeException("Failed to merge an Deployment", ex);
        }
        return onFile;
    }

    @Override
    public Activation mergeActivation(Activation incoming, Activation onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"An Activation must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"An Activation on file must not be null");
        try {
            this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
        }
        catch (ServiceException ex) {
            this.logger.debug((Object)"Failed to merge an Activation", (Throwable)ex);
            throw new RuntimeException("Failed to merge an Activation", ex);
        }
        return onFile;
    }

    @Override
    public ConflictExperience mergeConflictExperience(ConflictExperience incoming, ConflictExperience onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"A Combat Experience must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"A Combat Experience on file must not be null");
        this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
        return onFile;
    }

    @Override
    public PurpleHeart mergePurpleHeart(PurpleHeart incoming, PurpleHeart result) throws ServiceException {
        Validate.notNull((Object)incoming, (String)"A incoming PurpleHeart must not be null");
        Validate.notNull((Object)result, (String)"A PurpleHeart on file must not be null");
        this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)result);
        Set mergedDocuments = this.mergeSets(incoming.getDocuments(), result.getDocuments());
        result.removeAllDocuments();
        Iterator iter = mergedDocuments.iterator();
        while (iter.hasNext()) {
            result.addDocument((PurpleHeartDocument)iter.next());
        }
        return result;
    }

    @Override
    public Application mergeApplication(Application incoming, Application onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"An application must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"An application on file must not be null");
        this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
        return onFile;
    }

    @Override
    public CancelDecline mergeCancelDecline(CancelDecline incoming, CancelDecline onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"A CancelDecline must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"A CancelDecline on file must not be null");
        this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
        return onFile;
    }

    @Override
    public CancelDecline mergeCancelDecline(CancelDecline incoming, Person onFile) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"An on file person must not be null");
        CancelDecline cancelDecline = null;
        if (incoming != null) {
            cancelDecline = onFile.getCancelDecline();
            if (cancelDecline == null) {
                cancelDecline = new CancelDecline();
                onFile.setCancelDecline(cancelDecline);
            }
            this.mergeCancelDecline(incoming, cancelDecline);
        } else {
            onFile.setCancelDecline(null);
        }
        return cancelDecline;
    }

    @Override
    public EligibilityVerification mergeEligibilityVerification(EligibilityVerification incoming, EligibilityVerification onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"An EligibilityVerification must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"An EligibilityVerification on file must not be null");
        this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
        return onFile;
    }

    @Override
    public EligibilityVerification mergeEligibilityVerification(EligibilityVerification incoming, Person onFile) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"An onFile person must not be null ");
        EligibilityVerification updated = onFile.getEligibilityVerification();
        if (incoming != null) {
            if (updated == null) {
                updated = new EligibilityVerification();
                onFile.setEligibilityVerification(updated);
            }
            this.mergeEligibilityVerification(incoming, updated);
        } else {
            updated = null;
            onFile.setEligibilityVerification(null);
        }
        return updated;
    }

    @Override
    public IncompetenceRuling mergeIncompetenceRuling(IncompetenceRuling incoming, IncompetenceRuling onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"An IncompetenceRuling must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"An IncompetenceRuling on file must not be null");
        this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
        return onFile;
    }

    @Override
    public IncompetenceRuling mergeIncompetenceRuling(IncompetenceRuling incoming, Person onFile) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"An onFile person must not be null ");
        IncompetenceRuling updated = null;
        if (incoming != null) {
            updated = onFile.getIncompetenceRuling();
            if (updated == null) {
                updated = new IncompetenceRuling();
                onFile.setIncompetenceRuling(updated);
            }
            this.mergeIncompetenceRuling(incoming, updated);
        } else {
            onFile.setIncompetenceRuling(null);
        }
        return updated;
    }

    @Override
    public MedicaidFactor mergeMedicaidFactor(MedicaidFactor incoming, MedicaidFactor onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"A MedicaidFactor must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"A MedicaidFactor on file must not be null");
        this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
        return onFile;
    }

    @Override
    public MonetaryBenefit mergeMonetaryBenefit(MonetaryBenefit incoming, MonetaryBenefit onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"A MonetaryBenefit must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"A MonetaryBenefit on file must not be null");
        this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
        this.processPensionData(incoming, onFile);
        return onFile;
    }

    private void processPensionData(MonetaryBenefit incoming, MonetaryBenefit onFile) throws CopyServiceException, UnknownLookupTypeException, UnknownLookupCodeException {
        Pension in = null;
        if (incoming != null && incoming.getPension() != null) {
            in = incoming.getPension();
            if (incoming.getMonetaryBenefitIndicator() != null && Boolean.TRUE.equals(incoming.getMonetaryBenefitIndicator().toBoolean()) && in.getEffectiveDate() != null) {
                in.setTerminationDate(null);
                in.setTerminationReasonCode1(null);
                in.setTerminationReasonCode2(null);
                in.setTerminationReasonCode3(null);
                in.setTerminationReasonCode4(null);
            } else if (incoming.getMonetaryBenefitIndicator() != null && Boolean.FALSE.equals(incoming.getMonetaryBenefitIndicator().toBoolean()) && in.getTerminationDate() != null) {
                in.setEffectiveDate(null);
                in.setAwardReasonCode(null);
                this.compactTerminationReasons(in);
            }
            Pension p = onFile.getPension();
            if (p == null) {
                p = new Pension();
                p.setMonetaryBenefit(onFile);
                onFile.setPension(p);
            }
            this.copyPensionData(in, onFile.getPension());
        } else if (onFile.getPension() != null) {
            onFile.setPension(null);
        }
    }

    private void compactTerminationReasons(Pension p) {
        if (p != null) {
            PensionReasonCode[] codes = new PensionReasonCode[]{p.getTerminationReasonCode1(), p.getTerminationReasonCode2(), p.getTerminationReasonCode3(), p.getTerminationReasonCode4()};
            for (int j = 0; j < 3; ++j) {
                for (int i = 0; i < 3; ++i) {
                    if (codes[i] != null) continue;
                    codes[i] = codes[i + 1];
                    codes[i + 1] = null;
                }
            }
            p.setTerminationReasonCode1(codes[0]);
            p.setTerminationReasonCode2(codes[1]);
            p.setTerminationReasonCode3(codes[2]);
            p.setTerminationReasonCode4(codes[3]);
        }
    }

    private void copyPensionData(Pension incoming, Pension onFile) {
        onFile.setAwardReasonCode(incoming.getAwardReasonCode());
        onFile.setEffectiveDate(incoming.getEffectiveDate());
        onFile.setTerminationDate(incoming.getTerminationDate());
        onFile.setTerminationReasonCode1(incoming.getTerminationReasonCode1());
        onFile.setTerminationReasonCode2(incoming.getTerminationReasonCode2());
        onFile.setTerminationReasonCode3(incoming.getTerminationReasonCode3());
        onFile.setTerminationReasonCode4(incoming.getTerminationReasonCode4());
    }

    @Override
    public MonetaryBenefitAward mergeMonetaryBenefitAward(MonetaryBenefitAward incoming, Person onFile) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"An onFile person must not be null ");
        MonetaryBenefitAward updated = onFile.getMonetaryBenefitAward();
        if (incoming != null) {
            if (updated == null) {
                updated = new MonetaryBenefitAward();
                onFile.setMonetaryBenefitAward(updated);
            }
            this.mergeMonetaryBenefitAward(incoming, updated);
        } else {
            updated = null;
            onFile.setMonetaryBenefitAward(null);
        }
        return updated;
    }

    @Override
    public MonetaryBenefitAward mergeMonetaryBenefitAward(MonetaryBenefitAward incoming, MonetaryBenefitAward onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"A MonetaryBenefitAward must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"A MonetaryBenefitAward on file must not be null");
        try {
            boolean found;
            this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
            HashSet<MonetaryBenefit> mbsToRemove = new HashSet<MonetaryBenefit>();
            HashSet onFileMBAs = new HashSet(onFile.getMonetaryBenefits());
            for (MonetaryBenefit mb : onFileMBAs) {
                found = false;
                for (MonetaryBenefit incomingMB : incoming.getMonetaryBenefits()) {
                    if (!this.getMatchRuleService().match((AbstractEntity)mb, (AbstractEntity)incomingMB)) continue;
                    this.mergeMonetaryBenefit(incomingMB, mb);
                    found = true;
                    break;
                }
                if (found) continue;
                mbsToRemove.add(mb);
            }
            for (MonetaryBenefit remove : mbsToRemove) {
                onFile.removeMonetaryBenefit(remove);
            }
            for (MonetaryBenefit incomingMB : incoming.getMonetaryBenefits()) {
                found = false;
                for (MonetaryBenefit onFileMB : onFile.getMonetaryBenefits()) {
                    if (!this.getMatchRuleService().match((AbstractEntity)onFileMB, (AbstractEntity)incomingMB)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                MonetaryBenefit mb = this.mergeMonetaryBenefit(incomingMB, new MonetaryBenefit());
                onFile.addMonetaryBenefit(mb);
            }
        }
        catch (ServiceException ex) {
            this.logger.debug((Object)"Failed to merge a MonetaryBenefitAward", (Throwable)ex);
            throw new RuntimeException("Failed to merge a MonetaryBenefitAward", ex);
        }
        return onFile;
    }

    public RatedDisability mergeRatedDisability(RatedDisability incoming, RatedDisability onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"A RatedDisability must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"A RatedDisability on file must not be null");
        this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
        return onFile;
    }

    @Override
    public ServiceConnectionAward mergeServiceConnectionAward(ServiceConnectionAward incoming, Person onFile) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"An onFile person must not be null ");
        ServiceConnectionAward updated = onFile.getServiceConnectionAward();
        if (incoming != null) {
            if (updated == null) {
                updated = new ServiceConnectionAward();
                onFile.setServiceConnectionAward(updated);
            }
            this.mergeServiceConnectionAward(incoming, updated);
        } else {
            updated = null;
            onFile.setServiceConnectionAward(null);
        }
        return updated;
    }

    @Override
    public ServiceConnectionAward mergeServiceConnectionAward(ServiceConnectionAward incoming, ServiceConnectionAward onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"A ServiceConnectionAward must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"A ServiceConnectionAward on file must not be null");
        try {
            this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
            HashSet onFileRDs = new HashSet(onFile.getRatedDisabilities());
            onFile.removeAllRatedDisability();
            HashSet<RatedDisability> addRds = new HashSet<RatedDisability>();
            for (RatedDisability incomingRD : incoming.getRatedDisabilities()) {
                RatedDisability found = null;
                for (RatedDisability rd : onFileRDs) {
                    if (!this.getMatchRuleService().match((AbstractEntity)rd, (AbstractEntity)incomingRD)) continue;
                    this.mergeRatedDisability(incomingRD, rd);
                    found = rd;
                    break;
                }
                if (found != null) {
                    onFileRDs.remove((Object)found);
                    addRds.add(found);
                    continue;
                }
                RatedDisability newRd = new RatedDisability();
                this.mergeRatedDisability(incomingRD, newRd);
                addRds.add(newRd);
            }
            for (RatedDisability rd : addRds) {
                onFile.addRatedDisability(rd);
            }
        }
        catch (ServiceException ex) {
            this.logger.debug((Object)"Failed to merge a ServiceConnectionAward", (Throwable)ex);
            throw new RuntimeException("Failed to merge a ServiceConnectionAward", ex);
        }
        return onFile;
    }

    @Override
    public SpecialFactor mergeSpecialFactor(SpecialFactor incoming, SpecialFactor onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"A SpecialFactor must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"A SpecialFactor must not be null");
        if (((Object)((Object)incoming)).getClass().getName().contains("Camp")) {
            this.mergeCampLejeuneVerification((CampLejeuneVerification)incoming, (CampLejeuneVerification)onFile);
        } else {
            this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
        }
        return onFile;
    }

    @Override
    public SpecialFactor mergeSpecialFactor(SpecialFactor incoming, Person onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"A SpecialFactor must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"An on file person must not be null");
        SpecialFactor found = onFile.getSpecialFactorByType(((Object)((Object)incoming)).getClass());
        if (found != null) {
            this.mergeSpecialFactor(incoming, found);
        } else {
            try {
                SpecialFactor newSf = (SpecialFactor)((Object)((Object)((Object)incoming)).getClass().newInstance());
                this.mergeSpecialFactor(incoming, newSf);
                onFile.addSpecialFactor(newSf);
                found = newSf;
            }
            catch (Exception e) {
                this.logger.debug((Object)"Failed to merge a special factor", (Throwable)e);
                throw new RuntimeException("Failed to merge a special factor", e);
            }
        }
        return found;
    }

    @Override
    public void mergeSpecialFactor(Person incoming, Person onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"An incoming person must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"An on file person must not be null");
        Set factors = incoming.getSpecialFactors();
        if (factors != null && factors.size() > 0) {
            Set merged = this.mergeSets(factors, onFile.getSpecialFactors());
            onFile.removeAllSpecialFactors();
            for (SpecialFactor factor : merged) {
                onFile.addSpecialFactor(factor);
            }
        } else {
            onFile.removeAllSpecialFactors();
        }
    }

    @Override
    public CatastrophicDisability mergeCatastrophicDisability(CatastrophicDisability incoming, CatastrophicDisability onFile) throws ServiceException {
        return this.mergeCatastrophicDisability(incoming, onFile, true);
    }

    @Override
    public CatastrophicDisability mergeCatastrophicDisability(CatastrophicDisability incoming, CatastrophicDisability onFile, boolean isFromUI) throws ServiceException {
        boolean cpdDataWasProvided;
        Validate.notNull((Object)((Object)incoming), (String)"A CatastrophicDisability must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"A CatastrophicDisability must not be null");
        this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
        if (incoming.getDeterminationFacility() != null) {
            onFile.setDeterminationFacility(incoming.getDeterminationFacility());
        }
        this.mergeCatastrophicDisabilityCDDescriptorsOnly(incoming, onFile, false);
        boolean descriptorExists = onFile.getCDDescriptors().size() > 0;
        boolean bl = cpdDataWasProvided = incoming.getConditions().size() > 0 || incoming.getProcedures().size() > 0 || incoming.getDiagnoses().size() > 0;
        if (isFromUI || !descriptorExists || descriptorExists && cpdDataWasProvided) {
            Set conditions = this.mergeSets(incoming.getConditions(), onFile.getConditions());
            onFile.removeAllConditions();
            Iterator iter = conditions.iterator();
            while (iter.hasNext()) {
                onFile.addCondition((CDCondition)((Object)iter.next()));
            }
            Set procedures = this.mergeSets(incoming.getProcedures(), onFile.getProcedures());
            onFile.removeAllProcedures();
            Iterator iter2 = procedures.iterator();
            while (iter2.hasNext()) {
                onFile.addProcedure((CDProcedure)((Object)iter2.next()));
            }
            Set diagnoses = this.mergeSets(incoming.getDiagnoses(), onFile.getDiagnoses());
            onFile.removeAllDiagnoses();
            Iterator iter3 = diagnoses.iterator();
            while (iter3.hasNext()) {
                onFile.addDiagnosis((CDDiagnosis)((Object)iter3.next()));
            }
        }
        return onFile;
    }

    @Override
    public CatastrophicDisability mergeCatastrophicDisabilityCDDescriptorsOnly(CatastrophicDisability incoming, CatastrophicDisability onFile, boolean addOnly) throws ServiceException {
        block12: {
            Validate.notNull((Object)((Object)incoming), (String)"A CatastrophicDisability must not be null");
            Validate.notNull((Object)((Object)onFile), (String)"A CatastrophicDisability must not be null");
            if (ObjectUtils.equals((Object)incoming.getCDDescriptors().size(), (Object)0)) {
                onFile.removeAllCDDescriptors();
                return onFile;
            }
            boolean skipMergeSets = true;
            if (ObjectUtils.equals((Object)incoming.getCDDescriptors().size(), (Object)onFile.getCDDescriptors().size())) {
                for (CDDescriptor descriptor : incoming.getCDDescriptors()) {
                    CDDescriptor matched = (CDDescriptor)this.getMatchRuleService().findMatchingElement((AbstractEntity)descriptor, onFile.getCDDescriptors());
                    if (matched != null) continue;
                    skipMergeSets = false;
                    break;
                }
            } else {
                skipMergeSets = false;
            }
            if (skipMergeSets) break block12;
            if (!addOnly) {
                HashSet<CDDescriptor> descriptorsHold = new HashSet<CDDescriptor>(onFile.getCDDescriptors());
                HashSet<CDDescriptor> toAdd = new HashSet<CDDescriptor>();
                onFile.removeAllCDDescriptors();
                for (CDDescriptor descriptor : incoming.getCDDescriptors()) {
                    CDDescriptor matched = (CDDescriptor)this.getMatchRuleService().findMatchingElement((AbstractEntity)descriptor, descriptorsHold);
                    if (matched != null) {
                        toAdd.add(matched);
                        continue;
                    }
                    CDDescriptor newCDD = new CDDescriptor();
                    newCDD.setDescriptorType(descriptor.getDescriptorType());
                    toAdd.add(newCDD);
                }
                for (CDDescriptor descriptor : toAdd) {
                    onFile.addCDDescriptor(descriptor);
                }
            } else {
                HashSet<CDDescriptor> toAdd = new HashSet<CDDescriptor>();
                for (CDDescriptor descriptor : incoming.getCDDescriptors()) {
                    CDDescriptor matched = (CDDescriptor)this.getMatchRuleService().findMatchingElement((AbstractEntity)descriptor, onFile.getCDDescriptors());
                    if (matched != null) continue;
                    CDDescriptor newCDD = new CDDescriptor();
                    newCDD.setDescriptorType(descriptor.getDescriptorType());
                    toAdd.add(newCDD);
                }
                for (CDDescriptor descriptor : toAdd) {
                    onFile.addCDDescriptor(descriptor);
                }
            }
        }
        return onFile;
    }

    @Override
    public MilitarySexualTrauma mergeMilitarySexualTrauma(MilitarySexualTrauma incoming, MilitarySexualTrauma onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"A MilitarySexualTrauma must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"A MilitarySexualTrauma must not be null");
        this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
        if (incoming.getDeterminationFacility() != null) {
            onFile.setDeterminationFacility(incoming.getDeterminationFacility());
        }
        return onFile;
    }

    @Override
    public NoseThroatRadium mergeNoseThroatRadium(NoseThroatRadium incoming, NoseThroatRadium onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"A NoseThroatRadium must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"A NoseThroatRadium must not be null");
        this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
        if (incoming.getDeterminationFacility() != null) {
            onFile.setDeterminationFacility(incoming.getDeterminationFacility());
        }
        return onFile;
    }

    @Override
    public FinancialStatement mergeFinancialStatement(FinancialStatement incoming, FinancialStatement onFile) throws ServiceException {
        return this.mergeFinancialStatement(incoming, onFile, false);
    }

    @Override
    public FinancialStatement mergeFinancialStatement(FinancialStatement incoming, FinancialStatement onFile, boolean isMergeForZ07) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"A FinancialStatement must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"A FinancialStatement must not be null");
        this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
        this.mergeFinancialInformation(incoming, onFile);
        this.removeDeletedSpouseFinancials(incoming, onFile);
        Set incomingSpouseFinancials = incoming.getSpouseFinancials();
        Set onFileSpouseFinancials = onFile.getSpouseFinancials();
        for (SpouseFinancials sourceFinancials : incomingSpouseFinancials) {
            SpouseFinancials targetFinancials = (SpouseFinancials)this.matchRuleService.findMatchingElement((AbstractEntity)sourceFinancials, onFileSpouseFinancials);
            if (targetFinancials == null) {
                targetFinancials = new SpouseFinancials();
                this.mergeSpouseFinancials(sourceFinancials, targetFinancials, isMergeForZ07);
                onFile.addSpouseFinancials(targetFinancials);
                continue;
            }
            this.mergeSpouseFinancials(sourceFinancials, targetFinancials, isMergeForZ07);
        }
        this.removeDeletedDependentFinancials(incoming, onFile);
        Set onFileDependentFinancials = onFile.getDependentFinancials();
        Set incomingDependentFinancials = incoming.getDependentFinancials();
        for (DependentFinancials sourceFinancials : incomingDependentFinancials) {
            DependentFinancials targetFinancials = (DependentFinancials)this.matchRuleService.findMatchingElement((AbstractEntity)sourceFinancials, onFileDependentFinancials);
            if (targetFinancials == null) {
                targetFinancials = new DependentFinancials();
                this.mergeDependentFinancials(sourceFinancials, targetFinancials, isMergeForZ07);
                onFile.addDependentFinancials(targetFinancials);
                continue;
            }
            this.mergeDependentFinancials(sourceFinancials, targetFinancials, isMergeForZ07);
        }
        return onFile;
    }

    private void removeDeletedSpouseFinancials(FinancialStatement incoming, FinancialStatement onFile) {
        Set incomingSpouseFinancials = incoming.getSpouseFinancials();
        Set onFileSpouseFinancials = onFile.getSpouseFinancials();
        HashSet<SpouseFinancials> spousesToBeDeleted = new HashSet<SpouseFinancials>();
        for (SpouseFinancials spouseFinancials : onFileSpouseFinancials) {
            if (this.matchRuleService.findMatchingElement((AbstractEntity)spouseFinancials, incomingSpouseFinancials) != null) continue;
            spousesToBeDeleted.add(spouseFinancials);
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)(" Removing Spouse Finacials with id " + spouseFinancials.getEntityKey().getKeyValueAsString()));
        }
        if (spousesToBeDeleted.size() > 0) {
            onFile.removeSpouseFinancials(spousesToBeDeleted);
        }
    }

    private void removeDeletedDependentFinancials(FinancialStatement incoming, FinancialStatement onFile) {
        Set incomingDependentFinancials = incoming.getDependentFinancials();
        Set onFileDependentFinancials = onFile.getDependentFinancials();
        HashSet<DependentFinancials> dependentsToBeDeleted = new HashSet<DependentFinancials>();
        for (DependentFinancials dependentFinancials : onFileDependentFinancials) {
            if (this.matchRuleService.findMatchingElement((AbstractEntity)dependentFinancials, incomingDependentFinancials) != null) continue;
            dependentsToBeDeleted.add(dependentFinancials);
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)(" Removing Dependent Finacials with id " + dependentFinancials.getEntityKey().getKeyValueAsString()));
        }
        if (dependentsToBeDeleted.size() > 0) {
            onFile.removeDependentFinancials(dependentsToBeDeleted);
        }
    }

    @Override
    public FinancialInformation mergeFinancialInformation(FinancialInformation incoming, FinancialInformation onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"A FinancialStatement must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"A FinancialStatement must not be null");
        Map assets = this.mergeMaps(incoming.getAssets(), onFile.getAssets());
        for (AssetType assetType : assets.keySet()) {
            onFile.setAsset(assetType, (Asset)((Object)assets.get((Object)assetType)));
        }
        Map incomes = this.mergeMaps(incoming.getIncome(), onFile.getIncome());
        for (IncomeType incomeType : incomes.keySet()) {
            onFile.setIncome(incomeType, (Income)((Object)incomes.get((Object)incomeType)));
        }
        Map expenses = this.mergeMaps(incoming.getExpenses(), onFile.getExpenses());
        for (ExpenseType expenseType : expenses.keySet()) {
            onFile.setExpense(expenseType, (Expense)((Object)expenses.get((Object)expenseType)));
        }
        this.mergeDebt(incoming, onFile);
        return onFile;
    }

    private void mergeDebt(FinancialInformation incoming, FinancialInformation onFile) {
        Debt incomingDebt = incoming.getDebt();
        Debt onFileDebt = onFile.getDebt();
        if (incomingDebt == null && onFileDebt == null) {
            return;
        }
        if (incomingDebt == null && onFileDebt != null) {
            onFile.setDebt(null);
        } else if (incomingDebt != null && onFileDebt == null) {
            onFile.setDebt(new Debt(incomingDebt.getAmount()));
        } else if (incomingDebt != null && onFileDebt != null) {
            onFileDebt.setAmount(incomingDebt.getAmount());
        }
    }

    private Map mergeMaps(Map incoming, Map onFile) throws CopyServiceException {
        HashMap mergedMap = new HashMap();
        Validate.notNull((Object)incoming, (String)"A incoming map must not be null");
        Validate.notNull((Object)onFile, (String)"A onFile map must not be null");
        HashSet deletedKeys = new HashSet(onFile.keySet());
        deletedKeys.removeAll(incoming.keySet());
        HashSet newKeys = new HashSet(incoming.keySet());
        newKeys.removeAll(onFile.keySet());
        HashSet updatedKeys = new HashSet(incoming.keySet());
        updatedKeys.removeAll(newKeys);
        for (Object key : deletedKeys) {
            mergedMap.put(key, null);
        }
        for (Object key : newKeys) {
            try {
                Object newInstance = incoming.get(key).getClass().newInstance();
                this.getCopyService().copy((AbstractEntity)incoming.get(key), (AbstractEntity)newInstance);
                mergedMap.put(key, newInstance);
            }
            catch (Exception e) {
                throw new CopyServiceException("Unable to create new Instance for " + incoming.get(key).getClass().getName());
            }
        }
        for (Object key : updatedKeys) {
            this.getCopyService().copy((AbstractEntity)incoming.get(key), (AbstractEntity)onFile.get(key));
            mergedMap.put(key, onFile.get(key));
        }
        return mergedMap;
    }

    @Override
    public void mergeFullIncomeTest(IncomeTest incomingTest, IncomeTest resultTest) throws ServiceException {
        this.mergeIncomeTest(incomingTest, resultTest);
        resultTest.setGmtThresholdAmount(incomingTest.getGmtThresholdAmount());
        Hardship incomingHardship = incomingTest.getHardship();
        Hardship onFileHardship = resultTest.getHardship();
        if (incomingHardship == null) {
            resultTest.setHardship(null);
        } else {
            if (onFileHardship == null) {
                onFileHardship = new Hardship();
                resultTest.setHardship(onFileHardship);
            }
            this.mergeHardship(incomingHardship, onFileHardship);
        }
        resultTest.setLastEditedDate(incomingTest.getLastEditedDate());
        resultTest.setCompletedDate(incomingTest.getCompletedDate());
        Address resultGMTAddress = resultTest.getGmtAddress();
        Address incomingGMTAddress = incomingTest.getGmtAddress();
        if (incomingGMTAddress == null) {
            resultTest.setGmtAddress(null);
        } else {
            if (resultGMTAddress == null) {
                resultGMTAddress = new Address();
                resultTest.setGmtAddress(resultGMTAddress);
            }
            this.mergeAddress(incomingGMTAddress, resultGMTAddress);
        }
    }

    @Override
    public IncomeTest mergeIncomeTest(IncomeTest incoming, IncomeTest onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"A IncomeTest must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"A IncomeTest must not be null");
        this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
        this.removeDeletedIncomeTestStatuses(incoming, onFile);
        Set statuses = incoming.getStatuses();
        Set onFileStatuses = onFile.getStatuses();
        for (IncomeTestStatus incomingStatus : statuses) {
            IncomeTestStatus targetStatus = (IncomeTestStatus)this.matchRuleService.findMatchingElement((AbstractEntity)incomingStatus, onFileStatuses);
            if (targetStatus == null) {
                targetStatus = new IncomeTestStatus();
                onFile.addStatus(targetStatus);
            }
            this.mergeIncomeTestStatus(incomingStatus, targetStatus);
        }
        return onFile;
    }

    @Override
    public void mergeIncomeTestStatus(IncomeTestStatus incomingStatus, IncomeTestStatus targetStatus) throws CopyServiceException {
        Validate.notNull((Object)((Object)incomingStatus), (String)"A source IncomeTestStatus must not be null");
        Validate.notNull((Object)((Object)targetStatus), (String)"A target IncomeTestStatus must not be null");
        this.getCopyService().copy((AbstractEntity)incomingStatus, (AbstractEntity)targetStatus);
    }

    private void removeDeletedIncomeTestStatuses(IncomeTest incoming, IncomeTest onFile) {
        Set incomingStatuses = incoming.getStatuses();
        Set onFileStatuses = onFile.getStatuses();
        HashSet<IncomeTestStatus> statusesToBeDeleted = new HashSet<IncomeTestStatus>();
        for (IncomeTestStatus incomeTestStatus : onFileStatuses) {
            if (this.matchRuleService.findMatchingElement((AbstractEntity)incomeTestStatus, incomingStatuses) != null) continue;
            statusesToBeDeleted.add(incomeTestStatus);
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug((Object)(" Removing IncomeTestStatus with id " + incomeTestStatus.getEntityKey().getKeyValueAsString()));
        }
        for (IncomeTestStatus incomeTestStatus : statusesToBeDeleted) {
            onFile.removeStatus(incomeTestStatus);
        }
    }

    @Override
    public SpouseFinancials mergeSpouseFinancials(SpouseFinancials incoming, SpouseFinancials onFile) throws ServiceException {
        return this.mergeSpouseFinancials(incoming, onFile, false);
    }

    public SpouseFinancials mergeSpouseFinancials(SpouseFinancials incoming, SpouseFinancials onFile, boolean isMergeForZ07) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"A SpouseFinancials must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"A SpouseFinancials must not be null");
        if (AbstractEntity.matchesDomainValues((AbstractEntity)incoming, (AbstractEntity)onFile)) {
            return onFile;
        }
        this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
        this.mergeFinancialInformation(incoming, onFile);
        Spouse incomingSpouse = incoming.getReportedOn();
        Spouse onFileSpouse = onFile.getReportedOn();
        if (incomingSpouse == null) {
            if (onFileSpouse != null) {
                onFile.setReportedOn(null);
            }
        } else {
            if (onFileSpouse == null) {
                onFileSpouse = new Spouse();
            }
            this.mergeSpouse(incomingSpouse, onFileSpouse, isMergeForZ07);
            onFile.setReportedOn(onFileSpouse);
        }
        return onFile;
    }

    @Override
    public DependentFinancials mergeDependentFinancials(DependentFinancials incoming, DependentFinancials onFile) throws ServiceException {
        return this.mergeDependentFinancials(incoming, onFile, false);
    }

    public DependentFinancials mergeDependentFinancials(DependentFinancials incoming, DependentFinancials onFile, boolean isMergeForZ07) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"A DependentFinancials must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"A DependentFinancials must not be null");
        if (AbstractEntity.matchesDomainValues((AbstractEntity)incoming, (AbstractEntity)onFile)) {
            return onFile;
        }
        this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
        this.mergeFinancialInformation(incoming, onFile);
        Dependent incomingDependent = incoming.getReportedOn();
        Dependent onFileDependent = onFile.getReportedOn();
        if (incomingDependent == null) {
            if (onFileDependent != null) {
                onFile.setReportedOn(null);
            }
        } else {
            if (onFileDependent == null) {
                onFileDependent = new Dependent();
            }
            onFile.setReportedOn(onFileDependent);
            this.mergeDependent(incomingDependent, onFileDependent, isMergeForZ07);
        }
        return onFile;
    }

    @Override
    public Spouse mergeSpouse(Spouse incoming, Spouse onFile) throws ServiceException {
        return this.mergeSpouse(incoming, onFile, false);
    }

    public Spouse mergeSpouse(Spouse incoming, Spouse onFile, boolean isMergeForZ07) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"A Spouse must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"A Spouse must not be null");
        this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
        this.mergeSSN(incoming, onFile, isMergeForZ07);
        if (!isMergeForZ07) {
            this.mergeSpouseEmployment(incoming, onFile);
        }
        return onFile;
    }

    @Override
    public void mergeSpouseEmployment(Spouse incoming, Spouse onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"An incoming spouse must not be null ");
        Validate.notNull((Object)((Object)onFile), (String)"An onFile spouse must not be null ");
        Employment incomingEM = incoming.getEmployment();
        Employment onFileEM = onFile.getEmployment();
        if (incomingEM != null) {
            if (onFileEM == null) {
                onFileEM = new Employment();
            }
            this.mergeEmployment(incomingEM, onFileEM);
            onFile.setEmployment(onFileEM);
        } else {
            onFile.setEmployment(null);
        }
    }

    @Override
    public void mergeSpouseAddress(Spouse incoming, Spouse onFile) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"An incoming spouse must not be null ");
        Validate.notNull((Object)((Object)onFile), (String)"An onFile spouse must not be null ");
        Address incomingAddresses = incoming.getAddress();
        Address onfileAddress = onFile.getAddress();
        if (onfileAddress == null) {
            onfileAddress = new Address();
        }
        if (incomingAddresses != null) {
            this.mergeAddress(incomingAddresses, onfileAddress);
            onFile.setAddress(onfileAddress);
        } else {
            onFile.setAddress(null);
        }
    }

    @Override
    public void mergeSpouseHomePhone(Spouse incoming, Spouse onFile) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"An incoming spouse must not be null ");
        Validate.notNull((Object)((Object)onFile), (String)"An onFile spouse must not be null ");
        Phone incomingPhone = incoming.getHomePhone();
        Phone onfilePhone = onFile.getHomePhone();
        if (onfilePhone == null) {
            onfilePhone = new Phone();
        }
        if (incomingPhone != null) {
            this.mergePhone(incomingPhone, onfilePhone);
            onFile.setHomePhone(onfilePhone);
        } else {
            onFile.setHomePhone(null);
        }
    }

    @Override
    public void mergeSSN(Relation incoming, Relation onFile) throws ServiceException {
        this.mergeSSN(incoming, onFile, false);
    }

    public void mergeSSN(Relation incoming, Relation onFile, boolean isMergeForZ07) throws ServiceException {
        SSN prevSsn = onFile.getOfficialSsn() == null ? null : (SSN)((Object)onFile.getOfficialSsn().clone());
        Set ssns = incoming.getSsns();
        if (ssns != null && ssns.size() > 0) {
            Set merged = null;
            merged = isMergeForZ07 ? this.mergeSsnSets(ssns, onFile.getSsns()) : this.mergeSets(ssns, onFile.getSsns());
            onFile.removeAllSsns();
            for (SSN ssn : merged) {
                onFile.addSsn(ssn);
            }
        } else {
            onFile.removeAllSsns();
        }
        SSN onFileSsn = onFile.getOfficialSsn();
        if (onFileSsn != null && onFileSsn.getSsnText() != null && !SSN.isValidSSN(onFileSsn.getSsnText())) {
            if (prevSsn != null) {
                this.getCopyService().copy((AbstractEntity)prevSsn, (AbstractEntity)onFileSsn);
            } else {
                onFile.removeSsn(onFileSsn);
            }
        }
    }

    @Override
    public Dependent mergeDependent(Dependent incoming, Dependent onFile) throws ServiceException {
        return this.mergeDependent(incoming, onFile, false);
    }

    public Dependent mergeDependent(Dependent incoming, Dependent onFile, boolean isMergeForZ07) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"A Dependent must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"A Dependent must not be null");
        this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
        this.mergeSSN(incoming, onFile, isMergeForZ07);
        return onFile;
    }

    @Override
    public BeneficiaryTravel mergeBeneficiaryTravel(BeneficiaryTravel incoming, BeneficiaryTravel onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"A BeneficiaryTravel must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"A BeneficiaryTravel must not be null");
        this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
        return onFile;
    }

    @Override
    public Hardship mergeHardship(Hardship incoming, Hardship onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"A Hardship must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"A Hardship must not be null");
        this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
        return onFile;
    }

    @Override
    public PatientVisitSummary mergePatientVisitSummary(PatientVisitSummary incoming, PatientVisitSummary onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"A PatientVisitSummary must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"A PatientVisitSummary must not be null");
        this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
        return onFile;
    }

    @Override
    public FeeBasis mergeFeeBasis(FeeBasis incoming, FeeBasis onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"A incoming FeeBasis must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"A FeeBasis on file must not be null");
        this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
        return onFile;
    }

    @Override
    public ReceivedEnrollment mergeReceivedEnrollment(ReceivedEnrollment incoming, ReceivedEnrollment onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"A Received Enrollment must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"A Received Enrollment must not be null");
        this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
        return onFile;
    }

    @Override
    public ReceivedEligibility mergeReceivedEligibility(ReceivedEligibility incoming, ReceivedEligibility onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"A Received Eligibility must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"A Received Eligibility must not be null");
        this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
        return onFile;
    }

    @Override
    public EnrollmentOverride mergeEnrollmentOverride(EnrollmentOverride incoming, EnrollmentOverride onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"A received Enrollment Override must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"An on file Enrollment Override must not be null");
        this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
        return onFile;
    }

    public CDDiagnosis mergeCDDiagnosis(CDDiagnosis incoming, CDDiagnosis onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"A CDDiagnosis must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"A CDDiagnosis on file must not be null");
        this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
        return onFile;
    }

    public CDProcedure mergeCDProcedure(CDProcedure incoming, CDProcedure onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"A CDProcedure must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"A CDProcedure on file must not be null");
        this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
        return onFile;
    }

    public CDCondition mergeCDCondition(CDCondition incoming, CDCondition onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"A CDCondition must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"A CDCondition on file must not be null");
        this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
        return onFile;
    }

    @Override
    public DeathRecord mergeDeathRecord(DeathRecord incoming, DeathRecord onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"A DeathRecord must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"A DeathRecord on file must not be null");
        this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
        return onFile;
    }

    @Override
    public Eligibility mergeEligibility(Eligibility incoming, Eligibility onFile) throws ServiceException {
        Validate.notNull((Object)incoming, (String)"A Eligibility must not be null");
        Validate.notNull((Object)onFile, (String)"A Eligibility on file must not be null");
        this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
        return onFile;
    }

    @Override
    public EnrollmentDetermination mergeEnrollmentDetermination(EnrollmentDetermination incoming, EnrollmentDetermination onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"A EnrollmentDetermination must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"A EnrollmentDetermination on file must not be null");
        boolean matchedEnrollment = AbstractEntity.matchesDomainConcept((AbstractEntity)incoming, (AbstractEntity)onFile);
        Eligibility incomingPrimary = incoming.getPrimaryEligibility();
        Eligibility onFileprimary = onFile.getPrimaryEligibility();
        boolean matchedPrimary = AbstractEntity.matchesDomainConcept((AbstractEntity)incomingPrimary, (AbstractEntity)onFileprimary);
        boolean matchedSecondaries = true;
        if (!ObjectUtils.equals((Object)incoming.getSecondaryEligibilities().size(), (Object)onFile.getSecondaryEligibilities().size())) {
            matchedSecondaries = false;
        } else {
            for (Eligibility e : incoming.getSecondaryEligibilities()) {
                Eligibility match = (Eligibility)this.getMatchRuleService().findMatchingElement((AbstractEntity)e, onFile.getSecondaryEligibilities());
                if (match != null) continue;
                matchedSecondaries = false;
                break;
            }
        }
        boolean matchedOthers = true;
        if (!ObjectUtils.equals((Object)incoming.getOtherEligibilities().size(), (Object)onFile.getOtherEligibilities().size())) {
            matchedOthers = false;
        } else {
            for (Eligibility e : incoming.getOtherEligibilities()) {
                Eligibility match = (Eligibility)this.getMatchRuleService().findMatchingElement((AbstractEntity)e, onFile.getOtherEligibilities());
                if (match != null) continue;
                matchedOthers = false;
                break;
            }
        }
        if (!(matchedEnrollment && matchedPrimary && matchedOthers && matchedSecondaries)) {
            this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
            if (incomingPrimary != null) {
                if (onFileprimary == null) {
                    onFileprimary = new Eligibility();
                    onFile.setPrimaryEligiblity(onFileprimary);
                }
                this.getCopyService().copy((AbstractEntity)incomingPrimary, (AbstractEntity)onFileprimary);
            } else {
                onFile.setPrimaryEligiblity(null);
            }
            Set mergedSecondaryEligibilities = this.mergeSets(incoming.getSecondaryEligibilities(), onFile.getSecondaryEligibilities());
            HashSet secondaryEligibilities = new HashSet(onFile.getSecondaryEligibilities());
            Iterator iter = secondaryEligibilities.iterator();
            while (iter.hasNext()) {
                onFile.removeSecondaryEligibility((Eligibility)iter.next());
            }
            iter = mergedSecondaryEligibilities.iterator();
            while (iter.hasNext()) {
                onFile.addSecondaryEligibility((Eligibility)iter.next());
            }
            Set mergedOtherEligibilities = this.mergeSets(incoming.getOtherEligibilities(), onFile.getOtherEligibilities());
            HashSet otherEligibilities = new HashSet(onFile.getOtherEligibilities());
            Iterator iter2 = otherEligibilities.iterator();
            while (iter2.hasNext()) {
                onFile.removeOtherEligibility((Eligibility)iter2.next());
            }
            iter2 = mergedOtherEligibilities.iterator();
            while (iter2.hasNext()) {
                onFile.addOtherEligibility((Eligibility)iter2.next());
            }
        }
        return onFile;
    }

    @Override
    public PrisonerOfWar mergePrisonerOfWar(PrisonerOfWar incoming, PrisonerOfWar onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"A PrisonerOfWar must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"A PrisonerOfWar on file must not be null");
        this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
        return onFile;
    }

    @Override
    public POWEpisode mergePOWEpisode(POWEpisode incoming, POWEpisode onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"A POWEpisode must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"A POWEpisode on file must not be null");
        this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
        return onFile;
    }

    @Override
    public PrisonerOfWar mergePrisonerOfWar(PrisonerOfWar incoming, Person onFile) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"A person on file must not be null");
        if (incoming == null) {
            onFile.setPrisonerOfWar(null);
            return null;
        }
        PrisonerOfWar onFilePow = onFile.getPrisonerOfWar();
        if (onFilePow == null) {
            onFilePow = new PrisonerOfWar();
            onFile.setPrisonerOfWar(onFilePow);
        }
        this.mergePrisonerOfWar(incoming, onFilePow);
        Set mergedEpisodes = this.mergeSets(incoming.getEpisodes(), onFilePow.getEpisodes());
        onFilePow.removeAllEpisodes();
        Iterator iter = mergedEpisodes.iterator();
        while (iter.hasNext()) {
            onFilePow.addEpisode((POWEpisode)((Object)iter.next()));
        }
        return onFile.getPrisonerOfWar();
    }

    @Override
    public SHAD mergeSHAD(SHAD incoming, Person onFile) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"A person on file must not be null");
        if (incoming == null) {
            onFile.setShad(null);
            return null;
        }
        SHAD onFileSHAD = onFile.getShad();
        if (onFileSHAD == null) {
            onFileSHAD = new SHAD();
            onFile.setShad(onFileSHAD);
        }
        this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFileSHAD);
        Set mergedDocuments = this.mergeSets(incoming.getDocuments(), onFileSHAD.getDocuments());
        onFileSHAD.removeAllDocuments();
        if (mergedDocuments.size() > 0) {
            onFileSHAD.addAllDocuments(mergedDocuments);
        }
        RegistryTrait trait = incoming.getRegistryTrait();
        RegistryTrait onFileTrait = onFileSHAD.getRegistryTrait();
        if (trait == null) {
            onFileSHAD.setRegistryTrait(null);
        } else {
            if (onFileTrait == null) {
                onFileTrait = new RegistryTrait();
                onFileSHAD.setRegistryTrait(onFileTrait);
            }
            this.getCopyService().copy((AbstractEntity)trait, (AbstractEntity)onFileTrait);
            Set mergedDetails = this.mergeSets(trait.getRegistryTraitDetails(), onFileTrait.getRegistryTraitDetails());
            onFileTrait.removeAllRegistryTraitDetails();
            if (mergedDetails.size() > 0) {
                onFileTrait.addAllRegistryTraitDetails(mergedDetails);
            }
        }
        return onFile.getShad();
    }

    @Override
    public SignatureImage mergeSignatureImage(SignatureImage incoming, Person onFile) throws ServiceException {
        Validate.notNull((Object)incoming, (String)"A SignatureImage must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"A person on file must not be null");
        Set signatures = onFile.getSignatureImages();
        SignatureImage match = incoming;
        boolean found = false;
        for (AbstractEntity obj : signatures) {
            if (!this.getMatchRuleService().match(obj, (AbstractEntity)incoming)) continue;
            match = (SignatureImage)obj;
            this.mergeSignatureImage(incoming, match);
            onFile.addSignatureImage(match);
            found = true;
            break;
        }
        if (!found) {
            SignatureImage signatureImage = new SignatureImage();
            this.mergeSignatureImage(match, signatureImage);
            onFile.addSignatureImage(signatureImage);
        }
        return match;
    }

    @Override
    public SignatureImage mergeSignatureImage(SignatureImage incoming, SignatureImage onFile) throws ServiceException {
        Validate.notNull((Object)incoming, (String)"A SignatureImage must not be null");
        Validate.notNull((Object)onFile, (String)"A SignatureImage on file must not be null");
        this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
        return onFile;
    }

    @Override
    public PurpleHeart mergeRegistry(PurpleHeart incoming, PurpleHeart onFile) throws ServiceException {
        return this.mergeRegistry(incoming, onFile, true);
    }

    @Override
    public PrisonerOfWar mergeRegistry(PrisonerOfWar incoming, PrisonerOfWar onFile) throws ServiceException {
        return this.mergeRegistry(incoming, onFile, true);
    }

    @Override
    public SHAD mergeRegistry(SHAD incoming, SHAD onFile) throws ServiceException {
        return this.mergeRegistry(incoming, onFile, true);
    }

    protected RegistryTrait mergeRegistryTrait(RegistryTrait incoming, RegistryTrait onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"A RegistryTrait must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"A RegistryTrait on file must not be null");
        try {
            this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
            HashSet onFileDetails = new HashSet(onFile.getRegistryTraitDetails());
            for (RegistryTraitDetail detail : onFileDetails) {
                if (incoming.getRegistryTraitDetailByEntityKey(detail.getEntityKey()) != null) continue;
                onFile.removeRegistryTraitDetail(detail);
            }
            for (RegistryTraitDetail incomingDetail : incoming.getRegistryTraitDetails()) {
                EntityKey key = incomingDetail.getEntityKey();
                if (key == null) {
                    RegistryTraitDetail detail = new RegistryTraitDetail();
                    detail.setMilitaryServiceNumber(incomingDetail.getMilitaryServiceNumber());
                    onFile.addRegistryTraitDetail(detail);
                    continue;
                }
                RegistryTraitDetail onFiledetail = onFile.getRegistryTraitDetailByEntityKey(key);
                onFiledetail.setMilitaryServiceNumber(incomingDetail.getMilitaryServiceNumber());
            }
        }
        catch (ServiceException ex) {
            this.logger.debug((Object)"Failed to merge an RegistryTrait", (Throwable)ex);
            throw new RuntimeException("Failed to merge an RegistryTrait", ex);
        }
        return onFile;
    }

    @Override
    public Person mergePerson(Person incoming, Person onFile, boolean isUpdateFromGUI) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"An incoming personR must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"A person on file must not be null");
        this.mergeDemographic(incoming, onFile, isUpdateFromGUI);
        this.mergeIdentityTraits(incoming, onFile, true);
        this.mergeDeathRecord(incoming, onFile);
        this.mergeSSN(incoming, onFile);
        this.mergePatientVisitSummary(incoming, onFile);
        this.mergeSHAD(incoming.getShad(), onFile);
        this.mergeEligibilityVerification(incoming.getEligibilityVerification(), onFile);
        this.mergeServiceConnectionAward(incoming.getServiceConnectionAward(), onFile);
        this.mergeCancelDecline(incoming.getCancelDecline(), onFile);
        this.mergeIncompetenceRuling(incoming.getIncompetenceRuling(), onFile);
        this.mergeIneligibilityFactor(incoming.getIneligibilityFactor(), onFile);
        this.mergeSpecialFactor(incoming, onFile);
        this.mergeMonetaryBenefitAward(incoming.getMonetaryBenefitAward(), onFile);
        this.mergeMedicaidFactor(incoming, onFile);
        this.mergeMilitaryService(incoming, onFile, isUpdateFromGUI);
        this.mergeFeeBasis(incoming, onFile);
        this.mergeReceivedEligibility(incoming, onFile);
        this.mergePrisonerOfWar(incoming.getPrisonerOfWar(), onFile);
        this.mergePurpleHeart(incoming, onFile);
        this.mergeAssociation(incoming, onFile);
        this.mergeAddress(incoming, onFile);
        this.mergePhone(incoming, onFile);
        this.mergeEmail(incoming, onFile);
        this.mergeInsurancePolicy(incoming, onFile);
        this.mergeEnrollmentOverride(incoming, onFile);
        this.mergeSignatureImage(incoming, onFile);
        this.mergeCatastrophicDisability(incoming, onFile);
        this.mergeMilitarySexualTrauma(incoming, onFile);
        this.mergeNoseThroatRadium(incoming, onFile);
        this.mergeFinancialData(incoming, onFile);
        this.mergeEmergencyResponseIndicator(incoming, onFile);
        return onFile;
    }

    @Override
    public EmergencyResponseIndicator mergeEmergencyResponseIndicator(EmergencyResponseIndicator incoming, EmergencyResponseIndicator onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"An incoming EmergencyResponseIndicator must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"A EmergencyResponseIndicator on file must not be null");
        this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
        return onFile;
    }

    @Override
    public void mergeEmergencyResponseIndicator(Person incoming, Person onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"An incoming personR must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"A person on file must not be null");
        Set merged = this.mergeSets(incoming.getEmergencyResponseIndicators(), onFile.getEmergencyResponseIndicators());
        onFile.removeAllEmergencyResponseIndicators();
        Iterator iter = merged.iterator();
        while (iter.hasNext()) {
            onFile.addEmergencyResponseIndicator((EmergencyResponseIndicator)((Object)iter.next()));
        }
    }

    @Override
    public EGTSetting mergeEGTSetting(EGTSetting incoming, EGTSetting onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"An incoming EGTSetting must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"A EGTSetting on file must not be null");
        try {
            this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
        }
        catch (ServiceException ex) {
            this.logger.debug((Object)"Failed to merge an EGTSetting", (Throwable)ex);
            throw new RuntimeException("Failed to merge an EGTSetting", ex);
        }
        return onFile;
    }

    @Override
    public EGTProcessStatistic mergeEGTProcessStatistic(EGTProcessStatistic incoming, EGTProcessStatistic onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"An incoming EGTProcessStatistic must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"A EGTProcessStatistic on file must not be null");
        try {
            this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
        }
        catch (ServiceException ex) {
            this.logger.debug((Object)"Failed to merge an EGTProcessStatistic", (Throwable)ex);
            throw new RuntimeException("Failed to merge an EGTProcessStatistic", ex);
        }
        return onFile;
    }

    @Override
    public EGTSiteStatistic mergeEGTSiteStatistic(EGTSiteStatistic incoming, EGTSiteStatistic onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"An incoming EGTSiteStatistic must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"A EGTSiteStatistic on file must not be null");
        try {
            this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
        }
        catch (ServiceException ex) {
            this.logger.debug((Object)"Failed to merge an EGTSiteStatistic", (Throwable)ex);
            throw new RuntimeException("Failed to merge an EGTSiteStatistic", ex);
        }
        return onFile;
    }

    @Override
    public PrisonerOfWar mergeRegistry(PrisonerOfWar incoming, PrisonerOfWar onFile, boolean isUI) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"A Registry must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"A Registry on file must not be null");
        try {
            this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
            this.mergeRegistryTrait(incoming.getRegistryTrait(), onFile.getRegistryTrait());
            if (isUI) {
                HashSet onFileEpisodes = new HashSet(onFile.getEpisodes());
                for (POWEpisode episode : onFileEpisodes) {
                    if (incoming.getEpisodeByEntityKey(episode.getEntityKey()) != null) continue;
                    onFile.removeEpisode(episode);
                }
            }
            for (POWEpisode incomingEpisode : incoming.getEpisodes()) {
                EntityKey key = incomingEpisode.getEntityKey();
                if (key == null) {
                    POWEpisode episode = new POWEpisode();
                    this.getCopyService().copy((AbstractEntity)incomingEpisode, (AbstractEntity)episode);
                    onFile.addEpisode(episode);
                    continue;
                }
                POWEpisode onFileEpisode = onFile.getEpisodeByEntityKey(key);
                this.getCopyService().copy((AbstractEntity)incomingEpisode, (AbstractEntity)onFileEpisode);
            }
        }
        catch (ServiceException ex) {
            this.logger.debug((Object)"Failed to merge an POW registry", (Throwable)ex);
            throw new RuntimeException("Failed to merge an POW registry", ex);
        }
        return onFile;
    }

    @Override
    public PurpleHeart mergeRegistry(PurpleHeart incoming, PurpleHeart onFile, boolean isUI) throws ServiceException {
        Validate.notNull((Object)incoming, (String)"A Registry must not be null");
        Validate.notNull((Object)onFile, (String)"A Registry on file must not be null");
        try {
            this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
            this.mergeRegistryTrait(incoming.getRegistryTrait(), onFile.getRegistryTrait());
            if (isUI) {
                HashSet onFileDocs = new HashSet(onFile.getDocuments());
                for (PurpleHeartDocument doc : onFileDocs) {
                    if (incoming.getDocumentByEntityKey(doc.getEntityKey()) != null) continue;
                    onFile.removeDocument(doc);
                }
            }
            for (PurpleHeartDocument incomingDoc : incoming.getDocuments()) {
                EntityKey key = incomingDoc.getEntityKey();
                if (key == null) {
                    PurpleHeartDocument doc = new PurpleHeartDocument();
                    this.getCopyService().copy((AbstractEntity)incomingDoc, (AbstractEntity)doc);
                    onFile.addDocument(doc);
                    continue;
                }
                PurpleHeartDocument onFileDoc = onFile.getDocumentByEntityKey(key);
                this.getCopyService().copy((AbstractEntity)incomingDoc, (AbstractEntity)onFileDoc);
            }
        }
        catch (ServiceException ex) {
            this.logger.debug((Object)"Failed to merge an PurpleHeart registry", (Throwable)ex);
            throw new RuntimeException("Failed to merge an PurpleHeart registry", ex);
        }
        return onFile;
    }

    @Override
    public SHAD mergeRegistry(SHAD incoming, SHAD onFile, boolean isUI) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"A Registry must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"A Registry on file must not be null");
        try {
            this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
            this.mergeRegistryTrait(incoming.getRegistryTrait(), onFile.getRegistryTrait());
            if (isUI) {
                HashSet onFileDocs = new HashSet(onFile.getDocuments());
                for (SHADDocument doc : onFileDocs) {
                    if (incoming.getDocumentByEntityKey(doc.getEntityKey()) != null) continue;
                    onFile.removeDocument(doc);
                }
            }
            for (SHADDocument incomingDoc : incoming.getDocuments()) {
                EntityKey key = incomingDoc.getEntityKey();
                if (key == null) {
                    SHADDocument doc = new SHADDocument();
                    this.getCopyService().copy((AbstractEntity)incomingDoc, (AbstractEntity)doc);
                    onFile.addDocument(doc);
                    continue;
                }
                SHADDocument onFileDoc = onFile.getDocumentByEntityKey(key);
                this.getCopyService().copy((AbstractEntity)incomingDoc, (AbstractEntity)onFileDoc);
            }
        }
        catch (ServiceException ex) {
            this.logger.debug((Object)"Failed to merge an SHAD registry", (Throwable)ex);
            throw new RuntimeException("Failed to merge an SHAD registry", ex);
        }
        return onFile;
    }

    public Set mergeSsnSets(Set incoming, Set onFile) throws ServiceException {
        HashSet<AbstractEntity> mergedSet = new HashSet<AbstractEntity>();
        Validate.notNull((Object)incoming, (String)"A incoming set must not be null");
        Validate.notNull((Object)onFile, (String)"A onFile set must not be null");
        for (AbstractEntity incomingObj : incoming) {
            boolean matchFound = false;
            for (AbstractEntity onFileObj : onFile) {
                if (!this.getMatchRuleService().match(incomingObj, onFileObj)) continue;
                SSN onFileSsn = (SSN)onFileObj;
                if (onFileSsn.getSsaVerificationStatus() == null || !onFileSsn.getSsaVerificationStatus().getCode().equalsIgnoreCase(SSAVerificationStatus.NEW_RECORD.getCode())) {
                    SSAVerificationStatus status = onFileSsn.getSsaVerificationStatus();
                    Date date = onFileSsn.getSsaVerificationDate();
                    Date sentDate = onFileSsn.getSsaSentDate();
                    Date receivedDate = onFileSsn.getSsaReceivedDate();
                    SSAMessage message = onFileSsn.getSsaMessage();
                    this.getCopyService().copy(incomingObj, onFileObj);
                    onFileSsn.setSsaMessage(message);
                    onFileSsn.setSsaReceivedDate(receivedDate);
                    onFileSsn.setSsaSentDate(sentDate);
                    onFileSsn.setSsaVerificationDate(date);
                    onFileSsn.setSsaVerificationStatus(status);
                    mergedSet.add(onFileObj);
                } else {
                    this.getCopyService().copy(incomingObj, onFileObj);
                    mergedSet.add(onFileObj);
                }
                matchFound = true;
                break;
            }
            if (matchFound) continue;
            try {
                AbstractEntity onFileObj = (AbstractEntity)incomingObj.getClass().newInstance();
                this.getCopyService().copy(incomingObj, onFileObj);
                mergedSet.add(onFileObj);
            }
            catch (Exception e) {
                throw new CopyServiceException("Unable to create new insatnce for " + incomingObj.getClass().getName());
            }
        }
        return mergedSet;
    }

    @Override
    public Set mergeSets(Set incoming, Set onFile) throws ServiceException {
        return this.mergeSets(incoming, onFile, false);
    }

    @Override
    public Set mergeSets(Set incoming, Set onFile, boolean alwaysAddIncomingDuplicates) throws ServiceException {
        Validate.notNull((Object)incoming, (String)"The incoming set must not be null");
        Validate.notNull((Object)onFile, (String)"The onFile set must not be null");
        HashSet<AbstractEntity> mergedSet = new HashSet<AbstractEntity>();
        HashSet<AbstractEntity> alreadyProcessedIncomingItems = new HashSet<AbstractEntity>();
        for (AbstractEntity incomingObj : incoming) {
            AbstractEntity matchingObj;
            if (alwaysAddIncomingDuplicates) {
                AbstractEntity testDuplicate = this.getMatchingObjectInSet(incomingObj, alreadyProcessedIncomingItems);
                if (testDuplicate != null) {
                    this.createNewInstanceAndMerge(mergedSet, incomingObj);
                    continue;
                }
                alreadyProcessedIncomingItems.add(incomingObj);
            }
            if ((matchingObj = this.getMatchingObjectInSet(incomingObj, onFile)) != null) {
                this.getCopyService().copy(incomingObj, matchingObj);
                mergedSet.add(matchingObj);
                continue;
            }
            this.createNewInstanceAndMerge(mergedSet, incomingObj);
        }
        return mergedSet;
    }

    private void createNewInstanceAndMerge(Set mergedSet, AbstractEntity incomingObj) throws CopyServiceException {
        try {
            AbstractEntity onFileObj = (AbstractEntity)incomingObj.getClass().newInstance();
            this.getCopyService().copy(incomingObj, onFileObj);
            mergedSet.add(onFileObj);
        }
        catch (Exception e) {
            throw new CopyServiceException("Unable to create new instance of " + incomingObj.getClass().getName());
        }
    }

    private AbstractEntity getMatchingObjectInSet(AbstractEntity o, Set s) {
        MatchRuleService matchRuleService = this.getMatchRuleService();
        for (AbstractEntity setObj : s) {
            if (!matchRuleService.match(o, setObj)) continue;
            return setObj;
        }
        return null;
    }

    @Override
    public MatchRuleService getMatchRuleService() {
        return this.matchRuleService;
    }

    public void setMatchRuleService(MatchRuleService matchRuleService) {
        this.matchRuleService = matchRuleService;
    }

    public CopyService getCopyService() {
        return this.copyService;
    }

    public void setCopyService(CopyService copyService) {
        this.copyService = copyService;
    }

    public LookupService getLookupService() {
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    private void mergeSSN(Person incoming, Person onFile) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"An incoming person must not be null ");
        Validate.notNull((Object)((Object)onFile), (String)"An onFile person must not be null ");
        HashSet ssns = new HashSet(onFile.getSsns());
        Set mergedSsns = this.mergeSets(incoming.getSsns(), onFile.getSsns());
        Iterator iter = ssns.iterator();
        while (iter.hasNext()) {
            onFile.removeSsn((SSN)((Object)iter.next()));
        }
        iter = mergedSsns.iterator();
        while (iter.hasNext()) {
            onFile.addSsn((SSN)((Object)iter.next()));
        }
    }

    private void mergeAddress(Person incoming, Person onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"An incoming person must not be null ");
        Validate.notNull((Object)((Object)onFile), (String)"An onFile person must not be null ");
        Set addresses = incoming.getAddresses();
        if (addresses != null && addresses.size() > 0) {
            Set merged = this.mergeSets(addresses, onFile.getAddresses());
            onFile.removeAllAddresses();
            for (Address address : merged) {
                onFile.addAddress(address);
            }
        } else {
            onFile.removeAllAddresses();
        }
    }

    private void mergeAssociation(Person incoming, Person onFile) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"An incoming person must not be null ");
        Validate.notNull((Object)((Object)onFile), (String)"An onFile person must not be null ");
        Set associations = incoming.getAssociations();
        if (associations != null && associations.size() > 0) {
            Set merged = this.mergeSets(associations, onFile.getAssociations());
            onFile.removeAllAssociations();
            for (Association association : merged) {
                Association incomingAssociation = null;
                if (association.getEntityKey() != null) {
                    incomingAssociation = incoming.getAssociationByEntityKey(association.getEntityKey());
                }
                if (incomingAssociation == null) {
                    incomingAssociation = (Association)this.getMatchRuleService().findMatchingElement((AbstractEntity)association, incoming.getAssociations());
                }
                this.mergeAssociation(incomingAssociation, association);
                onFile.addAssociation(association);
            }
        } else {
            onFile.removeAllAssociations();
        }
    }

    private void mergeMilitaryService(Person incoming, Person onFile, boolean isUpdateFromGUI) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"An incoming person must not be null ");
        Validate.notNull((Object)((Object)onFile), (String)"An onFile person must not be null ");
        if (isUpdateFromGUI && incoming.getMilitaryService() != null) {
            MilitaryService militaryService = onFile.getMilitaryService();
            if (militaryService == null) {
                militaryService = new MilitaryService();
                onFile.setMilitaryService(militaryService);
            }
            this.getCopyService().copy((AbstractEntity)incoming.getMilitaryService(), (AbstractEntity)militaryService);
            Set combatEpisodes = incoming.getMilitaryService().getCombatEpisodes();
            Set currentCombatEpisodes = onFile.getMilitaryService().getCombatEpisodes();
            Set mergedCombatEpisodes = this.mergeSets(combatEpisodes, currentCombatEpisodes);
            onFile.getMilitaryService().removeAllCombatEpisodes();
            onFile.getMilitaryService().addAllCombatEpisodes(mergedCombatEpisodes);
            Set siteRecords = incoming.getMilitaryService().getMilitaryServiceSiteRecords();
            Set currentSiteRecords = onFile.getMilitaryService().getMilitaryServiceSiteRecords();
            Set merged = this.mergeSets(siteRecords, currentSiteRecords);
            onFile.getMilitaryService().removeAllMilitaryServiceSiteRecords();
            for (MilitaryServiceSiteRecord merge : merged) {
                MilitaryServiceSiteRecord incomingSite = incoming.getMilitaryService().getMilitaryServiceSiteRecordsBySite(merge.getSite());
                this.mergeMilitaryServiceSiteRecord(incomingSite, merge);
                onFile.getMilitaryService().addMilitaryServiceSiteRecord(merge);
            }
        }
    }

    private void mergeDeathRecord(Person incoming, Person onFile) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"An incoming person must not be null ");
        Validate.notNull((Object)((Object)onFile), (String)"An onFile person must not be null ");
        DeathRecord deathRecord = incoming.getDeathRecord();
        if (deathRecord == null) {
            onFile.setDeathRecord(null);
        } else {
            DeathRecord resultDeathRecord = onFile.getDeathRecord();
            if (resultDeathRecord == null) {
                resultDeathRecord = new DeathRecord();
                onFile.setDeathRecord(resultDeathRecord);
            }
            this.mergeDeathRecord(deathRecord, resultDeathRecord);
        }
    }

    private void mergeDemographic(Person incoming, Person onFile, boolean isUpdateFromGUI) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"An incoming person must not be null ");
        Validate.notNull((Object)((Object)onFile), (String)"An onFile person must not be null ");
        this.mergeDemographic(incoming, onFile);
        if (isUpdateFromGUI) {
            boolean compare = ObjectUtils.equals((Object)incoming.getSensitiveRecord(), (Object)onFile.getSensitiveRecord());
            if (!compare) {
                SensitivityChangeSource sensitivityChangeSource = this.getLookupService().getSensitivityChangeSourceByCode(SensitivityChangeSource.CODE_HEC.getName());
                onFile.setSensitivityChangeSource(sensitivityChangeSource);
                onFile.setSensitivityChangeDate(new Date());
                onFile.setSensitiveRecord(incoming.getSensitiveRecord());
                onFile.setSensitivityChangeSite(incoming.getSensitivityChangeSite());
            }
            onFile.setClaimFolderLocation(incoming.getClaimFolderLocation());
            onFile.setClaimFolderNumber(incoming.getClaimFolderNumber());
            onFile.setUserEnrolleeValidThrough(incoming.getUserEnrolleeValidThrough());
            onFile.setUserEnrolleeSite(incoming.getUserEnrolleeSite());
        } else {
            Integer existingYear = onFile.getUserEnrolleeValidThrough();
            Integer incomingYear = incoming.getUserEnrolleeValidThrough();
            if (existingYear != null && incomingYear != null && incomingYear.compareTo(existingYear) > 0 || existingYear == null) {
                onFile.setUserEnrolleeValidThrough(incoming.getUserEnrolleeValidThrough());
                onFile.setUserEnrolleeSite(incoming.getUserEnrolleeSite());
            }
        }
        this.mergePreferredFacilities(incoming, onFile);
        onFile.setMostRecentPreferredFacility(incoming.getMostRecentPreferredFacility());
    }

    private void mergeMedicaidFactor(Person incoming, Person onFile) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"An incoming person must not be null ");
        Validate.notNull((Object)((Object)onFile), (String)"An onFile person must not be null ");
        if (incoming.getMedicaidFactor() != null) {
            MedicaidFactor medicaidFactor = onFile.getMedicaidFactor();
            if (medicaidFactor == null) {
                medicaidFactor = new MedicaidFactor();
                onFile.setMedicaidFactor(medicaidFactor);
            }
            this.mergeMedicaidFactor(incoming.getMedicaidFactor(), medicaidFactor);
        } else {
            onFile.setMedicaidFactor(null);
        }
    }

    private void mergePurpleHeart(Person incoming, Person onFile) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"An incoming person must not be null ");
        Validate.notNull((Object)((Object)onFile), (String)"An onFile person must not be null ");
        if (incoming.getPurpleHeart() != null) {
            PurpleHeart ph = onFile.getPurpleHeart();
            if (ph == null) {
                ph = new PurpleHeart();
                onFile.addDecoration(ph);
            }
            this.mergePurpleHeart(incoming.getPurpleHeart(), ph);
        } else {
            onFile.removeAllDecorations();
        }
    }

    private void mergeCatastrophicDisability(Person incoming, Person onFile) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"An incoming person must not be null ");
        Validate.notNull((Object)((Object)onFile), (String)"An onFile person must not be null ");
        CatastrophicDisability inCD = incoming.getCatastrophicDisability();
        CatastrophicDisability onFileCD = onFile.getCatastrophicDisability();
        if (inCD != null) {
            if (onFileCD == null) {
                onFileCD = new CatastrophicDisability();
                onFile.addClinicalDetermination(onFileCD);
            }
            this.mergeCatastrophicDisability(inCD, onFileCD);
        } else {
            onFile.removeClinicalDeterminationByType(CatastrophicDisability.class);
        }
    }

    private void mergeFeeBasis(Person incoming, Person onFile) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"An incoming person must not be null ");
        Validate.notNull((Object)((Object)onFile), (String)"An onFile person must not be null ");
        Set merged = this.mergeSets(incoming.getFeeBasis(), onFile.getFeeBasis());
        onFile.removeAllFeeBasis();
        for (FeeBasis feeBasis : merged) {
            onFile.addFeeBasis(feeBasis);
        }
    }

    @Override
    public void mergeReceivedEligibility(Person incoming, Person onFile) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"An incoming person must not be null ");
        Validate.notNull((Object)((Object)onFile), (String)"An onFile person must not be null ");
        ReceivedEligibility inPrimary = incoming.getReceivedPrimaryEligibility();
        ReceivedEligibility currPrimary = onFile.getReceivedPrimaryEligibility();
        if (inPrimary != null && this.isValidReceivedCode(inPrimary)) {
            if (currPrimary == null) {
                currPrimary = new ReceivedEligibility();
                onFile.setReceivedPrimaryEligiblity(currPrimary);
            }
            this.mergeReceivedEligibility(inPrimary, currPrimary);
        } else {
            onFile.setReceivedPrimaryEligiblity(null);
        }
        Set validReceivedSecondaries = this.getValidReceivedEligibilities(incoming.getReceivedSecondaryEligibilities());
        Set merged = this.mergeSets(validReceivedSecondaries, onFile.getReceivedSecondaryEligibilities());
        onFile.removeAllReceivedSecondaryEligibilities();
        for (ReceivedEligibility merge : merged) {
            onFile.addReceivedSecondaryEligibility(merge);
        }
    }

    private Set getValidReceivedEligibilities(Set received) {
        HashSet<ReceivedEligibility> valids = new HashSet<ReceivedEligibility>();
        if (received == null || received.size() == 0) {
            return valids;
        }
        for (ReceivedEligibility receivedEligibility : received) {
            if (!this.isValidReceivedCode(receivedEligibility)) continue;
            valids.add(receivedEligibility);
        }
        return valids;
    }

    private boolean isValidReceivedCode(ReceivedEligibility re) {
        return re == null || !(re.getType().getCode().equals(EligibilityType.ALLIED_VETERAN.getName()) ? re.getAlliedCountry() == null : re.getType().getCode().equals(EligibilityType.OTHER_FEDERAL_AGENCY.getName()) && re.getOtherFederalAgency() == null);
    }

    private void mergePhone(Person incoming, Person onFile) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"An incoming person must not be null ");
        Validate.notNull((Object)((Object)onFile), (String)"An onFile person must not be null ");
        Set merged = this.mergeSets(incoming.getPhones(), onFile.getPhones());
        onFile.removeAllPhones();
        for (Phone merge : merged) {
            onFile.addPhone(merge);
        }
    }

    private void mergeEmail(Person incoming, Person onFile) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"An incoming person must not be null ");
        Validate.notNull((Object)((Object)onFile), (String)"An onFile person must not be null ");
        Set merged = this.mergeSets(incoming.getEmails(), onFile.getEmails());
        onFile.removeAllEmails();
        for (Email merge : merged) {
            onFile.addEmail(merge);
        }
    }

    private void mergeInsurancePolicy(Person incoming, Person onFile) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"An incoming person must not be null ");
        Validate.notNull((Object)((Object)onFile), (String)"An onFile person must not be null ");
        Set insurances = incoming.getInsurances();
        if (insurances != null && !insurances.isEmpty()) {
            HashSet<InsurancePolicy> updated = new HashSet<InsurancePolicy>();
            for (InsurancePolicy policy : insurances) {
                InsurancePolicy update = this.mergeInsurancePolicy(policy, onFile);
                updated.add(update);
            }
            onFile.removeAllInsurances();
            onFile.addAllInsurances(updated);
        } else {
            onFile.removeAllInsurances();
        }
    }

    private void mergeSignatureImage(Person incoming, Person onFile) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"An incoming person must not be null ");
        Validate.notNull((Object)((Object)onFile), (String)"An onFile person must not be null ");
        Set merged = this.mergeSets(incoming.getSignatureImages(), onFile.getSignatureImages());
        onFile.removeAllSignatureImages();
        for (SignatureImage merge : merged) {
            onFile.addSignatureImage(merge);
        }
    }

    private void mergeEnrollmentOverride(Person incoming, Person onFile) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"An incoming person must not be null ");
        Validate.notNull((Object)((Object)onFile), (String)"An onFile person must not be null ");
        EnrollmentOverride incomingOverride = incoming.getEnrollmentOverride();
        if (incomingOverride != null) {
            EnrollmentOverride curr = onFile.getEnrollmentOverride();
            if (curr == null) {
                curr = new EnrollmentOverride();
                onFile.setEnrollmentOverride(curr);
            }
            this.mergeEnrollmentOverride(incomingOverride, curr);
        } else {
            onFile.setEnrollmentOverride(null);
        }
    }

    private void mergeMilitarySexualTrauma(Person incoming, Person onFile) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"An incoming person must not be null ");
        Validate.notNull((Object)((Object)onFile), (String)"An onFile person must not be null ");
        MilitarySexualTrauma inMST = incoming.getMilitarySexualTrauma();
        MilitarySexualTrauma onFileMST = onFile.getMilitarySexualTrauma();
        if (inMST != null) {
            if (onFileMST == null) {
                onFileMST = new MilitarySexualTrauma();
                onFile.addClinicalDetermination(onFileMST);
            }
            this.mergeMilitarySexualTrauma(inMST, onFileMST);
        } else {
            onFile.removeClinicalDeterminationByType(MilitarySexualTrauma.class);
        }
    }

    private void mergeNoseThroatRadium(Person incoming, Person onFile) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"An incoming person must not be null ");
        Validate.notNull((Object)((Object)onFile), (String)"An onFile person must not be null ");
        NoseThroatRadium inNTR = incoming.getNoseThroatRadium();
        NoseThroatRadium onFileNTR = onFile.getNoseThroatRadium();
        if (inNTR != null) {
            if (onFileNTR == null) {
                onFileNTR = new NoseThroatRadium();
                onFile.addClinicalDetermination(onFileNTR);
            }
            this.mergeNoseThroatRadium(inNTR, onFileNTR);
        } else {
            onFile.removeClinicalDeterminationByType(NoseThroatRadium.class);
        }
    }

    private void mergePatientVisitSummary(Person incoming, Person onFile) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"An incoming person must not be null ");
        Validate.notNull((Object)((Object)onFile), (String)"An onFile person must not be null ");
        Map incomingSummaries = incoming.getPatientVisitSummaries();
        Map onFileSummaries = onFile.getPatientVisitSummaries();
        HashMap toRemove = new HashMap(onFileSummaries);
        if (incomingSummaries.size() > 0) {
            Map merged = this.mergeMaps(incomingSummaries, onFileSummaries);
            for (SiteYear key : toRemove.keySet()) {
                onFile.removePatientVisitSummary(key.getFacility());
            }
            for (SiteYear key : merged.keySet()) {
                PatientVisitSummary summary = (PatientVisitSummary)((Object)merged.get((Object)key));
                onFile.setPatientVisitSummary(key.getYear(), key.getFacility(), summary);
            }
        } else {
            for (SiteYear key : toRemove.keySet()) {
                onFile.removePatientVisitSummary(key.getFacility());
            }
        }
    }

    private void mergeFinancialData(Person incoming, Person onFile) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"An incoming person must not be null ");
        Validate.notNull((Object)((Object)onFile), (String)"An onFile person must not be null ");
        Map statements = incoming.getFinancialStatements();
        if (statements.size() > 0) {
            Map onFileStatements = onFile.getFinancialStatements();
            Map merged = this.mergeMaps(statements, onFileStatements);
            for (Integer key : merged.keySet()) {
                FinancialStatement incomingStatement = incoming.getFinancialStatement(key);
                FinancialStatement mergedStatement = (FinancialStatement)((Object)merged.get(key));
                this.mergeFinancialStatement(incomingStatement, mergedStatement);
            }
            onFile.removeAllFinancialStatements();
            for (Integer key : merged.keySet()) {
                onFile.setFinancialStatement(key, (FinancialStatement)((Object)merged.get(key)));
            }
        } else {
            onFile.removeAllFinancialStatements();
        }
        Map tests = incoming.getIncomeTests();
        if (tests.size() > 0) {
            Map onfileTests = onFile.getIncomeTests();
            Map merged = this.mergeMaps(tests, onfileTests);
            for (Integer key : merged.keySet()) {
                IncomeTest incomingTest = incoming.getIncomeTest(key);
                IncomeTest mergedTest = (IncomeTest)((Object)merged.get(key));
                this.mergeFullIncomeTest(incomingTest, mergedTest);
            }
            onFile.removeAllIncomeTests();
            for (Integer key : merged.keySet()) {
                onFile.setIncomeTest(key, (IncomeTest)((Object)merged.get(key)));
            }
        } else {
            onFile.removeAllIncomeTests();
        }
    }

    @Override
    public void mergeReportSetup(ReportSetup incoming, ReportSetup onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"An incoming ReportSetup must not be null ");
        Validate.notNull((Object)((Object)onFile), (String)"An onFile ReportSetup must not be null ");
        this.copyService.copy((AbstractEntity)incoming, (AbstractEntity)onFile);
        ReportParameterSet inParam = incoming.getParameterSet();
        ReportParameterSet onParam = onFile.getParameterSet();
        if (inParam != null) {
            if (onParam == null) {
                onParam = new ReportParameterSet();
            }
            onFile.setParameterSet(onParam);
            this.mergeReportParameterSet(inParam, onParam);
        } else {
            onFile.setParameterSet(null);
        }
        onFile.setParameterSet(onParam);
        ReportSchedule inSchedule = incoming.getSchedule();
        ReportSchedule onSchedule = onFile.getSchedule();
        if (inSchedule != null) {
            if (onSchedule == null) {
                onSchedule = new ReportSchedule();
            }
            onFile.setSchedule(onSchedule);
            this.mergeReportSchedule(inSchedule, onSchedule);
        } else {
            onFile.setSchedule(null);
        }
    }

    @Override
    public void mergeReportParameterSet(ReportParameterSet incoming, ReportParameterSet onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"An incoming ReportParameterSet must not be null ");
        Validate.notNull((Object)((Object)onFile), (String)"An onFile ReportParameterSet must not be null ");
        this.copyService.copy((AbstractEntity)incoming, (AbstractEntity)onFile);
        Set mergedUsers = this.mergeSets(incoming.getUsers(), onFile.getUsers());
        onFile.removeAllUsers();
        onFile.addAllUsers(mergedUsers);
        Set mergedMsgTypes = this.mergeSets(incoming.getMessageTypes(), onFile.getMessageTypes());
        onFile.removeAllMessageTypes();
        onFile.addAllMessageTypes(mergedMsgTypes);
        Set mergedBadAddrResons = this.mergeSets(incoming.getBadAddressReasons(), onFile.getBadAddressReasons());
        onFile.removeAllBadAddressReasons();
        onFile.addAllBadAddressReasons(mergedBadAddrResons);
        Set mergedCancelDeclineReasons = this.mergeSets(incoming.getCancelDeclineReasons(), onFile.getCancelDeclineReasons());
        onFile.removeAllCancelDeclineReasons();
        onFile.addAllCancelDeclineReasons(mergedCancelDeclineReasons);
        Set mergedPHRejectionRemarks = this.mergeSets(incoming.getPHRejectionRemarks(), onFile.getPHRejectionRemarks());
        onFile.removeAllPHRejectionRemarks();
        onFile.addAllPHRejectionRemarks(mergedPHRejectionRemarks);
        Set mergedReportEnrollmentPriorityGroups = this.mergeSets(incoming.getReportEnrollmentPriorityGroups(), onFile.getReportEnrollmentPriorityGroups());
        onFile.removeAllReportEnrollmentPriorityGroups();
        onFile.addAllReportEnrollmentPriorityGroups(mergedReportEnrollmentPriorityGroups);
        Set mergedEnrollmentCategories = this.mergeSets(incoming.getEnrollmentCategories(), onFile.getEnrollmentCategories());
        onFile.removeAllEnrollmentCategories();
        onFile.addAllEnrollmentCategories(mergedEnrollmentCategories);
        Set mergedEnrollmentStatusComponents = this.mergeSets(incoming.getEnrollmentStatusComponents(), onFile.getEnrollmentStatusComponents());
        onFile.removeAllEnrollmentStatusComponents();
        onFile.addAllEnrollmentStatusComponents(mergedEnrollmentStatusComponents);
        Set mergedPersonMergeStatuses = this.mergeSets(incoming.getPersonMergeStatuses(), onFile.getPersonMergeStatuses());
        onFile.removeAllPersonMergeStatuses();
        onFile.addAllPersonMergeStatuses(mergedPersonMergeStatuses);
        Set mergedEligibilityFactors = this.mergeSets(incoming.getEligibilityFactors(), onFile.getEligibilityFactors());
        onFile.removeAllEligibilityFactors();
        onFile.addAllEligibilityFactors(mergedEligibilityFactors);
        Set mergedEnrollmentStatuses = this.mergeSets(incoming.getEnrollmentStatuses(), onFile.getEnrollmentStatuses());
        onFile.removeAllEnrollmentStatuses();
        onFile.addAllEnrollmentStatuses(mergedEnrollmentStatuses);
        Set mergedEnrollmentOverrideReasons = this.mergeSets(incoming.getEnrollmentOverrideReasons(), onFile.getEnrollmentOverrideReasons());
        onFile.removeAllEnrollmentOverrideReasons();
        onFile.addAllEnrollmentOverrideReasons(mergedEnrollmentOverrideReasons);
        Set mergedQueryToSites = this.mergeSets(incoming.getQueryToSites(), onFile.getQueryToSites());
        onFile.removeAllQueryToSites();
        onFile.addAllQueryToSites(mergedQueryToSites);
        Set mergedVBAQueryStatuses = this.mergeSets(incoming.getVBAQueryStatuses(), onFile.getVBAQueryStatuses());
        onFile.removeAllVBAQueryStatuses();
        onFile.addAllVBAQueryStatuses(mergedVBAQueryStatuses);
        Set mergedReportEEDWeeklyReportTypes = this.mergeSets(incoming.getReportEEDWeeklyReportTypes(), onFile.getReportEEDWeeklyReportTypes());
        onFile.removeAllReportEEDWeeklyReportTypes();
        onFile.addAllReportEEDWeeklyReportTypes(mergedReportEEDWeeklyReportTypes);
        Set mergedFacilities = this.mergeSets(incoming.getFacilities(), onFile.getFacilities());
        onFile.removeAllFacilities();
        onFile.addAllFacilities(mergedFacilities);
        Set mergedFunctionalGroups = this.mergeSets(incoming.getFunctionalGroups(), onFile.getFunctionalGroups());
        onFile.removeAllFunctionalGroups();
        onFile.addAllFunctionalGroups(mergedFunctionalGroups);
        Set mergedWkfCaseStatusTypes = this.mergeSets(incoming.getWkfCaseStatusTypes(), onFile.getWkfCaseStatusTypes());
        onFile.removeAllWkfCaseStatusTypes();
        onFile.addAllWkfCaseStatusTypes(mergedWkfCaseStatusTypes);
        Set mergedWkfCaseTypes = this.mergeSets(incoming.getWkfCaseTypes(), onFile.getWkfCaseTypes());
        onFile.removeAllWkfCaseTypes();
        onFile.addAllWkfCaseTypes(mergedWkfCaseTypes);
        Set mergedMessageErrors = this.mergeSets(incoming.getMessageErrors(), onFile.getMessageErrors());
        onFile.removeAllMessageErrors();
        onFile.addAllMessageErrors(mergedMessageErrors);
        Set mergedRegistryTypes = this.mergeSets(incoming.getRegistryTypes(), onFile.getRegistryTypes());
        onFile.removeAllRegistryTypes();
        onFile.addAllRegistryTypes(mergedRegistryTypes);
        Set mergedLetterFiles = this.mergeSets(incoming.getReportLinkLetterFiles(), onFile.getReportLinkLetterFiles());
        onFile.removeAllReportLinkLetterFiles();
        onFile.addAllReportLinkLetterFiles(mergedLetterFiles);
        Set mergedLetterRejectreasons = this.mergeSets(incoming.getLetterRejectReasons(), onFile.getLetterRejectReasons());
        onFile.removeAllLetterRejectReasons();
        onFile.addAllLetterRejectReasons(mergedLetterRejectreasons);
        Set mergedLetterErrorTypes = this.mergeSets(incoming.getLetterErrorTypes(), onFile.getLetterErrorTypes());
        onFile.removeAllLetterErrorTypes();
        onFile.addAllLetterErrorTypes(mergedLetterErrorTypes);
    }

    @Override
    public void mergeReportSchedule(ReportSchedule incoming, ReportSchedule onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"An incoming ReportSchedule must not be null ");
        Validate.notNull((Object)((Object)onFile), (String)"An onFile ReportSchedule must not be null ");
        this.copyService.copy((AbstractEntity)incoming, (AbstractEntity)onFile);
        Set mergedDaysOfWeek = this.mergeSets(incoming.getDaysOfWeek(), onFile.getDaysOfWeek());
        onFile.removeAllDaysOfWeek();
        onFile.addAllDaysOfWeek(mergedDaysOfWeek);
    }

    @Override
    public Person mergeIdentityTraits(Person incoming, Person onFile) throws ServiceException {
        return this.mergeIdentityTraits(incoming, onFile, false);
    }

    public Person mergeIdentityTraits(Person incoming, Person onFile, boolean isPersonMerge) throws ServiceException {
        Name incomingLegalName;
        Validate.notNull((Object)((Object)incoming), (String)"An incoming person must not be null ");
        Validate.notNull((Object)((Object)onFile), (String)"An onFile person must not be null ");
        if (!isPersonMerge) {
            this.mergeSSN(incoming, onFile);
        }
        if ((incomingLegalName = incoming.getLegalName()) != null) {
            Name onFileLegalName = onFile.getLegalName();
            if (onFileLegalName == null) {
                onFileLegalName = new Name();
                onFile.setLegalName(onFileLegalName);
            }
            this.getCopyService().copy((AbstractEntity)incomingLegalName, (AbstractEntity)onFileLegalName);
        } else {
            onFile.setLegalName(null);
        }
        onFile.setGender(incoming.getGender());
        onFile.setMothersMaidenName(incoming.getMothersMaidenName());
        BirthRecord incomingBirthRecord = incoming.getBirthRecord();
        if (incomingBirthRecord != null) {
            BirthRecord onFileBirthRecord = onFile.getBirthRecord();
            if (onFileBirthRecord == null) {
                onFileBirthRecord = new BirthRecord();
                onFile.setBirthRecord(onFileBirthRecord);
            }
            this.getCopyService().copy((AbstractEntity)incomingBirthRecord, (AbstractEntity)onFileBirthRecord);
        } else {
            onFile.setBirthRecord(null);
        }
        return onFile;
    }

    @Override
    public void mergeUserAccount(ESRUserPrincipalImpl incoming, ESRUserPrincipalImpl onFile) throws ServiceException {
        Validate.notNull((Object)incoming, (String)"An incoming user must not be null ");
        Validate.notNull((Object)onFile, (String)"An onFile user must not be null ");
        this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
    }

    @Override
    public void mergeUserProfile(ESRUserPrincipalImpl incoming, ESRUserPrincipalImpl onFile) throws ServiceException {
        Validate.notNull((Object)incoming, (String)"An incoming user must not be null ");
        Validate.notNull((Object)onFile, (String)"An onFile user must not be null ");
    }

    @Override
    public Employment mergeEmployment(Employment incoming, Employment onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"An incoming  employment not be null");
        Validate.notNull((Object)((Object)onFile), (String)"An incoming on file employment must not be null");
        this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
        this.mergeEmploymentAddress(incoming.getEmployerAddress(), onFile);
        return onFile;
    }

    public Employment mergeEmploymentAddress(Address incoming, Employment onFile) throws ServiceException {
        if (incoming == null) {
            onFile.setEmployerAddress(null);
        } else {
            Address currentAddress = onFile.getEmployerAddress();
            if (currentAddress == null) {
                currentAddress = new Address();
                this.mergeAddress(incoming, currentAddress);
                onFile.setEmployerAddress(currentAddress);
            } else {
                this.mergeAddress(incoming, currentAddress);
            }
        }
        return onFile;
    }

    @Override
    public MedalOfHonor mergeMedalOfHonor(MedalOfHonor incoming, MedalOfHonor result) throws ServiceException {
        Validate.notNull((Object)incoming, (String)"A incoming Medal Of Honor must not be null");
        Validate.notNull((Object)result, (String)"A Medal Of Honor on file must not be null");
        this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)result);
        return result;
    }

    @Override
    public void mergeSeedingMilitaryServiceEpisode(MilitaryServiceEpisode incomingEpisode, MilitaryServiceEpisode overlappedEpisode, MilitaryServiceSiteRecord onFile) {
        Validate.notNull((Object)((Object)incomingEpisode), (String)"A MilitaryServiceEpisode must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"A MilitaryServiceSiteRecord on file must not be null");
        try {
            if (overlappedEpisode == null) {
                MilitaryServiceEpisode mse = new MilitaryServiceEpisode();
                this.mergeMilitaryServiceEpisode(incomingEpisode, mse);
                onFile.addMilitaryServiceEpisode(mse);
            } else {
                this.mergeMilitaryServiceEpisode(incomingEpisode, overlappedEpisode);
            }
        }
        catch (ServiceException ex) {
            this.logger.debug((Object)"Failed to merge an MilitaryServiceEpisode", (Throwable)ex);
            throw new RuntimeException("Failed to merge an MilitaryServiceEpisode", ex);
        }
    }

    @Override
    public Set mergeRatedDisabilities(Set incomingDisabilities, Set onFileDisabilities) throws ServiceException {
        return this.mergeSets(incomingDisabilities, onFileDisabilities, true);
    }

    @Override
    public Set mergeRatedDisabilitiesFromHL7(Set incomingDisabilities, Set onFileDisabilities) throws ServiceException {
        Validate.notNull((Object)incomingDisabilities, (String)"incomingDisabilities must not be null");
        Validate.notNull((Object)onFileDisabilities, (String)"onFileDisabilities must not be null");
        HashSet onFileRDs = new HashSet(onFileDisabilities);
        HashSet incoming = new HashSet(incomingDisabilities);
        HashSet<RatedDisability> done = new HashSet<RatedDisability>();
        HashSet<RatedDisability> addRds = new HashSet<RatedDisability>();
        try {
            ImpreciseDate holdRatingDate;
            ImpreciseDate holdOrigEffDt;
            RatedDisability found;
            for (RatedDisability incomingRD : incoming) {
                found = null;
                found = this.findExactMatchingRatedDisabilityFromHL7(incomingRD, onFileRDs);
                if (found == null) continue;
                onFileRDs.remove((Object)found);
                holdOrigEffDt = found.getOriginalEffectiveRatingDate();
                holdRatingDate = found.getRatingDate();
                this.mergeRatedDisability(incomingRD, found);
                if (holdOrigEffDt != null && found.getOriginalEffectiveRatingDate() == null) {
                    found.setOriginalEffectiveRatingDate(holdOrigEffDt);
                }
                if (holdRatingDate != null && found.getRatingDate() == null) {
                    found.setRatingDate(holdRatingDate);
                }
                addRds.add(found);
                done.add(incomingRD);
            }
            incoming.removeAll(done);
            for (RatedDisability incomingRD : incoming) {
                found = null;
                found = (RatedDisability)this.getMatchRuleService().findMatchingElement((AbstractEntity)incomingRD, onFileRDs);
                if (found != null) {
                    onFileRDs.remove((Object)found);
                    holdOrigEffDt = found.getOriginalEffectiveRatingDate();
                    holdRatingDate = found.getRatingDate();
                    this.mergeRatedDisability(incomingRD, found);
                    if (holdOrigEffDt != null && found.getOriginalEffectiveRatingDate() == null) {
                        found.setOriginalEffectiveRatingDate(holdOrigEffDt);
                    }
                    if (holdRatingDate != null && found.getRatingDate() == null) {
                        found.setRatingDate(holdRatingDate);
                    }
                    addRds.add(found);
                }
                if (found != null) continue;
                RatedDisability newRd = new RatedDisability();
                this.mergeRatedDisability(incomingRD, newRd);
                addRds.add(newRd);
            }
        }
        catch (ServiceException ex) {
            this.logger.debug((Object)"Failed to merge a ServiceConnectionAward", (Throwable)ex);
            throw new RuntimeException("Failed to merge a ServiceConnectionAward", ex);
        }
        return addRds;
    }

    private RatedDisability findExactMatchingRatedDisabilityFromHL7(RatedDisability incoming, Set disabilities) {
        Validate.notNull((Object)((Object)incoming), (String)"incoming rated disability must not be null");
        Validate.notNull((Object)disabilities, (String)"incoming disabilities must not be null");
        for (RatedDisability rd : disabilities) {
            if (!ObjectUtils.equals((Object)((Object)incoming.getDisability()), (Object)((Object)rd.getDisability())) || !ObjectUtils.equals((Object)((Object)incoming.getDiagnosticExtremity()), (Object)((Object)rd.getDiagnosticExtremity())) || !ObjectUtils.equals((Object)incoming.getOriginalEffectiveRatingDate(), (Object)rd.getOriginalEffectiveRatingDate()) || !ObjectUtils.equals((Object)incoming.getRatingDate(), (Object)rd.getRatingDate()) || !ObjectUtils.equals((Object)incoming.isServiceConnected(), (Object)rd.isServiceConnected()) || !ObjectUtils.equals((Object)incoming.getPercentage(), (Object)rd.getPercentage())) continue;
            return rd;
        }
        return null;
    }

    @Override
    public void mergeIncomingMSEToHEC(MilitaryServiceSiteRecord incoming, MilitaryServiceSiteRecord onFile) {
        Validate.notNull((Object)((Object)onFile), (String)"A MilitaryServiceSiteRecord on file must not be null");
        try {
            this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
            for (MilitaryServiceEpisode incomingEpisode : incoming.getMilitaryServiceEpisodes()) {
                MilitaryServiceEpisode mse = new MilitaryServiceEpisode();
                this.mergeMilitaryServiceEpisode(incomingEpisode, mse);
                onFile.addMilitaryServiceEpisode(mse);
            }
        }
        catch (ServiceException ex) {
            this.logger.debug((Object)"Failed to merge an MilitaryServiceEpisode", (Throwable)ex);
            throw new RuntimeException("Failed to merge an MilitaryServiceEpisode", ex);
        }
    }

    @Override
    public void mergeHealthCareProvider(HealthCareProvider incoming, HealthCareProvider onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"An incoming HealthCareProvider must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"An incoming on file HealthCareProvider must not be null");
        Name incomingName = incoming.getName();
        Name onFileName = onFile.getName();
        if (incomingName == null) {
            onFile.setName(null);
        } else if (onFileName != null) {
            this.getCopyService().copy((AbstractEntity)incomingName, (AbstractEntity)onFileName);
        } else {
            Name newName = new Name();
            this.getCopyService().copy((AbstractEntity)incomingName, (AbstractEntity)newName);
            onFileName = new Name();
            onFile.setName(newName);
        }
        this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
    }

    @Override
    public void mergeProviderAssignment(PatientProviderAssignmentLite incoming, PatientProviderAssignmentLite onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"An incoming PatientProviderAssignmentLite must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"An incoming on file PatientProviderAssignmentLite must not be null");
        this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
        onFile.setProvider(incoming.getProvider());
    }

    private void mergePreferredFacilities(Person incoming, Person onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"An incoming person must not be null ");
        Validate.notNull((Object)((Object)onFile), (String)"An onFile person must not be null ");
        Set pfs = incoming.getPreferredFacilities();
        if (pfs != null && pfs.size() > 0) {
            Set merged = this.mergeSets(pfs, onFile.getPreferredFacilities());
            onFile.removeAllPreferredFacilities();
            for (PreferredFacility pf : merged) {
                onFile.addPreferredFacility(pf);
            }
        } else if (onFile.getPreferredFacilities() != null && onFile.getPreferredFacilities().size() > 0) {
            onFile.removeAllPreferredFacilities();
        }
        onFile.setMostRecentPreferredFacility(incoming.getMostRecentPreferredFacility());
    }

    @Override
    public void mergeCampLejeuneVerification(CampLejeuneVerification incoming, CampLejeuneVerification onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"An incoming CampLejeuneVerification must not be null ");
        Validate.notNull((Object)((Object)onFile), (String)"An onFile CampLejeuneVerification must not be null ");
        if (incoming.getSpecialFactorIndicator() != null) {
            onFile.setSpecialFactorIndicator(incoming.getSpecialFactorIndicator());
        } else {
            onFile.setSpecialFactorIndicator(null);
        }
        onFile.setChangeDate(incoming.getChangeDate());
        onFile.setChangeSite(incoming.getChangeSite());
        onFile.setChangeSource(incoming.getChangeSource());
        onFile.setRegistrationDate(incoming.getRegistrationDate());
        Set<CampLejeuneVerificationMethod> incomingCLVM = incoming.getCampLejeuneVerificationMethods();
        if (incomingCLVM != null && incomingCLVM.size() > 0) {
            if (!StringUtils.equals((String)incoming.getComments(), (String)onFile.getComments())) {
                onFile.setComments(incoming.getComments());
            }
            HashSet<CampLejeuneVerificationType> removeList = new HashSet<CampLejeuneVerificationType>();
            for (CampLejeuneVerificationMethod ofcm : onFile.getCampLejeuneVerificationMethods()) {
                if (incoming.getCampLejeuneMethodByType(ofcm.getVerificationType().getCode()) != null) continue;
                removeList.add(ofcm.getVerificationType());
            }
            for (CampLejeuneVerificationType tobeRemoved : removeList) {
                onFile.removeCampLejeuneVerificationMethodByType(tobeRemoved);
            }
            HashSet<CampLejeuneVerificationType> addList = new HashSet<CampLejeuneVerificationType>();
            for (CampLejeuneVerificationMethod clvm : incomingCLVM) {
                if (onFile.getCampLejeuneMethodByType(clvm.getVerificationType().getCode()) != null) continue;
                addList.add(clvm.getVerificationType());
            }
            for (CampLejeuneVerificationType tobeAdded : addList) {
                CampLejeuneVerificationMethod newCLVM = new CampLejeuneVerificationMethod();
                newCLVM.setVerificationType(tobeAdded);
                onFile.addCampLejeuneVerificationMethod(newCLVM);
            }
        }
    }

    @Override
    public void mergeCLVerificationMethod(CampLejeuneVerificationMethod incoming, CampLejeuneVerificationMethod onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"An incoming CampLejeuneVerificationMethod must not be null");
        Validate.notNull((Object)((Object)onFile), (String)"An on file CampLejeuneVerificationMethod must not be null");
        this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
    }

    @Override
    public void mergeHealthBenefitProfile(HealthBenefitProfile incoming, HealthBenefitProfile onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"An incoming HealthBenefitProfile must not be null ");
        Validate.notNull((Object)((Object)onFile), (String)"An onFile HealthBenefitProfile must not be null ");
        Set incominghealthBenefitPlans = incoming.getHealthBenefitPlans();
        Set onFileHealthBenefitPlans = onFile.getHealthBenefitPlans();
        if (incominghealthBenefitPlans != null && incominghealthBenefitPlans.size() > 0) {
            for (HealthBenefitPlan incomingHBP : incominghealthBenefitPlans) {
                HealthBenefitPlan newHbp = new HealthBenefitPlan();
                boolean matched = false;
                HealthBenefitPlan onFileHBP2 = null;
                for (HealthBenefitPlan onFileHBP2 : onFileHealthBenefitPlans) {
                    if (!incomingHBP.getPlanType().getCode().equals(onFileHBP2.getPlanType().getCode())) continue;
                    matched = true;
                    this.mergeHealthBenefitPlan(incomingHBP, onFileHBP2);
                    break;
                }
                if (matched) continue;
                this.getCopyService().copy((AbstractEntity)incomingHBP, (AbstractEntity)newHbp);
                onFile.addHealthBenefitPlan(newHbp);
            }
            HashSet onFileHBPs = new HashSet(onFile.getHealthBenefitPlans());
            for (HealthBenefitPlan hbp : onFileHBPs) {
                if (incoming.getHealthBenefitPlanByType(hbp.getPlanType()) != null) continue;
                onFile.removeHealthBenefitPlan(hbp);
            }
        }
    }

    public HealthBenefitPlan mergeHealthBenefitPlan(HealthBenefitPlan incoming, HealthBenefitPlan onFile) throws ServiceException {
        Validate.notNull((Object)incoming, (String)"An incoming plan must not be null");
        Validate.notNull((Object)onFile, (String)"An on file plan must not be null");
        this.getCopyService().copy((AbstractEntity)incoming, (AbstractEntity)onFile);
        return onFile;
    }

    private AbstractEntity matchDomainConceptInSet(AbstractEntity o, Set s) {
        for (AbstractEntity setObj : s) {
            boolean matches = AbstractEntity.matchesDomainConcept((AbstractEntity)o, (AbstractEntity)setObj);
            if (!matches) continue;
            return setObj;
        }
        return null;
    }
}

