/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.rule.service.impl;

import gov.va.med.esr.common.model.ee.IncomingMessageInfo;
import gov.va.med.esr.common.model.ee.VerificationInfo;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.person.Employment;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.rule.data.EventInputData;
import gov.va.med.esr.common.rule.service.EventRuleService;
import gov.va.med.esr.common.rule.service.impl.AbstractRuleValidationServiceAwareImpl;
import gov.va.med.esr.service.PersonHelperService;
import gov.va.med.fw.rule.RuleDataAware;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.StringUtils;
import gov.va.med.fw.validation.ValidationMessage;
import gov.va.med.fw.validation.ValidationMessages;
import gov.va.med.fw.validation.ValidationServiceException;
import org.apache.commons.lang.Validate;

public class EventRuleServiceImpl
extends AbstractRuleValidationServiceAwareImpl
implements EventRuleService {
    private static final long serialVersionUID = -6645463158040971084L;
    private static final String QRYZ11 = "QRYZ11";
    private static final String QRYZ10 = "QRYZ10";
    public static final String PERSON_NOT_FOUND = "PERSON_NOT_FOUND";
    public static final String NO_DATA_ON_FILE = "NO_DATA_ON_FILE";
    private PersonHelperService personHelperService = null;
    private String triggerRuleParameters = null;
    private String personEventRuleParameters = null;
    private String handBookEventRuleParameters = null;

    @Override
    public void processMessageEvents(Person onFile) throws ServiceException {
        this.doTriggerMessage(onFile, false, false);
    }

    @Override
    public void processMessageEvents(Person person, VAFacility sendingFacility, VerificationInfo verificationInfo, boolean isZ10Sent) throws ServiceException {
        this.doTriggerMessage(person, sendingFacility, verificationInfo, isZ10Sent);
    }

    @Override
    public void processMessageEvents(Person person, VerificationInfo verificationInfo, boolean isZ10Sent, boolean fromAddNewPerson) throws ServiceException {
        this.doTriggerMessage(person, verificationInfo, isZ10Sent, fromAddNewPerson);
    }

    @Override
    public void processMessageEvents(Person person, VerificationInfo verificationInfo) throws ServiceException {
        this.doTriggerMessage(person, null, verificationInfo, false);
    }

    @Override
    public void processMessageEvents(Person onFile, Integer incomeYear, IncomingMessageInfo incomingMessageInfo, VerificationInfo verificationInfo) throws ServiceException {
        this.doTriggerMessage(onFile, incomeYear, incomingMessageInfo, verificationInfo);
    }

    @Override
    public void processMessageEventsForMsds(Person onFile) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"An on file person must not be null ");
        Person pristine = this.getPristinePerson(onFile);
        EventInputData data = new EventInputData(onFile, pristine);
        data.setDataFromGUI(true);
        data.setUseCaseName("MSDSVBAQRY");
        this.invokeRuleFlow(this.getRuleParameters(this.getTriggerRuleParameters()), (RuleDataAware)data);
    }

    @Override
    public void postProcessVOASubmissions(Person onFile) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"An on file person must not be null ");
        Person pristine = this.getPristinePerson(onFile);
        EventInputData data = new EventInputData(onFile, pristine);
        data.setUseCaseName("POST_PROCESS_VOA");
        this.invokeRuleFlow(this.getRuleParameters(this.getTriggerRuleParameters()), (RuleDataAware)data);
    }

    @Override
    public void manageMessageEvents(Person onFile) throws ServiceException {
        this.doTriggerMessage(onFile, true, false);
    }

    @Override
    public void managePersonEvents(Person onFile) throws ServiceException {
        this.doProcessPersonEvents(onFile, true, null);
    }

    @Override
    public void manageHandBookEvents(Person onFile) throws ServiceException {
        this.doProcessHandBookEvents(onFile, true, null);
    }

    @Override
    public void processPersonEvents(Person onFile) throws ServiceException {
        this.doProcessPersonEvents(onFile, false, null);
    }

    @Override
    public void processPersonEventsForAppointmentConversion(Person onFile) throws ServiceException {
        this.doProcessPersonEvents(onFile, false, "APPT");
    }

    @Override
    public void processMessageEvents(Person onFile, boolean isMSDSTrigger) throws ServiceException {
        this.doTriggerMessage(onFile, isMSDSTrigger);
    }

    @Override
    public void handleCommonPostEvents(Person onFile, boolean isDataFromUI) throws ServiceException {
        this.doTriggerMessage(onFile, isDataFromUI, false);
        this.doProcessPersonEvents(onFile, isDataFromUI, null);
        this.doProcessHandBookEvents(onFile, isDataFromUI, null);
    }

    @Override
    public void processMessageEventsForIVM(Person onFile) throws ServiceException {
        this.doTriggerMessage(onFile, true, true);
    }

    @Override
    public void handleCommonPostEvents(Person onFile, boolean isDataFromUI, boolean isZ10Sent) throws ServiceException {
        this.doTriggerMessage(onFile, isDataFromUI, isZ10Sent);
        this.doProcessPersonEvents(onFile, isDataFromUI, null);
        this.doProcessHandBookEvents(onFile, isDataFromUI, null);
    }

    @Override
    public void addPersonChangeEventsForAdvice(Person person) throws ServiceException {
        Validate.notNull((Object)((Object)person), (String)"the person must not be null ");
        Person pristine = this.getPristinePerson(person);
        String updatedNumber = person.getClaimFolderNumber();
        VAFacility fac = person.getClaimFolderLocation();
        String oldNumber = pristine.getClaimFolderNumber();
        VAFacility oldFac = pristine.getClaimFolderLocation();
        if (updatedNumber != null && oldNumber == null || updatedNumber == null && oldNumber != null || updatedNumber != null && oldNumber != null && !updatedNumber.equals(oldNumber)) {
            person.setChangeEvent("CLAIMNUM", "NUMBER");
        }
        if (fac != null && oldFac == null || fac == null && oldFac != null || fac != null && oldFac != null && !fac.equals((Object)oldFac)) {
            person.setChangeEvent("CLAIMLOC", "LOCATION");
        }
        Employment updatedEmployment = person.getEmployment();
        Employment oldEmployment = pristine.getEmployment();
        if (updatedEmployment != null && oldEmployment == null || updatedEmployment == null && oldEmployment != null) {
            person.setChangeEvent("EMPLOYMENT", "EMPLOYMENT");
        } else if (updatedEmployment != null && oldEmployment != null && this.hasEmploymentChange(updatedEmployment, oldEmployment)) {
            person.setChangeEvent("EMPLOYMENT", "EMPLOYMENT");
        }
    }

    private boolean hasEmploymentChange(Employment updatedEmployment, Employment oldEmployment) throws ServiceException {
        boolean updNameFlag = StringUtils.isEmpty((String)updatedEmployment.getEmployerName());
        boolean updPhoneFlag = StringUtils.isEmpty((String)updatedEmployment.getEmployerPhone());
        boolean updOccupationFlag = StringUtils.isEmpty((String)updatedEmployment.getOccupation());
        boolean oldNameFlag = StringUtils.isEmpty((String)oldEmployment.getEmployerName());
        boolean oldPhoneFlag = StringUtils.isEmpty((String)oldEmployment.getEmployerPhone());
        boolean oldOccupationFlag = StringUtils.isEmpty((String)oldEmployment.getOccupation());
        if (!updNameFlag && oldNameFlag || updNameFlag && !oldNameFlag || !updNameFlag && !oldNameFlag && !updatedEmployment.getEmployerName().equals(oldEmployment.getEmployerName())) {
            return true;
        }
        if (!updPhoneFlag && oldPhoneFlag || updPhoneFlag && !oldPhoneFlag || !updPhoneFlag && !oldPhoneFlag && !updatedEmployment.getEmployerPhone().equals(oldEmployment.getEmployerPhone())) {
            return true;
        }
        if (!updOccupationFlag && oldOccupationFlag || updOccupationFlag && !oldOccupationFlag || !updOccupationFlag && !oldOccupationFlag && !updatedEmployment.getOccupation().equals(oldEmployment.getOccupation())) {
            return true;
        }
        if (updatedEmployment.getEmploymentStatus() != null && oldEmployment.getEmploymentStatus() == null || updatedEmployment.getEmploymentStatus() == null && oldEmployment.getEmploymentStatus() != null || updatedEmployment.getEmploymentStatus() != null && oldEmployment.getEmploymentStatus() != null && !updatedEmployment.getEmploymentStatus().equals((Object)oldEmployment.getEmploymentStatus())) {
            return true;
        }
        if (updatedEmployment.getRetirementDate() != null && oldEmployment.getRetirementDate() == null || updatedEmployment.getRetirementDate() == null && oldEmployment.getRetirementDate() != null || updatedEmployment.getRetirementDate() != null && oldEmployment.getRetirementDate() != null && !updatedEmployment.getRetirementDate().equals((Object)oldEmployment.getRetirementDate())) {
            return true;
        }
        Address updated = updatedEmployment.getEmployerAddress();
        Address old = oldEmployment.getEmployerAddress();
        return updated != null && old == null || updated == null && old != null || updated != null && old != null && !updated.matchesDomainValues(old);
    }

    @Override
    public void triggerCreateHecRecord(Person person) throws ServiceException {
        Validate.notNull((Object)((Object)person), (String)"the person must not be null ");
        Person pristine = this.getPristinePerson(person);
        EventInputData data = new EventInputData(person, pristine);
        data.setUseCaseName("HEC_RECORD_CREATE");
        this.invokeRuleFlow(this.getRuleParameters(this.getTriggerRuleParameters()), (RuleDataAware)data);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.triggerRuleParameters, (String)"Trigger rule parameters must not be null");
        Validate.notNull((Object)this.personEventRuleParameters, (String)"Person event rule parameters must not be null");
    }

    public String getTriggerRuleParameters() {
        return this.triggerRuleParameters;
    }

    public String getPersonEventRuleParameters() {
        return this.personEventRuleParameters;
    }

    public void setPersonEventRuleParameters(String personEventRuleParameters) {
        this.personEventRuleParameters = personEventRuleParameters;
    }

    public String getHandBookEventRuleParameters() {
        return this.handBookEventRuleParameters;
    }

    public void setHandBookEventRuleParameters(String handBookEventRuleParameters) {
        this.handBookEventRuleParameters = handBookEventRuleParameters;
    }

    public void setTriggerRuleParameters(String triggerRuleParameters) {
        this.triggerRuleParameters = triggerRuleParameters;
    }

    private void doTriggerMessage(Person onFile, boolean isMSDSTrigger) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"An on file person must not be null ");
        Person pristine = this.getPristinePerson(onFile);
        EventInputData data = new EventInputData(onFile, pristine);
        data.setTriggerMSDSBroker(isMSDSTrigger);
        this.invokeRuleFlow(this.getRuleParameters(this.getTriggerRuleParameters()), (RuleDataAware)data);
    }

    private void doTriggerMessage(Person onFile, boolean isDataFromGUI, boolean isZ10Sent) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"An on file person must not be null ");
        Person pristine = this.getPristinePerson(onFile);
        EventInputData data = new EventInputData(onFile, pristine);
        data.setDataFromGUI(isDataFromGUI);
        data.setZ10Sent(isZ10Sent);
        this.invokeRuleFlow(this.getRuleParameters(this.getTriggerRuleParameters()), (RuleDataAware)data);
    }

    private void doTriggerMessage(Person onFile, Integer incomeYear, IncomingMessageInfo incomingMessageInfo, VerificationInfo verificationInfo) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"An on file person must not be null ");
        Validate.notNull((Object)((Object)incomingMessageInfo), (String)"The incoming message info must not be null ");
        Validate.notNull((Object)((Object)verificationInfo), (String)"The incoming verification info must not be null ");
        Person pristine = this.getPristinePerson(onFile);
        if ((QRYZ11.equals(verificationInfo.getMessageType()) || QRYZ10.equals(verificationInfo.getMessageType())) && onFile.getEnrollmentDetermination() == null) {
            ValidationMessages validationMessages = new ValidationMessages();
            validationMessages.add(new ValidationMessage(PERSON_NOT_FOUND));
            throw new ValidationServiceException(PERSON_NOT_FOUND, validationMessages);
        }
        if (QRYZ10.equals(verificationInfo.getMessageType())) {
            IncomeTest test;
            IncomeTest incomeTest = test = incomeYear != null ? onFile.getIncomeTest(incomeYear) : null;
            if (incomeYear == null || test == null || test.getFutureTest() != null && test.getFutureTest().booleanValue()) {
                IncomeTest currentTest = this.getPersonHelperService().getCurrentIncomeTest(onFile);
                if (currentTest != null) {
                    incomeYear = currentTest.getIncomeYear();
                } else {
                    ValidationMessages validationMessages = new ValidationMessages();
                    validationMessages.add(new ValidationMessage(NO_DATA_ON_FILE));
                    throw new ValidationServiceException(NO_DATA_ON_FILE, validationMessages);
                }
            }
        }
        EventInputData data = new EventInputData(onFile, pristine, incomeYear, incomingMessageInfo, verificationInfo);
        this.invokeRuleFlow(this.getRuleParameters(this.getTriggerRuleParameters()), (RuleDataAware)data);
    }

    private void doTriggerMessage(Person onFile, VAFacility sendingFacility, VerificationInfo verificationInfo, boolean isZ10Sent) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"An on file person must not be null ");
        Person pristine = this.getPristinePerson(onFile);
        EventInputData data = new EventInputData(onFile, sendingFacility, onFile, pristine, verificationInfo);
        data.setZ10Sent(isZ10Sent);
        this.invokeRuleFlow(this.getRuleParameters(this.getTriggerRuleParameters()), (RuleDataAware)data);
    }

    private void doTriggerMessage(Person onFile, VerificationInfo verificationInfo, boolean isZ10Sent, boolean fromAddNewPerson) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"An on file person must not be null ");
        Person pristine = this.getPristinePerson(onFile);
        EventInputData data = new EventInputData(onFile, null, onFile, pristine, verificationInfo);
        data.setZ10Sent(isZ10Sent);
        data.setFromAddNewPerson(fromAddNewPerson);
        this.invokeRuleFlow(this.getRuleParameters(this.getTriggerRuleParameters()), (RuleDataAware)data);
    }

    private void doProcessPersonEvents(Person onFile, boolean isDataFromGUI, String useCaseName) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"An on file person must not be null ");
        Person pristine = this.getPristinePerson(onFile);
        EventInputData data = new EventInputData(onFile, pristine);
        data.setDataFromGUI(isDataFromGUI);
        data.setUseCaseName(useCaseName);
        this.invokeRuleFlow(this.getRuleParameters(this.getPersonEventRuleParameters()), (RuleDataAware)data);
    }

    private void doProcessHandBookEvents(Person onFile, boolean isDataFromGUI, String useCaseName) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"An on file person must not be null ");
        Person pristine = this.getPristinePerson(onFile);
        EventInputData data = new EventInputData(onFile, pristine);
        data.setDataFromGUI(isDataFromGUI);
        data.setUseCaseName(useCaseName);
        this.invokeRuleFlow(this.getRuleParameters(this.getHandBookEventRuleParameters()), (RuleDataAware)data);
    }

    public PersonHelperService getPersonHelperService() {
        return this.personHelperService;
    }

    public void setPersonHelperService(PersonHelperService personHelperService) {
        this.personHelperService = personHelperService;
    }

    @Override
    public void processPersonEventsForPensionBulletin(Person onFile) throws ServiceException {
        this.doProcessPersonEvents(onFile, false, "PENSIONBUL");
    }
}

