/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.rule.service.impl;

import gov.va.med.esr.common.clock.Clock;
import gov.va.med.esr.common.model.ee.Application;
import gov.va.med.esr.common.model.ee.CancelDecline;
import gov.va.med.esr.common.model.ee.EGTSetting;
import gov.va.med.esr.common.model.ee.EnrollmentDetermination;
import gov.va.med.esr.common.model.ee.ReceivedEnrollment;
import gov.va.med.esr.common.model.ee.ServiceConnectionAward;
import gov.va.med.esr.common.model.ee.VerificationInfo;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.rule.data.EEInputData;
import gov.va.med.esr.common.rule.data.IneligibilityInputData;
import gov.va.med.esr.common.rule.data.PersonInputData;
import gov.va.med.esr.common.rule.service.CommunicationRuleService;
import gov.va.med.esr.common.rule.service.EligibilityEnrollmentRuleService;
import gov.va.med.esr.common.rule.service.FinancialInfoRuleService;
import gov.va.med.esr.common.rule.service.impl.AbstractRuleValidationServiceAwareImpl;
import gov.va.med.fw.rule.RuleDataAware;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.validation.ValidationMessages;
import gov.va.med.fw.validation.ValidationServiceException;
import org.apache.commons.lang.Validate;

public class EligibilityEnrollmentRuleServiceImpl
extends AbstractRuleValidationServiceAwareImpl
implements EligibilityEnrollmentRuleService {
    private static final long serialVersionUID = 7635816577039685872L;
    private String eligibilityRuleParameters = null;
    private String enrollmentRuleParameters = null;
    private String ineligibilityRuleParameters = null;
    private String receivedEligibilityRuleParameters = null;
    private String otherEligibilityRuleParameters = null;
    private String personRuleParameters = null;
    private String handBookEventRuleParameters = null;
    private String healthBenefitProfileRuleParameters = null;
    private FinancialInfoRuleService financialInfoRuleService = null;
    private CommunicationRuleService communicationRuleService = null;

    @Override
    public void processCancelDecline(CancelDecline incoming, Person onFile) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"An onFile person must not be null ");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("EERuleServiceImpl processCD : incoming" + (Object)((Object)incoming) + " onfile: " + (Object)((Object)onFile)));
        }
        this.getMergeRuleService().mergeCancelDecline(incoming, onFile);
    }

    @Override
    public void calculateEEForCleanup(Person onFile) throws ServiceException {
        this.calculateEE(onFile, null, false, false, true, null, null, true);
    }

    @Override
    public void calculateEEForExpireMTBatchJob(Person onFile, Integer incomeYear) throws ServiceException {
        this.calculateEE(onFile, incomeYear, false, false, true, null, null, false);
    }

    @Override
    public void calculateEE(Person onFile, boolean isDataFromGUI, boolean isReviewOnly) throws ServiceException {
        this.calculateEE(onFile, isDataFromGUI, isReviewOnly, null, null);
    }

    @Override
    public void calculateEE(Person onFile, boolean isDataFromGUI, boolean isReviewOnly, Clock.Type clockType, VAFacility sendingFacility) throws ServiceException {
        this.calculateEE(onFile, null, isDataFromGUI, isReviewOnly, true, clockType, sendingFacility, false);
    }

    @Override
    public void calculateEE(Person onFile, boolean isDataFromGUI, boolean isReviewOnly, boolean shouldTriggerHBP, Clock.Type clockType, VAFacility sendingFacility) throws ServiceException {
        this.calculateEE(onFile, null, isDataFromGUI, isReviewOnly, shouldTriggerHBP, clockType, sendingFacility, false);
    }

    private void calculateEE(Person onFile, Integer incomeYear, boolean isDataFromGUI, boolean isReviewOnly, boolean shouldTriggerHBP, Clock.Type clockType, VAFacility sendingFacility, boolean cleanup) throws ServiceException {
        Person pristine = this.getPristinePerson(onFile);
        this.processServiceConnectedIndicator(onFile);
        Person incoming = (Person)((Object)onFile.clone());
        EnrollmentDetermination result = this.doCalculateEligibility(incoming, onFile, pristine, isDataFromGUI, isReviewOnly, sendingFacility);
        this.getFinancialInfoRuleService().determineIncomeTestFromElig(incoming, onFile, pristine, result, isDataFromGUI, sendingFacility);
        incoming = (Person)((Object)onFile.clone());
        this.doCalculateEnrollment(incoming, onFile, pristine, result, isDataFromGUI, isReviewOnly, cleanup);
        this.doProcessOtherEligibililities(incoming, onFile, pristine, result, isDataFromGUI);
        EnrollmentDetermination current = onFile.getEnrollmentDetermination();
        if (current == null) {
            current = new EnrollmentDetermination();
            onFile.setEnrollmentDetermination(current);
        }
        this.getMergeRuleService().mergeEnrollmentDetermination(result, current);
        onFile.setMigratedEE();
        if (shouldTriggerHBP) {
            this.processHealthBenefitProfile((Person)((Object)onFile.clone()), onFile);
        }
        if (!isReviewOnly) {
            this.getCommunicationRuleService().triggerAutomaticLetters(onFile, incomeYear, isReviewOnly, clockType);
        }
    }

    @Override
    public Person determineEnrollment(Person incoming, EGTSetting egtSetting) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"An incoming person must not be null ");
        Person pristine = this.getPristinePerson(incoming);
        EnrollmentDetermination result = incoming.getEnrollmentDetermination();
        Validate.notNull((Object)((Object)result), (String)"A result enrollment must not be null ");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("EERuleServiceImpl detEnrollment : incoming: " + (Object)((Object)incoming)));
        }
        this.doCalculateEnrollment(incoming, incoming, pristine, result, false, false, egtSetting, false);
        this.getCommunicationRuleService().triggerAutomaticLetters(incoming, null, false, null);
        return incoming;
    }

    @Override
    public Person determineEnrollmentNoTriggerLetters(Person incoming) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"An incoming person must not be null ");
        Person pristine = this.getPristinePerson(incoming);
        EnrollmentDetermination result = incoming.getEnrollmentDetermination();
        Validate.notNull((Object)((Object)result), (String)"A result enrollment must not be null ");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("EERuleServiceImpl detEnrollmentNTL : incoming: " + (Object)((Object)incoming)));
        }
        this.doCalculateEnrollment(incoming, incoming, pristine, result, false, false, null, false);
        return incoming;
    }

    @Override
    public void processIneligibility(Person incoming, Person onFile, VAFacility sendingFacility, VerificationInfo verificationInfo, boolean isDataFromGUI) throws ServiceException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("EERuleServiceImpl procIneligible : incoming: " + (Object)((Object)incoming) + " onfile: " + (Object)((Object)onFile)));
        }
        this.doProcessIneligibilityFactor(incoming, onFile, isDataFromGUI, sendingFacility, verificationInfo);
    }

    @Override
    public void manageIneligibility(Person incoming, Person onFile) throws ServiceException {
        this.doProcessIneligibilityFactor(incoming, onFile, true, null, null);
    }

    @Override
    public void manageReceivedEligibilities(Person incoming, Person onFile) throws ServiceException {
        this.doProcessReceivedEligibilities(incoming, onFile, null, true);
    }

    @Override
    public void processReceivedEligibilities(Person incoming, Person onFile, VerificationInfo verificationInfo, boolean isUpdateFromGUI) throws ServiceException {
        this.doProcessReceivedEligibilities(incoming, onFile, verificationInfo, isUpdateFromGUI);
    }

    @Override
    public void processReceivedEnrollment(ReceivedEnrollment incoming, Person onFile) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"An onFile person must not be null ");
        if (incoming != null) {
            Person pristine = this.getPristinePerson(onFile);
            ValidationMessages messages = this.getRuleValidationService().validateReceivedEnrollment(incoming.getPerson(), onFile, pristine, false);
            if (messages != null && !messages.isEmpty()) {
                throw new ValidationServiceException(messages);
            }
            ReceivedEnrollment receivedEnrollment = onFile.getReceivedEnrollment();
            if (receivedEnrollment == null) {
                receivedEnrollment = new ReceivedEnrollment();
                onFile.setReceivedEnrollment(receivedEnrollment);
            }
            this.getMergeRuleService().mergeReceivedEnrollment(incoming, receivedEnrollment);
        } else {
            onFile.setReceivedEnrollment(null);
        }
    }

    @Override
    public void processApplication(Application incoming, Person onFile) throws ServiceException {
        this.doProcessApplication(incoming, onFile, false);
    }

    @Override
    public void manageApplication(Application application, Person onFile) throws ServiceException {
        this.doProcessApplication(application, onFile, true);
    }

    public void setEligibilityRuleParameters(String eligibilityRuleParameters) {
        this.eligibilityRuleParameters = eligibilityRuleParameters;
    }

    public void setEnrollmentRuleParameters(String enrollmentRuleParameters) {
        this.enrollmentRuleParameters = enrollmentRuleParameters;
    }

    public String getHandBookEventRuleParameters() {
        return this.handBookEventRuleParameters;
    }

    public void setHandBookEventRuleParameters(String handBookEventRuleParameters) {
        this.handBookEventRuleParameters = handBookEventRuleParameters;
    }

    public String getEligibilityRuleParameters() {
        return this.eligibilityRuleParameters;
    }

    public String getEnrollmentRuleParameters() {
        return this.enrollmentRuleParameters;
    }

    public String getIneligibilityRuleParameters() {
        return this.ineligibilityRuleParameters;
    }

    public void setIneligibilityRuleParameters(String ineligibilityRuleParameters) {
        this.ineligibilityRuleParameters = ineligibilityRuleParameters;
    }

    public String getReceivedEligibilityRuleParameters() {
        return this.receivedEligibilityRuleParameters;
    }

    public void setReceivedEligibilityRuleParameters(String receivedEligibilityRuleParameters) {
        this.receivedEligibilityRuleParameters = receivedEligibilityRuleParameters;
    }

    public String getOtherEligibilityRuleParameters() {
        return this.otherEligibilityRuleParameters;
    }

    public void setOtherEligibilityRuleParameters(String otherEligibilityRuleParameters) {
        this.otherEligibilityRuleParameters = otherEligibilityRuleParameters;
    }

    public FinancialInfoRuleService getFinancialInfoRuleService() {
        return this.financialInfoRuleService;
    }

    public void setFinancialInfoRuleService(FinancialInfoRuleService financialInfoRuleService) {
        this.financialInfoRuleService = financialInfoRuleService;
    }

    public CommunicationRuleService getCommunicationRuleService() {
        return this.communicationRuleService;
    }

    public void setCommunicationRuleService(CommunicationRuleService communicationRuleService) {
        this.communicationRuleService = communicationRuleService;
    }

    public String getPersonRuleParameters() {
        return this.personRuleParameters;
    }

    public void setPersonRuleParameters(String personRuleParameters) {
        this.personRuleParameters = personRuleParameters;
    }

    private EnrollmentDetermination doCalculateEligibility(Person incoming, Person onFile, Person pristine, boolean isDataFromGUI, boolean isReviewOnly, VAFacility sendingFacility) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"An incoming person must not be null ");
        Validate.notNull((Object)((Object)onFile), (String)"An on file person must not be null ");
        EnrollmentDetermination result = new EnrollmentDetermination();
        EEInputData data = new EEInputData(incoming, onFile, pristine, result, isDataFromGUI, isReviewOnly, sendingFacility);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("EERuleServiceImpl doCalcElig : incoming: " + (Object)((Object)incoming) + " onfile: " + (Object)((Object)onFile)));
        }
        this.invokeRuleFlow(this.getRuleParameters(this.getEligibilityRuleParameters()), (RuleDataAware)data);
        return result;
    }

    private EnrollmentDetermination doCalculateEnrollment(Person incoming, Person onFile, Person pristine, EnrollmentDetermination result, boolean isDataFromGUI, boolean isReviewOnly, boolean cleanup) throws ServiceException {
        return this.doCalculateEnrollment(incoming, onFile, pristine, result, isDataFromGUI, isReviewOnly, null, cleanup);
    }

    private EnrollmentDetermination doCalculateEnrollment(Person incoming, Person onFile, Person pristine, EnrollmentDetermination result, boolean isDataFromGUI, boolean isReviewOnly, EGTSetting egtSetting, boolean cleanup) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"An incoming person must not be null ");
        Validate.notNull((Object)((Object)onFile), (String)"An on file person must not be null ");
        Validate.notNull((Object)((Object)result), (String)"A result enrollment must not be null ");
        EEInputData data = new EEInputData(incoming, onFile, pristine, result, isDataFromGUI, isReviewOnly, null);
        data.setCleanup(cleanup);
        data.setActiveEGTSetting(egtSetting);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("EERuleServiceImpl doCalcEnroll : incoming: " + (Object)((Object)incoming) + " onfile: " + (Object)((Object)onFile)));
        }
        this.invokeRuleFlow(this.getRuleParameters(this.getEnrollmentRuleParameters()), (RuleDataAware)data);
        return result;
    }

    private Person doProcessIneligibilityFactor(Person incoming, Person onFile, boolean isDataFromGUI, VAFacility sendingFacility, VerificationInfo verificationInfo) throws ServiceException {
        ValidationMessages messages;
        Validate.notNull((Object)((Object)onFile), (String)"An onFile person must not be null ");
        if (!isDataFromGUI && (messages = this.getRuleValidationService().validateIneligibility(incoming, isDataFromGUI)) != null && !messages.isEmpty()) {
            throw new ValidationServiceException(messages);
        }
        Person pristine = this.getPristinePerson(onFile);
        IneligibilityInputData data = null;
        data = verificationInfo != null ? new IneligibilityInputData(incoming, onFile, pristine, isDataFromGUI, sendingFacility, verificationInfo) : new IneligibilityInputData(incoming, onFile, pristine, sendingFacility, isDataFromGUI);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("EERuleServiceImpl doProcIneligible : incoming: " + (Object)((Object)incoming) + " onfile: " + (Object)((Object)onFile)));
        }
        this.invokeRuleFlow(this.getRuleParameters(this.getIneligibilityRuleParameters()), (RuleDataAware)data);
        return onFile;
    }

    private Person doProcessReceivedEligibilities(Person incoming, Person onFile, VerificationInfo verificationInfo, boolean isDataFromGUI) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"An onFile person must not be null ");
        Validate.notNull((Object)((Object)incoming), (String)"A received eligibility must not be null ");
        Person pristine = this.getPristinePerson(onFile);
        EEInputData data = new EEInputData(incoming, onFile, pristine, isDataFromGUI);
        if (verificationInfo != null) {
            data.setMessageControlId(verificationInfo.getMessageControlId());
        }
        this.invokeRuleFlow(this.getRuleParameters(this.getReceivedEligibilityRuleParameters()), (RuleDataAware)data);
        return onFile;
    }

    @Override
    public void processOtherEligibililities(Person incoming, Person onFile, EnrollmentDetermination enrollment) throws ServiceException {
        Person pristine = this.getPristinePerson(onFile);
        this.doProcessOtherEligibililities(incoming, onFile, pristine, enrollment, false);
    }

    public void manageOtherEligibilities(Person incoming, Person onFile, EnrollmentDetermination enrollment) throws ServiceException {
        Person pristine = this.getPristinePerson(onFile);
        this.doProcessOtherEligibililities(incoming, onFile, pristine, enrollment, true);
    }

    @Override
    public void processServiceConnectedIndicator(Person person) {
        ServiceConnectionAward award = person.getServiceConnectionAward();
        if (award != null) {
            if (award.getRatedDisabilities().size() > 0 && award.getServiceConnectedPercentage() != null) {
                award.setServiceConnectedIndicator(Boolean.TRUE);
            } else {
                award.setServiceConnectedIndicator(Boolean.FALSE);
            }
        } else {
            award = new ServiceConnectionAward();
            award.setServiceConnectedIndicator(Boolean.FALSE);
            person.setServiceConnectionAward(award);
        }
    }

    @Override
    public void processPerson(Person incoming, Person onFile, VAFacility sendingFacility, VerificationInfo verificationInfo, boolean updateFromGUI) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"An onFile person must not be null ");
        Validate.notNull((Object)((Object)incoming), (String)"A incoming person must not be null ");
        Person pristine = this.getPristinePerson(onFile);
        PersonInputData data = new PersonInputData(incoming, onFile, pristine, sendingFacility, verificationInfo);
        data.setDataFromGUI(updateFromGUI);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("EERuleServiceImpl processPerson : incoming: " + (Object)((Object)incoming) + " onfile: " + (Object)((Object)onFile)));
        }
        this.invokeRuleFlow(this.getRuleParameters(this.getPersonRuleParameters()), (RuleDataAware)data);
    }

    @Override
    public void processPersonHandBookTrigger(Person incoming, Person onFile, VAFacility sendingFacility, VerificationInfo verificationInfo) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"An onFile person must not be null ");
        Validate.notNull((Object)((Object)incoming), (String)"A incoming person must not be null ");
        Person pristine = this.getPristinePerson(onFile);
        PersonInputData data = new PersonInputData(incoming, onFile, pristine, sendingFacility, verificationInfo);
        data.setDataFromGUI(false);
        data.setHandBookTrigger(true);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("EERuleServiceImpl procPersHBTrigger : incoming: " + (Object)((Object)incoming) + " onfile: " + (Object)((Object)onFile)));
        }
        this.invokeRuleFlow(this.getRuleParameters(this.getPersonRuleParameters()), (RuleDataAware)data);
    }

    private void doProcessOtherEligibililities(Person incoming, Person onFile, Person pristine, EnrollmentDetermination enrollment, boolean isDataFromGUI) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"An incoming person must not be null ");
        Validate.notNull((Object)((Object)onFile), (String)"An on file person must not be null ");
        Validate.notNull((Object)((Object)pristine), (String)"A pristine person must not be null ");
        EEInputData data = new EEInputData(incoming, onFile, pristine, enrollment, isDataFromGUI, true, null);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("EERuleServiceImpl doProcOE : incoming: " + (Object)((Object)incoming) + " onfile: " + (Object)((Object)onFile)));
        }
        this.invokeRuleFlow(this.getRuleParameters(this.getOtherEligibilityRuleParameters()), (RuleDataAware)data);
    }

    @Override
    public void processHandBookTriggers(Person incoming, Person onFile, VAFacility sendingFacility, VerificationInfo verificationInfo) throws ServiceException {
        Person pristine = this.getPristinePerson(onFile);
        this.doProcessHandbookTriggers(incoming, onFile, pristine, sendingFacility, verificationInfo);
    }

    private void doProcessHandbookTriggers(Person incoming, Person onFile, Person pristine, VAFacility sendingFacility, VerificationInfo verificationInfo) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"An incoming person must not be null ");
        Validate.notNull((Object)((Object)onFile), (String)"An on file person must not be null ");
        Validate.notNull((Object)((Object)pristine), (String)"A pristine person must not be null ");
        PersonInputData data = new PersonInputData(incoming, onFile, pristine, sendingFacility, verificationInfo);
        data.setHandBookTrigger(true);
        this.invokeRuleFlow(this.getRuleParameters(this.getHandBookEventRuleParameters()), (RuleDataAware)data);
    }

    private void doProcessApplication(Application incoming, Person onFile, boolean isDataFromGUI) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"An onFile person must not be null ");
        if (incoming != null) {
            Application application = onFile.getApplication();
            if (application == null) {
                application = new Application();
                onFile.setApplication(application);
            }
            if (isDataFromGUI) {
                Person person = incoming.getPerson();
                Person pristine = this.getPristinePerson(onFile);
                ValidationMessages messages = this.getRuleValidationService().validateReceivedEnrollment(person, onFile, pristine, isDataFromGUI);
                if (messages != null && !messages.isEmpty()) {
                    throw new ValidationServiceException(messages);
                }
            }
            this.getMergeRuleService().mergeApplication(incoming, application);
        } else {
            onFile.setApplication(null);
        }
    }

    @Override
    public void processHealthBenefitProfile(Person incoming, Person onFile) throws ServiceException {
        this.doProcessHealthBenefitProfile(incoming, onFile, false);
    }

    private void doProcessHealthBenefitProfile(Person incoming, Person onFile, boolean isDataFromGUI) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"A onFile Person must not be null ");
        Validate.notNull((Object)((Object)incoming), (String)"An incoming Person must not be null ");
        Person pristine = this.getPristinePerson(onFile);
        PersonInputData data = new PersonInputData(incoming, onFile, pristine, isDataFromGUI);
        this.invokeRuleFlow(this.getRuleParameters(this.getHealthBenefitProfileRuleParameters()), (RuleDataAware)data);
    }

    @Override
    public void manageHealthBenefitProfile(Person incoming, Person onFile) throws ServiceException {
        this.doProcessHealthBenefitProfile(incoming, onFile, true);
    }

    public String getHealthBenefitProfileRuleParameters() {
        return this.healthBenefitProfileRuleParameters;
    }

    public void setHealthBenefitProfileRuleParameters(String healthBenefitProfileRuleParameters) {
        this.healthBenefitProfileRuleParameters = healthBenefitProfileRuleParameters;
    }
}

