/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.rule.service.impl;

import gov.va.med.esr.common.model.ee.EGTSetting;
import gov.va.med.esr.common.rule.data.EgtInputData;
import gov.va.med.esr.common.rule.service.EGTRuleService;
import gov.va.med.esr.common.rule.service.impl.AbstractRuleValidationServiceAwareImpl;
import gov.va.med.fw.rule.RuleDataAware;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.validation.ValidationMessages;
import gov.va.med.fw.validation.ValidationServiceException;
import org.apache.commons.lang.Validate;

public class EGTRuleServiceImpl
extends AbstractRuleValidationServiceAwareImpl
implements EGTRuleService {
    private static final long serialVersionUID = 6200609426168999185L;
    private String egtRuleParameters = null;
    private String manageEgtRuleParameters = null;

    @Override
    public EGTSetting manageEGT(EGTSetting incoming, EGTSetting onFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"Incoming EGT setting must not be null");
        ValidationMessages messages = this.getRuleValidationService().validateEgtSetting(incoming, onFile);
        if (messages != null && !messages.isEmpty()) {
            throw new ValidationServiceException(messages);
        }
        EgtInputData data = new EgtInputData(incoming, onFile);
        this.invokeRuleFlow(this.getRuleParameters(this.getManageEgtRuleParameters()), (RuleDataAware)data);
        return onFile;
    }

    @Override
    public EGTSetting processEGT(EGTSetting incoming, EGTSetting egtOnFile) throws ServiceException {
        Validate.notNull((Object)((Object)incoming), (String)"Incoming EGTSetting must not be null");
        EgtInputData data = new EgtInputData(incoming, egtOnFile);
        this.invokeRuleFlow(this.getRuleParameters(this.getEgtRuleParameters()), (RuleDataAware)data);
        return egtOnFile;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.egtRuleParameters, (String)"egtRuleParameters property is required");
        Validate.notNull((Object)this.manageEgtRuleParameters, (String)"manageEgtRuleParameters property is required");
    }

    public String getEgtRuleParameters() {
        return this.egtRuleParameters;
    }

    public void setEgtRuleParameters(String egtRuleParameters) {
        this.egtRuleParameters = egtRuleParameters;
    }

    public String getManageEgtRuleParameters() {
        return this.manageEgtRuleParameters;
    }

    public void setManageEgtRuleParameters(String manageEgtRuleParameters) {
        this.manageEgtRuleParameters = manageEgtRuleParameters;
    }
}

