/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.rule.service.impl;

import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.rule.data.PersonInputData;
import gov.va.med.esr.common.rule.service.ClinicalDeterminationRuleService;
import gov.va.med.esr.common.rule.service.impl.AbstractRuleValidationServiceAwareImpl;
import gov.va.med.fw.rule.RuleDataAware;
import gov.va.med.fw.service.ServiceException;
import org.apache.commons.lang.Validate;

public class ClinicalDeterminationRuleServiceImpl
extends AbstractRuleValidationServiceAwareImpl
implements ClinicalDeterminationRuleService {
    private static final long serialVersionUID = -1455258106175382818L;
    private String clinicalDeterminationRuleParameters = null;

    @Override
    public Person processClinicalDetermination(Person incoming, Person onFile, VAFacility sendingFacility, String caller) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"A incoming must person not be null ");
        return this.doClinicalDetermination(incoming, onFile, sendingFacility, caller);
    }

    private Person doClinicalDetermination(Person incoming, Person onFile, VAFacility sendingFacility, String caller) throws ServiceException {
        Validate.notNull((Object)((Object)onFile), (String)"A current veteran must not be null ");
        Person pristine = this.getPristinePerson(onFile);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("ClinicalDetermRuleServiceImpl doClinicalDetermination : incoming" + (Object)((Object)incoming) + " onfile: " + (Object)((Object)onFile)));
        }
        this.invokeRuleFlow(this.getRuleParameters(this.getClinicalDeterminationRuleParameters()), (RuleDataAware)new PersonInputData(incoming, onFile, pristine, sendingFacility, "UI".equals(caller)));
        return onFile;
    }

    public String getClinicalDeterminationRuleParameters() {
        return this.clinicalDeterminationRuleParameters;
    }

    public void setClinicalDeterminationRuleParameters(String clinicalDeterminationRuleParameters) {
        this.clinicalDeterminationRuleParameters = clinicalDeterminationRuleParameters;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.clinicalDeterminationRuleParameters, (String)"A clinical determination rule parameters is required");
    }
}

