/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.rule.service.impl;

import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.rule.service.MergeRuleService;
import gov.va.med.esr.common.rule.service.RuleValidationService;
import gov.va.med.esr.service.PersonService;
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.rule.AbstractRuleFlowAwareService;
import gov.va.med.fw.rule.RuleParameters;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.transaction.TransactionTimestampManager;
import gov.va.med.fw.service.trigger.TriggerRouter;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.lang.Validate;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

public abstract class AbstractRuleValidationServiceAwareImpl
extends AbstractRuleFlowAwareService {
    public static final String UI = "UI";
    private RuleValidationService ruleValidationService = null;
    private PersonService personService = null;
    private PersonService cachedPersonService = null;
    private MergeRuleService mergeRuleService = null;
    private TriggerRouter eventRounterService = null;
    private TransactionTimestampManager timestampManager;

    protected AbstractRuleValidationServiceAwareImpl() {
    }

    public Person getPristinePerson(Person person) throws ServiceException {
        Validate.notNull((Object)((Object)person), (String)"A person must not be null");
        if (person.isJustAdded()) {
            return this.getCachedPersonService().getPerson(person.getPersonEntityKey(), person.getIdentityTraits());
        }
        return this.getCachedPersonService().getPerson(person.getPersonEntityKey());
    }

    public RuleValidationService getRuleValidationService() {
        return this.ruleValidationService;
    }

    public void setRuleValidationService(RuleValidationService ruleValidationService) {
        this.ruleValidationService = ruleValidationService;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.ruleValidationService, (String)"Rule validation service is required");
        Validate.notNull((Object)this.mergeRuleService, (String)"A merge rule service must not be null");
        Validate.notNull((Object)this.personService, (String)"A person service must not be null");
        Validate.notNull((Object)this.eventRounterService, (String)"An event router service must not be null");
        Validate.notNull((Object)this.timestampManager, (String)"A Timestamp Manager service must not be null");
    }

    protected Date getTransactionDate() {
        return new Date(this.timestampManager.getTransactionTimestamp().getTime());
    }

    public MergeRuleService getMergeRuleService() {
        return this.mergeRuleService;
    }

    public void setMergeRuleService(MergeRuleService mergeRuleService) {
        this.mergeRuleService = mergeRuleService;
    }

    public TriggerRouter getEventRounterService() {
        return this.eventRounterService;
    }

    public void setEventRounterService(TriggerRouter eventRounterService) {
        this.eventRounterService = eventRounterService;
    }

    public PersonService getCachedPersonService() {
        return this.cachedPersonService;
    }

    public void setCachedPersonService(PersonService cachedPersonService) {
        this.cachedPersonService = cachedPersonService;
    }

    public TransactionTimestampManager getTimestampManager() {
        return this.timestampManager;
    }

    public void setTimestampManager(TransactionTimestampManager timestampManager) {
        this.timestampManager = timestampManager;
    }

    protected AbstractEntity findMatchingElement(AbstractEntity entity, Collection target) {
        return this.getMergeRuleService().getMatchRuleService().findMatchingElement(entity, target);
    }

    protected RuleParameters getRuleParameters(String name) throws NoSuchBeanDefinitionException {
        try {
            return (RuleParameters)this.getComponent(name, RuleParameters.class);
        }
        catch (ServiceException e) {
            throw new NoSuchBeanDefinitionException("Failed to obtain rule parameters: " + name);
        }
    }
}

