/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.rule.parameter;

import gov.va.med.esr.common.model.cases.Assignment;
import gov.va.med.esr.common.model.cases.WorkflowCase;
import gov.va.med.esr.common.model.ee.PurpleHeart;
import gov.va.med.esr.common.model.ee.VerificationInfo;
import gov.va.med.esr.common.model.lookup.FunctionalGroup;
import gov.va.med.esr.common.model.lookup.WkfCaseType;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.common.model.workload.WorkflowCaseInfo;
import gov.va.med.esr.common.rule.WorkloadInput;
import gov.va.med.esr.common.rule.parameter.AbstractTriggerAwareInputParameter;
import gov.va.med.esr.service.UnknownLookupCodeException;
import gov.va.med.esr.service.UnknownLookupTypeException;
import gov.va.med.fw.rule.RuleException;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.StringUtils;
import java.util.Date;
import org.apache.commons.lang.Validate;

public class WorkloadInputParameter
extends AbstractTriggerAwareInputParameter
implements WorkloadInput {
    private static final long serialVersionUID = 8150949549518628909L;

    @Override
    public void createCaseIfZipCodeisInvalid(String oldZipCode, String newZipCode) throws RuleException {
        if (StringUtils.isEmpty((String)newZipCode)) {
            return;
        }
        if (StringUtils.isNotEmpty((String)oldZipCode) && StringUtils.isNotEmpty((String)newZipCode) && oldZipCode.equals(newZipCode)) {
            return;
        }
        try {
            if (this.getLookupService().getZipCodeByCode(newZipCode) != null) {
                return;
            }
        }
        catch (UnknownLookupTypeException e) {
            throw new RuleException("UnknownLookupType", (Throwable)((Object)e));
        }
        catch (UnknownLookupCodeException unknownLookupCodeException) {
            // empty catch block
        }
        this.createWorkloadCase(FunctionalGroup.DQ.getCode(), WkfCaseType.CODE_APPLICATION_EXCEPTION.getCode(), null, "Update Reference Data Zip code " + newZipCode);
    }

    @Override
    public void createWorkloadCase(String groupType, String caseType, String issueType, String description) throws RuleException {
        Validate.notNull((Object)groupType, (String)"A Group type must not be null");
        Validate.notNull((Object)caseType, (String)"A case type must not be null");
        WorkflowCaseInfo caseInfo = this.getMessageCaseInfo();
        if (caseInfo == null) {
            caseInfo = new WorkflowCaseInfo();
            if (this.getPersonId() != null) {
                caseInfo.setPersonEntityKey(this.getPersonId());
            } else {
                caseInfo.setPersonEntityKey((PersonEntityKey)this.getIncomingPerson().getEntityKey());
            }
        }
        try {
            caseInfo.setErrorMessage(description);
            caseInfo.setGroupType(this.getLookupService().getFunctionalGroupByCode(groupType));
            caseInfo.setCaseType(this.getLookupService().getWkfCaseTypeByCode(caseType));
            if (StringUtils.isNotEmpty((String)issueType)) {
                caseInfo.setIssueType(this.getLookupService().getWkfIssueTypeByCode(issueType));
            }
            this.getWorkflowService().autoCreateCase(caseInfo);
        }
        catch (Exception e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Case description: " + description));
                this.logger.debug((Object)("Case type: " + caseType));
                this.logger.debug((Object)"Failed to create case due to ", (Throwable)e);
            }
            throw new RuleException("Failed to create a case", (Throwable)e);
        }
    }

    @Override
    public void assignPHCaseToAssignedLas() throws RuleException {
        try {
            PurpleHeart ph;
            WorkflowCase wfCase = this.getWorkflowService().getWorkItem(this.getIncomingPerson(), this.getLookupService().getWkfCaseTypeByCode(WkfCaseType.CODE_PURPLE_HEART.getCode()), true);
            if (wfCase != null && (ph = this.getIncomingPerson().getPurpleHeart()) != null) {
                Assignment assignment = wfCase.getAssignment();
                if (!(ph.getAssignedContactUser() == null || assignment.getAssignedTo() != null && ph.getAssignedContactUser().equals(assignment.getAssignedTo()))) {
                    assignment.setAssignedTo(ph.getAssignedContactUser());
                    assignment.setAssignmentDate(new Date());
                }
                if (wfCase.getEntityKey() != null) {
                    this.getWorkflowService().update(wfCase);
                } else {
                    this.getWorkflowService().create(wfCase);
                }
            }
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to close a case", (Throwable)e);
        }
    }

    @Override
    public void setWorkloadCaseToClosed() throws RuleException {
        try {
            WorkflowCase wfCase = this.getWorkflowService().getWorkItem(this.getIncomingPerson(), this.getLookupService().getWkfCaseTypeByCode(WkfCaseType.CODE_PURPLE_HEART.getCode()), false);
            if (wfCase != null) {
                this.getWorkflowService().close(wfCase);
            }
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to close a case", (Throwable)e);
        }
    }

    private WorkflowCaseInfo getMessageCaseInfo() {
        WorkflowCaseInfo caseInfo;
        VerificationInfo info = this.getAacInfo();
        WorkflowCaseInfo workflowCaseInfo = caseInfo = info != null ? info.getWorkflowCaseInfo() : null;
        if (caseInfo != null && caseInfo.getPersonEntityKey() == null) {
            caseInfo.setPersonEntityKey(this.getPersonId());
        }
        return caseInfo;
    }
}

