/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.rule.parameter;

import gov.va.med.esr.common.infra.ImpreciseDateUtils;
import gov.va.med.esr.common.model.ee.Document;
import gov.va.med.esr.common.model.ee.POWEpisode;
import gov.va.med.esr.common.model.ee.PrisonerOfWar;
import gov.va.med.esr.common.model.ee.PurpleHeart;
import gov.va.med.esr.common.model.ee.PurpleHeartDocument;
import gov.va.med.esr.common.model.ee.ReceivedEligibility;
import gov.va.med.esr.common.model.ee.SHAD;
import gov.va.med.esr.common.model.ee.SHADDocument;
import gov.va.med.esr.common.model.lookup.Indicator;
import gov.va.med.esr.common.model.lookup.RegistryType;
import gov.va.med.esr.common.model.lookup.ReportExceptionType;
import gov.va.med.esr.common.model.person.DeathRecord;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.common.model.registry.Registry;
import gov.va.med.esr.common.model.registry.RegistryTrait;
import gov.va.med.esr.common.model.registry.RegistryTraitDetail;
import gov.va.med.esr.common.persistent.registry.RegistryDAO;
import gov.va.med.esr.common.rule.RegistryInput;
import gov.va.med.esr.common.rule.data.RegistryInputData;
import gov.va.med.esr.common.rule.parameter.BaseParameter;
import gov.va.med.esr.service.LoadRegistryResult;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.rule.RuleDataAware;
import gov.va.med.fw.rule.RuleException;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.StringUtils;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.EqualsBuilder;

public class RegistryInputParameter
extends BaseParameter
implements RegistryInput {
    private static final long serialVersionUID = -2100826797626752705L;
    private String registryDaoName = null;

    @Override
    public boolean isEnrolled(Person person) {
        return person != null ? person.isEnrolled() : false;
    }

    @Override
    public boolean isVeteran(Person person) {
        return person != null && person.isVeteran() != null ? person.isVeteran() : false;
    }

    @Override
    public String getReceivedPrimaryEligibilityCode(Person person) {
        ReceivedEligibility primary = person != null ? person.getReceivedPrimaryEligibility() : null;
        return primary != null && primary.getType() != null ? primary.getType().getCode() : null;
    }

    @Override
    public boolean isNewRegistry() {
        Registry registry = this.getRegistry();
        return registry != null && registry.getEntityKey() == null;
    }

    @Override
    public boolean isRegistryExists() throws RuleException {
        try {
            Registry registry = this.getRegistry();
            RegistryTrait trait = registry.getRegistryTrait();
            RegistryTrait onFileTrait = this.getRegistryDAO().getRegistryTrait(registry);
            if (!(onFileTrait == null || trait.getEntityKey() != null && trait.getEntityKey().equals(onFileTrait.getEntityKey()))) {
                return true;
            }
        }
        catch (Exception ex) {
            throw new RuleException("Error while getting the registry trait", (Throwable)ex);
        }
        return false;
    }

    @Override
    public String getRegistryType() {
        RegistryType regType = this.getRegistryInputData().getRegistryTytpe();
        return regType != null ? regType.getCode() : null;
    }

    @Override
    public String getSSN() {
        return this.getRegistryTrait() != null ? this.getRegistryTrait().getSsn() : null;
    }

    @Override
    public String getFirstName() {
        return this.getRegistryTrait() != null ? this.getRegistryTrait().getFirstName() : null;
    }

    @Override
    public String getLastName() {
        return this.getRegistryTrait() != null ? this.getRegistryTrait().getLastName() : null;
    }

    @Override
    public Date getDOD() {
        return this.getRegistryTrait() != null && this.getRegistryTrait().getDeathDate() != null ? ImpreciseDateUtils.getDateWithDefault(this.getRegistryTrait().getDeathDate()) : null;
    }

    @Override
    public boolean getPHIndicator() {
        PurpleHeart ph = this.getPurpleHeart();
        return ph != null && ph.getPhIndicator() != null ? ph.getPhIndicator() : false;
    }

    @Override
    public boolean getPristinePHIndicator() {
        PurpleHeart ph = this.getPristinePurpleHeart();
        return ph != null && ph.getPhIndicator() != null ? ph.getPhIndicator() : false;
    }

    @Override
    public void setPHIndicator(boolean indicator) {
        PurpleHeart ph = this.getResultPurpleHeart();
        if (ph != null) {
            ph.setPhIndicator(indicator ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    @Override
    public String getPHStatus() {
        PurpleHeart ph = this.getPurpleHeart();
        return ph != null && ph.getStatus() != null ? ph.getStatus().getCode() : null;
    }

    @Override
    public String getPristinePHStatus() {
        PurpleHeart ph = this.getPristinePurpleHeart();
        return ph != null && ph.getStatus() != null ? ph.getStatus().getCode() : null;
    }

    @Override
    public String getPHRejectedRemarks() {
        PurpleHeart ph = this.getPurpleHeart();
        return ph != null && ph.getRejectionRemark() != null ? ph.getRejectionRemark().getCode() : null;
    }

    @Override
    public void setPHStatusUpdateDate(Date date) {
        PurpleHeart ph = this.getResultPurpleHeart();
        if (ph != null) {
            ph.setStatusLastEditDate(date);
        }
    }

    @Override
    public void setPHStatusUpdateUser(String user) {
        PurpleHeart ph = this.getResultPurpleHeart();
        if (ph != null) {
            ph.setStatusLastUpdateUser(user);
        }
    }

    @Override
    public String getPHDocumentType() {
        PurpleHeartDocument phDoc = this.getPHDocument();
        return phDoc != null && phDoc.getDocumentType() != null ? phDoc.getDocumentType().getCode() : null;
    }

    @Override
    public String getPHDataSource() {
        PurpleHeartDocument phDoc = this.getPHDocument();
        return phDoc != null && phDoc.getDataSource() != null ? phDoc.getDataSource().getCode() : null;
    }

    @Override
    public Date getPHDocumentReceivedDate() {
        PurpleHeartDocument phDoc = this.getPHDocument();
        return phDoc != null ? phDoc.getReceivedDate() : null;
    }

    @Override
    public Boolean getPHDocumentAcceptable() {
        PurpleHeartDocument phDoc = this.getPHDocument();
        return phDoc != null ? phDoc.getAcceptable() : null;
    }

    @Override
    public String getPHAssignedLAS() {
        return null;
    }

    @Override
    public void addPHRegistry() {
        try {
            this.getMergeRuleService().mergeRegistry(this.getPurpleHeart(), this.getResultPurpleHeart());
            this.setPHDocumentDefaults(this.getResultPurpleHeart());
        }
        catch (ServiceException e) {
            this.logger.debug((Object)"Failed to merge PH registry", (Throwable)e);
            throw new RuntimeException("Failed to merge PH registry", e);
        }
    }

    @Override
    public void updatePHRegistry() {
        try {
            this.getMergeRuleService().mergeRegistry(this.getPurpleHeart(), this.getResultPurpleHeart());
            this.setPHDocumentDefaults(this.getResultPurpleHeart());
        }
        catch (ServiceException e) {
            this.logger.debug((Object)"Failed to merge PH registry", (Throwable)e);
            throw new RuntimeException("Failed to merge PH registry", e);
        }
    }

    @Override
    public void linkNewPersonPHRegistry() throws RuleException {
        PurpleHeart phRegistry;
        Person resultPerson = this.getResultPerson();
        if (resultPerson != null && (phRegistry = (PurpleHeart)this.getUnlinkedRegistry(resultPerson, RegistryType.CODE_PH_REGISTRY.getCode())) != null && phRegistry.getPerson() == null) {
            resultPerson.setPurpleHeart(phRegistry);
        }
    }

    @Override
    public void linkExistingPersonPHRegistry() throws RuleException {
        PurpleHeart phRegistry;
        PurpleHeart resultPH;
        Person resultPerson = this.getResultPerson();
        if (resultPerson != null && (resultPH = resultPerson.getPurpleHeart()) != null && resultPH.getRegistryTrait() == null && (phRegistry = (PurpleHeart)this.getUnlinkedRegistry(resultPerson, RegistryType.CODE_PH_REGISTRY.getCode())) != null && phRegistry.getPerson() == null) {
            resultPerson.setPurpleHeart(phRegistry);
        }
    }

    @Override
    public void linkPersonPHRegistry() throws RuleException {
        PurpleHeart resultPurpleHeart;
        Person resultPerson = this.getResultPerson();
        PurpleHeart purpleHeart = resultPurpleHeart = resultPerson != null ? resultPerson.getPurpleHeart() : null;
        if (resultPurpleHeart != null && resultPurpleHeart.getRegistryTrait() == null) {
            RegistryTrait registryTrait = null;
            PurpleHeart phRegistry = (PurpleHeart)this.getUnlinkedRegistry(resultPerson, RegistryType.CODE_PH_REGISTRY.getCode());
            if (phRegistry != null) {
                registryTrait = phRegistry.getRegistryTrait();
                if (phRegistry.getPerson() == null) {
                    phRegistry.setRegistryTrait(null);
                }
                if (phRegistry.getDocuments() != null) {
                    Set docs = new HashSet();
                    try {
                        docs = this.getMergeRuleService().mergeSets(phRegistry.getDocuments(), docs);
                    }
                    catch (ServiceException se) {
                        throw new RuleException("Unable to merge PH documents", (Throwable)se);
                    }
                    if (!docs.isEmpty()) {
                        resultPurpleHeart.addAllDocuments(docs);
                    }
                }
            }
            registryTrait = registryTrait == null ? this.createRegistryTrait(resultPerson, RegistryType.CODE_PH_REGISTRY.getCode()) : registryTrait;
            resultPurpleHeart.setRegistryTrait(registryTrait);
            try {
                if (phRegistry != null && phRegistry.getPerson() == null) {
                    this.delete(phRegistry.getEntityKey());
                }
            }
            catch (ServiceException se) {
                throw new RuleException("Unable to delete PurpleHeart Registry", (Throwable)se);
            }
        }
    }

    @Override
    public boolean getPOWIndicator() {
        PrisonerOfWar pow = this.getPrisonerOfWar();
        return pow != null && pow.getPowIndicator() != null && pow.getPowIndicator().toBoolean() != null ? pow.getPowIndicator().toBoolean() : false;
    }

    @Override
    public boolean getPristinePOWIndicator() {
        PrisonerOfWar pow = this.getPristinePrisonerOfWar();
        return pow != null && pow.getPowIndicator() != null && pow.getPowIndicator().toBoolean() != null ? pow.getPowIndicator().toBoolean() : false;
    }

    @Override
    public void setPOWIndicator(boolean indicator) {
        try {
            PrisonerOfWar pow = this.getResultPrisonerOfWar();
            if (pow != null) {
                String indCode = indicator ? Indicator.YES.getCode() : Indicator.NO.getCode();
                pow.setPowIndicator((Indicator)this.getLookupService().getByCode(Indicator.class, indCode));
            }
        }
        catch (ServiceException e) {
            this.logger.debug((Object)"Failed to find Indicator lookup", (Throwable)e);
            throw new RuntimeException("Failed to find Indicator lookup", e);
        }
    }

    @Override
    public void setPOWDateEntered(Date date) {
        PrisonerOfWar pow = this.getResultPrisonerOfWar();
        if (pow != null) {
            pow.setDateEntered(date);
        }
    }

    @Override
    public void setPOWEnteredBy(String user) {
        PrisonerOfWar pow = this.getResultPrisonerOfWar();
        if (pow != null) {
            pow.setUser(user);
        }
    }

    @Override
    public String getPOWDocumentType() {
        POWEpisode powEpi = this.getPOWEpisode();
        return powEpi != null && powEpi.getDocumentType() != null ? powEpi.getDocumentType().getCode() : null;
    }

    @Override
    public String getPOWDataSource() {
        POWEpisode powEpi = this.getPOWEpisode();
        return powEpi != null && powEpi.getDataSource() != null ? powEpi.getDataSource().getCode() : null;
    }

    @Override
    public Date getPOWCaptureDate() {
        POWEpisode powEpi = this.getPOWEpisode();
        return powEpi != null && powEpi.getCaptureDate() != null ? ImpreciseDateUtils.getDateWithDefault(powEpi.getCaptureDate()) : null;
    }

    @Override
    public Date getPOWReleaseDate() {
        POWEpisode powEpi = this.getPOWEpisode();
        return powEpi != null && powEpi.getReleaseDate() != null ? ImpreciseDateUtils.getDateWithDefault(powEpi.getReleaseDate()) : null;
    }

    @Override
    public String getPOWConfinementLocation() {
        POWEpisode powEpi = this.getPOWEpisode();
        return powEpi != null && powEpi.getConfinementLocation() != null ? powEpi.getConfinementLocation().getCode() : null;
    }

    @Override
    public void addPOWRegistry() {
        try {
            this.getMergeRuleService().mergeRegistry(this.getPrisonerOfWar(), this.getResultPrisonerOfWar());
            this.setPOWEpisodeDefaults(this.getResultPrisonerOfWar());
        }
        catch (ServiceException e) {
            this.logger.debug((Object)"Failed to merge POW registry", (Throwable)e);
            throw new RuntimeException("Failed to merge POW registry", e);
        }
    }

    @Override
    public void updatePOWRegistry() {
        try {
            this.getMergeRuleService().mergeRegistry(this.getPrisonerOfWar(), this.getResultPrisonerOfWar());
            this.setPOWEpisodeDefaults(this.getResultPrisonerOfWar());
        }
        catch (ServiceException e) {
            this.logger.debug((Object)"Failed to merge POW registry", (Throwable)e);
            throw new RuntimeException("Failed to merge POW registry", e);
        }
    }

    @Override
    public void linkNewPersonPOWRegistry() throws RuleException {
        PrisonerOfWar powRegistry;
        Person resultPerson = this.getResultPerson();
        if (resultPerson != null && (powRegistry = (PrisonerOfWar)this.getUnlinkedRegistry(resultPerson, RegistryType.CODE_POW_REGISTRY.getCode())) != null && powRegistry.getPerson() == null) {
            resultPerson.setPrisonerOfWar(powRegistry);
        }
    }

    @Override
    public void linkExistingPersonPOWRegistry() throws RuleException {
        PrisonerOfWar powRegistry;
        PrisonerOfWar resultPOW;
        Person resultPerson = this.getResultPerson();
        if (resultPerson != null && (resultPOW = resultPerson.getPrisonerOfWar()) != null && resultPOW.getRegistryTrait() == null && (powRegistry = (PrisonerOfWar)this.getUnlinkedRegistry(resultPerson, RegistryType.CODE_POW_REGISTRY.getCode())) != null && powRegistry.getPerson() == null) {
            resultPerson.setPrisonerOfWar(powRegistry);
        }
    }

    @Override
    public void linkPersonPOWRegistry() throws RuleException {
        Person resultPerson = this.getResultPerson();
        PrisonerOfWar resultPrisonerOfWar = resultPerson != null ? resultPerson.getPrisonerOfWar() : null;
        PrisonerOfWar incomingPOW = this.getPrisonerOfWar();
        if (resultPrisonerOfWar != null && resultPrisonerOfWar.getRegistryTrait() == null) {
            RegistryTrait registryTrait = null;
            PrisonerOfWar powRegistry = (PrisonerOfWar)this.getUnlinkedRegistry(resultPerson, RegistryType.CODE_POW_REGISTRY.getCode());
            if (powRegistry != null) {
                registryTrait = powRegistry.getRegistryTrait();
                if (powRegistry.getPerson() == null) {
                    powRegistry.setRegistryTrait(null);
                }
                if (powRegistry.getEpisodes() != null) {
                    Set episodes = new HashSet();
                    try {
                        episodes = this.getMergeRuleService().mergeSets(powRegistry.getEpisodes(), episodes);
                    }
                    catch (ServiceException se) {
                        throw new RuleException("Unable to merge POW episodes", (Throwable)se);
                    }
                    Set incomingEpisodes = incomingPOW.getEpisodes() != null ? incomingPOW.getEpisodes() : new HashSet();
                    this.removeMatchedPOWEpisodes(episodes, incomingEpisodes);
                    if (!episodes.isEmpty()) {
                        resultPrisonerOfWar.addAllEpisodes(episodes);
                    }
                }
            }
            registryTrait = registryTrait == null ? this.createRegistryTrait(resultPerson, RegistryType.CODE_POW_REGISTRY.getCode()) : registryTrait;
            resultPrisonerOfWar.setRegistryTrait(registryTrait);
            try {
                if (powRegistry != null && powRegistry.getPerson() == null) {
                    this.delete(powRegistry.getEntityKey());
                }
            }
            catch (ServiceException se) {
                throw new RuleException("Unable to delete POW Registry", (Throwable)se);
            }
        }
    }

    @Override
    public boolean isUpdateFromGUI() {
        RegistryInputData registryInputData = this.getRegistryInputData();
        return registryInputData.isDataFromGUI();
    }

    private Set removeMatchedPOWEpisodes(Set episodes1, Set episodes2) {
        if (episodes1 != null && !episodes1.isEmpty() && episodes2 != null && !episodes2.isEmpty()) {
            Iterator it = episodes1.iterator();
            while (it.hasNext()) {
                POWEpisode episode = (POWEpisode)((Object)it.next());
                POWEpisode matchingEpisode = this.getMatchingPOWEpisode(episode, episodes2);
                if (matchingEpisode == null) continue;
                it.remove();
            }
        }
        return episodes1;
    }

    private POWEpisode getMatchingPOWEpisode(POWEpisode pOWEpisode, Set episodes) {
        if (pOWEpisode != null && episodes != null) {
            for (POWEpisode episode : episodes) {
                if (!this.match(pOWEpisode, episode)) continue;
                return episode;
            }
        }
        return null;
    }

    private boolean match(POWEpisode source, POWEpisode target) {
        EqualsBuilder builder = new EqualsBuilder();
        builder.append(((Object)((Object)source)).getClass(), ((Object)((Object)target)).getClass()).append((Object)source.getCaptureDate(), (Object)target.getCaptureDate()).append((Object)source.getReleaseDate(), (Object)target.getReleaseDate()).append((Object)source.getCampLocation(), (Object)target.getCampLocation());
        return builder.isEquals();
    }

    @Override
    public boolean isExactMatch() {
        return this.getRegistryInputData() != null ? this.getRegistryInputData().isExactMatch() : false;
    }

    @Override
    public boolean isPersonIdMatched() {
        return this.getRegistryInputData() != null ? this.getRegistryInputData().isExactMatchDifferentEpisode() : false;
    }

    @Override
    public boolean isAmbiguousMatch() {
        return this.getRegistryInputData() != null ? this.getRegistryInputData().isAmbiguousMatch() : false;
    }

    @Override
    public boolean isSameEpisode() {
        return this.getRegistryInputData() != null ? this.getRegistryInputData().isExactMatchSameEpisode() : false;
    }

    @Override
    public void setPersonId() {
    }

    @Override
    public void addRegistry() {
        this.updateRegistry();
    }

    @Override
    public void updateRegistry() {
        LoadRegistryResult lrr;
        try {
            String type = this.getRegistryType();
            if (RegistryType.CODE_PH_REGISTRY.getCode().equals(type)) {
                this.getMergeRuleService().mergeRegistry((PurpleHeart)this.getIncomingRegistry(), (PurpleHeart)this.getResultRegistry(), false);
            } else if (RegistryType.CODE_POW_REGISTRY.getCode().equals(type)) {
                this.getMergeRuleService().mergeRegistry((PrisonerOfWar)this.getIncomingRegistry(), (PrisonerOfWar)this.getResultRegistry(), false);
            } else if (RegistryType.CODE_SHAD_REGISTRY.getCode().equals(type)) {
                this.getMergeRuleService().mergeRegistry((SHAD)this.getIncomingRegistry(), (SHAD)this.getResultRegistry(), false);
            }
        }
        catch (ServiceException e) {
            this.logger.debug((Object)"Failed to merge registry", (Throwable)e);
            throw new RuntimeException("Failed to merge registry", e);
        }
        LoadRegistryResult loadRegistryResult = lrr = this.getRegistryInputData() != null ? this.getRegistryInputData().getLoadRegistryResult() : null;
        if (lrr != null && !lrr.isAmbiguousMatch() && !lrr.isExactMatchSameEpisode()) {
            lrr.setNewRegistry(true);
        }
    }

    @Override
    public void writeRegistryException(String exceptionType) {
        LoadRegistryResult loadRegistryResult;
        RegistryInputData rid = this.getRegistryInputData();
        if (exceptionType != null && rid != null && (loadRegistryResult = this.getRegistryInputData().getLoadRegistryResult()) != null) {
            try {
                loadRegistryResult.setExceptionType((ReportExceptionType)this.getLookupService().getByCode(ReportExceptionType.class, exceptionType));
            }
            catch (ServiceException e) {
                this.logger.error((Object)"Failed to find Indicator lookup", (Throwable)e);
                throw new RuntimeException("Failed to find Indicator lookup", e);
            }
        }
    }

    @Override
    public boolean getSHADIndicator() {
        SHAD shad = this.getSHAD();
        return shad != null && shad.getShadIndicator() != null && shad.getShadIndicator().toBoolean() != null ? shad.getShadIndicator().toBoolean() : false;
    }

    @Override
    public boolean getPristineSHADIndicator() {
        SHAD shad = this.getPristineSHAD();
        return shad != null && shad.getShadIndicator() != null && shad.getShadIndicator().toBoolean() != null ? shad.getShadIndicator().toBoolean() : false;
    }

    @Override
    public void setSHADIndicator(boolean indicator) {
        try {
            SHAD shad = this.getResultSHAD();
            if (shad != null) {
                String indCode = indicator ? Indicator.YES.getCode() : Indicator.NO.getCode();
                shad.setShadIndicator((Indicator)this.getLookupService().getByCode(Indicator.class, indCode));
            }
        }
        catch (ServiceException e) {
            this.logger.debug((Object)"Failed to find Indicator lookup", (Throwable)e);
            throw new RuntimeException("Failed to find Indicator lookup", e);
        }
    }

    @Override
    public String getSHADDocumentType() {
        SHADDocument shadDoc = this.getSHADDocument();
        return shadDoc != null && shadDoc.getDocumentType() != null ? shadDoc.getDocumentType().getCode() : null;
    }

    @Override
    public Date getSHADDocumentReceivedDate() {
        SHADDocument shadDoc = this.getSHADDocument();
        return shadDoc != null ? shadDoc.getReceivedDate() : null;
    }

    @Override
    public void addSHADRegistry() {
        try {
            this.getMergeRuleService().mergeRegistry(this.getSHAD(), this.getResultSHAD());
        }
        catch (ServiceException e) {
            this.logger.debug((Object)"Failed to merge SHAD registry", (Throwable)e);
            throw new RuntimeException("Failed to merge SHAD registry", e);
        }
    }

    @Override
    public void updateSHADRegistry() {
        try {
            this.getMergeRuleService().mergeRegistry(this.getSHAD(), this.getResultSHAD());
        }
        catch (ServiceException e) {
            this.logger.debug((Object)"Failed to merge SHAD registry", (Throwable)e);
            throw new RuntimeException("Failed to merge SHAD registry", e);
        }
    }

    @Override
    public void linkNewPersonSHADRegistry() throws RuleException {
        SHAD shadRegistry;
        Person resultPerson = this.getResultPerson();
        if (resultPerson != null && (shadRegistry = (SHAD)this.getUnlinkedRegistry(resultPerson, RegistryType.CODE_SHAD_REGISTRY.getCode())) != null && shadRegistry.getPerson() == null) {
            resultPerson.setShad(shadRegistry);
        }
    }

    @Override
    public void linkExistingPersonSHADRegistry() throws RuleException {
        SHAD shadRegistry;
        SHAD resultSHAD;
        Person resultPerson = this.getResultPerson();
        if (resultPerson != null && (resultSHAD = resultPerson.getShad()) != null && resultSHAD.getRegistryTrait() == null && (shadRegistry = (SHAD)this.getUnlinkedRegistry(resultPerson, RegistryType.CODE_SHAD_REGISTRY.getCode())) != null && shadRegistry.getPerson() == null) {
            resultPerson.setShad(shadRegistry);
        }
    }

    @Override
    public void linkPersonSHADRegistry() throws RuleException {
        SHAD resultShad;
        Person resultPerson = this.getResultPerson();
        SHAD sHAD = resultShad = resultPerson != null ? resultPerson.getShad() : null;
        if (resultShad != null && resultShad.getRegistryTrait() == null) {
            RegistryTrait registryTrait = null;
            SHAD shadRegistry = (SHAD)this.getUnlinkedRegistry(resultPerson, RegistryType.CODE_SHAD_REGISTRY.getCode());
            if (shadRegistry != null) {
                registryTrait = shadRegistry.getRegistryTrait();
                if (shadRegistry.getPerson() == null) {
                    shadRegistry.setRegistryTrait(null);
                }
                resultShad.setClaimNumber(shadRegistry.getClaimNumber());
                if (shadRegistry.getDocuments() != null) {
                    Set docs = new HashSet();
                    try {
                        docs = this.getMergeRuleService().mergeSets(shadRegistry.getDocuments(), docs);
                    }
                    catch (ServiceException se) {
                        throw new RuleException("Unable to merge SHAD documents", (Throwable)se);
                    }
                    if (!docs.isEmpty()) {
                        resultShad.addAllDocuments(docs);
                    }
                }
            }
            registryTrait = registryTrait == null ? this.createRegistryTrait(resultPerson, RegistryType.CODE_SHAD_REGISTRY.getCode()) : registryTrait;
            resultShad.setRegistryTrait(registryTrait);
            try {
                if (shadRegistry != null && shadRegistry.getPerson() == null) {
                    this.delete(shadRegistry.getEntityKey());
                }
            }
            catch (ServiceException se) {
                throw new RuleException("Unable to delete SHAD Registry", (Throwable)se);
            }
        }
    }

    public RegistryTrait createRegistryTrait(Person person, String registryType) throws RuleException {
        DeathRecord deathRecord;
        RegistryTrait registryTrait = new RegistryTrait();
        try {
            registryTrait.setRegistryType((RegistryType)this.getLookupService().getByCode(RegistryType.class, registryType));
        }
        catch (Exception ex) {
            throw new RuleException("Unable to look up registry type", (Throwable)ex);
        }
        SSN ssn = person.getOfficialSsn();
        registryTrait.setSsn(ssn != null ? ssn.getFormattedSsnText() : null);
        Name name = person.getLegalName();
        if (name != null) {
            registryTrait.setLastName(name.getFamilyName());
            registryTrait.setFirstName(name.getGivenName());
            registryTrait.setMiddleName(name.getMiddleName());
            registryTrait.setPrefix(name.getPrefix());
            registryTrait.setSuffix(name.getSuffix());
        }
        registryTrait.setDeathDate((deathRecord = person.getDeathRecord()) != null ? deathRecord.getDeathDate() : null);
        Set msns = person.getMilitaryServiceNumbers();
        Iterator iter = msns.iterator();
        while (iter.hasNext()) {
            RegistryTraitDetail traitDetail = new RegistryTraitDetail();
            traitDetail.setMilitaryServiceNumber((String)iter.next());
            registryTrait.addRegistryTraitDetail(traitDetail);
        }
        return registryTrait;
    }

    @Override
    public Person getIncomingPerson() {
        return this.getRegistryInputData() != null ? this.getRegistryInputData().getIncomingPerson() : null;
    }

    @Override
    public Person getResultPerson() {
        return this.getRegistryInputData() != null ? this.getRegistryInputData().getResultPerson() : null;
    }

    private void setPHDocumentDefaults(PurpleHeart ph) {
        if (ph != null && ph.getDocuments() != null) {
            for (PurpleHeartDocument doc : ph.getDocuments()) {
                if (doc == null || doc.getEntityKey() != null) continue;
                doc.setLoginDate(this.getCurrentDate());
                doc.setLoggedInUser(this.getLoggedInUser());
            }
        }
    }

    private void setPOWEpisodeDefaults(PrisonerOfWar pow) {
        if (pow != null && pow.getEpisodes() != null) {
            for (POWEpisode episode : pow.getEpisodes()) {
                if (episode == null || episode.getEntityKey() != null) continue;
                episode.setDateEntered(this.getCurrentDate());
            }
        }
    }

    private void delete(EntityKey entityKey) throws ServiceException {
        Validate.notNull((Object)entityKey.getKeyValue(), (String)"Entity Key Value can not be NULL");
        Validate.notNull((Object)entityKey.getEntityClass(), (String)"Entity Class can not be NULL");
        try {
            this.getRegistryDAO().removeObject(entityKey);
        }
        catch (DAOException ex) {
            throw new ServiceException("Error while retrieving entity of type: " + entityKey.getEntityClass().getName(), (Throwable)ex);
        }
    }

    @Override
    public PurpleHeart getPurpleHeart() {
        return StringUtils.equals((String)this.getRegistryType(), (String)RegistryType.CODE_PH_REGISTRY.getName()) ? (PurpleHeart)this.getRegistry() : null;
    }

    private PurpleHeart getResultPurpleHeart() {
        return StringUtils.equals((String)this.getRegistryType(), (String)RegistryType.CODE_PH_REGISTRY.getName()) ? (PurpleHeart)this.getResultRegistry() : null;
    }

    private PurpleHeart getPristinePurpleHeart() {
        return StringUtils.equals((String)this.getRegistryType(), (String)RegistryType.CODE_PH_REGISTRY.getName()) ? (PurpleHeart)this.getPristineRegistry() : null;
    }

    @Override
    public PrisonerOfWar getPrisonerOfWar() {
        return StringUtils.equals((String)this.getRegistryType(), (String)RegistryType.CODE_POW_REGISTRY.getName()) ? (PrisonerOfWar)this.getRegistry() : null;
    }

    private PrisonerOfWar getResultPrisonerOfWar() {
        return StringUtils.equals((String)this.getRegistryType(), (String)RegistryType.CODE_POW_REGISTRY.getName()) ? (PrisonerOfWar)this.getResultRegistry() : null;
    }

    private PrisonerOfWar getPristinePrisonerOfWar() {
        return StringUtils.equals((String)this.getRegistryType(), (String)RegistryType.CODE_POW_REGISTRY.getName()) ? (PrisonerOfWar)this.getPristineRegistry() : null;
    }

    @Override
    public SHAD getSHAD() {
        return StringUtils.equals((String)this.getRegistryType(), (String)RegistryType.CODE_SHAD_REGISTRY.getName()) ? (SHAD)this.getRegistry() : null;
    }

    private SHAD getResultSHAD() {
        return StringUtils.equals((String)this.getRegistryType(), (String)RegistryType.CODE_SHAD_REGISTRY.getName()) ? (SHAD)this.getResultRegistry() : null;
    }

    private SHAD getPristineSHAD() {
        return StringUtils.equals((String)this.getRegistryType(), (String)RegistryType.CODE_SHAD_REGISTRY.getName()) ? (SHAD)this.getPristineRegistry() : null;
    }

    @Override
    public RegistryTrait getRegistryTrait(Registry registry) {
        return registry != null ? registry.getRegistryTrait() : null;
    }

    private RegistryTrait getRegistryTrait() {
        Registry registry = this.getRegistry();
        return registry != null ? registry.getRegistryTrait() : null;
    }

    @Override
    public Registry getRegistry() {
        return this.getIncomingData() instanceof Registry ? (Registry)this.getIncomingData() : null;
    }

    private Registry getResultRegistry() {
        return this.getResultData() instanceof Registry ? (Registry)this.getResultData() : null;
    }

    private Registry getIncomingRegistry() {
        return this.getIncomingData() instanceof Registry ? (Registry)this.getIncomingData() : null;
    }

    private Registry getPristineRegistry() {
        return this.getPristineData() instanceof Registry ? (Registry)this.getPristineData() : null;
    }

    private PurpleHeartDocument getPHDocument() {
        return this.getDocument() instanceof PurpleHeartDocument ? (PurpleHeartDocument)this.getDocument() : null;
    }

    private POWEpisode getPOWEpisode() {
        return this.getDocument() instanceof POWEpisode ? (POWEpisode)this.getDocument() : null;
    }

    private SHADDocument getSHADDocument() {
        return this.getDocument() instanceof SHADDocument ? (SHADDocument)this.getDocument() : null;
    }

    private Document getDocument() {
        RuleDataAware ruleDataAware = this.getRuleDataAware();
        return ruleDataAware instanceof RegistryInputData ? ((RegistryInputData)ruleDataAware).getDocument() : null;
    }

    public void setRegistryDaoName(String registryDaoName) {
        this.registryDaoName = registryDaoName;
    }

    private RegistryDAO getRegistryDAO() throws ServiceException {
        return (RegistryDAO)this.getComponent(this.registryDaoName);
    }

    private Registry getUnlinkedRegistry(Person person, String registryType) throws RuleException {
        try {
            RegistryType regType = this.getRegistryTypeFromCode(registryType);
            if (person != null && regType != null) {
                return this.getRegistryDAO().getRegistry(person, regType);
            }
        }
        catch (Exception ex) {
            throw new RuleException("Error while getting the registry trait", (Throwable)ex);
        }
        return null;
    }

    private RegistryInputData getRegistryInputData() {
        RuleDataAware ruleDataAware = this.getRuleDataAware();
        if (ruleDataAware instanceof RegistryInputData) {
            return (RegistryInputData)ruleDataAware;
        }
        return null;
    }

    private RegistryType getRegistryTypeFromCode(String rType) throws RuleException {
        try {
            return (RegistryType)this.getLookupService().getByCode(RegistryType.class, rType);
        }
        catch (Exception ex) {
            throw new RuleException("Error while getting the RegistryType lookup for code = " + rType);
        }
    }
}

