/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.rule.parameter;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.infra.PreciseDateUtils;
import gov.va.med.esr.common.model.ee.MilitaryService;
import gov.va.med.esr.common.model.ee.MilitaryServiceSiteRecord;
import gov.va.med.esr.common.model.ee.POWEpisode;
import gov.va.med.esr.common.model.ee.PrisonerOfWar;
import gov.va.med.esr.common.model.lookup.PrisonerOfWarLocation;
import gov.va.med.esr.common.model.lookup.RegistryType;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.registry.Registry;
import gov.va.med.esr.common.persistent.registry.RegistryDAO;
import gov.va.med.esr.common.rule.PrisonerOfWarInput;
import gov.va.med.esr.common.rule.data.POWInputData;
import gov.va.med.esr.common.rule.parameter.BaseParameter;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.rule.RuleException;
import gov.va.med.fw.service.ServiceException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang.ObjectUtils;

public class PrisonerOfWarInputParameter
extends BaseParameter
implements PrisonerOfWarInput {
    private POWEpisode powEpisode = null;
    private String registryDaoName = null;
    private static final long serialVersionUID = -5430350191946923167L;

    @Override
    public boolean isPrisonerOfWarRecordDiscrepant() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"+isPrisonerOfWarRecordDiscrepant");
        }
        PrisonerOfWar incoming = this.getPrisonerOfWar(this.getIncomingPerson());
        PrisonerOfWar onFile = this.getPrisonerOfWar(this.getPristinePerson());
        Iterator iterIncoming = incoming != null ? incoming.getEpisodes().iterator() : null;
        POWInputData data = this.getPOWInputData();
        if (iterIncoming != null) {
            while (iterIncoming.hasNext()) {
                POWEpisode incomingPOWEpisode = (POWEpisode)((Object)iterIncoming.next());
                if (data != null) {
                    data.setPowEpisode(incomingPOWEpisode);
                }
                if (incomingPOWEpisode.getConfinementLocation() == null) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)"confinement location is null");
                    }
                    return true;
                }
                Iterator iterOnFile = onFile != null ? onFile.getEpisodes().iterator() : null;
                if (iterOnFile == null) continue;
                while (iterOnFile.hasNext()) {
                    POWEpisode onFilePOWEpisode = (POWEpisode)((Object)iterOnFile.next());
                    if (incomingPOWEpisode.getConfinementLocation().equals((Object)onFilePOWEpisode.getConfinementLocation())) {
                        if (ObjectUtils.equals((Object)incomingPOWEpisode.getCaptureDate(), (Object)onFilePOWEpisode.getCaptureDate()) && ObjectUtils.equals((Object)incomingPOWEpisode.getReleaseDate(), (Object)onFilePOWEpisode.getReleaseDate())) {
                            return false;
                        }
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)"start date or end date is discrepant");
                        }
                        return true;
                    }
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)"confinement location is discrepant");
                }
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"-isPrisonerOfWarRecordDiscrepant");
        }
        return true;
    }

    @Override
    public Boolean getPrisonerOfWarIndicator() {
        return this.getPrisonerOfWarIndicator(this.getIncomingPerson());
    }

    @Override
    public Boolean getPrisonerOfWarIndicator(Person person) {
        PrisonerOfWar pow;
        PrisonerOfWar prisonerOfWar = pow = person != null ? this.getPrisonerOfWar(person) : null;
        if (pow != null && pow.getPowIndicator() != null && pow.getPowIndicator().toBoolean() != null) {
            return pow.getPowIndicator().toBoolean();
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean getVeteranPrisonerOfWarIndicator() {
        return this.getPrisonerOfWarIndicator(this.getPristinePerson());
    }

    @Override
    public String getPOWIndicatorCode() {
        PrisonerOfWar pow = this.getPrisonerOfWar(this.getIncomingPerson());
        if (pow != null && pow.getPowIndicator() != null) {
            return pow.getPowIndicator().getCode();
        }
        return null;
    }

    @Override
    public String getVeteranPOWIndicatorCode() {
        PrisonerOfWar pow = this.getPrisonerOfWar(this.getPristinePerson());
        if (pow != null && pow.getPowIndicator() != null) {
            return pow.getPowIndicator().getCode();
        }
        return null;
    }

    @Override
    public boolean isPrisonerOfWarIndicatorChanged() throws RuleException {
        boolean result = this.getPrisonerOfWarIndicator(this.getResultPerson());
        boolean prior = this.getPrisonerOfWarIndicator(this.getPristinePerson());
        return prior != result;
    }

    @Override
    public void updatePrisonerOfWar() throws RuleException {
        try {
            PrisonerOfWar pow = this.getPrisonerOfWar(this.getIncomingPerson());
            if (pow != null) {
                Set episodes = pow.getEpisodes();
                for (POWEpisode powe : episodes) {
                    Integer days = null;
                    if (powe.getCaptureDate() != null && powe.getCaptureDate().isPrecise() && powe.getReleaseDate() != null && powe.getReleaseDate().isPrecise()) {
                        days = this.calculateCaptivityDays(powe.getCaptureDate().getDate(), powe.getReleaseDate().getDate());
                    }
                    powe.setNumberOfDaysInCaptivity(days);
                    if (powe.getDateEntered() != null) continue;
                    powe.setDateEntered(this.getCurrentDate());
                }
            }
            this.getMergeRuleService().mergePrisonerOfWar(pow, this.getResultPerson());
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to merge prisoner of war record", (Throwable)e);
        }
    }

    @Override
    public Integer calculateCaptivityDays() {
        return null;
    }

    public Integer calculateCaptivityDays(Date capture, Date release) {
        if (capture != null && release != null) {
            Calendar captureCalendar = Calendar.getInstance();
            captureCalendar.setTime(capture);
            Calendar releaseCalendar = Calendar.getInstance();
            releaseCalendar.setTime(release);
            return new Integer(PreciseDateUtils.getDays(captureCalendar, releaseCalendar).intValue());
        }
        return null;
    }

    @Override
    public EntityKey getPOWEntityKey() {
        PrisonerOfWar prisonerOfWar = this.getPrisonerOfWar(this.getIncomingPerson());
        return prisonerOfWar != null ? prisonerOfWar.getEntityKey() : null;
    }

    @Override
    public EntityKey getPristinePOWEntityKey() {
        PrisonerOfWar pristine = this.getPrisonerOfWar(this.getPristinePerson());
        return pristine != null ? pristine.getEntityKey() : null;
    }

    public POWEpisode getIncomingPOWEpisode() {
        if (this.powEpisode == null && this.getPOWInputData() != null) {
            this.powEpisode = this.getPOWInputData().getPowEpisode();
        }
        return this.powEpisode;
    }

    public String getPristineConfirmedStatus() {
        return null;
    }

    @Override
    public void removePOWRecord() {
        this.getResultPerson().setPrisonerOfWar(null);
    }

    @Override
    public void setCapitivityDays(Integer days) {
    }

    @Override
    public ImpreciseDate getCaptureDate() {
        POWEpisode powe = this.getIncomingPOWEpisode();
        return powe != null ? powe.getCaptureDate() : null;
    }

    @Override
    public String getConfinementLocation() {
        POWEpisode powe = this.getIncomingPOWEpisode();
        PrisonerOfWarLocation prisonerOfWarLocation = powe != null ? powe.getConfinementLocation() : null;
        return prisonerOfWarLocation != null ? prisonerOfWarLocation.getCode() : null;
    }

    @Override
    public ImpreciseDate getReleaseDate() {
        POWEpisode powe = this.getIncomingPOWEpisode();
        return powe != null ? powe.getReleaseDate() : null;
    }

    @Override
    public Boolean getPriorPrisonerOfWarIndicator() throws RuleException {
        PrisonerOfWar pow;
        Person priorPerson = this.getPriorEEPerson();
        if (priorPerson != null && (pow = this.getPrisonerOfWar(priorPerson)) != null && pow.getPowIndicator() != null) {
            return pow.getPowIndicator().toBoolean();
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean isCaptureAndReleaseDateswithinMSE() throws RuleException {
        return Boolean.TRUE;
    }

    @Override
    public Registry getPOWRegistry(Person person) throws RuleException {
        try {
            if (person != null) {
                RegistryType registryType = (RegistryType)this.getLookupService().getByCode(RegistryType.class, RegistryType.CODE_POW_REGISTRY.getCode());
                return this.getRegistryDAO().getRegistry(person, registryType);
            }
        }
        catch (Exception ex) {
            throw new RuleException("Error while getting the registry", (Throwable)ex);
        }
        return null;
    }

    private Set getMilitrayServiceEpisodes(Person person) {
        MilitaryService ms = person.getMilitaryService();
        HashSet mse = new HashSet();
        if (ms != null) {
            for (MilitaryServiceSiteRecord msHECRecord : ms.getMilitaryServiceSiteRecords()) {
                if (msHECRecord == null) continue;
                mse.addAll(msHECRecord.getMilitaryServiceEpisodes());
            }
        }
        return mse;
    }

    private boolean isInRange(Date date, Date lower_range, Date upper_range) {
        return !(!date.equals(lower_range) && !date.after(lower_range) || !date.equals(upper_range) && !date.before(upper_range));
    }

    private PrisonerOfWar getPrisonerOfWar(Person person) {
        return person.getPrisonerOfWar();
    }

    public void setRegistryDaoName(String registryDaoName) {
        this.registryDaoName = registryDaoName;
    }

    private RegistryDAO getRegistryDAO() throws ServiceException {
        return (RegistryDAO)this.getComponent(this.registryDaoName);
    }

    @Override
    public boolean isVOA() {
        return this.getSendingFacility() != null && VAFacility.CODE_MHV.getCode().equals(this.getSendingFacility().getCode());
    }
}

