/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.rule.parameter;

import gov.va.med.esr.common.model.ee.MedicaidFactor;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.rule.MedicaidInput;
import gov.va.med.esr.common.rule.parameter.BaseParameter;
import gov.va.med.fw.service.ServiceException;
import java.util.Date;

public class MedicaidInputParameter
extends BaseParameter
implements MedicaidInput {
    private static final long serialVersionUID = 1607147494117646390L;

    @Override
    public MedicaidFactor getMedicaidFactor() {
        return this.getMedicaidFactor(this.getIncomingPerson());
    }

    @Override
    public MedicaidFactor getResultMedicaidFactor() {
        return this.getMedicaidFactor(this.getResultPerson());
    }

    @Override
    public boolean isEligibleForMedicaid() {
        return this.isEligibleForMedicaid(this.getIncomingPerson());
    }

    @Override
    public Date getDateMedicaidLastUpdated() {
        MedicaidFactor medicaidFactor = this.getMedicaidFactor(this.getIncomingPerson());
        return medicaidFactor != null ? medicaidFactor.getLastUpdateDate() : null;
    }

    @Override
    public Date getResultDateMedicaidLastUpdated() {
        MedicaidFactor medicaidFactor = this.getMedicaidFactor(this.getResultPerson());
        return medicaidFactor != null ? medicaidFactor.getLastUpdateDate() : null;
    }

    @Override
    public boolean isResultEligibleForMedicaid() {
        return this.isEligibleForMedicaid(this.getResultPerson());
    }

    @Override
    public void updateMedicaidFacotr() {
        MedicaidFactor incoming = this.getMedicaidFactor();
        if (incoming != null) {
            MedicaidFactor medicaidFactor = this.getResultMedicaidFactor();
            if (medicaidFactor == null) {
                medicaidFactor = new MedicaidFactor();
                this.getResultPerson().setMedicaidFactor(medicaidFactor);
            }
            try {
                this.getMergeRuleService().mergeMedicaidFactor(incoming, medicaidFactor);
            }
            catch (ServiceException ex) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }
    }

    @Override
    public boolean isEligibleForMedicaid(Person person) {
        MedicaidFactor medicaidFactor = this.getMedicaidFactor(person);
        return medicaidFactor != null && medicaidFactor.isEligibleForMedicaid() != null ? medicaidFactor.isEligibleForMedicaid() : false;
    }

    private MedicaidFactor getMedicaidFactor(Person person) {
        return person != null ? person.getMedicaidFactor() : null;
    }

    @Override
    public boolean isEligibleForMedicaidChanged() {
        MedicaidFactor incomingMedicaidFactor = this.getMedicaidFactor(this.getIncomingPerson());
        MedicaidFactor PristineMedicaidFactor = this.getMedicaidFactor(this.getPristinePerson());
        if (incomingMedicaidFactor != null && PristineMedicaidFactor != null) {
            return !this.isEqual((Object)incomingMedicaidFactor, (Object)PristineMedicaidFactor);
        }
        if (incomingMedicaidFactor == null && PristineMedicaidFactor == null) {
            return false;
        }
        return incomingMedicaidFactor == null && PristineMedicaidFactor != null && PristineMedicaidFactor.getEligibleForMedicaid() != false || incomingMedicaidFactor != null && PristineMedicaidFactor == null && incomingMedicaidFactor.getEligibleForMedicaid() != false;
    }
}

