/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.rule.parameter;

import gov.va.med.esr.common.infra.ImpreciseDateUtils;
import gov.va.med.esr.common.model.insurance.InsurancePlan;
import gov.va.med.esr.common.model.insurance.InsurancePolicy;
import gov.va.med.esr.common.model.insurance.InsuranceSubscriber;
import gov.va.med.esr.common.model.insurance.Medicare;
import gov.va.med.esr.common.model.insurance.PrivateInsurance;
import gov.va.med.esr.common.model.lookup.InsuranceReportSource;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.rule.InsuranceInput;
import gov.va.med.esr.common.rule.data.InsuranceInputData;
import gov.va.med.esr.common.rule.parameter.BaseParameter;
import gov.va.med.esr.common.rule.service.MatchRuleService;
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.rule.RuleDataAware;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.StringUtils;
import java.util.Date;
import java.util.Set;

public class InsuranceInputParameter
extends BaseParameter
implements InsuranceInput {
    private static final long serialVersionUID = -4434696672458757518L;
    private InsurancePolicy policy = null;
    private PrivateInsurance privateInsurance = null;
    private Medicare medicare = null;
    private String medicareClaimNumber = null;
    private String nameOnMedicareCard = null;
    private Boolean enrolledInPartA = null;
    private Boolean enrolledInPartB = null;
    private Date partAEffectiveDate = null;
    private Date partBEffectiveDate = null;
    private String relationshipToInsured = null;
    private String nameOfInsure = null;
    private String reportSource = null;
    private String insurancePolicyType = null;
    private AbstractKeyedEntity updatedEntity = null;

    @Override
    public Date getInsuranceEffectiveDate() {
        return this.getPrivateInsurance() != null && this.getPrivateInsurance().getPolicyEffectiveDate() != null ? ImpreciseDateUtils.getDateWithDefault(this.getPrivateInsurance().getPolicyEffectiveDate()) : null;
    }

    @Override
    public Date getInsuranceExpirationDate() {
        return this.getPrivateInsurance() != null && this.getPrivateInsurance().getPolicyExpirationDate() != null ? ImpreciseDateUtils.getDateWithDefault(this.getPrivateInsurance().getPolicyExpirationDate()) : null;
    }

    @Override
    public String getMedicareClaimNumber() {
        if (this.medicareClaimNumber == null) {
            Medicare medicare = this.getMedicare();
            this.medicareClaimNumber = medicare != null ? medicare.getMedicareClaimNumber() : null;
        }
        return this.medicareClaimNumber;
    }

    @Override
    public String getNameOnMedicareCard() {
        if (this.nameOnMedicareCard == null) {
            Medicare medicare = this.getMedicare();
            this.nameOnMedicareCard = medicare != null ? medicare.getNameOnMedicareCard() : null;
        }
        return this.nameOnMedicareCard;
    }

    @Override
    public boolean getEnrolledInPartA() {
        if (this.enrolledInPartA == null) {
            Medicare medicare = this.getMedicare();
            this.enrolledInPartA = medicare != null ? medicare.isEnrolledInPartA() : Boolean.FALSE;
        }
        return this.enrolledInPartA;
    }

    @Override
    public boolean getEnrolledInPartB() {
        if (this.enrolledInPartB == null) {
            Medicare medicare = this.getMedicare();
            this.enrolledInPartB = medicare != null ? medicare.isEnrolledInPartB() : Boolean.FALSE;
        }
        return this.enrolledInPartB != null ? this.enrolledInPartB : false;
    }

    @Override
    public Date getPartAEffectiveDate() {
        return this.getMedicare() != null && this.getMedicare().getPartAEffectiveDate() != null ? ImpreciseDateUtils.getDateWithDefault(this.getMedicare().getPartAEffectiveDate()) : null;
    }

    @Override
    public Date getPartBEffectiveDate() {
        return this.getMedicare() != null && this.getMedicare().getPartBEffectiveDate() != null ? ImpreciseDateUtils.getDateWithDefault(this.getMedicare().getPartBEffectiveDate()) : null;
    }

    @Override
    public boolean isInsurancePolicyTypeForMedicare() {
        return this.getMedicare() != null;
    }

    @Override
    public String getRelationshipToInsured() {
        InsurancePolicy policy;
        if (this.relationshipToInsured == null && (policy = this.getInsuranceInputData().getIncomingInsurancePolicy()) != null) {
            InsuranceSubscriber subscriber = policy.getSubscriber();
            this.relationshipToInsured = subscriber != null && subscriber.getRelationship() != null ? subscriber.getRelationship().getCode() : null;
        }
        return this.relationshipToInsured;
    }

    @Override
    public String getNameOfInsured() {
        InsurancePolicy policy;
        if (this.nameOfInsure == null && (policy = this.getInsuranceInputData().getIncomingInsurancePolicy()) != null) {
            InsuranceSubscriber subscriber = policy.getSubscriber();
            this.nameOfInsure = subscriber != null ? subscriber.getName() : null;
        }
        return StringUtils.isEmpty((String)this.nameOfInsure) ? null : this.nameOfInsure;
    }

    @Override
    public void setNameOfInsured(String name) {
        InsurancePolicy policy = this.getInsurancePolicy();
        if (policy != null && policy.getSubscriber() != null) {
            InsuranceSubscriber subscriber = policy.getSubscriber();
            subscriber.setName(name);
            this.nameOfInsure = name;
        }
    }

    @Override
    public void setInsuranceCompanyName(String name) {
        InsurancePolicy policy = this.getInsurancePolicy();
        if (policy != null) {
            policy.setCompanyName(name);
        }
    }

    @Override
    public void setGroupNumber(String groupNumber) {
        InsurancePolicy policy = this.getInsuranceInputData().getIncomingInsurancePolicy();
        if (policy != null) {
            policy.setGroupNumber(groupNumber);
        }
    }

    @Override
    public void setGroupName(String groupName) {
        InsurancePolicy policy = this.getInsuranceInputData().getIncomingInsurancePolicy();
        if (policy != null) {
            policy.setGroupName(groupName);
        }
    }

    @Override
    public void setEnrolledInMedicarePartA(boolean flag) {
        Medicare policy = this.getMedicare();
        if (policy != null) {
            policy.setEnrolledInPartA(flag);
            this.enrolledInPartA = flag;
        }
    }

    @Override
    public void setEnrolledInMedicarePartB(boolean flag) {
        Medicare policy = this.getMedicare();
        if (policy != null) {
            policy.setEnrolledInPartB(flag);
            this.enrolledInPartB = flag;
        }
    }

    @Override
    public String getInsuranceReportSource() {
        InsurancePolicy policy;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("A report source's code is " + this.reportSource));
        }
        if (this.reportSource == null && (policy = this.getInsuranceInputData().getIncomingInsurancePolicy()) != null) {
            InsuranceReportSource source = policy.getReportSource();
            this.reportSource = source != null ? source.getCode() : null;
        }
        return this.reportSource;
    }

    @Override
    public boolean isInsurancePolicyOnFile() {
        boolean newRecord = false;
        InsurancePolicy incoming = this.getInsurancePolicy();
        if (this.isUpdateFromGUI() && (this.getSendingFacility() == null || !VAFacility.CODE_MHV.getCode().equals(this.getSendingFacility().getCode()))) {
            InsurancePolicy onFilePolicy = incoming.getEntityKey() != null ? this.getPristinePerson().getInsuranceByEntityKey(incoming.getEntityKey()) : null;
            newRecord = onFilePolicy != null;
        } else {
            boolean bl = newRecord = this.getResultInsurancePolicy() != null;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Is this a new reccord ? " + newRecord));
        }
        return newRecord;
    }

    @Override
    public void mergeInsurancePolicy() {
        try {
            InsurancePolicy incoming = this.getInsurancePolicy();
            this.updatedEntity = this.getMergeRuleService().mergeInsurancePolicy(incoming, this.getResultPerson());
        }
        catch (ServiceException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Failed to merge an insurance policy", (Throwable)e);
            }
            throw new RuntimeException("Failed to merge an insurance policy", e);
        }
    }

    @Override
    public void addInsurancePolicy() {
        InsurancePolicy incoming = this.getInsurancePolicy();
        if (incoming != null) {
            try {
                InsurancePolicy newPolicy = (InsurancePolicy)incoming.getClass().newInstance();
                newPolicy = this.getMergeRuleService().mergeInsurancePolicy(incoming, newPolicy);
                this.getResultPerson().addInsurance(newPolicy);
            }
            catch (Exception ex) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Failed to merge new insurance policy", (Throwable)ex);
                }
                throw new RuntimeException("Failed to merge new insurance policy", ex);
            }
        }
    }

    @Override
    public String getInsurancePolicyType() {
        if (this.insurancePolicyType == null) {
            InsurancePolicy incoming = this.getInsurancePolicy();
            InsurancePlan plan = incoming.getInsurancePlan();
            this.insurancePolicyType = plan != null ? plan.getPlanType().getCode() : null;
        }
        return this.insurancePolicyType;
    }

    @Override
    public String getAddressZipCode() {
        InsurancePolicy incoming = this.getInsurancePolicy();
        if (incoming != null && incoming.getAddress() != null) {
            return incoming.getAddress().getZipCode();
        }
        return null;
    }

    @Override
    public String getPristineAddressZipCode() {
        InsurancePolicy onFilePolicy;
        InsurancePolicy incoming = this.getInsurancePolicy();
        if (this.isUpdateFromGUI() && incoming.getEntityKey() != null && (onFilePolicy = this.getPristinePerson().getInsuranceByEntityKey(incoming.getEntityKey())) != null && onFilePolicy.getAddress() != null) {
            return onFilePolicy.getAddress().getZipCode();
        }
        return null;
    }

    private PrivateInsurance getPrivateInsurance() {
        if (this.privateInsurance == null) {
            this.privateInsurance = this.getInsuranceInputData() != null ? this.getInsuranceInputData().getIncomingPrivateInsurance() : null;
        }
        return this.privateInsurance;
    }

    private Medicare getMedicare() {
        if (this.medicare == null) {
            this.medicare = this.getInsuranceInputData() != null ? this.getInsuranceInputData().getIncomingMedicare() : null;
        }
        return this.medicare;
    }

    private InsurancePolicy getInsurancePolicy() {
        if (this.policy == null) {
            this.policy = this.getInsuranceInputData() != null ? this.getInsuranceInputData().getIncomingInsurancePolicy() : null;
        }
        return this.policy;
    }

    @Override
    public InsurancePolicy getResultInsurancePolicy() {
        InsurancePolicy incoming = this.getInsurancePolicy();
        if (incoming == null) {
            return null;
        }
        Set result = this.getResultPerson().getInsurances();
        MatchRuleService mrs = this.getMergeRuleService().getMatchRuleService();
        return (InsurancePolicy)mrs.findMatchingElement((AbstractEntity)incoming, result);
    }

    @Override
    public boolean isInsuranceAddressFound() {
        InsurancePolicy incoming = this.getInsurancePolicy();
        return incoming != null && incoming.getAddress() != null;
    }

    @Override
    public String getInsuranceCompanyName() {
        InsurancePolicy incoming = this.getInsurancePolicy();
        if (incoming != null && incoming.getCompanyName() != null) {
            return incoming.getCompanyName();
        }
        return null;
    }

    private InsuranceInputData getInsuranceInputData() {
        RuleDataAware ruleDataAware = this.getRuleDataAware();
        if (ruleDataAware instanceof InsuranceInputData) {
            return (InsuranceInputData)ruleDataAware;
        }
        return null;
    }

    @Override
    protected AbstractKeyedEntity getKeyedEntity() {
        return this.updatedEntity;
    }
}

