/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.rule.parameter;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.lookup.EmploymentStatus;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.person.Employment;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.rule.EmploymentInput;
import gov.va.med.esr.common.rule.parameter.BaseParameter;
import gov.va.med.fw.rule.RuleException;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.StringUtils;

public class EmploymentInputParameter
extends BaseParameter
implements EmploymentInput {
    private static final long serialVersionUID = -1613498691937118670L;

    @Override
    public Employment getEmployment() {
        return this.getEmployment(this.getIncomingPerson());
    }

    @Override
    public Employment getResultEmployment() {
        return this.getEmployment(this.getResultPerson());
    }

    @Override
    public Employment getPristineEmployment() {
        return this.getEmployment(this.getPristinePerson());
    }

    private Employment getEmployment(Person person) {
        return person != null ? person.getEmployment() : null;
    }

    @Override
    public String getEmployerName() {
        return this.getEmployerName(this.getEmployment());
    }

    @Override
    public String getPristineEmployerName() {
        return this.getEmployerName(this.getPristineEmployment());
    }

    @Override
    public String getEmployerName(Employment employment) {
        return employment != null ? employment.getEmployerName() : null;
    }

    @Override
    public EmploymentStatus getEmploymentStatus() {
        return this.getEmploymentStatus(this.getEmployment());
    }

    @Override
    public EmploymentStatus getPristineEmploymentStatus() {
        return this.getEmploymentStatus(this.getPristineEmployment());
    }

    @Override
    public EmploymentStatus getEmploymentStatus(Employment employment) {
        return employment != null ? employment.getEmploymentStatus() : null;
    }

    @Override
    public Address getEmployerAddress() {
        return this.getEmployerAddress(this.getEmployment());
    }

    @Override
    public Address getPristineEmployerAddress() {
        return this.getEmployerAddress(this.getPristineEmployment());
    }

    @Override
    public Address getEmployerAddress(Employment employment) {
        return employment != null ? employment.getEmployerAddress() : null;
    }

    @Override
    public ImpreciseDate getRetirementDate() {
        return this.getRetirementDate(this.getEmployment());
    }

    @Override
    public ImpreciseDate getPristineRetirementDate() {
        return this.getRetirementDate(this.getPristineEmployment());
    }

    @Override
    public ImpreciseDate getRetirementDate(Employment employment) {
        return employment != null ? employment.getRetirementDate() : null;
    }

    public String getEmployerPhone() {
        return this.getEmployerPhone(this.getEmployment());
    }

    @Override
    public String getPristineEmployerPhone() {
        return this.getEmployerPhone(this.getPristineEmployment());
    }

    @Override
    public String getEmployerPhone(Employment employment) {
        return employment != null ? employment.getEmployerPhone() : null;
    }

    @Override
    public String getEmployerAddressLineTwo() {
        return this.getEmployerAddressLineTwo(this.getEmployment());
    }

    @Override
    public String getEmployerAddressLineTwo(Employment employment) {
        if (employment != null) {
            Address address = employment.getEmployerAddress();
            return address != null ? address.getLine2() : null;
        }
        return null;
    }

    @Override
    public String getEmployerAddressLineThree() {
        return this.getEmployerAddressLineThree(this.getEmployment());
    }

    @Override
    public String getEmployerAddressLineThree(Employment employment) {
        if (employment != null) {
            Address address = employment.getEmployerAddress();
            return address != null ? address.getLine3() : null;
        }
        return null;
    }

    @Override
    public String getEmployerCity() {
        return this.getEmployerCity(this.getEmployment());
    }

    @Override
    public String getEmployerCity(Employment employment) {
        if (employment != null) {
            Address address = employment.getEmployerAddress();
            return address != null ? address.getCity() : null;
        }
        return null;
    }

    @Override
    public String getEmployerState() {
        return this.getEmployerState(this.getEmployment());
    }

    @Override
    public String getEmployerState(Employment employment) {
        if (employment != null) {
            Address address = employment.getEmployerAddress();
            return address != null ? address.getState() : null;
        }
        return null;
    }

    @Override
    public String getEmployerZipCode() {
        return this.getEmployerZipCode(this.getEmployment());
    }

    @Override
    public String getEmployerZipCode(Employment employment) {
        if (employment != null) {
            Address address = employment.getEmployerAddress();
            return address != null ? address.getZipCode() : null;
        }
        return null;
    }

    @Override
    public String getEmployerZipPlus4() {
        return this.getEmployerZipPlus4(this.getEmployment());
    }

    @Override
    public String getEmployerZipPlus4(Employment employment) {
        if (employment != null) {
            Address address = employment.getEmployerAddress();
            return address != null ? address.getZipPlus4() : null;
        }
        return null;
    }

    @Override
    public void setEmployerAddressLineTwo(Employment resultEmployment, Employment incomingEmployment) {
        if (incomingEmployment != null && resultEmployment != null) {
            Address incomingAddress = incomingEmployment.getEmployerAddress();
            Address resultAddress = resultEmployment.getEmployerAddress();
            if (incomingAddress != null) {
                if (resultAddress == null) {
                    resultAddress = new Address();
                }
                resultAddress.setLine2(incomingAddress.getLine2());
            }
        }
    }

    @Override
    public void setEmployerAddressLineThree(Employment resultEmployment, Employment incomingEmployment) {
        if (incomingEmployment != null && resultEmployment != null) {
            Address incomingAddress = incomingEmployment.getEmployerAddress();
            Address resultAddress = resultEmployment.getEmployerAddress();
            if (incomingAddress != null) {
                if (resultAddress == null) {
                    resultAddress = new Address();
                }
                resultAddress.setLine3(incomingAddress.getLine3());
            }
        }
    }

    @Override
    public void setEmployerCity(Employment resultEmployment, Employment incomingEmployment) {
        if (incomingEmployment != null && resultEmployment != null) {
            Address incomingAddress = incomingEmployment.getEmployerAddress();
            Address resultAddress = resultEmployment.getEmployerAddress();
            if (incomingAddress != null) {
                if (resultAddress == null) {
                    resultAddress = new Address();
                }
                resultAddress.setCity(incomingAddress.getCity());
            }
        }
    }

    @Override
    public void setEmployerState(Employment resultEmployment, Employment incomingEmployment) {
        if (incomingEmployment != null && resultEmployment != null) {
            Address incomingAddress = incomingEmployment.getEmployerAddress();
            Address resultAddress = resultEmployment.getEmployerAddress();
            if (incomingAddress != null) {
                if (resultAddress == null) {
                    resultAddress = new Address();
                }
                resultAddress.setState(incomingAddress.getState());
            }
        }
    }

    @Override
    public void setEmployerZipCode(Employment resultEmployment, Employment incomingEmployment) {
        if (incomingEmployment != null && resultEmployment != null) {
            Address incomingAddress = incomingEmployment.getEmployerAddress();
            Address resultAddress = resultEmployment.getEmployerAddress();
            if (incomingAddress != null) {
                if (resultAddress == null) {
                    resultAddress = new Address();
                }
                resultAddress.setZipCode(incomingAddress.getZipCode());
            }
        }
    }

    @Override
    public void setEmployerZipPlus4(Employment resultEmployment, Employment incomingEmployment) {
        if (incomingEmployment != null && resultEmployment != null) {
            Address incomingAddress = incomingEmployment.getEmployerAddress();
            Address resultAddress = resultEmployment.getEmployerAddress();
            if (incomingAddress != null) {
                if (resultAddress == null) {
                    resultAddress = new Address();
                }
                resultAddress.setZipPlus4(incomingAddress.getZipPlus4());
            }
        }
    }

    @Override
    public void setEmployerPhone(Employment resultEmployment, Employment incomingEmployment) {
        if (incomingEmployment != null) {
            if (resultEmployment == null) {
                resultEmployment = new Employment();
            }
            resultEmployment.setEmployerPhone(incomingEmployment.getEmployerPhone());
        }
    }

    @Override
    public void setOccupation(Employment resultEmployment, Employment incomingEmployment) {
        if (incomingEmployment != null) {
            if (resultEmployment == null) {
                resultEmployment = new Employment();
            }
            resultEmployment.setOccupation(incomingEmployment.getOccupation());
        }
    }

    public void setEmployerAddress(Employment incomingEmployment, Employment resultEmployment) {
        if (incomingEmployment != null) {
            if (resultEmployment == null) {
                resultEmployment = new Employment();
            }
            resultEmployment.setEmployerAddress(incomingEmployment.getEmployerAddress());
        }
    }

    public void setEmployerName(Employment resultEmployment, Employment incomingEmployment) {
        if (incomingEmployment != null) {
            if (resultEmployment == null) {
                resultEmployment = new Employment();
            }
            resultEmployment.setEmployerName(incomingEmployment.getEmployerName());
        }
    }

    @Override
    public void removeEmployment(Employment employment) {
        if (employment != null) {
            employment.setEmployerName(null);
            employment.setEmployerAddress(null);
            employment.setEmployerPhone(null);
            employment.setRetirementDate(null);
        }
    }

    @Override
    public void removeEmployment() {
        Employment employment = this.getResultEmployment();
        this.removeEmployment(employment);
    }

    @Override
    public void removeEmployerAddressLineTwo(Employment employment) {
        Address address;
        if (employment != null && (address = employment.getEmployerAddress()) != null) {
            address.setLine2(null);
        }
    }

    @Override
    public void removeEmployerAddressLineOne(Employment employment) {
        Address address;
        if (employment != null && (address = employment.getEmployerAddress()) != null) {
            address.setLine1(null);
        }
    }

    @Override
    public void removeEmployerAddressLineTwo() {
        Employment employment = this.getResultEmployment();
        this.removeEmployerAddressLineTwo(employment);
    }

    @Override
    public void removeEmployerAddressLineThree(Employment employment) {
        Address address;
        if (employment != null && (address = employment.getEmployerAddress()) != null) {
            address.setLine3(null);
        }
    }

    @Override
    public void removeEmployerAddressLineThree() {
        Employment employment = this.getResultEmployment();
        this.removeEmployerAddressLineThree(employment);
    }

    @Override
    public void removeEmployerCity(Employment employment) {
        Address address;
        if (employment != null && (address = employment.getEmployerAddress()) != null) {
            address.setCity(null);
        }
    }

    @Override
    public void removeEmployerCity() {
        Employment employment = this.getResultEmployment();
        this.removeEmployerCity(employment);
    }

    @Override
    public void removeEmployerState(Employment employment) {
        Address address;
        if (employment != null && (address = employment.getEmployerAddress()) != null) {
            address.setState(null);
        }
    }

    @Override
    public void removeEmployerState() {
        Employment employment = this.getResultEmployment();
        this.removeEmployerState(employment);
    }

    @Override
    public void removeEmployerZipCode(Employment employment) {
        Address address;
        if (employment != null && (address = employment.getEmployerAddress()) != null) {
            address.setZipCode(null);
        }
    }

    @Override
    public void removeEmployerZipCode() {
        Employment employment = this.getResultEmployment();
        this.removeEmployerZipCode(employment);
    }

    @Override
    public void removeEmployerZipPlus4(Employment employment) {
        Address address;
        if (employment != null && (address = employment.getEmployerAddress()) != null) {
            address.setZipPlus4(null);
        }
    }

    @Override
    public void removeEmployerZipPlus4() {
        Employment employment = this.getResultEmployment();
        this.removeEmployerZipPlus4(employment);
    }

    @Override
    public void removeEmployerPhone(Employment employment) {
        if (employment != null) {
            employment.setEmployerPhone(null);
        }
    }

    @Override
    public void removeEmployerPhone() {
        Employment employment = this.getResultEmployment();
        this.removeEmployerPhone(employment);
    }

    @Override
    public void removeDateOfRetirement(Employment employment) {
        if (employment != null) {
            employment.setRetirementDate(null);
        }
    }

    @Override
    public void removeDateOfRetirement() {
        Employment employment = this.getResultEmployment();
        this.removeDateOfRetirement(employment);
    }

    @Override
    public void updateEmployment() throws RuleException {
        Employment updated = this.getResultEmployment();
        Employment incoming = this.getEmployment();
        this.updateEmployment(updated, incoming);
    }

    @Override
    public void updateEmployment(Employment updated, Employment incoming) throws RuleException {
        if (updated != null && incoming != null) {
            try {
                this.getMergeRuleService().mergeEmployment(incoming, updated);
            }
            catch (ServiceException e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Failed to merge an employment " + (Object)((Object)e)));
                }
                throw new RuleException("Failed to merge an employment " + (Object)((Object)e));
            }
        }
    }

    @Override
    public void acceptEmploymentForTheVeteran() {
        try {
            Employment incoming = this.getEmployment();
            Employment resultEmployment = null;
            resultEmployment = this.isUpdateFromGUI() ? (incoming != null ? this.getResultPerson().getEmployment() : null) : this.getResultEmployment();
            if (resultEmployment != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Accept and merge employment " + incoming.toString()));
                }
                this.getMergeRuleService().mergeEmployment(incoming, resultEmployment);
            } else {
                this.addNewEmployment();
            }
        }
        catch (ServiceException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Failed to merge an employment", (Throwable)e);
            }
            throw new RuntimeException("Failed to merge an employment", e);
        }
    }

    @Override
    public void addNewEmployment() {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Accept and add a new employment " + this.getEmployment().toString()));
            }
            Employment newEmployment = new Employment();
            this.getMergeRuleService().mergeEmployment(this.getEmployment(), newEmployment);
            this.getResultPerson().setEmployment(newEmployment);
        }
        catch (ServiceException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Failed to add an employment", (Throwable)e);
            }
            throw new RuntimeException("Failed to add an employment", e);
        }
    }

    @Override
    public void acceptEmploymentForTheSpouse(Employment incoming, Employment resultEmployment) {
        try {
            resultEmployment = this.isUpdateFromGUI() ? (incoming != null ? resultEmployment : null) : this.getResultEmployment();
            if (resultEmployment != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Accept and merge employment " + incoming.toString()));
                }
                this.getMergeRuleService().mergeEmployment(incoming, resultEmployment);
            } else {
                this.addNewEmploymentForSpouse(incoming);
            }
        }
        catch (ServiceException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Failed to merge an employment", (Throwable)e);
            }
            throw new RuntimeException("Failed to merge an employment", e);
        }
    }

    @Override
    public void addNewEmploymentForSpouse(Employment incomingEmployment) {
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Accept and add a new employment " + this.getEmployment().toString()));
            }
            Employment newEmployment = new Employment();
            this.getMergeRuleService().mergeEmployment(incomingEmployment, newEmployment);
            Employment spouseEmployment = this.getResultPerson().getEmployment();
            if (spouseEmployment != null && spouseEmployment.getSpouse() != null) {
                spouseEmployment.getSpouse().setEmployment(newEmployment);
            }
        }
        catch (ServiceException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Failed to add an employment", (Throwable)e);
            }
            throw new RuntimeException("Failed to add an employment", e);
        }
    }

    @Override
    public boolean isEmploymentStatusUnknownOrNotEmployed() {
        Employment incomingEmployment = this.getEmployment();
        return this.isEmploymentStatusUnknownOrNotEmployed(incomingEmployment);
    }

    @Override
    public boolean isEmploymentStatusUnknownOrNotEmployed(Employment incomingEmployment) {
        EmploymentStatus employmentStatus = null;
        if (incomingEmployment != null) {
            employmentStatus = incomingEmployment.getEmploymentStatus();
        }
        if (employmentStatus == null) {
            return true;
        }
        return employmentStatus != null && (EmploymentStatus.CODE_UNKNOWN.getCode().equalsIgnoreCase(employmentStatus.getCode()) || EmploymentStatus.CODE_NOT_EMPLOYED.getCode().equalsIgnoreCase(employmentStatus.getCode()));
    }

    @Override
    public boolean isEmploymentAddressGroupAllNull(Employment incomingEmployment) {
        Address incomingaddress = null;
        if (incomingEmployment == null) {
            return true;
        }
        incomingaddress = incomingEmployment.getEmployerAddress();
        if (incomingaddress == null) {
            return true;
        }
        return incomingaddress.getLine1() == null && incomingaddress.getLine2() == null && incomingaddress.getLine3() == null && incomingaddress.getCity() == null && incomingaddress.getState() == null && incomingaddress.getZipCode() == null;
    }

    @Override
    public boolean isEmployerNameNotEqualtoESREmployerName(Employment incomingEmployment, Employment pristineEmployment) {
        String incomingEmployerName = null;
        String pristineEmployerName = null;
        if (incomingEmployment == null || pristineEmployment == null) {
            return false;
        }
        if (incomingEmployment != null) {
            incomingEmployerName = incomingEmployment.getEmployerName();
        }
        if (pristineEmployment != null) {
            pristineEmployerName = pristineEmployment.getEmployerName();
        }
        return incomingEmployerName != null && pristineEmployerName != null && !incomingEmployerName.equalsIgnoreCase(pristineEmployerName);
    }

    @Override
    public void deleteEmployerAddressGroup(Employment resultEmployment) {
        Address employerAddress = null;
        if (resultEmployment != null) {
            employerAddress = resultEmployment.getEmployerAddress();
            if (employerAddress != null) {
                employerAddress.setLine1(null);
                employerAddress.setLine2(null);
                employerAddress.setLine3(null);
                employerAddress.setCity(null);
                employerAddress.setState(null);
                employerAddress.setZipCode(null);
            }
            resultEmployment.setEmployerAddress(null);
        }
    }

    @Override
    public boolean isAddressLineTwoNull(Employment incomingEmployment) {
        Address employerAddress = null;
        if (incomingEmployment != null) {
            employerAddress = incomingEmployment.getEmployerAddress();
            if (employerAddress != null) {
                return employerAddress.getLine2() == null;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean isEmployerNameNotNull(Employment incomingEmployment) {
        String employerName = null;
        if (incomingEmployment != null) {
            employerName = incomingEmployment.getEmployerName();
            return employerName != null;
        }
        return false;
    }

    @Override
    public boolean isEmploymentStatusNotRetired(Employment incomingEmployment) {
        EmploymentStatus employmentStatus = null;
        if (incomingEmployment != null) {
            employmentStatus = incomingEmployment.getEmploymentStatus();
        }
        return employmentStatus != null && !EmploymentStatus.CODE_RETIRED.getCode().equalsIgnoreCase(employmentStatus.getCode());
    }

    @Override
    public String getEmploymentStatusCode(Employment employment) {
        return employment != null && employment.getEmploymentStatus() != null ? employment.getEmploymentStatus().getCode() : null;
    }

    @Override
    public String getEmployerAddressLineOne(Employment employment) {
        if (employment != null) {
            Address address = employment.getEmployerAddress();
            return address != null ? address.getLine1() : null;
        }
        return null;
    }

    @Override
    public boolean isIncomingMessageHasOccupation(Employment incomingEmployment) {
        return incomingEmployment != null && !StringUtils.isBlank((String)incomingEmployment.getOccupation());
    }
}

