/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.rule.parameter;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.infra.ImpreciseDateUtils;
import gov.va.med.esr.common.model.comms.CommsLogEntry;
import gov.va.med.esr.common.model.ee.MilitaryService;
import gov.va.med.esr.common.model.ee.MilitaryServiceEpisode;
import gov.va.med.esr.common.model.ee.MilitaryServiceSiteRecord;
import gov.va.med.esr.common.model.financials.DependentFinancials;
import gov.va.med.esr.common.model.financials.FinancialStatement;
import gov.va.med.esr.common.model.financials.PatientVisitSummary;
import gov.va.med.esr.common.model.financials.SpouseFinancials;
import gov.va.med.esr.common.model.lookup.AssociationType;
import gov.va.med.esr.common.model.lookup.CollectionMethod;
import gov.va.med.esr.common.model.lookup.DeathDataSource;
import gov.va.med.esr.common.model.lookup.PseudoSSNReason;
import gov.va.med.esr.common.model.lookup.SSAVerificationStatus;
import gov.va.med.esr.common.model.lookup.SSNType;
import gov.va.med.esr.common.model.lookup.SourceDesignation;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Association;
import gov.va.med.esr.common.model.person.DeathRecord;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.PreferredFacility;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.common.model.system.SystemParameter;
import gov.va.med.esr.common.rule.DemographicInput;
import gov.va.med.esr.common.rule.data.CommsInputData;
import gov.va.med.esr.common.rule.data.ExternalSystemsInputData;
import gov.va.med.esr.common.rule.data.PersonInputData;
import gov.va.med.esr.common.rule.parameter.BaseParameter;
import gov.va.med.esr.service.PSDelegateService;
import gov.va.med.esr.service.PersonService;
import gov.va.med.esr.service.PreferredFacilityService;
import gov.va.med.esr.service.external.demographics.DemographicsChangeType;
import gov.va.med.esr.service.trigger.LetterTriggerEvent;
import gov.va.med.fw.rule.RuleException;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.StringUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DemographicInputParameter
extends BaseParameter
implements DemographicInput {
    private static final long serialVersionUID = -750695891690076382L;
    private Date dateOfBirth = null;
    private Date dateOfDeath = null;
    private Date preferredLanguageEntryDate = null;
    private Date dateOfDeathReported = null;
    private String genderCode = null;
    private String ssn = null;
    private String patientName = null;
    private VAFacility preferredFacility = null;
    private static final String PSEUDO_SSN_REASON = "R";
    private static final String SSN_INVALID = "I";
    private static final Character KNOWN = Character.valueOf('1');
    private PSDelegateService psDelegateService = null;
    private PreferredFacilityService preferredFacilityService = null;
    private PersonService personService = null;

    @Override
    public DeathRecord getDeathRecord() {
        return this.getDeathRecord(this.getIncomingPerson());
    }

    @Override
    public Date getPristineDateOfDeath() {
        return this.getDateOfDeath(this.getPristinePerson());
    }

    @Override
    public Date getDateOfBirth() {
        if (this.dateOfBirth == null) {
            this.dateOfBirth = this.getDateOfBirth(this.getIncomingPerson());
        }
        return this.dateOfBirth;
    }

    @Override
    public Date getDateOfDeath() {
        if (this.dateOfDeath == null) {
            this.dateOfDeath = this.getDateOfDeath(this.getIncomingPerson());
        }
        return this.dateOfDeath;
    }

    @Override
    public Date getPreferredLanguageEntryDate() {
        if (this.preferredLanguageEntryDate == null && this.getIncomingPerson() != null && this.getIncomingPerson().getPreferredLanguage() != null) {
            this.preferredLanguageEntryDate = this.getIncomingPerson().getPreferredLanguage().getLanguageEntryDate();
        }
        return this.preferredLanguageEntryDate;
    }

    @Override
    public String getPristineSiteOfNotification() {
        DeathRecord deathRecord = this.getDeathRecord(this.getPristinePerson());
        return deathRecord != null && deathRecord.getFacilityReceived() != null ? deathRecord.getFacilityReceived().getName() : null;
    }

    @Override
    public Date getDateOfDeathReported() {
        if (this.dateOfDeathReported == null) {
            this.dateOfDeathReported = this.getDateOfDeathReported(this.getIncomingPerson());
        }
        return this.dateOfDeathReported;
    }

    @Override
    public String getSourceOfNotification() {
        DeathRecord deathRecord = this.getDeathRecord(this.getIncomingPerson());
        return deathRecord != null && deathRecord.getDataSource() != null ? deathRecord.getDataSource().getCode() : null;
    }

    @Override
    public void setSourceOfNotification(String deathSource) {
        DeathRecord resultDeathRecord = this.getDeathRecord(this.getResultPerson());
        if (resultDeathRecord != null && StringUtils.isNotEmpty((String)deathSource)) {
            try {
                DeathDataSource dataSource = (DeathDataSource)this.getLookupService().getByCode(DeathDataSource.class, deathSource);
                resultDeathRecord.setDataSource(dataSource);
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to get VBA DeathDataSource", ex);
            }
        }
    }

    @Override
    public String getSiteOfNotification() {
        DeathRecord deathRecord = this.getDeathRecord(this.getIncomingPerson());
        return deathRecord != null && deathRecord.getFacilityReceived() != null ? deathRecord.getFacilityReceived().getName() : null;
    }

    @Override
    public boolean isDOBPlus15AfterMilitaryServiceServiceEntryDate() {
        Date dobPlus15 = this.getDateOf15thBirthday();
        if (dobPlus15 == null) {
            return false;
        }
        MilitaryService militaryService = this.getIncomingPerson().getMilitaryService();
        if (militaryService == null || militaryService.getHECMilitaryServiceSiteRecord() == null) {
            return false;
        }
        Set MSEs = militaryService.getHECMilitaryServiceSiteRecord().getMilitaryServiceEpisodes();
        for (MilitaryServiceEpisode mse : MSEs) {
            Date mseStartDate = mse.getStartDate() != null ? ImpreciseDateUtils.getDateWithDefault(mse.getStartDate()) : null;
            if (!this.isAfter(dobPlus15, mseStartDate)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDODBeforeMilitaryServiceServiceEntryDate() {
        Set siteRecords;
        Date dod = this.getDateOfDeath();
        MilitaryService militaryService = this.getIncomingPerson().getMilitaryService();
        Set set = siteRecords = militaryService != null ? militaryService.getMilitaryServiceSiteRecords() : null;
        if (dod == null || siteRecords == null || siteRecords.isEmpty()) {
            return false;
        }
        for (MilitaryServiceSiteRecord siteRecord : siteRecords) {
            if (siteRecord == null) continue;
            Set MSEs = siteRecord.getMilitaryServiceEpisodes();
            for (MilitaryServiceEpisode mse : MSEs) {
                Date mseStartDate = mse.getStartDate() != null ? ImpreciseDateUtils.getDateWithDefault(mse.getStartDate()) : null;
                if (!this.isBefore(dod, mseStartDate)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isDODBeforeMilitaryServiceServiceSeparationDate() {
        Set siteRecords;
        Date dod = this.getDateOfDeath();
        MilitaryService militaryService = this.getIncomingPerson().getMilitaryService();
        Set set = siteRecords = militaryService != null ? militaryService.getMilitaryServiceSiteRecords() : null;
        if (dod == null || siteRecords == null || siteRecords.isEmpty()) {
            return false;
        }
        for (MilitaryServiceSiteRecord siteRecord : siteRecords) {
            if (siteRecord == null) continue;
            Set MSEs = siteRecord.getMilitaryServiceEpisodes();
            for (MilitaryServiceEpisode mse : MSEs) {
                Date mseEndDate = mse.getEndDate() != null ? ImpreciseDateUtils.getDateWithDefault(mse.getEndDate()) : null;
                if (!this.isBefore(dod, mseEndDate)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void updateDeathRecord(DeathRecord deathRecord) throws RuleException {
        if (deathRecord == null) {
            this.removeDeathRecord();
            return;
        }
        try {
            DeathRecord resultDeathRecord;
            if (deathRecord.getDeathDate() != null) {
                deathRecord.setLazarusDate(null);
            }
            if ((resultDeathRecord = this.getDeathRecord(this.getResultPerson())) == null) {
                resultDeathRecord = new DeathRecord();
                this.setDeathRecord(resultDeathRecord);
            }
            this.getMergeRuleService().mergeDeathRecord(deathRecord, resultDeathRecord);
        }
        catch (ServiceException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Failed to merge death record", (Throwable)e);
            }
            throw new RuntimeException("Failed to merge death record", e);
        }
    }

    @Override
    public void setDateOfDeathReported(Date date) {
        DeathRecord resultDeathRecord = this.getDeathRecord(this.getResultPerson());
        if (resultDeathRecord != null) {
            resultDeathRecord.setDeathReportDate(date);
        }
    }

    @Override
    public String getGenderCode() {
        if (this.genderCode == null) {
            this.genderCode = this.getGenderCode(this.getIncomingPerson());
        }
        return this.genderCode;
    }

    @Override
    public String getPristineGenderCode() {
        return this.getGenderCode(this.getPristinePerson());
    }

    @Override
    public String getLastName() {
        Name legalName = this.getLegalName(this.getIncomingPerson());
        return legalName != null ? legalName.getFamilyName() : null;
    }

    @Override
    public Association getNextOfKin() {
        Association primaryNok = Association.getAssociationOfType(this.getIncomingPerson().getAssociations(), AssociationType.CODE_PRIMARY_NEXT_OF_KIN.getCode());
        return primaryNok;
    }

    @Override
    public String getNokFirstName() {
        Association nok = this.getNextOfKin();
        return nok != null ? nok.getFirstName() : null;
    }

    @Override
    public String getNokLastName() {
        Association nok = this.getNextOfKin();
        return nok != null ? nok.getLastName() : null;
    }

    @Override
    public String getSSN() {
        if (this.ssn == null) {
            this.ssn = this.getSSN(this.getIncomingPerson());
        }
        return this.ssn;
    }

    @Override
    public boolean isDateInFuture(Date adate) {
        Date today = Calendar.getInstance().getTime();
        return this.isAfter(adate, today);
    }

    @Override
    public Date getDateOf15thBirthday() {
        Date birthDate = this.getDateOfBirth(this.getIncomingPerson());
        Date fifteenthBirthday = null;
        if (birthDate != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(birthDate);
            int year = calendar.get(1);
            calendar.set(1, year += 15);
            fifteenthBirthday = calendar.getTime();
        }
        return fifteenthBirthday;
    }

    @Override
    public boolean isDeathRecordDeleted() {
        return this.getDateOfDeath(this.getPristinePerson()) != null && this.getDateOfDeath(this.getIncomingPerson()) == null;
    }

    @Override
    public boolean isVOAApplicantKnownToES() {
        return this.getIncomingPerson().getVOAIndicator() == null || KNOWN.equals(this.getIncomingPerson().getVOAIndicator());
    }

    @Override
    public void removeDeathRecord() throws RuleException {
        DeathRecord deathRecord = this.getResultPerson().getDeathRecord();
        if (deathRecord != null) {
            deathRecord.setDeathDate(null);
            deathRecord.setDataSource(null);
            deathRecord.setDeathReportDate(null);
            deathRecord.setFacilityReceived(null);
            deathRecord.setLazarusDate(new ImpreciseDate(this.getCurrentDate()));
            if (this.isMVIDODServiceActive()) {
                if (this.isUpdateFromGUI()) {
                    deathRecord.setDeathReportedBy("ES_USER");
                } else {
                    deathRecord.setDeathReportedBy(this.getIncomingPerson().getModifiedBy().getName());
                }
            }
        }
    }

    @Override
    public void restorePristineDeathRecord() {
        DeathRecord pristineDeathRecord = this.getPristinePerson().getDeathRecord();
        DeathRecord incomingDeathRecord = this.getIncomingPerson().getDeathRecord();
        if (pristineDeathRecord == null) {
            this.getIncomingPerson().setDeathRecord(null);
        } else {
            if (incomingDeathRecord == null) {
                incomingDeathRecord = new DeathRecord();
            }
            incomingDeathRecord.setDeathDate(pristineDeathRecord.getDeathDate());
            incomingDeathRecord.setDataSource(pristineDeathRecord.getDataSource());
            incomingDeathRecord.setDeathReportDate(pristineDeathRecord.getDeathReportDate());
            incomingDeathRecord.setDeathReportedBy(pristineDeathRecord.getDeathReportedBy());
            incomingDeathRecord.setDodVerifiedInd(pristineDeathRecord.getDodVerifiedInd());
            incomingDeathRecord.setFacilityReceived(pristineDeathRecord.getFacilityReceived());
            incomingDeathRecord.setLazarusDate(pristineDeathRecord.getLazarusDate());
        }
    }

    @Override
    public String getDODReceivedFrom() {
        DeathRecord deathRecord = this.getIncomingPerson().getDeathRecord();
        String stationNumber = deathRecord != null && deathRecord.getFacilityReceived() != null ? deathRecord.getFacilityReceived().getStationNumber() : null;
        return stationNumber;
    }

    @Override
    public boolean isDateOfDeathUpdatedByVAMC() {
        String stationNumber;
        DeathRecord deathRecord = this.getIncomingPerson().getDeathRecord();
        String string = stationNumber = deathRecord != null && deathRecord.getFacilityReceived() != null ? deathRecord.getFacilityReceived().getStationNumber() : null;
        return stationNumber != null ? !stationNumber.equals(VAFacility.CODE_HEC.getName()) : false;
    }

    @Override
    public boolean isDateOfDeathUpdatedByMVI() {
        return this.isUpdateFromMVI();
    }

    @Override
    public String getPristineFirstName() {
        Name legalName = this.getLegalName(this.getPristinePerson());
        return legalName != null ? legalName.getGivenName() : null;
    }

    @Override
    public String getPristineLastName() {
        Name legalName = this.getLegalName(this.getPristinePerson());
        return legalName != null ? legalName.getFamilyName() : null;
    }

    @Override
    public String getPristineMiddleName() {
        Name legalName = this.getLegalName(this.getPristinePerson());
        return legalName != null ? legalName.getMiddleName() : null;
    }

    @Override
    public String getMiddleName() {
        Name legalName = this.getLegalName(this.getIncomingPerson());
        return legalName != null ? legalName.getMiddleName() : null;
    }

    @Override
    public String getFirstName() {
        Name legalName = this.getLegalName(this.getIncomingPerson());
        return legalName != null ? legalName.getGivenName() : null;
    }

    @Override
    public String getPatientName() {
        if (this.patientName == null) {
            StringBuffer info = new StringBuffer();
            info.append(this.getPristineLastName()).append(", ").append(this.getPristineFirstName());
            this.patientName = info.toString();
        }
        return this.patientName;
    }

    @Override
    public Boolean getSensitiveIndicator() {
        return this.getSensitivityRecordIndicator(this.getIncomingPerson());
    }

    @Override
    public Boolean getPristineSensitiveIndicator() {
        return this.getSensitivityRecordIndicator(this.getPristinePerson());
    }

    public boolean isSensitivityChanged() {
        return !this.isEqual(this.getPristinePerson().getSensitiveRecord(), this.getIncomingPerson().getSensitiveRecord());
    }

    @Override
    public Date getSensitivityChangeDate() {
        return this.getSensitivityChangeDate(this.getIncomingPerson());
    }

    @Override
    public Date getPristineSensitivityChangeDate() {
        return this.getSensitivityChangeDate(this.getPristinePerson());
    }

    @Override
    public VAFacility getCalculatedPreferredFacility() {
        if (this.preferredFacility == null) {
            Map PVS = this.getIncomingPerson().getPatientVisitSummaries();
            List sortedPatientVisitSummaries = this.sortLastVisitDateRecentToOld(PVS.values());
            this.preferredFacility = this.getPreferredFacilityPast2Years(sortedPatientVisitSummaries);
            if (this.preferredFacility == null) {
                this.preferredFacility = this.getPreferredFacilityByLocation();
            }
            if (this.preferredFacility == null) {
                this.preferredFacility = this.getPreferredFacilityRecentVisit(sortedPatientVisitSummaries);
            }
            if (this.preferredFacility == null) {
                this.preferredFacility = this.getPreferredFacilityBySiteSendingMessage();
            }
        }
        return this.preferredFacility;
    }

    @Override
    public void setPreferredFacility(VAFacility facility) throws ServiceException {
        PreferredFacility pf = new PreferredFacility();
        pf.setAssignmentDate(new Date());
        pf.setFacility(facility);
        pf.setSourceDesignation(this.getLookupService().getSourceDesignationByCode(SourceDesignation.CODE_ESR.getCode()));
        this.getResultPerson().addPreferredFacility(pf);
    }

    @Override
    public void updateSensitivityInformation() {
        Person incomingPerson = this.getIncomingPerson();
        Person resultPerson = this.getResultPerson();
        resultPerson.setSensitiveRecord(incomingPerson.getSensitiveRecord());
        resultPerson.setSensitivityChangeDate(incomingPerson.getSensitivityChangeDate());
        resultPerson.setSensitivityChangeSite(incomingPerson.getSensitivityChangeSite());
        resultPerson.setSensitivityChangeSource(incomingPerson.getSensitivityChangeSource());
    }

    @Override
    public void updateDemographicInformation() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"updateDemographicInformation()");
        }
        try {
            Person incomingPerson = this.getIncomingPerson();
            if (this.isUpdateFromGUI()) {
                if (this.isSensitivityChanged()) {
                    incomingPerson.setSensitivityChangeDate(this.getCurrentDate());
                }
                this.updateSensitivityInformation();
                if (this.getIncomingPerson().getEthnicity() != null && this.getIncomingPerson().getEthnicity().getCollectionMethod() == null) {
                    this.getIncomingPerson().getEthnicity().setCollectionMethod(this.getLookupService().getCollectionMethodByCode(CollectionMethod.CODE_SLF.getCode()));
                }
            }
            this.getMergeRuleService().mergeDemographic(incomingPerson, this.getResultPerson());
            if (this.isUpdateFromGUI()) {
                this.getResultPerson().setClaimFolderLocation(this.getIncomingPerson().getClaimFolderLocation());
                this.getResultPerson().setClaimFolderNumber(this.getIncomingPerson().getClaimFolderNumber());
                this.getResultPerson().setUserEnrolleeValidThrough(this.getIncomingPerson().getUserEnrolleeValidThrough());
                this.getResultPerson().setUserEnrolleeSite(this.getIncomingPerson().getUserEnrolleeSite());
                this.getResultPerson().setAppointmentRequestDate(this.getIncomingPerson().getAppointmentRequestDate());
                this.getResultPerson().setAppointmentRequestResponse(this.getIncomingPerson().getAppointmentRequestResponse());
            } else {
                Boolean appointmentRequestResponse;
                Integer incoming;
                this.getMergeRuleService().mergeIdentityTraits(incomingPerson, this.getResultPerson());
                Integer existing = this.getPristinePerson() != null ? this.getPristinePerson().getUserEnrolleeValidThrough() : null;
                Integer n = incoming = this.getIncomingPerson() != null ? this.getIncomingPerson().getUserEnrolleeValidThrough() : null;
                if ((existing != null && incoming != null && incoming.compareTo(existing) > 0 || existing == null) && incoming != null && this.getIncomingPerson().getUserEnrolleeSite() != null) {
                    this.getResultPerson().setUserEnrolleeValidThrough(this.getIncomingPerson().getUserEnrolleeValidThrough());
                    this.getResultPerson().setUserEnrolleeSite(this.getIncomingPerson().getUserEnrolleeSite());
                }
                Date appointmentRequestDate = this.getPristinePerson() != null ? this.getPristinePerson().getAppointmentRequestDate() : null;
                Boolean bl = appointmentRequestResponse = this.getPristinePerson() != null ? this.getPristinePerson().getAppointmentRequestResponse() : null;
                if (appointmentRequestDate == null || appointmentRequestResponse == null) {
                    this.getResultPerson().setAppointmentRequestDate(this.getIncomingPerson().getAppointmentRequestDate());
                    this.getResultPerson().setAppointmentRequestResponse(this.getIncomingPerson().getAppointmentRequestResponse());
                }
                if (appointmentRequestDate != null) {
                    this.getResultPerson().setAppointmentRequestDate(this.getIncomingPerson().getAppointmentRequestDate());
                }
            }
        }
        catch (ServiceException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Failed to merge person", (Throwable)e);
            }
            throw new RuntimeException("Failed to merge person", e);
        }
    }

    @Override
    public void updateIdentityTraitsInformation() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"updateIdentityTraitsInformation()");
        }
        try {
            Person incomingPerson = this.getIncomingPerson();
            this.getMergeRuleService().mergeIdentityTraits(incomingPerson, this.getResultPerson());
        }
        catch (ServiceException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Failed to merge person", (Throwable)e);
            }
            throw new RuntimeException("Failed to merge person", e);
        }
    }

    @Override
    public void updateEmergencyResponseIndicator() throws RuleException {
        try {
            Person incomingPerson = this.getIncomingPerson();
            Person resultPerson = this.getResultPerson();
            this.getMergeRuleService().mergeEmergencyResponseIndicator(incomingPerson, resultPerson);
        }
        catch (Exception ex) {
            throw new RuleException("Error while merging EmergencyResponseIndicator", (Throwable)ex);
        }
    }

    @Override
    public String getNamePrefix() {
        Name legalName = this.getIncomingPerson().getLegalName();
        return legalName != null ? legalName.getPrefix() : null;
    }

    @Override
    public String getPOAFirstName() {
        Name name = this.getNameFromLetter();
        return name != null ? name.getGivenName() : null;
    }

    @Override
    public String getPOALastName() {
        Name name = this.getNameFromLetter();
        return name != null ? name.getFamilyName() : null;
    }

    @Override
    public DemographicsChangeType getRequestedChangeType() {
        ExternalSystemsInputData externalSystemsInputData = this.getExternalSystemsInputData();
        if (externalSystemsInputData != null) {
            return externalSystemsInputData.getDemographicsChangeEvent() != null ? externalSystemsInputData.getDemographicsChangeEvent().getChangeType() : null;
        }
        return null;
    }

    @Override
    public String getPristinePseudoSSNReason() {
        SSN ssn = this.getPristinePerson().getOfficialSsn();
        return ssn != null && ssn.getPseudoSSNReason() != null ? ssn.getPseudoSSNReason().getCode() : null;
    }

    @Override
    public String getPseudoSSNReason() {
        SSN ssn = this.getIncomingPerson().getOfficialSsn();
        return ssn != null && ssn.getPseudoSSNReason() != null ? ssn.getPseudoSSNReason().getCode() : null;
    }

    @Override
    public String getPristineSSNVerificationStatus() {
        SSN ssn = this.getIncomingPerson().getOfficialSsn();
        return ssn != null && ssn.getSsaVerificationStatus() != null ? ssn.getSsaVerificationStatus().getCode() : null;
    }

    @Override
    public String getSSNVerificationStatus() {
        SSN ssn = this.getIncomingPerson().getOfficialSsn();
        return ssn != null && ssn.getSsaVerificationStatus() != null ? ssn.getSsaVerificationStatus().getCode() : null;
    }

    @Override
    public boolean hasInvalidSSNVerificationStatusForVetOrRelation(Person person) throws RuleException {
        return this.satisfiesSSNCriteria(SSN_INVALID, person);
    }

    @Override
    public boolean hasPseudoSSNReasonOfFollowup() throws RuleException {
        return this.satisfiesSSNCriteria(PSEUDO_SSN_REASON, this.getIncomingPerson());
    }

    private boolean satisfiesSSNCriteria(String ssnCriteria, Person person) {
        if (ssnCriteria == null) {
            return false;
        }
        if (person == null) {
            return false;
        }
        boolean result = false;
        SSN ssn = null;
        String subject = this.getSubject();
        if (subject == null || "V".equals(subject)) {
            ssn = ssnCriteria.equals(SSN_INVALID) ? person.getOfficialSsn() : SSN.getSSNOfType(person.getSsns(), SSNType.CODE_PSEUDO.getCode());
            boolean bl = result = ssnCriteria.equals(SSN_INVALID) ? this.hasInvalidSSNVerificationStatus(ssn) : this.hasPseudoReasonOfFollowup(ssn);
        }
        if (!result) {
            Map statements = person.getFinancialStatements();
            for (Integer year : statements.keySet()) {
                FinancialStatement statement = person.getFinancialStatement(year);
                if (subject == null || "S".equals(subject)) {
                    Set spouses = statement.getSpouseFinancials();
                    for (SpouseFinancials sf : spouses) {
                        if (sf.getReportedOn() != null) {
                            SSN spouseSSN = ssnCriteria.equals(SSN_INVALID) ? sf.getReportedOn().getOfficialSsn() : sf.getReportedOn().getPseudoSsn();
                            boolean bl = result = ssnCriteria.equals(SSN_INVALID) ? this.hasInvalidSSNVerificationStatus(spouseSSN) : this.hasPseudoReasonOfFollowup(spouseSSN);
                        }
                        if (!result) continue;
                        break;
                    }
                }
                if (!result && (subject == null || "D".equals(subject))) {
                    Set dependents = statement.getDependentFinancials();
                    for (DependentFinancials df : dependents) {
                        if (df.getReportedOn() != null) {
                            SSN dependentSSN = ssnCriteria.equals(SSN_INVALID) ? df.getReportedOn().getOfficialSsn() : df.getReportedOn().getPseudoSsn();
                            boolean bl = result = ssnCriteria.equals(SSN_INVALID) ? this.hasInvalidSSNVerificationStatus(dependentSSN) : this.hasPseudoReasonOfFollowup(dependentSSN);
                        }
                        if (!result) continue;
                        break;
                    }
                }
                if (!result) continue;
                break;
            }
        }
        return result;
    }

    private boolean hasInvalidSSNVerificationStatus(SSN ssn) {
        if (ssn == null) {
            return false;
        }
        CommsInputData cid = this.getCommsInputData();
        if (cid.getRuleContext() != null && cid.getMailType() != null && cid.getRuleContext().equals("REQUEST_LETTER") && cid.getMailType().equals((Object)LetterTriggerEvent.AUTO_MAIL)) {
            return true;
        }
        return ssn.getSsnText() != null && ssn.getSsaVerificationStatus() != null && SSAVerificationStatus.INVALID_PER_SSA.getCode().equals(ssn.getSsaVerificationStatus().getCode());
    }

    private boolean hasPseudoReasonOfFollowup(SSN ssn) {
        if (ssn == null) {
            return false;
        }
        return ssn.getPseudoSSNReason() != null && PseudoSSNReason.CODE_FOLLOWUP_REQD.getCode().equals(ssn.getPseudoSSNReason().getCode());
    }

    private Boolean getSensitivityRecordIndicator(Person person) {
        return person != null ? person.getSensitiveRecord() : null;
    }

    private Date getSensitivityChangeDate(Person person) {
        return person != null ? person.getSensitivityChangeDate() : null;
    }

    private VAFacility getPreferredFacilityPast2Years(Collection PVSs) {
        PatientVisitSummary preferredPVS = null;
        if (PVSs != null) {
            Date currentDateMinus2Years = this.getCurrentDateMinus2Years();
            ArrayList<PatientVisitSummary> PVSsPast2Years = new ArrayList<PatientVisitSummary>();
            for (PatientVisitSummary PVS : PVSs) {
                Date lastVisitedDate = PVS != null ? PVS.getLastVisitDate() : null;
                if (!this.isAfter(lastVisitedDate, currentDateMinus2Years)) continue;
                PVSsPast2Years.add(PVS);
            }
            preferredPVS = PVSsPast2Years.size() == 1 ? (PatientVisitSummary)((Object)PVSsPast2Years.get(0)) : null;
        }
        return preferredPVS != null ? preferredPVS.getFacilityVisited() : null;
    }

    private VAFacility getPreferredFacilityByLocation() {
        return null;
    }

    private VAFacility getPreferredFacilityRecentVisit(Collection sortedPatientVisitSummaries) {
        PatientVisitSummary PVS = null;
        if (sortedPatientVisitSummaries != null && !sortedPatientVisitSummaries.isEmpty()) {
            PVS = (PatientVisitSummary)((Object)sortedPatientVisitSummaries.iterator().next());
        }
        return PVS != null ? PVS.getFacilityVisited() : null;
    }

    private VAFacility getPreferredFacilityBySiteSendingMessage() {
        PersonInputData inputData = this.getRuleDataAware() instanceof PersonInputData ? (PersonInputData)this.getRuleDataAware() : null;
        return inputData != null ? inputData.getSendingFacility() : null;
    }

    private Date getCurrentDateMinus2Years() {
        Calendar calendar = this.toCalendar(this.getCurrentDate());
        if (calendar != null) {
            calendar.add(1, -2);
        }
        return calendar != null ? calendar.getTime() : null;
    }

    private List sortLastVisitDateRecentToOld(Collection patientVisitSummaries) {
        ArrayList sortedPatientVisitSummaries = new ArrayList();
        if (patientVisitSummaries != null && !patientVisitSummaries.isEmpty()) {
            sortedPatientVisitSummaries.addAll(patientVisitSummaries);
            Comparator comparator = new Comparator(){

                public int compare(Object pObject1, Object pObject2) {
                    Date date1 = pObject1 instanceof PatientVisitSummary ? ((PatientVisitSummary)((Object)pObject1)).getLastVisitDate() : null;
                    Date date2 = pObject2 instanceof PatientVisitSummary ? ((PatientVisitSummary)((Object)pObject2)).getLastVisitDate() : null;
                    return date1 != null && date2 != null ? -date1.compareTo(date2) : 0;
                }
            };
            Collections.sort(sortedPatientVisitSummaries, comparator);
        }
        return sortedPatientVisitSummaries;
    }

    private DeathRecord getDeathRecord(Person person) {
        return person != null ? person.getDeathRecord() : null;
    }

    private Date getDateOfDeath(Person person) {
        DeathRecord deathRecord = this.getDeathRecord(person);
        ImpreciseDate impreciseDate = deathRecord != null ? deathRecord.getDeathDate() : null;
        return impreciseDate != null ? ImpreciseDateUtils.getDateWithDefault(impreciseDate) : null;
    }

    private Date getDateOfDeathReported(Person person) {
        DeathRecord deathRecord = this.getDeathRecord(person);
        return deathRecord != null ? deathRecord.getDeathReportDate() : null;
    }

    private String getGenderCode(Person person) {
        return person != null && person.getGender() != null ? person.getGender().getCode() : null;
    }

    private Name getLegalName(Person person) {
        return this.getIncomingPerson().getLegalName() != null ? this.getIncomingPerson().getLegalName() : null;
    }

    private String getSSN(Person person) {
        return person != null && person.getOfficialSsn() != null ? person.getOfficialSsn().getFormattedSsnText() : null;
    }

    private void setDeathRecord(DeathRecord deathRecord) {
        this.getResultPerson().setDeathRecord(deathRecord);
    }

    private Name getNameFromLetter() {
        CommsInputData commsInputData = this.getCommsInputData();
        CommsLogEntry commsLogEntry = commsInputData != null ? commsInputData.getCommsLogEntry() : null;
        return commsLogEntry != null ? commsLogEntry.getName() : null;
    }

    public PSDelegateService getPsDelegateService() {
        return this.psDelegateService;
    }

    public void setPsDelegateService(PSDelegateService psDelegateService) {
        this.psDelegateService = psDelegateService;
    }

    public PreferredFacilityService getPreferredFacilityService() {
        return this.preferredFacilityService;
    }

    public void setPreferredFacilityService(PreferredFacilityService preferredFacilityService) {
        this.preferredFacilityService = preferredFacilityService;
    }

    @Override
    public boolean isTreatingFacilityExist() throws ServiceException {
        Set facilities = this.getMessagingService().findSitesOfRecord(this.getPristinePerson());
        return facilities == null ? false : facilities.size() > 0;
    }

    @Override
    public Set findSitesOfRecord() throws ServiceException {
        return this.getMessagingService().findSitesOfRecord(this.getIncomingPerson());
    }

    @Override
    public String getIDState() throws ServiceException {
        this.getPersonService().checkAndAddESRCorrelation(this.getPristinePerson());
        return this.getPsDelegateService().getIDState(this.getIncomingPerson().getVPIDEntityKey());
    }

    @Override
    public boolean isRequestIDStateChangeError() throws ServiceException {
        try {
            this.getPsDelegateService().requestIDStateChange(this.getIncomingPerson().getVPIDEntityKey(), this.getPristinePerson().getEnrollmentDetermination().getEnrollmentStatus());
        }
        catch (ServiceException ex) {
            this.logger.error((Object)"Failed to Request IDState Change", (Throwable)ex);
            return true;
        }
        return false;
    }

    @Override
    public boolean isCreatePreferFacilityError() throws ServiceException {
        try {
            this.getPersonService().addPreferredFacilityCorrelation(this.getIncomingPerson());
        }
        catch (ServiceException ex) {
            this.logger.error((Object)"Failed to Add Preferred Facility", (Throwable)ex);
            return true;
        }
        return false;
    }

    @Override
    public boolean hasIncomingPreferredFacility() {
        return !this.getIncomingPerson().getPreferredFacilities().isEmpty();
    }

    @Override
    public boolean hasResultPreferredFacility() {
        return !this.getResultPerson().getPreferredFacilities().isEmpty();
    }

    @Override
    public PreferredFacility getPreferredFacility() {
        Iterator iter = this.getIncomingPerson().getPreferredFacilities().iterator();
        return iter.hasNext() ? (PreferredFacility)((Object)iter.next()) : null;
    }

    @Override
    public boolean shouldIgnoreIncomingPreferredFacility() throws ServiceException {
        return this.getPreferredFacilityService().hasPCPActiveOrESRPF(this.getPristinePerson());
    }

    @Override
    public boolean shouldIgnoreIncomingVOAPreferredFacility() throws ServiceException {
        return this.getPreferredFacilityService().hasPCPActivePF(this.getPristinePerson());
    }

    @Override
    public boolean shouldAddIncomingPreferredFacility() throws ServiceException {
        return !this.getPreferredFacilityService().hasActivePreferredFacility(this.getPristinePerson().getPreferredFacilities());
    }

    @Override
    public boolean shouldAddIncomingVOAPreferredFacility() throws ServiceException {
        return this.getPreferredFacilityService().hasVistaOrPCPInactivePF(this.getPristinePerson());
    }

    @Override
    public void addIncomingPreferredFacility(PreferredFacility incoming, String sdCode) throws ServiceException {
        this.getPreferredFacilityService().addPreferredFacility(incoming, this.getResultPerson(), sdCode);
        this.getPreferredFacilityService().setCalculatedMostRecentPreferredFacility(this.getResultPerson());
    }

    @Override
    public void updatePreferredFacilityFromVistA(PreferredFacility incoming) throws ServiceException {
        PreferredFacility vistaPf = this.getPreferredFacilityService().getPreferredFacilityFromVista(this.getResultPerson());
        if (vistaPf != null) {
            if (incoming.getFacility().getStationNumber().equals(vistaPf.getFacility().getStationNumber())) {
                return;
            }
            vistaPf.setUnassignmentDate(new Date());
        }
        this.getPreferredFacilityService().addPreferredFacility(incoming, this.getResultPerson(), SourceDesignation.CODE_VISTA.getCode());
        this.getPreferredFacilityService().setCalculatedMostRecentPreferredFacility(this.getResultPerson());
    }

    @Override
    public void updatePreferredFacilityFromVOA(PreferredFacility incoming) throws ServiceException {
        PreferredFacility esPf = this.getPreferredFacilityService().getPreferredFacilityFromES(this.getResultPerson());
        if (esPf != null) {
            if (incoming.getFacility().getStationNumber().equals(esPf.getFacility().getStationNumber())) {
                return;
            }
            esPf.setUnassignmentDate(new Date());
        }
        this.getPreferredFacilityService().addPreferredFacility(incoming, this.getResultPerson(), SourceDesignation.CODE_ESR.getCode());
        this.getPreferredFacilityService().setCalculatedMostRecentPreferredFacility(this.getResultPerson());
    }

    @Override
    public void updatePreferredFacilitiesFromUI() throws ServiceException {
        Set incomingPFs = this.getIncomingPerson().getPreferredFacilities();
        for (PreferredFacility incomingPF : incomingPFs) {
            if (incomingPF.getEntityKey() == null) {
                this.getPreferredFacilityService().addPreferredFacility(incomingPF, this.getResultPerson(), SourceDesignation.CODE_ESR.getCode());
                continue;
            }
            PreferredFacility onFilePF = this.getResultPerson().getPreferredFacilityByEntityKey(incomingPF.getEntityKey());
            if (onFilePF == null || onFilePF.getFacility().getStationNumber().equals(incomingPF.getFacility().getStationNumber()) || onFilePF.getSourceDesignation().getCode().equals(SourceDesignation.CODE_PCP_ACTIVE.getCode())) continue;
            onFilePF.setUnassignmentDate(new Date());
            this.getPreferredFacilityService().addPreferredFacility(incomingPF, this.getResultPerson(), SourceDesignation.CODE_ESR.getCode());
        }
        this.getPreferredFacilityService().setCalculatedMostRecentPreferredFacility(this.getResultPerson());
    }

    @Override
    public boolean isPreferredFacilityChanged() throws ServiceException {
        boolean anyPFChanges = false;
        Set<VAFacility> resultPFs = this.getPreferredFacilityService().getPFSites(this.getResultPerson());
        Set<VAFacility> pristinePFs = this.getPreferredFacilityService().getPFSites(this.getPristinePerson());
        Iterator<VAFacility> iter = resultPFs.iterator();
        while (iter.hasNext()) {
            if (pristinePFs.contains((Object)iter.next())) continue;
            return true;
        }
        return anyPFChanges;
    }

    @Override
    public boolean isMVIDODServiceActive() throws RuleException {
        try {
            SystemParameter sysParameter = this.getSystemParameterService().getByName("Use MVI Date of Death Service Indicator");
            if (sysParameter != null && sysParameter.getValue() != null) {
                return sysParameter.getValue().equalsIgnoreCase("Y");
            }
        }
        catch (Exception ex) {
            throw new RuleException("Error getting SystemParameter (DOD_INDICATOR) value", (Throwable)ex);
        }
        return false;
    }

    @Override
    public boolean wasDODVerified() {
        return this.getPristinePerson().getDeathRecord() != null && this.getPristinePerson().getDeathRecord().getDodVerifiedInd() != null && this.getPristinePerson().getDeathRecord().getDodVerifiedInd() != false;
    }

    @Override
    public void setDoDModifiedBy() {
        DeathRecord resultDeathRecord = this.getDeathRecord(this.getResultPerson());
        if (resultDeathRecord != null) {
            if (this.isUpdateFromGUI()) {
                resultDeathRecord.setDeathReportedBy("ES_USER");
            } else if (this.getIncomingPerson().getModifiedBy() != null && !StringUtils.isBlank((String)this.getIncomingPerson().getModifiedBy().getName())) {
                resultDeathRecord.setDeathReportedBy(this.getIncomingPerson().getModifiedBy().getName());
            } else {
                resultDeathRecord.setDeathReportedBy("MVI Date of Death Process");
            }
        }
    }

    @Override
    public boolean isDODVerified() {
        return this.getDeathRecord() != null && this.getDeathRecord().getDodVerifiedInd() != null && this.getDeathRecord().getDodVerifiedInd() != false;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }
}

