/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.rule.parameter;

import gov.va.med.esr.common.rule.ConsistencyCheckInput;
import gov.va.med.esr.common.rule.data.accessor.MessageTriggerAccessor;
import gov.va.med.esr.common.rule.parameter.BaseParameter;
import gov.va.med.esr.service.trigger.IncomeYearTriggerEvent;
import gov.va.med.esr.service.trigger.PersonTrigger;
import gov.va.med.esr.service.trigger.PersonTriggerEvent;
import gov.va.med.esr.service.trigger.PersonTriggerIdentity;
import gov.va.med.fw.hl7.InvalidMessageException;
import gov.va.med.fw.hl7.Message;
import gov.va.med.fw.hl7.Segment;
import gov.va.med.fw.hl7.segment.IN1;
import gov.va.med.fw.hl7.segment.ZMT;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;

public class ConsistencyCheckInputParameter
extends BaseParameter
implements ConsistencyCheckInput {
    private static final long serialVersionUID = 3613165189362610469L;

    @Override
    public boolean isMessageTypeEqual(String messageTypeCode) {
        return this.getMessageTypeCode().equals(messageTypeCode);
    }

    private MessageTriggerAccessor getMessageTriggerAccessor() {
        return this.getRuleDataAware() instanceof MessageTriggerAccessor ? (MessageTriggerAccessor)this.getRuleDataAware() : null;
    }

    @Override
    public String getMessageTypeCode() {
        MessageTriggerAccessor data = this.getMessageTriggerAccessor();
        if (data == null) {
            return null;
        }
        return data.getMessageType(null) != null ? data.getMessageType(null).getCode() : null;
    }

    private PersonTriggerEvent getTriggerEvent() {
        MessageTriggerAccessor data = this.getMessageTriggerAccessor();
        if (data == null) {
            return null;
        }
        return data.getTriggerEvent(null);
    }

    private Message getMessage() {
        MessageTriggerAccessor data = this.getMessageTriggerAccessor();
        if (data == null) {
            return null;
        }
        return data.getMessage(null);
    }

    private Segment getSegment(String segmentName) {
        Segment segment = null;
        Message message = this.getMessage();
        if (message == null) {
            return null;
        }
        try {
            segment = message.getSegment(segmentName);
        }
        catch (InvalidMessageException e) {
            // empty catch block
        }
        return segment;
    }

    @Override
    public Integer getTriggerEventIncomeYear() {
        PersonTriggerEvent triggerEvent = this.getTriggerEvent();
        if (triggerEvent == null) {
            return null;
        }
        return triggerEvent instanceof IncomeYearTriggerEvent ? ((IncomeYearTriggerEvent)triggerEvent).getIncomeYear() : null;
    }

    @Override
    public boolean isTriggerEventDataTypeEqualTo(String personTriggerIdentityDataTypeCode) {
        PersonTriggerEvent triggerEvent = this.getTriggerEvent();
        if (triggerEvent == null) {
            return false;
        }
        HashSet<PersonTrigger.DataType> applicableDataTypes = new HashSet<PersonTrigger.DataType>(1);
        applicableDataTypes.add(PersonTrigger.DataType.getDataType(personTriggerIdentityDataTypeCode));
        PersonTriggerIdentity triggerIdentity = (PersonTriggerIdentity)triggerEvent.getTriggerIdentity();
        PersonTriggerIdentity matchingIdentity = new PersonTriggerIdentity(triggerIdentity);
        matchingIdentity.setApplicableDataTypes(applicableDataTypes);
        return triggerEvent != null ? ((PersonTriggerIdentity)triggerEvent.getTriggerIdentity()).matchTriggerCriteria(matchingIdentity) : false;
    }

    private IN1 getIN1Segment() {
        return (IN1)this.getSegment("IN1");
    }

    private ZMT getZMTSegment() {
        return (ZMT)this.getSegment("ZMT");
    }

    private String standardizeSegmentValueForCC(String val) {
        return StringUtils.isBlank((String)val) ? null : val;
    }

    @Override
    public String getZ04InsuranceCompanyName() {
        IN1 segment = this.getIN1Segment();
        if (segment == null) {
            return null;
        }
        return this.standardizeSegmentValueForCC(segment.getInsuranceCompanyName());
    }

    @Override
    public String getZ04InsuranceGroupNumber() {
        IN1 segment = this.getIN1Segment();
        if (segment == null) {
            return null;
        }
        return this.standardizeSegmentValueForCC(segment.getGroupNumber());
    }

    @Override
    public String getZ04InsuranceRelationshipToPatient() {
        IN1 segment = this.getIN1Segment();
        if (segment == null) {
            return null;
        }
        return this.standardizeSegmentValueForCC(segment.getInsuredRelationToPatient());
    }

    @Override
    public String getZ04NameOfInsured() {
        IN1 segment = this.getIN1Segment();
        if (segment == null) {
            return null;
        }
        return this.standardizeSegmentValueForCC(segment.getInsuredName());
    }

    @Override
    public String getZ06MeansTestDate() {
        ZMT segment = this.getZMTSegment();
        if (segment == null) {
            return null;
        }
        return this.standardizeSegmentValueForCC(segment.getMeansTestDate());
    }

    @Override
    public String getZ06DateVeteranSignedMeansTest() {
        ZMT segment = this.getZMTSegment();
        if (segment == null) {
            return null;
        }
        return this.standardizeSegmentValueForCC(segment.getVeteranTestSignedDate());
    }
}

