/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.rule.data;

import gov.va.med.esr.common.model.ee.VerificationInfo;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.rule.data.BaseData;
import gov.va.med.esr.common.rule.data.accessor.PropertyAccessor;
import gov.va.med.esr.service.PersonService;

public class PersonInputData
extends BaseData {
    private static final long serialVersionUID = -6938028049650005752L;
    private boolean isUpdateFromGUI = false;
    private VerificationInfo verificationInfo = null;
    private PersonService personService = null;
    private boolean handBookTrigger = false;

    public PersonInputData() {
    }

    public PersonInputData(Person incoming) {
        super(incoming);
    }

    public PersonInputData(Person incoming, boolean isUpdateFromGUI) {
        super(incoming);
        this.setUpdateFromGUI(isUpdateFromGUI);
    }

    public PersonInputData(Person incoming, Person result, boolean isUpdateFromGUI) {
        super(incoming, result);
        this.setUpdateFromGUI(isUpdateFromGUI);
    }

    public PersonInputData(Person incoming, Person result) {
        super(incoming, result);
    }

    public PersonInputData(Person incoming, Person result, Person pristine, boolean isUpdateFromGUI) {
        super(incoming, result, pristine);
        this.setUpdateFromGUI(isUpdateFromGUI);
    }

    public PersonInputData(Person incoming, Person result, Person pristine, VAFacility sendingFacility, boolean isUpdateFromGUI) {
        super(incoming, result, pristine);
        this.setSendingFacility(sendingFacility);
        this.setUpdateFromGUI(isUpdateFromGUI);
    }

    public PersonInputData(Person incoming, Person result, Person pristine, VAFacility sendingFacility, VerificationInfo info) {
        this(incoming, result, pristine, false);
        this.setSendingFacility(sendingFacility);
        this.setVerificationInfo(info);
    }

    public PersonInputData(Person incoming, Person result, Person pristine) {
        this(incoming, result, pristine, false);
    }

    public PersonInputData(Person incoming, Person result, Person pristine, boolean isUpdateFromGUI, VerificationInfo info) {
        this(incoming, result, pristine, isUpdateFromGUI);
        this.setVerificationInfo(info);
    }

    public PersonInputData(Person incoming, Person result, Person pristine, VerificationInfo info) {
        this(incoming, result, pristine, false);
        this.setVerificationInfo(info);
    }

    public PersonInputData(Person incoming, Person result, Person pristine, boolean isUpdateFromGUI, VAFacility sendingFacility, VerificationInfo info) {
        this(incoming, result, pristine, isUpdateFromGUI);
        this.setSendingFacility(sendingFacility);
        this.setVerificationInfo(info);
    }

    public PersonInputData(Person incoming, Person result, Person pristine, VAFacility sendingFacility, boolean isUpdateFromGUI, boolean isUpdateFromMVI) {
        super(incoming, result, pristine);
        this.setSendingFacility(sendingFacility);
        this.setUpdateFromGUI(isUpdateFromGUI);
        this.setDataFromMVI(isUpdateFromMVI);
    }

    public Person getPristinePerson() {
        return (Person)this.getPristineData();
    }

    public Person getResultPerson() {
        return (Person)this.getResultData();
    }

    public Person getIncomingPerson() {
        return (Person)this.getIncomingData();
    }

    public boolean isUpdateFromGUI() {
        return this.isUpdateFromGUI;
    }

    public void setUpdateFromGUI(boolean isUpdateFromGUI) {
        this.isUpdateFromGUI = isUpdateFromGUI;
    }

    public VerificationInfo getVerificationInfo() {
        return this.verificationInfo;
    }

    public void setVerificationInfo(VerificationInfo verificationInfo) {
        this.verificationInfo = verificationInfo;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public boolean getHandBookTrigger() {
        return this.handBookTrigger;
    }

    public void setHandBookTrigger(boolean handBookTrigger) {
        this.handBookTrigger = handBookTrigger;
    }

    protected Person getPerson(PropertyAccessor.DataType dataType) {
        Person person = null;
        if (dataType == null) {
            person = this.getPristinePerson();
        } else if (dataType.isIncoming()) {
            person = this.getIncomingPerson();
        } else if (dataType.isPristine()) {
            person = this.getPristinePerson();
        } else if (dataType.isResult()) {
            person = this.getResultPerson();
        }
        return person;
    }
}

