/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.rule.data;

import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.rule.data.BaseData;
import gov.va.med.esr.service.IVMFinancialInfo;

public class FinancialInputData
extends BaseData {
    private static final long serialVersionUID = 8498612584434516594L;
    private Integer incomingIncomeYear = null;
    private VAFacility sourceFacility = null;
    private IncomeTest existingFDTTest = null;
    private boolean isDemographicUpdate = false;
    private IVMFinancialInfo ivmFinancialInfo = null;
    private boolean isRXConversion = false;
    private boolean isMTConversion = false;
    private boolean isRXReversal = false;
    private boolean isMTReversal = false;

    protected FinancialInputData() {
    }

    public FinancialInputData(Person incomingPerson, Person resultPerson, Person pristine, Integer incomingIncomeYear, boolean isDemographicUpdate, boolean isDataFromGUI) {
        super(incomingPerson, resultPerson, pristine);
        this.setIncomingIncomeYear(incomingIncomeYear);
        this.setSourceFacility(this.sourceFacility);
        this.setSendingFacility(this.sourceFacility);
        this.setDataFromGUI(isDataFromGUI);
        this.setDemographicUpdate(isDemographicUpdate);
    }

    public FinancialInputData(Person incomingPerson, Person resultPerson, Person pristine, Integer incomingIncomeYear, VAFacility sourceFacility) {
        this(incomingPerson, resultPerson, pristine, incomingIncomeYear, sourceFacility, false);
    }

    public FinancialInputData(Person incomingPerson, Person resultPerson, Person pristine, IVMFinancialInfo ivmFinancialInfo) {
        super(incomingPerson, resultPerson, pristine);
        if (ivmFinancialInfo != null) {
            this.setIncomingIncomeYear(ivmFinancialInfo.getIncomeYear());
        }
        this.setIvmFinancialInfo(ivmFinancialInfo);
        this.setDataFromGUI(false);
    }

    public FinancialInputData(Person incomingPerson, Person resultPerson, Person pristine, Integer incomingIncomeYear, VAFacility sourceFacility, boolean isDataFromGUI) {
        super(incomingPerson, resultPerson, pristine);
        this.setDataFromGUI(isDataFromGUI);
        this.setIncomingIncomeYear(incomingIncomeYear);
        this.setSourceFacility(sourceFacility);
        this.setSendingFacility(sourceFacility);
    }

    public Integer getIncomingIncomeYear() {
        return this.incomingIncomeYear;
    }

    public void setIncomingIncomeYear(Integer incomingIncomeYear) {
        this.incomingIncomeYear = incomingIncomeYear;
    }

    public VAFacility getSourceFacility() {
        return this.sourceFacility;
    }

    public void setSourceFacility(VAFacility sourceFacility) {
        this.sourceFacility = sourceFacility;
    }

    public boolean isDemographicUpdate() {
        return this.isDemographicUpdate;
    }

    public void setDemographicUpdate(boolean isDemographicUpdate) {
        this.isDemographicUpdate = isDemographicUpdate;
    }

    public IncomeTest getExistingFDTTest() {
        return this.existingFDTTest;
    }

    public void setExistingFDTTest(IncomeTest existingFDTTest) {
        this.existingFDTTest = existingFDTTest;
    }

    public IVMFinancialInfo getIvmFinancialInfo() {
        return this.ivmFinancialInfo;
    }

    public void setIvmFinancialInfo(IVMFinancialInfo ivmFinancialInfo) {
        this.ivmFinancialInfo = ivmFinancialInfo;
    }

    public boolean isMTConversion() {
        return this.isMTConversion;
    }

    public void setMTConversion(boolean isMTConversion) {
        this.isMTConversion = isMTConversion;
    }

    public boolean isMTReversal() {
        return this.isMTReversal;
    }

    public void setMTReversal(boolean isMTReversal) {
        this.isMTReversal = isMTReversal;
    }

    public boolean isRXConversion() {
        return this.isRXConversion;
    }

    public void setRXConversion(boolean isRXConversion) {
        this.isRXConversion = isRXConversion;
    }

    public boolean isRXReversal() {
        return this.isRXReversal;
    }

    public void setRXReversal(boolean isRXReversal) {
        this.isRXReversal = isRXReversal;
    }
}

