/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.report.data.impl;

import gov.va.med.esr.common.model.lookup.ReportFacilityDisplayBy;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.lookup.VOAFormType;
import gov.va.med.esr.common.model.report.ReportFacility;
import gov.va.med.esr.common.model.report.ReportFormType;
import gov.va.med.esr.common.model.report.ReportParameterSet;
import gov.va.med.esr.common.model.report.ReportSetup;
import gov.va.med.esr.common.report.data.StandardReportCriteria;
import gov.va.med.esr.common.report.data.impl.AbstractStandardReportDataDAOImpl;
import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.data.QueryCriteria;
import gov.va.med.fw.report.data.ReportDataException;
import gov.va.med.fw.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Query;
import org.hibernate.Session;

public class VOA1ReportDataDAOImpl
extends AbstractStandardReportDataDAOImpl {
    private static final long serialVersionUID = -5657439440961807171L;

    @Override
    public void preDataRetrieval(ReportConfiguration config) throws ReportDataException {
        QueryCriteria reportCriteria = config.getQueryCriteria();
        if (reportCriteria instanceof StandardReportCriteria) {
            ReportParameterSet parameters;
            StandardReportCriteria criteria = (StandardReportCriteria)reportCriteria;
            ReportSetup setup = criteria.getReportSetup();
            ReportParameterSet reportParameterSet = parameters = setup != null ? setup.getParameterSet() : null;
            if (parameters == null) {
                throw new ReportDataException("Missing report parameters in report " + config.getReportID());
            }
            criteria.setStartDate(this.getDate(config, true));
            criteria.setEndDate(this.getDate(config, false));
            Set voaFormTypes = parameters.getFormTypes();
            if (voaFormTypes == null || voaFormTypes.isEmpty()) {
                criteria.getCriteria().put("voaFormTypes", "All");
            } else {
                criteria.getCriteria().put("voaFormTypes", this.getVoaFormTypeNames(voaFormTypes));
            }
            ReportFacilityDisplayBy facilityDisplayBy = parameters.getFacilityDisplayBy();
            if (facilityDisplayBy != null && !StringUtils.isEmpty((String)facilityDisplayBy.getCode())) {
                if (StringUtils.equals((String)facilityDisplayBy.getCode(), (String)ReportFacilityDisplayBy.CODE_VISN.getCode())) {
                    Set visns = parameters.getFacilities();
                    if (visns != null && !visns.isEmpty()) {
                        if (visns.size() > 23) {
                            criteria.getCriteria().put("visns", "All");
                        } else {
                            criteria.getCriteria().put("visns", this.getVisnNames(visns));
                        }
                    }
                } else {
                    Set reportFacilities = parameters.getFacilities();
                    if (reportFacilities == null || reportFacilities.isEmpty()) {
                        criteria.getCriteria().put("facilities", "All");
                        criteria.getCriteria().put("visns", "All");
                    } else {
                        criteria.getCriteria().put("facilities", this.getFacilitityCodes(reportFacilities));
                    }
                }
            }
        }
    }

    @Override
    protected Query buildQuery(ReportConfiguration config, Session session) throws ReportDataException {
        QueryCriteria reportCriteria = config.getQueryCriteria();
        Query query = null;
        if (reportCriteria instanceof StandardReportCriteria) {
            ReportParameterSet parameters;
            query = this.getNamedQuery(session);
            StandardReportCriteria criteria = (StandardReportCriteria)reportCriteria;
            ReportSetup setup = criteria.getReportSetup();
            ReportParameterSet reportParameterSet = parameters = setup != null ? setup.getParameterSet() : null;
            if (parameters == null) {
                throw new ReportDataException("Missing report parameters in report " + config.getReportID());
            }
            Date startDate = parameters.getFromDate();
            if (startDate == null) {
                throw new ReportDataException("Missing Start Date in report " + config.getReportID());
            }
            Date endDate = parameters.getToDate();
            if (endDate == null) {
                throw new ReportDataException("Missing End Date in report " + config.getReportID());
            }
            query.setDate("startDate", startDate);
            query.setDate("endDate", endDate);
            Set voaFormTypes = parameters.getFormTypes();
            if (voaFormTypes == null || voaFormTypes.isEmpty()) {
                ArrayList<Integer> dummyVoaFormTypes = new ArrayList<Integer>();
                dummyVoaFormTypes.add(new Integer(0));
                query.setParameterList("voaFormTypes", dummyVoaFormTypes);
                query.setString("allFormTypes", "all");
            } else {
                query.setParameterList("voaFormTypes", (Collection)this.getVoaFormTypeIds(voaFormTypes));
                query.setString("allFormTypes", "notAll");
            }
            ReportFacilityDisplayBy facilityDisplayBy = parameters.getFacilityDisplayBy();
            if (facilityDisplayBy != null && !StringUtils.isEmpty((String)facilityDisplayBy.getCode())) {
                if (StringUtils.equals((String)facilityDisplayBy.getCode(), (String)ReportFacilityDisplayBy.CODE_VISN.getCode())) {
                    List visns = this.getFacilitityIds(parameters.getFacilities());
                    if (visns != null && !visns.isEmpty()) {
                        query.setParameterList("visns", visns.toArray());
                    } else {
                        ArrayList<Integer> facilities = new ArrayList<Integer>();
                        facilities.add(new Integer(0));
                        query.setParameterList("visns", facilities);
                    }
                    if (parameters.isNoVISNPresent()) {
                        query.setString("noVISN", "noVISN");
                    } else {
                        query.setString("noVISN", "VISN");
                    }
                } else {
                    Set reportFacilities = parameters.getFacilities();
                    if (reportFacilities == null || reportFacilities.isEmpty()) {
                        ArrayList<Integer> facilities = new ArrayList<Integer>();
                        facilities.add(new Integer(0));
                        query.setParameterList("facilities", facilities);
                        query.setString("is_all", "all");
                    } else {
                        query.setParameterList("facilities", (Collection)this.getFacilitityIds(reportFacilities));
                        query.setString("is_all", "notAll");
                    }
                }
            }
        }
        return query;
    }

    private List getFacilitityIds(Set facilities) {
        Iterator i = facilities != null ? facilities.iterator() : null;
        ArrayList<BigDecimal> list = new ArrayList<BigDecimal>();
        while (i != null && i.hasNext()) {
            ReportFacility rFacility = (ReportFacility)i.next();
            if (rFacility == null) continue;
            list.add(((VAFacility)rFacility.getLookup()).getIdentifier());
        }
        return list;
    }

    private String getFacilitityCodes(Set facilities) {
        Iterator i = facilities != null ? facilities.iterator() : null;
        StringBuilder list = new StringBuilder();
        while (i != null && i.hasNext()) {
            ReportFacility rFacility = (ReportFacility)i.next();
            if (rFacility != null) {
                list.append(((VAFacility)rFacility.getLookup()).getCode());
            }
            if (!i.hasNext()) continue;
            list.append(",");
        }
        return list.toString();
    }

    private String getVisnNames(Set facilities) {
        Iterator i = facilities != null ? facilities.iterator() : null;
        StringBuilder list = new StringBuilder();
        while (i != null && i.hasNext()) {
            ReportFacility rFacility = (ReportFacility)i.next();
            if (rFacility != null) {
                list.append(((VAFacility)rFacility.getLookup()).getName());
            }
            if (!i.hasNext()) continue;
            list.append(",");
        }
        return list.toString();
    }

    private List getVoaFormTypeIds(Set voaFormTypes) {
        Iterator i = voaFormTypes != null ? voaFormTypes.iterator() : null;
        ArrayList<BigDecimal> list = new ArrayList<BigDecimal>();
        while (i != null && i.hasNext()) {
            ReportFormType rFormType = (ReportFormType)i.next();
            if (rFormType == null) continue;
            list.add(((VOAFormType)rFormType.getLookup()).getIdentifier());
        }
        return list;
    }

    private String getVoaFormTypeNames(Set voaFormTypes) {
        Iterator i = voaFormTypes != null ? voaFormTypes.iterator() : null;
        StringBuilder list = new StringBuilder();
        while (i != null && i.hasNext()) {
            ReportFormType rFormType = (ReportFormType)i.next();
            if (rFormType != null) {
                list.append(((VOAFormType)rFormType.getLookup()).getName());
            }
            if (!i.hasNext()) continue;
            list.append(",");
        }
        return list.toString();
    }
}

