/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.report.data.impl;

import gov.va.med.esr.common.model.lookup.ReportFacilityDisplayBy;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.lookup.VISN;
import gov.va.med.esr.common.model.report.ReportFacility;
import gov.va.med.esr.common.model.report.ReportParameterSet;
import gov.va.med.esr.common.model.report.ReportSetup;
import gov.va.med.esr.common.report.data.StandardReportCriteria;
import gov.va.med.esr.common.report.data.impl.AbstractStandardReportDataDAOImpl;
import gov.va.med.esr.service.UnknownLookupTypeException;
import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.data.QueryCriteria;
import gov.va.med.fw.report.data.ReportDataException;
import gov.va.med.fw.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Query;
import org.hibernate.Session;

public class SignedApplicationReportDataDAOImpl
extends AbstractStandardReportDataDAOImpl {
    private static final long serialVersionUID = 3913277504975056202L;
    private static final String PARAM_VALUE_ALL = "all";
    private static final String PARAM_VALUE_VISN = "visn";
    private static final String PARAM_VALUE_SITE = "site";
    private static final String PARAM_VALUE_NONE = "none";

    @Override
    public void preDataRetrieval(ReportConfiguration config) throws ReportDataException {
        super.preDataRetrieval(config);
        QueryCriteria reportCriteria = config.getQueryCriteria();
        try {
            if (reportCriteria instanceof StandardReportCriteria) {
                ReportParameterSet parameters;
                StandardReportCriteria criteria = (StandardReportCriteria)reportCriteria;
                ReportSetup setup = criteria.getReportSetup();
                ReportParameterSet reportParameterSet = parameters = setup != null ? setup.getParameterSet() : null;
                if (parameters == null) {
                    throw new ReportDataException("Missing report parameters in report " + config.getReportID());
                }
                criteria.setStartDate(this.getDate(config, true));
                criteria.setEndDate(this.getDate(config, false));
                criteria.setIncomeYear(criteria.getReportSetup().getParameterSet().getBeginIncomeYear());
                criteria.setEndIncomeYear(criteria.getReportSetup().getParameterSet().getEndIncomeYear());
                String visnNames = "";
                String facilityNames = "";
                ReportFacilityDisplayBy facilityDisplayBy = parameters.getFacilityDisplayBy();
                if (facilityDisplayBy == null || StringUtils.isEmpty((String)facilityDisplayBy.getCode())) {
                    visnNames = "ALL";
                    facilityNames = "ALL";
                } else if (StringUtils.equals((String)facilityDisplayBy.getCode(), (String)ReportFacilityDisplayBy.CODE_VISN.getCode())) {
                    Set visns = parameters.getFacilities();
                    if (visns != null && !visns.isEmpty()) {
                        List allVisns = this.lookupService.findAll(VISN.class);
                        if (allVisns.size() == visns.size()) {
                            visnNames = "ALL";
                            facilityNames = "ALL";
                        } else {
                            String visnVistaNames;
                            ArrayList visnVistaNameList = this.getVistaNameList(parameters.getFacilities());
                            visnNames = visnVistaNames = this.getItemsAsString(visnVistaNameList);
                            facilityNames = "ALL";
                        }
                    }
                } else {
                    Set reportFacilities = parameters.getFacilities();
                    if (reportFacilities == null || reportFacilities.isEmpty()) {
                        visnNames = "ALL";
                        facilityNames = "ALL";
                    } else {
                        StringBuffer visnVistaNamesSB = new StringBuffer();
                        StringBuffer facilityStationNamesSB = new StringBuffer();
                        this.getVisnAndFacilityNames(reportFacilities, visnVistaNamesSB, facilityStationNamesSB);
                        visnNames = visnVistaNamesSB.toString();
                        facilityNames = facilityStationNamesSB.toString();
                    }
                }
                criteria.addCriterion("visns", visnNames);
                criteria.addCriterion("facilities", facilityNames);
            }
        }
        catch (UnknownLookupTypeException e) {
            throw new ReportDataException((Throwable)((Object)e));
        }
        catch (ClassNotFoundException e) {
            throw new ReportDataException((Throwable)e);
        }
    }

    @Override
    protected Query buildQuery(ReportConfiguration config, Session session) throws ReportDataException {
        QueryCriteria reportCriteria = config.getQueryCriteria();
        Query query = null;
        if (reportCriteria instanceof StandardReportCriteria) {
            ReportParameterSet parameters;
            query = this.getNamedQuery(session);
            StandardReportCriteria criteria = (StandardReportCriteria)reportCriteria;
            ReportSetup setup = criteria.getReportSetup();
            ReportParameterSet reportParameterSet = parameters = setup != null ? setup.getParameterSet() : null;
            if (parameters == null) {
                throw new ReportDataException("Missing report parameters in report " + config.getReportID());
            }
            Integer incomeYear = parameters.getBeginIncomeYear();
            if (incomeYear == null) {
                throw new ReportDataException("Missing Income year in report " + config.getReportID());
            }
            query.setInteger("incomeYear", parameters.getBeginIncomeYear().intValue());
            if (parameters.getEndIncomeYear() != null) {
                query.setInteger("endIncomeYear", parameters.getEndIncomeYear().intValue());
            } else {
                query.setInteger("endIncomeYear", 0);
            }
            query.setDate("startDate", parameters.getFromDate());
            query.setDate("endDate", parameters.getToDate());
            query.setString("type", null);
            query.setString("is_all", null);
            query.setParameterList("facilities", (Collection)this.getDefaultList());
            query.setParameterList("visns", (Collection)this.getDefaultList());
            ReportFacilityDisplayBy facilityDisplayBy = parameters.getFacilityDisplayBy();
            if (facilityDisplayBy == null || StringUtils.isEmpty((String)facilityDisplayBy.getCode())) {
                query.setString("type", PARAM_VALUE_NONE);
                query.setString("noVISN", "noVISN");
            } else if (StringUtils.equals((String)facilityDisplayBy.getCode(), (String)ReportFacilityDisplayBy.CODE_VISN.getCode())) {
                query.setString("type", PARAM_VALUE_VISN);
                List visns = this.getFacilitityIds(parameters.getFacilities());
                if (visns != null && !visns.isEmpty()) {
                    query.setParameterList("visns", visns.toArray());
                } else {
                    ArrayList<Integer> facilities = new ArrayList<Integer>();
                    facilities.add(new Integer(0));
                    query.setParameterList("visns", facilities);
                }
                if (parameters.isNoVISNPresent()) {
                    query.setString("noVISN", "noVISN");
                } else {
                    query.setString("noVISN", "VISN");
                }
            } else {
                query.setString("type", PARAM_VALUE_SITE);
                query.setString("noVISN", "noVISN");
                Set reportFacilities = parameters.getFacilities();
                if (reportFacilities == null || reportFacilities.isEmpty()) {
                    query.setString("is_all", PARAM_VALUE_ALL);
                } else {
                    query.setParameterList("facilities", (Collection)this.getFacilitityIds(reportFacilities));
                }
            }
        }
        return query;
    }

    private List getDefaultList() {
        ArrayList<Integer> facilities = new ArrayList<Integer>();
        facilities.add(new Integer(0));
        return facilities;
    }

    private List getFacilitityIds(Set facilities) {
        Iterator i = facilities != null ? facilities.iterator() : null;
        ArrayList<BigDecimal> list = new ArrayList<BigDecimal>();
        while (i != null && i.hasNext()) {
            ReportFacility rFacility = (ReportFacility)i.next();
            if (rFacility == null || rFacility.getLookup() == null) continue;
            list.add(rFacility.getFacility().getIdentifier());
        }
        return list;
    }

    private void getVisnAndFacilityNames(Set facilities, StringBuffer visnVistaNamesSB, StringBuffer facilityStationNamesSB) throws UnknownLookupTypeException, ClassNotFoundException {
        Iterator i = facilities != null ? facilities.iterator() : null;
        HashMap<BigDecimal, ArrayList<VAFacility>> selectedVisnFacilityMap = new HashMap<BigDecimal, ArrayList<VAFacility>>();
        while (i != null && i.hasNext()) {
            VAFacility vaFacility;
            BigDecimal visnId;
            ReportFacility rFacility = (ReportFacility)i.next();
            if (rFacility == null || rFacility.getLookup() == null || (visnId = (vaFacility = rFacility.getFacility()).getVisnId()) == null) continue;
            ArrayList<VAFacility> visnfacilityList = (ArrayList<VAFacility>)selectedVisnFacilityMap.get(visnId);
            if (visnfacilityList == null) {
                visnfacilityList = new ArrayList<VAFacility>();
                selectedVisnFacilityMap.put(visnId, visnfacilityList);
            }
            visnfacilityList.add(vaFacility);
        }
        ArrayList<String> selectedVisnVistaNames = new ArrayList<String>();
        ArrayList selectedfacilityStationnames = new ArrayList();
        boolean allStations = true;
        Map visnFacilityMap = this.lookupService.getVISNSiteMap();
        for (Map.Entry mapEntry : visnFacilityMap.entrySet()) {
            VISN visn = (VISN)((Object)mapEntry.getKey());
            Collection visnFacilities = (Collection)mapEntry.getValue();
            Collection selectedVisnFacilities = (Collection)selectedVisnFacilityMap.get(visn.getIdentifier());
            if (selectedVisnFacilities == null) continue;
            int selectedVisnFacilitiesSize = selectedVisnFacilities != null ? selectedVisnFacilities.size() : 0;
            int visnFacililitiesSize = visnFacilities != null ? visnFacilities.size() : 0;
            selectedVisnVistaNames.add(visn.getDescription());
            if (selectedVisnFacilitiesSize == visnFacililitiesSize) continue;
            allStations = false;
        }
        if (!allStations) {
            selectedfacilityStationnames = this.getStationNameList(facilities);
            facilityStationNamesSB.append(this.getItemsAsString(selectedfacilityStationnames));
        } else {
            facilityStationNamesSB.append("ALL");
        }
        visnVistaNamesSB.append(this.getItemsAsString(selectedVisnVistaNames));
    }

    private ArrayList getVistaNameList(Set facilities) {
        Iterator i = facilities != null ? facilities.iterator() : null;
        ArrayList<String> vistaNameList = new ArrayList<String>();
        while (i != null && i.hasNext()) {
            ReportFacility rFacility = (ReportFacility)i.next();
            if (rFacility == null || rFacility.getLookup() == null) continue;
            vistaNameList.add(rFacility.getFacility().getDescription());
        }
        return vistaNameList;
    }

    private ArrayList getStationNameList(Set facilities) {
        Iterator i = facilities != null ? facilities.iterator() : null;
        ArrayList<String> vistaNameList = new ArrayList<String>();
        while (i != null && i.hasNext()) {
            ReportFacility rFacility = (ReportFacility)i.next();
            if (rFacility == null || rFacility.getLookup() == null) continue;
            vistaNameList.add(rFacility.getFacility().getStationNumber());
        }
        return vistaNameList;
    }

    private String getItemsAsString(ArrayList facilities) {
        String rFacility;
        Iterator i = facilities != null ? facilities.iterator() : null;
        StringBuffer sBuf = new StringBuffer();
        if (i != null && i.hasNext()) {
            rFacility = (String)i.next();
            sBuf.append(rFacility);
        }
        if (i != null) {
            while (i.hasNext()) {
                sBuf.append(", ");
                rFacility = (String)i.next();
                sBuf.append(rFacility);
            }
        }
        return sBuf.toString();
    }
}

