/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.report.data.impl;

import gov.va.med.esr.common.model.lookup.ReportExceptionType;
import gov.va.med.esr.common.model.report.ReportParameterSet;
import gov.va.med.esr.common.model.report.ReportSetup;
import gov.va.med.esr.common.report.data.StandardReportCriteria;
import gov.va.med.esr.common.report.data.impl.ParamSubstitutionDAOImpl;
import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.data.QueryCriteria;
import gov.va.med.fw.report.data.ReportDataException;
import gov.va.med.fw.util.StringUtils;
import org.hibernate.Query;
import org.hibernate.Session;

public class QM27ReportDataDAOImpl
extends ParamSubstitutionDAOImpl {
    private static final long serialVersionUID = 1178123948624532738L;

    @Override
    public void preDataRetrieval(ReportConfiguration config) throws ReportDataException {
        QueryCriteria reportCriteria = config.getQueryCriteria();
        if (reportCriteria instanceof StandardReportCriteria) {
            ReportExceptionType exceptionType;
            ReportParameterSet parameters;
            StandardReportCriteria criteria = (StandardReportCriteria)reportCriteria;
            ReportSetup setup = criteria.getReportSetup();
            ReportParameterSet reportParameterSet = parameters = setup != null ? setup.getParameterSet() : null;
            if (parameters == null) {
                throw new ReportDataException("Missing report parameters in report " + config.getReportID());
            }
            Integer batchNumber = parameters.getBatchNumber();
            if (batchNumber != null) {
                criteria.addCriterion("batchNumber", batchNumber.toString());
            }
            if ((exceptionType = parameters.getExceptionType()) != null) {
                criteria.addCriterion("exceptionType", exceptionType.getDescription());
            }
        }
    }

    @Override
    protected Query buildQuery(ReportConfiguration config, Session session) throws ReportDataException {
        QueryCriteria reportCriteria = config.getQueryCriteria();
        Query query = null;
        if (reportCriteria instanceof StandardReportCriteria) {
            ReportParameterSet parameters;
            query = this.getNamedQuery(session);
            StandardReportCriteria criteria = (StandardReportCriteria)reportCriteria;
            ReportSetup setup = criteria.getReportSetup();
            ReportParameterSet reportParameterSet = parameters = setup != null ? setup.getParameterSet() : null;
            if (parameters == null) {
                throw new ReportDataException("Missing report parameters in report " + config.getReportID());
            }
            Integer batchNumber = parameters.getBatchNumber();
            if (batchNumber == null) {
                throw new ReportDataException("Missing Batch Number in report " + config.getReportID());
            }
            query.setInteger("batchNumber", batchNumber.intValue());
            ReportExceptionType exceptionType = parameters.getExceptionType();
            if (exceptionType != null) {
                if (StringUtils.equals((String)exceptionType.getCode(), (String)ReportExceptionType.ALL.getCode())) {
                    query.setString("is_all", "is_all");
                    query.setString("is_null", "is_all");
                    query.setString("is_not_null", "is_all");
                    query.setString("exceptionType", "0");
                } else {
                    query.setString("is_all", "is_not_null");
                    query.setString("is_null", "is_not_null");
                    query.setString("is_not_null", "is_not_null");
                    query.setString("exceptionType", exceptionType.getCode());
                }
            } else {
                query.setString("is_all", "is_null");
                query.setString("is_null", "is_null");
                query.setString("is_not_null", "is_null");
                query.setString("exceptionType", "0");
            }
        }
        return query;
    }
}

