/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.report.data.impl;

import gov.va.med.esr.common.model.lookup.EnrollmentPriorityGroup;
import gov.va.med.esr.common.model.lookup.EnrollmentPrioritySubGroup;
import gov.va.med.esr.common.model.lookup.EnrollmentStatus;
import gov.va.med.esr.common.model.lookup.ReportFacilityDisplayBy;
import gov.va.med.esr.common.model.lookup.ReportFormat;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.report.ReportEnrollmentPriorityGroup;
import gov.va.med.esr.common.model.report.ReportEnrollmentStatus;
import gov.va.med.esr.common.model.report.ReportFacility;
import gov.va.med.esr.common.model.report.ReportParameterSet;
import gov.va.med.esr.common.model.report.ReportSetup;
import gov.va.med.esr.common.report.data.StandardReportCriteria;
import gov.va.med.esr.common.report.data.impl.AbstractStandardReportDataDAOImpl;
import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.data.QueryCriteria;
import gov.va.med.fw.report.data.ReportDataException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Query;
import org.hibernate.Session;

public class EnrolleeEnrollmentStatusReportDataDAOImpl
extends AbstractStandardReportDataDAOImpl {
    private static final long serialVersionUID = 5326464717739558387L;

    @Override
    protected Query buildQuery(ReportConfiguration config, Session session) throws ReportDataException {
        ReportFormat format;
        Set facilities;
        ReportParameterSet parameters;
        QueryCriteria reportCriteria = config.getQueryCriteria();
        StandardReportCriteria criteria = (StandardReportCriteria)reportCriteria;
        ReportSetup setup = criteria.getReportSetup();
        ReportParameterSet reportParameterSet = parameters = setup != null ? setup.getParameterSet() : null;
        if (parameters == null) {
            throw new ReportDataException("Missing report parameters in report " + config.getReportID());
        }
        Query query = this.getNamedQuery(session);
        query.setDate("startDate", this.getDate(config, true));
        query.setDate("endDate", this.getDate(config, false));
        ReportFacilityDisplayBy facilityDisplayBy = parameters.getFacilityDisplayBy();
        ArrayList<BigDecimal> facilityIds = new ArrayList<BigDecimal>();
        if (facilityDisplayBy != null && (facilities = parameters.getFacilities()) != null && !facilities.isEmpty()) {
            Iterator i = facilities.iterator();
            while (i.hasNext()) {
                VAFacility facility = ((ReportFacility)i.next()).getFacility();
                facilityIds.add(facility.getIdentifier());
            }
        }
        if ((format = parameters.getReportFormat()) != null && format.getCode().equals(ReportFormat.DETAIL.getCode())) {
            this.setDetailFacilities(parameters, facilityDisplayBy, query, facilityIds);
        } else if (facilityDisplayBy != null) {
            this.setSummaryFacilities(parameters, facilityDisplayBy, query, facilityIds);
        }
        Set enrollmentPriorites = parameters.getReportEnrollmentPriorityGroups();
        ArrayList<Number> priorityIds = new ArrayList<Number>();
        ArrayList<Number> subPriorityIds = new ArrayList<Number>();
        if (enrollmentPriorites != null && !enrollmentPriorites.isEmpty()) {
            for (ReportEnrollmentPriorityGroup reportPriorityGroup : enrollmentPriorites) {
                EnrollmentPrioritySubGroup subGroup;
                EnrollmentPriorityGroup group = reportPriorityGroup.getEnrollmentPriorityGroup();
                if (group != null) {
                    priorityIds.add(group.getIdentifier());
                }
                if ((subGroup = reportPriorityGroup.getEnrollmentPrioritySubGroup()) == null) continue;
                subPriorityIds.add(subGroup.getIdentifier());
            }
        }
        if (!priorityIds.isEmpty()) {
            query.setString("all_groups", "NO");
        } else {
            query.setString("all_groups", "ALL");
        }
        if (!subPriorityIds.isEmpty()) {
            query.setString("all_subGroups", "NO");
        } else if (subPriorityIds.isEmpty() && !priorityIds.isEmpty()) {
            query.setString("all_subGroups", "NO");
            subPriorityIds.add(new Integer(0));
        } else {
            query.setString("all_subGroups", "ALL");
            subPriorityIds.add(new Integer(0));
        }
        if (priorityIds.isEmpty()) {
            priorityIds.add(new Integer(0));
        }
        query.setParameterList("groupPriorities", priorityIds);
        query.setParameterList("subGroupPriorities", subPriorityIds);
        Set enrollmentstatuses = parameters.getEnrollmentStatuses();
        ArrayList<Number> statusIds = new ArrayList<Number>();
        if (enrollmentstatuses != null && !enrollmentstatuses.isEmpty()) {
            Iterator i = enrollmentstatuses.iterator();
            while (i.hasNext()) {
                EnrollmentStatus status = ((ReportEnrollmentStatus)i.next()).getEnrollmentStatus();
                statusIds.add(status.getIdentifier());
            }
        }
        if (!statusIds.isEmpty()) {
            query.setString("all_statuses", "NO");
        } else {
            query.setString("all_statuses", "ALL");
            statusIds.add(new Integer(0));
        }
        query.setParameterList("enrollmentStatuses", statusIds);
        return query;
    }

    private void setSummaryFacilities(ReportParameterSet parameters, ReportFacilityDisplayBy facilityDisplayBy, Query query, List facilityIds) {
        if (ReportFacilityDisplayBy.CODE_VISN.getCode().equals(facilityDisplayBy.getCode()) || ReportFacilityDisplayBy.CODE_VISN_SITE.getCode().equals(facilityDisplayBy.getCode()) || ReportFacilityDisplayBy.CODE_SITE.getCode().equals(facilityDisplayBy.getCode()) || ReportFacilityDisplayBy.CODE_VISN_VAMC.getCode().equals(facilityDisplayBy.getCode()) || ReportFacilityDisplayBy.CODE_VISN_VAMC_SITE.getCode().equals(facilityDisplayBy.getCode()) || ReportFacilityDisplayBy.CODE_VAMC.getCode().equals(facilityDisplayBy.getCode()) || ReportFacilityDisplayBy.CODE_VAMC_SITE.getCode().equals(facilityDisplayBy.getCode())) {
            if (!facilityIds.isEmpty()) {
                query.setString("all_facilities", "NO");
            } else if (ReportFacilityDisplayBy.CODE_VISN.getCode().equals(facilityDisplayBy.getCode())) {
                query.setString("all_facilities", "NO");
                facilityIds.add(new Integer(0));
            } else {
                query.setString("all_facilities", "ALL");
                facilityIds.add(new Integer(0));
            }
            query.setParameterList("facilities", (Collection)facilityIds);
        }
        if (facilityDisplayBy != null && ReportFacilityDisplayBy.CODE_VISN.getCode().equals(facilityDisplayBy.getCode())) {
            if (parameters.isNoVISNPresent()) {
                query.setString("noVISN", "noVISN");
            } else {
                query.setString("noVISN", "VISN");
            }
        }
    }

    private void setDetailFacilities(ReportParameterSet parameters, ReportFacilityDisplayBy facilityDisplayBy, Query query, List facilityIds) {
        ArrayList<Integer> visns = null;
        ArrayList<Integer> facilities = null;
        ArrayList<Integer> vamcs = null;
        if (facilityDisplayBy != null && ReportFacilityDisplayBy.CODE_VISN.getCode().equals(facilityDisplayBy.getCode())) {
            if (!facilityIds.isEmpty()) {
                query.setString("all_facilities", "NO");
                visns = facilityIds;
                facilities = new ArrayList();
                facilities.add(new Integer(0));
                vamcs = new ArrayList();
                vamcs.add(new Integer(0));
            } else {
                query.setString("all_facilities", "NO");
                facilities = new ArrayList();
                facilities.add(new Integer(0));
                visns = new ArrayList();
                visns.add(new Integer(0));
                vamcs = new ArrayList();
                vamcs.add(new Integer(0));
            }
        } else if (facilityDisplayBy != null && (ReportFacilityDisplayBy.CODE_VISN_SITE.getCode().equals(facilityDisplayBy.getCode()) || ReportFacilityDisplayBy.CODE_SITE.getCode().equals(facilityDisplayBy.getCode()))) {
            if (!facilityIds.isEmpty()) {
                query.setString("all_facilities", "NO");
                facilities = facilityIds;
                visns = new ArrayList();
                visns.add(new Integer(0));
                vamcs = new ArrayList();
                vamcs.add(new Integer(0));
            } else {
                query.setString("all_facilities", "ALL");
                facilities = new ArrayList();
                facilities.add(new Integer(0));
                visns = new ArrayList();
                visns.add(new Integer(0));
                vamcs = new ArrayList();
                vamcs.add(new Integer(0));
            }
        } else if (facilityDisplayBy != null && (ReportFacilityDisplayBy.CODE_VAMC_SITE.getCode().equals(facilityDisplayBy.getCode()) || ReportFacilityDisplayBy.CODE_VAMC.getCode().equals(facilityDisplayBy.getCode()) || ReportFacilityDisplayBy.CODE_VISN_VAMC_SITE.getCode().equals(facilityDisplayBy.getCode()) || ReportFacilityDisplayBy.CODE_VISN_VAMC.getCode().equals(facilityDisplayBy.getCode()))) {
            query.setString("all_facilities", "NO");
            visns = new ArrayList<Integer>();
            visns.add(new Integer(0));
            facilities = facilityIds;
            vamcs = facilityIds;
        } else {
            query.setString("all_facilities", "ALL");
            facilities = new ArrayList<Integer>();
            facilities.add(new Integer(0));
            visns = new ArrayList();
            visns.add(new Integer(0));
            vamcs = new ArrayList();
            vamcs.add(new Integer(0));
        }
        if (facilityDisplayBy != null && ReportFacilityDisplayBy.CODE_VISN.getCode().equals(facilityDisplayBy.getCode())) {
            if (parameters.isNoVISNPresent()) {
                query.setString("noVISN", "noVISN");
            } else {
                query.setString("noVISN", "VISN");
            }
        } else {
            query.setString("noVISN", "noVISN");
        }
        query.setParameterList("facilities", facilities);
        query.setParameterList("visns", visns);
        query.setParameterList("vamcs", vamcs);
    }
}

