/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.report.data.impl;

import gov.va.med.esr.common.model.lookup.CancelDeclineReason;
import gov.va.med.esr.common.model.lookup.ReportFacilityDisplayBy;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.report.ReportCancelDeclineReason;
import gov.va.med.esr.common.model.report.ReportFacility;
import gov.va.med.esr.common.model.report.ReportParameterSet;
import gov.va.med.esr.common.model.report.ReportSetup;
import gov.va.med.esr.common.report.data.StandardReportCriteria;
import gov.va.med.esr.common.report.data.impl.AbstractStandardReportDataDAOImpl;
import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.data.QueryCriteria;
import gov.va.med.fw.report.data.ReportDataException;
import gov.va.med.fw.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Query;
import org.hibernate.Session;

public class CancelDeclineReportDataDAOImpl
extends AbstractStandardReportDataDAOImpl {
    private static final long serialVersionUID = -4747089852162276203L;

    @Override
    protected Query buildQuery(ReportConfiguration config, Session session) throws ReportDataException {
        ReportParameterSet parameters;
        Query query = null;
        query = this.getNameResolver() != null ? this.getNamedQuery(this.getNameResolver().getReportName(config), session) : this.getNamedQuery(session);
        QueryCriteria reportCriteria = config.getQueryCriteria();
        StandardReportCriteria criteria = (StandardReportCriteria)reportCriteria;
        ReportSetup setup = criteria.getReportSetup();
        ReportParameterSet reportParameterSet = parameters = setup != null ? setup.getParameterSet() : null;
        if (parameters == null) {
            throw new ReportDataException("Missing report parameters in report " + config.getReportID());
        }
        query.setDate("startDate", parameters.getFromDate());
        query.setDate("endDate", parameters.getToDate());
        Set cdReasons = parameters.getCancelDeclineReasons();
        query.setParameterList("cdReasonType", (Collection)this.getCDReasonIds(cdReasons));
        ReportFacilityDisplayBy facilityDisplayBy = parameters.getFacilityDisplayBy();
        if (facilityDisplayBy != null && StringUtils.isNotEmpty((String)facilityDisplayBy.getCode())) {
            if (StringUtils.equals((String)facilityDisplayBy.getCode(), (String)ReportFacilityDisplayBy.CODE_VISN.getCode())) {
                List visns = this.getFacilitityIds(parameters.getFacilities());
                if (visns != null && !visns.isEmpty()) {
                    query.setParameterList("facilityList", visns.toArray());
                } else {
                    ArrayList<Integer> facilities = new ArrayList<Integer>();
                    facilities.add(new Integer(0));
                    query.setParameterList("facilityList", facilities);
                }
                if (parameters.isNoVISNPresent()) {
                    query.setString("noVISN", "noVISN");
                } else {
                    query.setString("noVISN", "VISN");
                }
            } else {
                Set reportFacilities = parameters.getFacilities();
                if (reportFacilities == null || reportFacilities.isEmpty()) {
                    ArrayList<Integer> facilities = new ArrayList<Integer>();
                    facilities.add(new Integer(0));
                    query.setParameterList("facilityList", facilities);
                    query.setString("ALL", "ALL");
                } else {
                    query.setParameterList("facilityList", (Collection)this.getFacilitityIds(reportFacilities));
                    query.setString("ALL", "NO");
                }
            }
        }
        return query;
    }

    private List getCDReasonIds(Set cdReasons) {
        Iterator i = cdReasons != null ? cdReasons.iterator() : null;
        ArrayList<BigDecimal> list = new ArrayList<BigDecimal>();
        while (i != null && i.hasNext()) {
            ReportCancelDeclineReason cdReason = (ReportCancelDeclineReason)i.next();
            if (cdReason == null) continue;
            list.add(((CancelDeclineReason)cdReason.getLookup()).getIdentifier());
        }
        return list;
    }

    private List getFacilitityIds(Set facilities) {
        Iterator i = facilities != null ? facilities.iterator() : null;
        ArrayList<BigDecimal> list = new ArrayList<BigDecimal>();
        while (i != null && i.hasNext()) {
            ReportFacility rFacility = (ReportFacility)i.next();
            if (rFacility == null) continue;
            list.add(((VAFacility)rFacility.getLookup()).getIdentifier());
        }
        return list;
    }
}

