/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.report.data.impl;

import gov.va.med.esr.common.model.report.ReportLookupParameter;
import gov.va.med.esr.common.model.report.ReportParameterSet;
import gov.va.med.esr.common.model.report.ReportSetup;
import gov.va.med.esr.common.report.data.StandardReportCriteria;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.PSDelegateService;
import gov.va.med.fw.model.lookup.AbstractLookup;
import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.ReportNameResolver;
import gov.va.med.fw.report.data.QueryCriteria;
import gov.va.med.fw.report.data.ReportDataException;
import gov.va.med.fw.report.data.hibernate.HibernateReportDataDAO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.hibernate.Query;
import org.hibernate.Session;

public abstract class AbstractStandardReportDataDAOImpl
extends HibernateReportDataDAO {
    private static final long serialVersionUID = 1178123948624532738L;
    protected PSDelegateService psDelegateService = null;
    protected LookupService lookupService = null;
    protected ReportNameResolver nameResolver = null;

    protected AbstractStandardReportDataDAOImpl() {
    }

    public void setPsDelegateService(PSDelegateService psDelegateService) {
        this.psDelegateService = psDelegateService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    public ReportNameResolver getNameResolver() {
        return this.nameResolver;
    }

    public void setNameResolver(ReportNameResolver nameResolver) {
        this.nameResolver = nameResolver;
    }

    public void preDataRetrieval(ReportConfiguration config) throws ReportDataException {
        QueryCriteria reportCriteria = config.getQueryCriteria();
        if (reportCriteria instanceof StandardReportCriteria) {
            StandardReportCriteria criteria = (StandardReportCriteria)reportCriteria;
            ReportSetup setup = criteria.getReportSetup();
            ReportParameterSet parameters = setup.getParameterSet();
            criteria.setStartDate(this.getDate(config, true));
            criteria.setEndDate(this.getDate(config, false));
            if (parameters.getFileType() != null) {
                criteria.setFileType(parameters.getFileType().getCode());
            }
        }
    }

    protected void initDao() throws Exception {
        super.initDao();
        Validate.notNull((Object)this.psDelegateService, (String)"A PS delegate service must be configured");
        Validate.notNull((Object)this.lookupService, (String)"A lookup service must be configured");
    }

    protected Date getDate(ReportConfiguration config, boolean isStartDate) {
        Date date = null;
        QueryCriteria reportCriteria = config.getQueryCriteria();
        if (reportCriteria instanceof StandardReportCriteria) {
            StandardReportCriteria criteria = (StandardReportCriteria)reportCriteria;
            ReportSetup setup = criteria.getReportSetup();
            ReportParameterSet parameters = setup.getParameterSet();
            date = isStartDate ? parameters.getFromDate() : parameters.getToDate();
        }
        return date;
    }

    protected Query buildQuery(ReportConfiguration config, Session session) throws ReportDataException {
        Query query = this.getNamedQuery(session);
        query.setDate("startDate", this.getDate(config, true));
        query.setDate("endDate", this.getDate(config, false));
        return query;
    }

    protected List getLookupIds(Set reportLookupParameterSet) {
        Iterator i = reportLookupParameterSet != null ? reportLookupParameterSet.iterator() : null;
        ArrayList<BigDecimal> list = new ArrayList<BigDecimal>();
        while (i != null && i.hasNext()) {
            ReportLookupParameter reportLookupParameter = (ReportLookupParameter)i.next();
            if (reportLookupParameter == null) continue;
            list.add(((AbstractLookup)reportLookupParameter.getLookup()).getIdentifier());
        }
        return list;
    }

    protected List getLookupIds(Class lookupClass) throws ReportDataException {
        try {
            List lookupList = this.lookupService.findAll(lookupClass);
            Iterator i = lookupList != null ? lookupList.iterator() : null;
            ArrayList<BigDecimal> list = new ArrayList<BigDecimal>();
            while (i != null && i.hasNext()) {
                AbstractLookup lookup = (AbstractLookup)i.next();
                list.add(lookup.getIdentifier());
            }
            return list;
        }
        catch (Exception e) {
            throw new ReportDataException(e.getMessage(), (Throwable)e);
        }
    }
}

