/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.report.data;

import gov.va.med.esr.common.model.lookup.ReportEEDWeeklyType;
import gov.va.med.esr.common.model.report.ReportEEDWeeklyReportType;
import gov.va.med.esr.common.model.report.ReportParameterSet;
import gov.va.med.esr.common.model.report.ReportSetup;
import gov.va.med.esr.common.report.data.StandardReportCriteria;
import gov.va.med.esr.common.rule.service.MergeRuleService;
import gov.va.med.fw.report.ConfigurableReportBuilder;
import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.ReportException;
import gov.va.med.fw.report.ReportExporter;
import gov.va.med.fw.report.ReportTemplate;
import gov.va.med.fw.report.data.QueryCriteria;
import gov.va.med.fw.report.data.ReportDataService;
import gov.va.med.fw.service.ServiceException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Set;

public class WeeklyReportBuilder
extends ConfigurableReportBuilder {
    private static final long serialVersionUID = 3052123366601812768L;
    private MergeRuleService mergeRuleService = null;

    public void setMergeRuleService(MergeRuleService mergeRuleService) {
        this.mergeRuleService = mergeRuleService;
    }

    public void afterPropertiesSet() throws Exception {
    }

    public void buildReport(ReportConfiguration configuration) throws ReportException {
        Set list;
        QueryCriteria criteria = configuration.getQueryCriteria();
        StandardReportCriteria reportCriteria = criteria instanceof StandardReportCriteria ? (StandardReportCriteria)criteria : null;
        ReportSetup reportSetup = reportCriteria != null ? reportCriteria.getReportSetup() : null;
        ReportParameterSet params = reportSetup != null ? reportSetup.getParameterSet() : null;
        Set set = list = params != null ? params.getReportEEDWeeklyReportTypes() : null;
        if (list != null) {
            for (ReportEEDWeeklyReportType report_type : list) {
                ReportSetup reportSetupCopy = this.getReportSetupCopy(reportSetup);
                this.removeOtherReportEEDWeeklyReportTypes(reportSetupCopy, report_type);
                String type = ReportEEDWeeklyType.Code.getByCode(report_type.getReportEEDWeeklyType().getCode()).getAlias();
                ReportDataService service = this.getReportDataService(type + ".dataService");
                ReportTemplate template = this.getReportTemplate(type + ".reportTemplate");
                ReportExporter exporter = this.getReportExporter(configuration.getReportOutputType());
                try {
                    if (reportCriteria == null || reportCriteria.getCriteria() == null) continue;
                    StandardReportCriteria sub_criteria = new StandardReportCriteria(new HashMap(reportCriteria.getCriteria()));
                    sub_criteria.setReportSetup(reportSetupCopy);
                    sub_criteria.setSubReportName(type);
                    StringBuffer output = new StringBuffer(reportSetup != null && reportSetup.getReport() != null ? reportSetup.getReport().getCode() : "");
                    output.append(" - ").append(type).append(".").append(configuration.getReportOutputType().getAlias().toLowerCase());
                    ReportConfiguration config = new ReportConfiguration(configuration.getReportName(), configuration.getReportID(), configuration.getReportOutputType(), output.toString());
                    config.setReportTitle(configuration.getReportTitle());
                    config.setReportUser(configuration.getReportUser());
                    config.setResourceMapping(sub_criteria.getCriteria());
                    config.setQueryCriteria((QueryCriteria)sub_criteria);
                    exporter.exportReport(config, service.requestReportData(config), template);
                }
                catch (IOException e) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info((Object)"Failed to create individual report configuration", (Throwable)e);
                    }
                    throw new ReportException("Failed to create individual report configuration", (Throwable)e);
                }
            }
        }
    }

    protected void removeOtherReportEEDWeeklyReportTypes(ReportSetup reportSetup, ReportEEDWeeklyReportType eedType) {
        ReportEEDWeeklyReportType reportType = null;
        for (ReportEEDWeeklyReportType eedReportType : reportSetup.getParameterSet().getReportEEDWeeklyReportTypes()) {
            if (!eedReportType.getReportEEDWeeklyType().getIdentifier().equals(eedType.getReportEEDWeeklyType().getIdentifier())) continue;
            reportType = eedReportType;
            break;
        }
        reportSetup.getParameterSet().removeAllReportEEDWeeklyReportTypes();
        reportSetup.getParameterSet().addReportEEDWeeklyReportType(reportType);
    }

    protected ReportSetup getReportSetupCopy(ReportSetup reportSetup) throws ReportException {
        ReportSetup newReportSetup = null;
        if (reportSetup != null) {
            newReportSetup = new ReportSetup();
            try {
                this.mergeRuleService.mergeReportSetup(reportSetup, newReportSetup);
            }
            catch (ServiceException e) {
                e.printStackTrace();
                throw new ReportException("Failed to merge report setup", (Throwable)e);
            }
        }
        return newReportSetup;
    }
}

