/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.report.data;

import gov.va.med.esr.common.model.report.ReportSetup;
import gov.va.med.esr.common.report.data.StandardReportCriteria;
import gov.va.med.esr.common.rule.service.MergeRuleService;
import gov.va.med.fw.report.ConfigurableReportBuilder;
import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.ReportException;
import gov.va.med.fw.report.data.QueryCriteria;
import gov.va.med.fw.report.data.ReportData;
import gov.va.med.fw.service.ServiceException;
import org.apache.commons.lang.Validate;

public class StandardReportBuilder
extends ConfigurableReportBuilder {
    private static final long serialVersionUID = -5393606047148762963L;
    private MergeRuleService mergeRuleService = null;

    public void setMergeRuleService(MergeRuleService mergeRuleService) {
        this.mergeRuleService = mergeRuleService;
    }

    public void buildReport(ReportConfiguration configuration) throws ReportException {
        super.buildReport(this.setReportSetupCopy(configuration));
    }

    public void buildReport(ReportConfiguration configuration, ReportData data) throws ReportException {
        super.buildReport(this.setReportSetupCopy(configuration), data);
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.mergeRuleService, (String)"A MergeRuleService service must be configured");
    }

    protected ReportConfiguration setReportSetupCopy(ReportConfiguration configuration) throws ReportException {
        QueryCriteria criteria = configuration.getQueryCriteria();
        StandardReportCriteria reportCriteria = criteria instanceof StandardReportCriteria ? (StandardReportCriteria)criteria : null;
        ReportSetup reportSetup = reportCriteria != null ? reportCriteria.getReportSetup() : null;
        ReportSetup reportSetupCopy = this.getReportSetupCopy(reportSetup);
        if (reportCriteria != null) {
            reportCriteria.setReportSetup(reportSetupCopy);
        }
        return configuration;
    }

    protected ReportSetup getReportSetupCopy(ReportSetup reportSetup) throws ReportException {
        ReportSetup newReportSetup = null;
        if (reportSetup != null) {
            newReportSetup = new ReportSetup();
            try {
                this.mergeRuleService.mergeReportSetup(reportSetup, newReportSetup);
            }
            catch (ServiceException e) {
                e.printStackTrace();
                throw new ReportException("Failed to merge report setup", (Throwable)e);
            }
        }
        return newReportSetup;
    }
}

