/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.report.data;

import gov.va.med.esr.common.model.lookup.AckType;
import gov.va.med.esr.common.report.data.StandardReportCriteria;
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.util.StringUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.springframework.context.MessageSource;

public class CommonExtractFileCriteria
extends StandardReportCriteria {
    public static final Type CDCONDITION_FILE = new Type("OPP 3");
    public static final Type CDDIAGNOSIS_FILE = new Type("OPP 2");
    public static final Type CDPROCEDURE_FILE = new Type("OPP 1");
    public static final Type ELIGIBILITY_FILE = new Type("OPP 6");
    public static final Type PERIODOFSERVICE_FILE = new Type("OPP 4");
    public static final Type RATEDDISABILITIES_FILE = new Type("OPP 7");
    public static final Type COMBATEPISODES_FILE = new Type("OPP 8");
    public static final Type MAIN_FILE = new Type("OPP 5");
    private static final String RUN_DATE = "runDate";
    private static final String RECORDS = "records";
    private static final String EXTRACT_FILE = "filename";
    private static final String REPORT_ID = "id";
    private static final String REPORT_TITLE = "title";
    private static final long serialVersionUID = -5789963986526186284L;
    private Type reportType = null;

    public CommonExtractFileCriteria(Type type) {
        this(type, null);
    }

    public CommonExtractFileCriteria(Type type, MessageSource bundle) {
        this.reportType = type;
        if (bundle != null) {
            String code = StringUtils.deleteWhitespace((String)type.getCode());
            String key = code + "." + EXTRACT_FILE;
            this.setExtractFileName(this.getDefaultValue(bundle, key));
            key = code + "." + REPORT_TITLE;
            this.setReportTitle(this.getDefaultValue(bundle, key));
            key = code + "." + REPORT_ID;
            this.setReportID(this.getDefaultValue(bundle, key));
        }
        this.setRunDate(Calendar.getInstance().getTime());
    }

    @Override
    public void setRunDate(Date date) {
        this.addCriterion(RUN_DATE, date);
    }

    @Override
    public Date getRunDate() {
        Object criterion = this.getCriteria().get(RUN_DATE);
        return criterion instanceof Date ? (Date)criterion : null;
    }

    public void setExtractFileName(String name) {
        this.addCriterion(EXTRACT_FILE, name);
    }

    public String getExtractFileName() {
        Object criterion = this.getCriteria().get(EXTRACT_FILE);
        return criterion instanceof String ? (String)criterion : null;
    }

    public void setRecords(Integer records) {
        this.addCriterion(RECORDS, records);
    }

    public Integer getRecords() {
        Object criterion = this.getCriteria().get(RECORDS);
        return criterion instanceof Integer ? (Integer)criterion : null;
    }

    public void setReportID(String id) {
        this.addCriterion(REPORT_ID, id);
    }

    public String getReportID() {
        Object criterion = this.getCriteria().get(REPORT_ID);
        return criterion instanceof String ? (String)criterion : null;
    }

    public void setReportTitle(String title) {
        this.addCriterion(REPORT_TITLE, title);
    }

    public String getReportTitle() {
        Object criterion = this.getCriteria().get(REPORT_TITLE);
        return criterion instanceof String ? (String)criterion : null;
    }

    public Type getReportType() {
        return this.reportType;
    }

    private String getDefaultValue(MessageSource bundle, String key) {
        String value = null;
        try {
            value = bundle.getMessage(key, null, Locale.getDefault());
        }
        catch (Exception e) {
            // empty catch block
        }
        return value;
    }

    public static class Type
    extends AbstractCode {
        private static final long serialVersionUID = 6209605494205996214L;

        private Type(String code) {
            super(code);
        }

        public static AckType.Code getByCode(String code) {
            return (AckType.Code)Type.getCode(AckType.Code.class, (String)code);
        }
    }
}

