/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.persistent.person.hibernate;

import gov.va.med.esr.common.model.person.VOAApplication;
import gov.va.med.esr.common.persistent.person.VOAApplicationDAO;
import gov.va.med.esr.common.ui.conversion.CommonVOAResubmissionConversionService;
import gov.va.med.esr.service.VOASearchCriteria;
import gov.va.med.esr.service.VOASearchResultBean;
import gov.va.med.fw.conversion.ConversionServiceException;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.MaxRecordsExceededException;
import gov.va.med.fw.persistent.hibernate.AbstractDAOAction;
import gov.va.med.fw.persistent.hibernate.GenericDAOImpl;
import gov.va.med.fw.persistent.hibernate.PaginatedQueryExecutor;
import gov.va.med.fw.service.pagination.SearchQueryInfo;
import gov.va.med.fw.util.SortElement;
import gov.va.med.fw.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateSystemException;

public class VOAApplicationDAOImpl
extends GenericDAOImpl
implements VOAApplicationDAO {
    private static final long serialVersionUID = 8793888127514734883L;
    private CommonVOAResubmissionConversionService voaConversionService;
    public static final String VOA_BY_PERSON_ID_QUERY = "VOAApplication_GetByPersonId";
    public static final String VOA_BY_APPLICATION_ID_QUERY = "VOAApplication_GetByApplicationId";
    public static final String VOA_BY_FQID_QUERY = "VOAApplication_GetByFQID";
    public static final String VOA_RESUBMISSION_APPS_QUERY = "VOAApplication_GetResubmissionApps";
    public static final String PARAM_PERSON_ID = "personId";
    public static final String PARAM_APPLICATION_ID = "applicationId";
    public static final String PARAM_FQID = "fqid";
    private static final String SELECT_COUNT_CLAUSE = "SELECT COUNT(*)";
    public static final String PENDING_IDENTITY_TRAITS = "Pending Identity Traits Update";
    public static final String PERSON_NOT_FOUND = "Person not found";
    public static final String PROXY_PF_FAILED = "Proxy PF Add Failed";
    public static final String PERSON_INFO_NOT_ACCEPTED = "Person Info Not Accepted";
    public static final String CHECK_PERSON_INFO = "person on the VOA submitted form was not accepted";
    public static final String CHECK_PROXY_PF = "VOA Workflow Case has been created";
    public static final String PCE = "Pending Catastrophic Edit (PCE)";
    private static final String DEFAULT_SORT_ORDER = " order by reqRecdDate DESC";
    public static final String TXT_1010EZ = "1010EZ";
    public static final String TXT_1010EZR = "1010EZR";
    public static final String TXT_1010HS = "1010HS";
    public static final String TXT_1010SH = "1010SH";
    public static final String TXT_1010CG = "1010CG";
    public static final String TXT_21526EZ = "21526EZ";
    public static final BigDecimal ID_1010EZ = new BigDecimal(1);
    public static final BigDecimal ID_1010EZR = new BigDecimal(2);
    public static final BigDecimal ID_1010HS = new BigDecimal(3);
    public static final BigDecimal ID_1010SH = new BigDecimal(4);
    public static final BigDecimal ID_1010CG = new BigDecimal(5);
    public static final BigDecimal ID_21526EZ = new BigDecimal(6);
    private static final String SELECT_VOA_CLAUSE = "SELECT voa.voa_enrollment_app_id applicationId, voa.fully_qualified_id fullqualifiedId, voa.applicant_last_name lastName, voa.applicant_first_name firstName, voa.applicant_ssn ssn, voa.applicant_dob dob, voa.std_gender_id gender, voa.request_received_timestamp reqRecdDate, voa.enrollment_form_type_id formType, voa.error_text errorText";
    private static final String FROM_VOA_CLAUSE = "from voa_enrollment_application voa, voa_resubmission resub WHERE voa.voa_enrollment_app_status_id = 4 AND voa.voa_enrollment_app_id = resub.voa_enrollment_app_id AND resub.pending_application_text IS NOT NULL ";
    private static Map uiFieldToColumnMap = new HashMap();

    @Override
    public List getByPersonId(BigDecimal personId) throws DAOException {
        Validate.notNull((Object)personId, (String)"personId cannot be null");
        try {
            return this.findByNamedQueryAndNamedParam(VOA_BY_PERSON_ID_QUERY, PARAM_PERSON_ID, personId);
        }
        catch (Exception e) {
            throw new DAOException("getByPersonId failed for personId: " + personId, (Throwable)e);
        }
    }

    @Override
    public VOAApplication getByApplicationId(BigDecimal applicationId) throws DAOException {
        Validate.notNull((Object)applicationId, (String)"applicationId cannot be null");
        try {
            List results = this.findByNamedQueryAndNamedParam(VOA_BY_APPLICATION_ID_QUERY, PARAM_APPLICATION_ID, applicationId);
            this.verifyDataIntegrity(applicationId, results);
            return results.size() == 0 ? null : (VOAApplication)((Object)results.get(0));
        }
        catch (Exception e) {
            throw new DAOException("getByApplicationId failed for applicationId: " + applicationId, (Throwable)e);
        }
    }

    @Override
    public List getByFQID(String fqid) throws DAOException {
        Validate.notNull((Object)fqid, (String)"fqid cannot be null");
        try {
            return this.findByNamedQueryAndNamedParam(VOA_BY_FQID_QUERY, PARAM_FQID, fqid);
        }
        catch (Exception e) {
            throw new DAOException("getByFQID failed for fqid: " + fqid, (Throwable)e);
        }
    }

    @Override
    public List getVOAResubmissionApplications() throws DAOException {
        try {
            return super.getHibernateTemplate().findByNamedQuery(VOA_RESUBMISSION_APPS_QUERY);
        }
        catch (Exception e) {
            throw new DAOException("getResubmissionApplications failed", (Throwable)e);
        }
    }

    public List findPendingSubmissions(VOASearchCriteria voaSearchCriteria) throws DAOException {
        HashMap<String, VOASearchCriteria> contextData = new HashMap<String, VOASearchCriteria>();
        contextData.put("voaSearchCriteria", voaSearchCriteria);
        AbstractDAOAction callback = new AbstractDAOAction(contextData){

            public Object execute(Session session) {
                Query dataQuery = VOAApplicationDAOImpl.this.getSearchSelectDataQueryString(session, (VOASearchCriteria)this.getContextData().get("voasearchCriteria"));
                return dataQuery.list();
            }
        };
        List pendingSubmissions = this.getHibernateTemplate().executeFind((HibernateCallback)callback);
        for (int i = 0; i < pendingSubmissions.size(); ++i) {
            this.loadLazyProperties((VOAApplication)((Object)pendingSubmissions.get(i)));
        }
        return pendingSubmissions;
    }

    @Override
    public List find(SearchQueryInfo searchQueryInfo) throws DAOException, MaxRecordsExceededException {
        VOASearchCriteria voasearchCriteria = (VOASearchCriteria)searchQueryInfo;
        HashMap<String, VOASearchCriteria> contextData = new HashMap<String, VOASearchCriteria>();
        contextData.put("voasearchCriteria", voasearchCriteria);
        AbstractDAOAction callback = new AbstractDAOAction(contextData){

            public Object execute(Session session) throws DAOException {
                VOASearchCriteria targetQueryInfo = (VOASearchCriteria)this.getContextData().get("voasearchCriteria");
                Query countQuery = VOAApplicationDAOImpl.this.getSearchSelectCountQueryString(session, targetQueryInfo);
                Query dataQuery = VOAApplicationDAOImpl.this.getSearchSelectDataQueryString(session, targetQueryInfo);
                PaginatedQueryExecutor queryExecutor = new PaginatedQueryExecutor(countQuery, dataQuery, (SearchQueryInfo)targetQueryInfo);
                try {
                    List results = queryExecutor.executeQuery();
                    ArrayList<VOASearchResultBean> pendingSubmissions = new ArrayList<VOASearchResultBean>();
                    ArrayList applicationids = new ArrayList();
                    for (Object[] objArray : results) {
                        VOASearchResultBean bean = new VOASearchResultBean();
                        try {
                            VOAApplicationDAOImpl.this.voaConversionService;
                            CommonVOAResubmissionConversionService.convert(objArray, bean);
                        }
                        catch (ConversionServiceException e) {
                            e.printStackTrace();
                        }
                        pendingSubmissions.add(bean);
                    }
                    return pendingSubmissions;
                }
                catch (MaxRecordsExceededException e) {
                    throw new DAOException("max records exceeded", (Throwable)e);
                }
            }
        };
        try {
            return this.getHibernateTemplate().executeFind((HibernateCallback)callback);
        }
        catch (HibernateSystemException e) {
            MaxRecordsExceededException rootCause = (MaxRecordsExceededException)this.getRootExceptionOfType(e, MaxRecordsExceededException.class);
            if (rootCause != null) {
                throw rootCause;
            }
            throw e;
        }
    }

    public int getPendingSubmissionsCount(VOASearchCriteria voaSearchCriteria) throws DAOException {
        HashMap<String, VOASearchCriteria> contextData = new HashMap<String, VOASearchCriteria>();
        contextData.put("voaSearchCriteria", voaSearchCriteria);
        AbstractDAOAction callback = new AbstractDAOAction(contextData){

            public Object execute(Session session) {
                Query query = VOAApplicationDAOImpl.this.getSearchSelectCountQueryString(session, (VOASearchCriteria)this.getContextData().get("voaSearchCriteria"));
                return new Integer(VOAApplicationDAOImpl.this.executeCountQuery(query));
            }
        };
        return (Integer)this.getHibernateTemplate().execute((HibernateCallback)callback);
    }

    private Query getSearchSelectCountQueryString(Session session, VOASearchCriteria searchCriteria) {
        ArrayList paramList = new ArrayList();
        ArrayList valueList = new ArrayList();
        String queryString = SELECT_COUNT_CLAUSE + this.getSearchFromClause(searchCriteria) + this.getSearchWhereClause(searchCriteria, paramList, valueList);
        SQLQuery query = session.createSQLQuery(queryString);
        for (int i = 0; i < paramList.size(); ++i) {
            Object parValue = valueList.get(i);
            if (parValue != null && parValue instanceof List) {
                query.setParameterList((String)paramList.get(i), (Collection)((List)parValue));
                continue;
            }
            query.setParameter((String)paramList.get(i), valueList.get(i));
        }
        return query;
    }

    private Query getSearchSelectDataQueryString(Session session, VOASearchCriteria searchCriteria) {
        ArrayList paramList = new ArrayList();
        ArrayList valueList = new ArrayList();
        String queryString = "SELECT voa.voa_enrollment_app_id applicationId, voa.fully_qualified_id fullqualifiedId, voa.applicant_last_name lastName, voa.applicant_first_name firstName, voa.applicant_ssn ssn, voa.applicant_dob dob, voa.std_gender_id gender, voa.request_received_timestamp reqRecdDate, voa.enrollment_form_type_id formType, voa.error_text errorText " + this.getSearchFromClause(searchCriteria) + this.getSearchWhereClause(searchCriteria, paramList, valueList) + this.getSearchOrderByClause(searchCriteria.getSortElements());
        SQLQuery query = session.createSQLQuery(queryString);
        for (int i = 0; i < paramList.size(); ++i) {
            Object parValue = valueList.get(i);
            if (parValue != null && parValue instanceof List) {
                query.setParameterList((String)paramList.get(i), (Collection)((List)parValue));
                continue;
            }
            query.setParameter((String)paramList.get(i), parValue);
        }
        return query;
    }

    private void verifyDataIntegrity(BigDecimal applicationId, List results) throws DAOException {
        if (results.size() > 1) {
            throw new DAOException("Found more than one record in VOAApplication for applicationId): " + applicationId);
        }
    }

    private String getSearchOrderByClause(List sortElements) {
        StringBuffer clauseBuffer = new StringBuffer();
        if (sortElements != null) {
            for (SortElement sortElement : sortElements) {
                String databaseColumn = (String)uiFieldToColumnMap.get(sortElement.getSortColumn());
                if (databaseColumn != null) {
                    if (clauseBuffer.length() > 0) {
                        clauseBuffer.append(", ").append(databaseColumn).append(" ").append(sortElement.getSortDirection());
                        continue;
                    }
                    clauseBuffer.append(" ORDER BY ").append(databaseColumn).append(" ").append(sortElement.getSortDirection());
                    continue;
                }
                clauseBuffer.append(DEFAULT_SORT_ORDER);
            }
        }
        return clauseBuffer.toString();
    }

    private String getSearchFromClause(VOASearchCriteria searchCriteria) {
        return FROM_VOA_CLAUSE;
    }

    private int executeCountQuery(Query query) throws HibernateException {
        List results = query.list();
        int count = 0;
        if (results.size() > 0) {
            Object resultCount = results.get(0);
            count = BigDecimal.class.isAssignableFrom(resultCount.getClass()) ? ((BigDecimal)resultCount).intValue() : ((Integer)resultCount).intValue();
        }
        return count;
    }

    private String getSearchWhereClause(VOASearchCriteria searchCriteria, List paramList, List valueList) {
        ArrayList<String> criteriaList = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)searchCriteria.getApplicationId())) {
            criteriaList.add("voa.voa_enrollment_app_id like :applicationId");
            paramList.add(PARAM_APPLICATION_ID);
            valueList.add(searchCriteria.getApplicationId());
        }
        Date reqRecdDateFrom = searchCriteria.getReqRecdDateFrom();
        Date reqRecdDateTo = searchCriteria.getReqRecdDateTo();
        Date reqRecdDate = searchCriteria.getReqRecdDate();
        if (reqRecdDate != null) {
            reqRecdDateFrom = reqRecdDate;
            reqRecdDateTo = reqRecdDate;
        }
        if (reqRecdDateFrom != null) {
            criteriaList.add(" voa.request_received_timestamp >= :reqRecdDateFrom");
            paramList.add("reqRecdDateFrom");
            valueList.add(reqRecdDateFrom);
        }
        if (reqRecdDateTo != null) {
            criteriaList.add(" voa.request_received_timestamp < :reqRecdDateTo");
            paramList.add("reqRecdDateTo");
            valueList.add(this.nextDay(reqRecdDateTo));
        }
        if (StringUtils.isNotEmpty((String)searchCriteria.getFormTypeValue())) {
            BigDecimal formType = null;
            String formTypeValue = searchCriteria.getFormTypeValue();
            if (TXT_1010EZ.equals(formTypeValue)) {
                formType = ID_1010EZ;
            } else if (TXT_1010EZR.equalsIgnoreCase(formTypeValue)) {
                formType = ID_1010EZR;
            } else if (TXT_1010HS.equalsIgnoreCase(formTypeValue)) {
                formType = ID_1010HS;
            } else if (TXT_1010SH.equalsIgnoreCase(formTypeValue)) {
                formType = ID_1010SH;
            } else if (TXT_1010CG.equalsIgnoreCase(formTypeValue)) {
                formType = ID_1010CG;
            } else if (TXT_21526EZ.equals(formTypeValue)) {
                formType = ID_21526EZ;
            }
            criteriaList.add("voa.enrollment_form_type_id = :formType");
            paramList.add("formType");
            valueList.add(formType);
        }
        if (StringUtils.isNotEmpty((String)searchCriteria.getFormPendingReason())) {
            String errorText = null;
            String formPendingReason = searchCriteria.getFormPendingReason();
            if (PENDING_IDENTITY_TRAITS.equalsIgnoreCase(formPendingReason)) {
                errorText = "%PCE%";
                searchCriteria.setErrorText(errorText);
            }
            if (PERSON_NOT_FOUND.equalsIgnoreCase(formPendingReason)) {
                errorText = "%Person not found%";
                searchCriteria.setErrorText(errorText);
            }
            if (PROXY_PF_FAILED.equalsIgnoreCase(formPendingReason)) {
                errorText = "%VOA Workflow Case has been created%";
                searchCriteria.setErrorText(errorText);
            }
            if (CHECK_PERSON_INFO.equalsIgnoreCase(formPendingReason)) {
                errorText = "%Person Info Not Accepted%";
                searchCriteria.setErrorText(errorText);
            }
            criteriaList.add("voa.error_text like :errorText");
            paramList.add("errorText");
            valueList.add(errorText);
        }
        StringBuffer whereClause = new StringBuffer();
        if (!criteriaList.isEmpty()) {
            for (int index = 0; index < criteriaList.size(); ++index) {
                whereClause.append(" and ").append(criteriaList.get(index));
            }
        }
        return whereClause.toString();
    }

    private void loadLazyProperties(VOAApplication voaApp) {
    }

    private Date nextDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        calendar.add(5, 1);
        return calendar.getTime();
    }

    private void accessSet(Set set) {
        block0: {
            Iterator i = set.iterator();
            if (!i.hasNext()) break block0;
            Object obj = i.next();
        }
    }

    public CommonVOAResubmissionConversionService getConversionService() {
        return this.voaConversionService;
    }

    public void setConversionService(CommonVOAResubmissionConversionService voaConversionService) {
        this.voaConversionService = voaConversionService;
    }

    static {
        uiFieldToColumnMap.put("result.applicationId", PARAM_APPLICATION_ID);
        uiFieldToColumnMap.put("result.fullQualifiedId", "fullQualifiedId");
        uiFieldToColumnMap.put("result.lastName", "lastName");
        uiFieldToColumnMap.put("result.firstName", "firstName");
        uiFieldToColumnMap.put("result.ssn", "ssn");
        uiFieldToColumnMap.put("result.dob", "dob");
        uiFieldToColumnMap.put("result.gender", "gender");
        uiFieldToColumnMap.put("result.reqRecdDate", "reqRecdDate");
        uiFieldToColumnMap.put("result.formType", "formType");
        uiFieldToColumnMap.put("result.formTypeValue", "formTypeValue");
        uiFieldToColumnMap.put("result.errorText", "errorText");
    }
}

