/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.persistent.person.hibernate;

import gov.va.med.esr.common.persistent.person.MECPeriodDAO;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.hibernate.GenericDAOImpl;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;

public class MECPeriodDAOImpl
extends GenericDAOImpl
implements MECPeriodDAO {
    private static final long serialVersionUID = 8793888126514734883L;
    public static final String MECPERIOD_BY_PERSON_ID_QUERY = "MECPeriod_GetByPersonId";
    public static final String MEC_RECORDS_TO_PROCESS_QUERY = "MECPeriod_GetListToProcess";
    public static final String MEC_BY_DATE = "MECPeriod_GetPeriodByDate";
    public static final String PARAM_PERSON_ID = "personId";
    public static final String PARAM_CALENDAR_YEAR = "calendarYear";
    public static final String PARAM_BATCH_SIZE = "batchSize";
    public static final String PARAM_DATE = "statusDate";
    private static Map uiFieldToColumnMap = new HashMap();

    @Override
    public List getByPersonId(BigDecimal personId) throws DAOException {
        Validate.notNull((Object)personId, (String)"personId cannot be null");
        try {
            return this.findByNamedQueryAndNamedParam(MECPERIOD_BY_PERSON_ID_QUERY, PARAM_PERSON_ID, personId);
        }
        catch (Exception e) {
            throw new DAOException("MEC Period getByPersonId failed for personId: " + personId, (Throwable)e);
        }
    }

    @Override
    public List getMECPeriodByDate(BigDecimal personId, String statusDate) throws DAOException {
        try {
            return this.findByNamedQueryAndNamedParam(MEC_BY_DATE, new String[]{PARAM_PERSON_ID, PARAM_DATE}, new Object[]{personId, statusDate});
        }
        catch (Exception e) {
            throw new DAOException("MEC Period getByPersonId failed for personId: " + personId, (Throwable)e);
        }
    }

    @Override
    public List getMECRecordsToProcess(String calendarYear, String batchSize) throws DAOException {
        try {
            List results = this.findByNamedQueryAndNamedParam(MEC_RECORDS_TO_PROCESS_QUERY, new String[]{PARAM_CALENDAR_YEAR, PARAM_BATCH_SIZE}, new String[]{calendarYear, batchSize});
            return results;
        }
        catch (Exception e) {
            throw new DAOException("MECPeriod getRecordsToProcess failed for calendaryear: " + calendarYear, (Throwable)e);
        }
    }

    static {
        uiFieldToColumnMap.put("result.mecPeriodId", "mecPeriodId");
        uiFieldToColumnMap.put("result.personId", PARAM_PERSON_ID);
        uiFieldToColumnMap.put("result.mecStartDate", "mecStartDate");
        uiFieldToColumnMap.put("result.mecEndDate", "mecEndDate");
    }
}

