/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.persistent.messaging.hibernate;

import gov.va.med.esr.common.model.lookup.MessageType;
import gov.va.med.esr.common.model.messaging.ArchivedMessageLogEntry;
import gov.va.med.esr.common.model.messaging.ArchivedMessageLogEntryLite;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.persistent.messaging.ArchivedMessageLogEntryDAO;
import gov.va.med.esr.service.MessageLogCriteria;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.MaxRecordsExceededException;
import gov.va.med.fw.persistent.hibernate.AbstractDAOAction;
import gov.va.med.fw.persistent.hibernate.GenericDAOImpl;
import gov.va.med.fw.persistent.hibernate.PaginatedQueryExecutor;
import gov.va.med.fw.service.pagination.SearchQueryInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateSystemException;
import org.springframework.orm.hibernate3.HibernateTemplate;

public class ArchivedMessageLogEntryDAOImpl
extends GenericDAOImpl
implements ArchivedMessageLogEntryDAO {
    private static final long serialVersionUID = -4381743890002053737L;

    @Override
    public ArchivedMessageLogEntry getById(BigDecimal identifier) throws DAOException {
        try {
            HibernateTemplate tpl = this.getHibernateTemplate();
            List results = tpl.findByNamedQueryAndNamedParam("arc_messageLogEntryQuery_Identifier", "identifier", (Object)identifier);
            return results.isEmpty() ? null : (ArchivedMessageLogEntry)((Object)results.get(0));
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to get the message log entry by identifier", (Throwable)e);
        }
    }

    @Override
    public ArchivedMessageLogEntryLite getMessageLogEntryLiteById(BigDecimal identifier) throws DAOException {
        try {
            HibernateTemplate tpl = this.getHibernateTemplate();
            List results = tpl.findByNamedQueryAndNamedParam("arc_messageLogEntryQueryLite_Identifier", "identifier", (Object)identifier);
            return results.isEmpty() ? null : (ArchivedMessageLogEntryLite)((Object)results.get(0));
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to get the message log entry lite by identifier", (Throwable)e);
        }
    }

    @Override
    public ArchivedMessageLogEntry getByControlId(String controlIdentifier) throws DAOException {
        try {
            HibernateTemplate tpl = this.getHibernateTemplate();
            List results = tpl.findByNamedQueryAndNamedParam("arc_messageLogEntryQuery_ControlIdentifier", "controlIdentifier", (Object)controlIdentifier);
            return results.isEmpty() ? null : (ArchivedMessageLogEntry)((Object)results.get(0));
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to get the message log entry", (Throwable)e);
        }
    }

    @Override
    public ArchivedMessageLogEntry getByBatchControlId(String controlIdentifier) throws DAOException {
        try {
            HibernateTemplate tpl = this.getHibernateTemplate();
            List results = tpl.findByNamedQueryAndNamedParam("arc_messageLogEntryQuery_BatchControlIdentifier", "controlIdentifier", (Object)controlIdentifier);
            return results.isEmpty() ? null : (ArchivedMessageLogEntry)((Object)results.get(0));
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to get the message log entry", (Throwable)e);
        }
    }

    @Override
    public List find(Person person) throws DAOException {
        try {
            HibernateTemplate tpl = this.getHibernateTemplate();
            List results = tpl.findByNamedQueryAndNamedParam("arc_messageLogEntryQuery_FindByPerson", "personId", (Object)((BigDecimal)person.getEntityKey().getKeyValue()));
            return results;
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to load the message log entries", (Throwable)e);
        }
    }

    @Override
    public List find(SearchQueryInfo criteria) throws DAOException, MaxRecordsExceededException {
        MessageLogCriteria searchCriteria = (MessageLogCriteria)criteria;
        HashMap<String, MessageLogCriteria> contextData = new HashMap<String, MessageLogCriteria>();
        contextData.put("searchCriteria", searchCriteria);
        AbstractDAOAction callback = new AbstractDAOAction(contextData){

            public Object execute(Session session) throws DAOException {
                ArrayList paramList = new ArrayList();
                ArrayList valueList = new ArrayList();
                MessageLogCriteria targetQueryInfo = (MessageLogCriteria)this.getContextData().get("searchCriteria");
                String whereClause = ArchivedMessageLogEntryDAOImpl.this.createWhereClause(targetQueryInfo, paramList, valueList);
                Query countQuery = session.createQuery("select count(*) from ArchivedMessageLogEntryLite as logEntry " + whereClause);
                Query dataQuery = session.createQuery("from ArchivedMessageLogEntryLite as logEntry " + whereClause);
                for (int i = 0; i < paramList.size(); ++i) {
                    countQuery.setParameter((String)paramList.get(i), valueList.get(i));
                    dataQuery.setParameter((String)paramList.get(i), valueList.get(i));
                }
                PaginatedQueryExecutor queryExecutor = new PaginatedQueryExecutor(countQuery, dataQuery, (SearchQueryInfo)targetQueryInfo);
                try {
                    return queryExecutor.executeQuery();
                }
                catch (MaxRecordsExceededException e) {
                    throw new DAOException("max records exceeded", (Throwable)e);
                }
            }
        };
        try {
            return this.getHibernateTemplate().executeFind((HibernateCallback)callback);
        }
        catch (HibernateSystemException e) {
            MaxRecordsExceededException rootCause = (MaxRecordsExceededException)this.getRootExceptionOfType(e, MaxRecordsExceededException.class);
            if (rootCause != null) {
                throw rootCause;
            }
            throw e;
        }
    }

    private String createWhereClause(MessageLogCriteria searchCriteria, List paramList, List valueList) {
        Date startDate = null;
        Date endDate = null;
        Calendar cal = Calendar.getInstance();
        if (searchCriteria.getTransmissionDate() != null) {
            startDate = searchCriteria.getTransmissionDate();
            cal.setTime(searchCriteria.getTransmissionDate());
            cal.add(5, 1);
            endDate = cal.getTime();
        } else if (searchCriteria.getTransmissionStartDate() != null && searchCriteria.getTransmissionEndDate() != null) {
            startDate = searchCriteria.getTransmissionStartDate();
            cal.setTime(searchCriteria.getTransmissionEndDate());
            cal.add(5, 1);
            endDate = cal.getTime();
        }
        ArrayList<String> criteriaList = new ArrayList<String>();
        if (startDate != null && endDate != null) {
            criteriaList.add(" logEntry.transmissionDate >= :transmissionStartDate and logEntry.transmissionDate <  :transmissionEndDate");
            paramList.add("transmissionStartDate");
            paramList.add("transmissionEndDate");
            valueList.add(startDate);
            valueList.add(endDate);
        }
        if (searchCriteria.getPersonId() != null) {
            criteriaList.add("logEntry.personId = :personId");
            paramList.add("personId");
            valueList.add(searchCriteria.getPersonId());
        }
        if (searchCriteria.getFacility() != null) {
            criteriaList.add("logEntry.vaFacility = :vaFacility");
            paramList.add("vaFacility");
            valueList.add(searchCriteria.getFacility());
        }
        if (searchCriteria.getType() != null) {
            criteriaList.add("logEntry.type = :type");
            paramList.add("type");
            valueList.add(searchCriteria.getType());
        }
        if (searchCriteria.getStatus() != null) {
            criteriaList.add("logEntry.status = :status");
            paramList.add("status");
            valueList.add(searchCriteria.getStatus());
        }
        StringBuffer whereClause = new StringBuffer();
        if (!criteriaList.isEmpty()) {
            whereClause.append(" where ").append(criteriaList.get(0));
            for (int index = 1; index < criteriaList.size(); ++index) {
                whereClause.append(" and ").append(criteriaList.get(index));
            }
        }
        return whereClause.toString();
    }

    @Override
    public ArchivedMessageLogEntry findByReceivedEligiblityStatus(Person person, String eligibilityStatus) throws DAOException {
        try {
            HibernateTemplate tpl = this.getHibernateTemplate();
            String[] params = new String[]{"personId", "siteReceivedEligibilityStatus"};
            Object[] values = new Object[]{(BigDecimal)person.getEntityKey().getKeyValue(), eligibilityStatus};
            List results = tpl.findByNamedQueryAndNamedParam("arc_messageLogEntryQuery_ElgbtyStatusAndPerson", params, values);
            return results.isEmpty() ? null : (ArchivedMessageLogEntry)((Object)results.get(0));
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to load the message log entries", (Throwable)e);
        }
    }

    @Override
    public String findSiteLastTransmittedMsg(EntityKey personId) throws DAOException {
        try {
            HibernateTemplate tpl = this.getHibernateTemplate();
            String[] params = new String[]{"personId"};
            Object[] values = new Object[]{(BigDecimal)personId.getKeyValue()};
            List results = tpl.findByNamedQueryAndNamedParam("arc_messageLogEntryQuery_findSiteLastTransmittedMsg", params, values);
            return results.isEmpty() ? null : (String)results.get(0);
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to load the message log entries", (Throwable)e);
        }
    }

    @Override
    public List findByRetransmissionWaitPeriodAndCount(Integer retransmissionWaitPeriod, Integer retransmissionCount, String messageStatusCode, boolean isEGTRetransmission) throws DAOException {
        try {
            HibernateTemplate tpl = this.getHibernateTemplate();
            String[] params = new String[]{"messageStatus", "retransmissionWaitPeriod", "retransmissionCount", "messageType"};
            Object[] values = new Object[]{messageStatusCode, retransmissionWaitPeriod, retransmissionCount, MessageType.CODE_MFNZEG_TO_SITE.getCode()};
            List results = tpl.findByNamedQueryAndNamedParam(isEGTRetransmission ? "arc_messageLogEntryQuery_FindByRetransmissionWaitPeriodAndCountForEGT" : "arc_messageLogEntryQuery_FindByRetransmissionWaitPeriodAndCount", params, values);
            return results;
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to load the message log entries by retransmission wait period and count", (Throwable)e);
        }
    }

    @Override
    public boolean hasProcessedInboundMessage(String messageControlNumber, String stationNumber) throws DAOException {
        Validate.notNull((Object)messageControlNumber, (String)"NULL messageControlNumber not allowed.");
        Validate.notNull((Object)stationNumber, (String)"NULL stationNumber not allowed.");
        boolean hasProcessedInboundMessage = false;
        try {
            String[] paramNames = new String[]{"controlIdentifier", "stationNumber"};
            Object[] values = new Object[]{messageControlNumber, stationNumber};
            List results = this.findByNamedQueryAndNamedParam("arc_messageLogEntryQuery_findInboundMessages", paramNames, values);
            if (results != null && !results.isEmpty()) {
                hasProcessedInboundMessage = true;
            }
            return hasProcessedInboundMessage;
        }
        catch (DataAccessException ex) {
            throw new DAOException("Failed to execute hasProcessedInboundMessage", (Throwable)ex);
        }
    }

    @Override
    public List findVoaAaAckLogEntryByPersonId(EntityKey personId) throws DAOException {
        try {
            HibernateTemplate tpl = this.getHibernateTemplate();
            List results = tpl.findByNamedQueryAndNamedParam("arc_messageLogEntryQuery_findVoaAaAckLogEntryByPersonId", "personId", (Object)((BigDecimal)personId.getKeyValue()));
            return results;
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to get the VOA AA Ack message log entries by identifier", (Throwable)e);
        }
    }
}

