/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.persistent.demographic.hibernate;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.lookup.AddressType;
import gov.va.med.esr.common.model.lookup.BadAddressReason;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.persistent.demographic.AddressDAO;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.hibernate.AbstractDAOImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class AddressDAOImpl
extends AbstractDAOImpl
implements AddressDAO {
    private static final long serialVersionUID = -9196318501892030277L;
    private static final String PERSON_ADDRESS_NAMED_SQL = "getAddressByPersonId";
    private static final String ADDRESS_BY_ID = "addressByAddressId";
    private static final String PERSON_ID_PARAM = "personId";
    private static final String PERSON_ADDRESS_NAMED_QUERY = "addressesByPersonId";

    @Override
    public List getPersonAddresses(BigDecimal personId) throws DAOException {
        List lst = null;
        if (personId == null) {
            return lst;
        }
        try {
            lst = this.getHibernateTemplate().findByNamedQueryAndNamedParam(PERSON_ADDRESS_NAMED_QUERY, PERSON_ID_PARAM, (Object)personId);
        }
        catch (Exception e) {
            throw new DAOException("Failed to find Address list by person id", (Throwable)e);
        }
        return this.mapToAddressList(lst);
    }

    @Override
    public Address getAddressById(BigDecimal addressId) throws DAOException {
        Address address = null;
        try {
            List lst = this.getHibernateTemplate().findByNamedQueryAndNamedParam(ADDRESS_BY_ID, "addressId", (Object)addressId);
            List addrList = this.mapToAddressList(lst);
            if (addrList.size() > 0) {
                address = (Address)addrList.get(0);
            }
        }
        catch (Exception e) {
            throw new DAOException("Failed to find Address by id", (Throwable)e);
        }
        return address;
    }

    private List mapToAddressList(List lst) {
        if (lst == null) {
            return null;
        }
        ArrayList<Address> addrList = new ArrayList<Address>();
        Address addr = null;
        for (int i = 0; i < lst.size(); ++i) {
            Object[] attributes = (Object[])lst.get(i);
            addr = new Address();
            if (attributes[0] != null) {
                addr.setStartDate((ImpreciseDate)attributes[0]);
            }
            if (attributes[1] != null) {
                addr.setEndDate((ImpreciseDate)attributes[1]);
            }
            if (attributes[2] != null) {
                addr.setBadAddressReason((BadAddressReason)((Object)attributes[2]));
            }
            if (attributes[3] != null) {
                addr.setType((AddressType)((Object)attributes[3]));
            }
            if (attributes[4] != null) {
                addr.setLine1((String)attributes[4]);
            }
            if (attributes[5] != null) {
                addr.setLine2((String)attributes[5]);
            }
            if (attributes[6] != null) {
                addr.setLine3((String)attributes[6]);
            }
            if (attributes[7] != null) {
                addr.setCity((String)attributes[7]);
            }
            if (attributes[8] != null) {
                addr.setState((String)attributes[8]);
            }
            if (attributes[9] != null) {
                addr.setProvince((String)attributes[9]);
            }
            if (attributes[10] != null) {
                addr.setPostalCode((String)attributes[10]);
            }
            if (attributes[11] != null) {
                addr.setZipCode((String)attributes[11]);
            }
            if (attributes[12] != null) {
                addr.setZipPlus4((String)attributes[12]);
            }
            if (attributes[13] != null) {
                addr.setCounty((String)attributes[13]);
            }
            if (attributes[14] != null) {
                addr.setCountry((String)attributes[14]);
            }
            if (attributes[15] != null) {
                addr.setNcoaInvalidUndeliverableDate((Date)attributes[15]);
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("AddressDAO map to addressList attributes: " + attributes + " address: " + addr));
            }
            addrList.add(addr);
        }
        return addrList;
    }
}

