/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.persistent.comms.hibernate;

import gov.va.med.esr.common.model.comms.CmsErrorFileEntry;
import gov.va.med.esr.common.model.comms.CmsMailedFileEntry;
import gov.va.med.esr.common.model.comms.CmsRejectFileEntry;
import gov.va.med.esr.common.model.comms.CmsReturnedByUSPSFileEntry;
import gov.va.med.esr.common.model.comms.CommsImportStatistics;
import gov.va.med.esr.common.model.comms.ErrorFileEntry;
import gov.va.med.esr.common.model.comms.MailedFileEntry;
import gov.va.med.esr.common.model.comms.RejectFileEntry;
import gov.va.med.esr.common.persistent.comms.ImportFileDAO;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.service.AbstractComponent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;

public class ImportFileDAOImpl
extends AbstractComponent
implements ImportFileDAO {
    private static String FILE_TYPE = null;
    private static String ARCHIVED_FILE_EXTENSION = "~";
    private String filePath = null;
    private String cmsFilePath = null;
    private boolean archiveFileAfterProcessing = true;

    @Override
    public String getAacFilePath() {
        return this.filePath;
    }

    @Override
    public void setAacFilePath(String filePath) {
        this.filePath = filePath;
    }

    @Override
    public ArrayList readErrorFile(CommsImportStatistics stat) throws DAOException {
        File file = this.getFileByExtension(".err");
        if (file == null) {
            return null;
        }
        stat.setErrorFileReceivedDate(new Date(file.lastModified()));
        stat.setErrorFileName(file.getName());
        ArrayList<ErrorFileEntry> errEntryLst = new ArrayList<ErrorFileEntry>();
        String aLine = null;
        String[] fields = null;
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(file));
            while ((aLine = in.readLine()) != null) {
                fields = aLine.split("\\^");
                if (fields.length != 5) continue;
                errEntryLst.add(new ErrorFileEntry(fields[0].trim(), fields[1].trim(), fields[2].trim(), fields[3].trim(), fields[4].trim()));
            }
        }
        catch (FileNotFoundException fnfex) {
            throw new DAOException("#### Error reading AAC Error file: File Not Found", (Throwable)fnfex);
        }
        catch (IOException ioex) {
            throw new DAOException("#### Error reading AAC Error file: IO Exception", (Throwable)ioex);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                    this.archiveProcessedFile(file);
                }
                catch (IOException e) {
                    this.logger.error((Object)"Unable to close input file", (Throwable)e);
                }
            }
        }
        return errEntryLst;
    }

    @Override
    public ArrayList readRejectFile(CommsImportStatistics stat) throws DAOException {
        File file = this.getFileByExtension(".rej");
        if (file == null) {
            return null;
        }
        stat.setRejectFileReceivedDate(new Date(file.lastModified()));
        stat.setRejectFileName(file.getName());
        ArrayList<RejectFileEntry> rejEntryLst = new ArrayList<RejectFileEntry>();
        String aLine = null;
        String[] fields = null;
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(file));
            while ((aLine = in.readLine()) != null) {
                fields = aLine.split("\\^");
                if (fields.length != 5) continue;
                rejEntryLst.add(new RejectFileEntry(fields[0].trim(), fields[1].trim(), fields[2].trim(), fields[3].trim(), fields[4].trim()));
            }
        }
        catch (FileNotFoundException fnfex) {
            throw new DAOException("#### Error reading AAC Reject file: File Not Found", (Throwable)fnfex);
        }
        catch (IOException ioex) {
            throw new DAOException("#### Error reading AAC Reject file: IO Exception", (Throwable)ioex);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                    this.archiveProcessedFile(file);
                }
                catch (IOException e) {
                    this.logger.error((Object)"Unable to close input file", (Throwable)e);
                }
            }
        }
        return rejEntryLst;
    }

    @Override
    public ArrayList readMailedFile(CommsImportStatistics stat) throws DAOException {
        File file = this.getFileByExtension(".adr");
        if (file == null) {
            return null;
        }
        stat.setMailedFileReceivedDate(new Date(file.lastModified()));
        stat.setMailedFileName(file.getName());
        ArrayList<MailedFileEntry> addrEntryLst = new ArrayList<MailedFileEntry>();
        String aLine = null;
        String[] fields = null;
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(file));
            while ((aLine = in.readLine()) != null) {
                fields = aLine.split("\\^");
                if (fields.length != 11) continue;
                addrEntryLst.add(new MailedFileEntry(fields[0].trim(), fields[1].trim(), fields[2].trim(), fields[3].trim(), fields[4].trim(), fields[5].trim(), fields[6].trim(), fields[7].trim(), fields[8].trim(), fields[9].trim(), fields[10].trim()));
            }
        }
        catch (FileNotFoundException fnfex) {
            throw new DAOException("#### Error reading AAC Mailed file: File Not Found", (Throwable)fnfex);
        }
        catch (IOException ioex) {
            throw new DAOException("#### Error reading AAC Mailed file: IO Exception", (Throwable)ioex);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                    this.archiveProcessedFile(file);
                }
                catch (IOException e) {
                    this.logger.error((Object)"Unable to close input file", (Throwable)e);
                }
            }
        }
        return addrEntryLst;
    }

    @Override
    public String getCmsFilePath() {
        return this.cmsFilePath;
    }

    @Override
    public ArrayList readCmsErrorFile(CommsImportStatistics stat) throws DAOException {
        File file = this.getCmsFileByExtension(".err");
        if (file == null) {
            return null;
        }
        stat.setErrorFileReceivedDate(new Date(file.lastModified()));
        stat.setErrorFileName(file.getName());
        ArrayList<CmsErrorFileEntry> errEntryLst = new ArrayList<CmsErrorFileEntry>();
        String aLine = null;
        String[] fields = null;
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(file));
            while ((aLine = in.readLine()) != null) {
                fields = aLine.split("\\^");
                if (fields.length != 6) continue;
                errEntryLst.add(new CmsErrorFileEntry(fields[0].trim(), fields[1].trim(), fields[2].trim(), fields[3].trim(), fields[4].trim(), fields[5].trim()));
            }
        }
        catch (FileNotFoundException fnfex) {
            throw new DAOException("#### Error reading CMS Error file: File Not Found", (Throwable)fnfex);
        }
        catch (IOException ioex) {
            throw new DAOException("#### Error reading CMS Error file: IO Exception", (Throwable)ioex);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                    this.archiveProcessedFile(file);
                }
                catch (IOException e) {
                    this.logger.error((Object)"Unable to close input file", (Throwable)e);
                }
            }
        }
        return errEntryLst;
    }

    @Override
    public ArrayList readCmsMailedFile(CommsImportStatistics stat) throws DAOException {
        File file = this.getCmsFileByExtension(".adr");
        if (file == null) {
            return null;
        }
        stat.setMailedFileReceivedDate(new Date(file.lastModified()));
        stat.setMailedFileName(file.getName());
        ArrayList<CmsMailedFileEntry> addrEntryLst = new ArrayList<CmsMailedFileEntry>();
        String aLine = null;
        String[] fields = null;
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(file));
            while ((aLine = in.readLine()) != null) {
                fields = aLine.split("\\^");
                if (fields.length != 6) continue;
                addrEntryLst.add(new CmsMailedFileEntry(fields[0].trim(), fields[1].trim(), fields[2].trim(), fields[3].trim(), fields[4].trim(), fields[5].trim()));
            }
        }
        catch (FileNotFoundException fnfex) {
            throw new DAOException("#### Error reading CMS Mailed file: File Not Found", (Throwable)fnfex);
        }
        catch (IOException ioex) {
            throw new DAOException("#### Error reading CMS Mailed file: IO Exception", (Throwable)ioex);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                    this.archiveProcessedFile(file);
                }
                catch (IOException e) {
                    this.logger.error((Object)"Unable to close input file", (Throwable)e);
                }
            }
        }
        return addrEntryLst;
    }

    @Override
    public ArrayList readCmsRejectFile(CommsImportStatistics stat) throws DAOException {
        File file = this.getCmsFileByExtension(".rej");
        if (file == null) {
            return null;
        }
        stat.setRejectFileReceivedDate(new Date(file.lastModified()));
        stat.setRejectFileName(file.getName());
        ArrayList<CmsRejectFileEntry> rejEntryLst = new ArrayList<CmsRejectFileEntry>();
        String aLine = null;
        String[] fields = null;
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(file));
            while ((aLine = in.readLine()) != null) {
                fields = aLine.split("\\^");
                if (fields.length != 6) continue;
                rejEntryLst.add(new CmsRejectFileEntry(fields[0].trim(), fields[1].trim(), fields[2].trim(), fields[3].trim(), fields[4].trim(), fields[5].trim()));
            }
        }
        catch (FileNotFoundException fnfex) {
            throw new DAOException("#### Error reading CMS Reject file: File Not Found", (Throwable)fnfex);
        }
        catch (IOException ioex) {
            throw new DAOException("#### Error reading CMS Reject file: IO Exception", (Throwable)ioex);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                    this.archiveProcessedFile(file);
                }
                catch (IOException e) {
                    this.logger.error((Object)"Unable to close input file", (Throwable)e);
                }
            }
        }
        return rejEntryLst;
    }

    @Override
    public ArrayList readCmsReturnedMailFile(CommsImportStatistics stat) throws DAOException {
        File file = this.getCmsFileByExtension(".ret");
        if (file == null) {
            return null;
        }
        stat.setRejectFileReceivedDate(new Date(file.lastModified()));
        stat.setRejectFileName(file.getName());
        ArrayList<CmsReturnedByUSPSFileEntry> rejEntryLst = new ArrayList<CmsReturnedByUSPSFileEntry>();
        String aLine = null;
        String[] fields = null;
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(file));
            while ((aLine = in.readLine()) != null) {
                fields = aLine.split("\\^");
                if (fields.length != 6) continue;
                rejEntryLst.add(new CmsReturnedByUSPSFileEntry(fields[0].trim(), fields[1].trim(), fields[2].trim(), fields[3].trim(), fields[4].trim(), fields[5].trim()));
            }
        }
        catch (FileNotFoundException fnfex) {
            throw new DAOException("#### Error reading CMS Returned Mail file: File Not Found", (Throwable)fnfex);
        }
        catch (IOException ioex) {
            throw new DAOException("#### Error reading CMS Returned Mail file: IO Exception", (Throwable)ioex);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                    this.archiveProcessedFile(file);
                }
                catch (IOException e) {
                    this.logger.error((Object)"Unable to close input file", (Throwable)e);
                }
            }
        }
        return rejEntryLst;
    }

    @Override
    public void setCmsFilePath(String cmsFilePath) {
        this.cmsFilePath = cmsFilePath;
    }

    private void archiveProcessedFile(File inputFile) {
        if (!this.archiveFileAfterProcessing) {
            return;
        }
        File archivedFile = new File(inputFile.getAbsolutePath() + ARCHIVED_FILE_EXTENSION);
        boolean result = inputFile.renameTo(archivedFile);
        if (!result) {
            this.logger.error((Object)("Unable to rename input file: " + inputFile));
        }
    }

    private File getFileByExtension(String fileType) {
        FILE_TYPE = fileType;
        File[] files = new File(this.getAacFilePath()).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File d, String name) {
                return name.endsWith(FILE_TYPE);
            }
        });
        if (files == null || files.length == 0) {
            return null;
        }
        return files[0];
    }

    private File getCmsFileByExtension(String fileType) {
        FILE_TYPE = fileType;
        File[] files = new File(this.getCmsFilePath()).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File d, String name) {
                return name.endsWith(FILE_TYPE);
            }
        });
        if (files == null || files.length == 0) {
            return null;
        }
        return files[0];
    }

    public boolean isArchiveFileAfterProcessing() {
        return this.archiveFileAfterProcessing;
    }

    public void setArchiveFileAfterProcessing(boolean archiveFileAfterProcessing) {
        this.archiveFileAfterProcessing = archiveFileAfterProcessing;
    }
}

