/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.persistent.comms.hibernate;

import gov.va.med.esr.common.model.comms.DocumentAccessLog;
import gov.va.med.esr.common.model.comms.HandBookMailQueue;
import gov.va.med.esr.common.model.comms.HealthBenefitPlan;
import gov.va.med.esr.common.persistent.comms.HandBookMailQueueDAO;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.DAOOperations;
import gov.va.med.fw.persistent.hibernate.AbstractDAOImpl;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.HibernateTemplate;

public class HandbookMailQueueDAOImpl
extends AbstractDAOImpl
implements HandBookMailQueueDAO {
    private static final long serialVersionUID = -2329390610776072947L;
    private static final String FIND_HANDBOOK_BY_PERSON_ID = "handbookQuery_FindByPersonId";
    private static final String FIND_HANDBOOK_STATUS_BY_PERSON_ID = "handbookStatusQuery_FindByPersonId";
    private static final String FIND_ANY_HANDBOOK_SENT_MAILED_BY_PERSON_ID = "handbookSentOrMailedQuery_FindByPersonId_AnyRelease";
    private static final String HANDBOOK_STATUS_RETURN_POST_BY_PERSON_ID = "handbookStatusReturnPostQuery_FindByPersonId";
    private static final String FIND_RAW_PROFILE_DATA_BY_PERSON_ID = "healthBenefitsProfileRawDataQuery";
    private static final String FIND_HANDBOOK_TEMPLATE = "commsTemplateQuery_FindHandbook";
    private static final String FIND_HANDBOOK_BY_PERSON_ID_TEMPLATE_ID_STATUSTYPE_ID = "handbookQuery_FindByPersonIdByTemplateID_STATUS_TYPEID";
    private static final String FIND_HANDBOOK_BY_BATCH_BY_STATUS = "HandBookMailQueue_FindCount_By_Batch_Status";
    private static final String FIND_DELIVERYPREFERENCE_EDITABLE_STATUS = "deliveryPreferenceEditableFieldQuery_FindByPersonId";
    private static final String[] personIdParamFields = new String[]{"personId"};
    private static final String[] rawDataParamFields = new String[]{"personVpid"};
    private static final String FIND_BY_FILE_ID = "documentAccessLog_FindByFileId";
    private static final String PARAM_FILEID = "fileId";
    private DAOOperations dao = null;

    public DAOOperations getDao() {
        return this.dao;
    }

    public void setDao(DAOOperations dao) {
        this.dao = dao;
    }

    @Override
    public List findHandbookListByPersonId(String personId) throws DAOException {
        Object[] personIdParamValues = new BigDecimal[]{new BigDecimal(personId)};
        try {
            return super.getHibernateTemplate().findByNamedQueryAndNamedParam(FIND_HANDBOOK_BY_PERSON_ID, personIdParamFields, personIdParamValues);
        }
        catch (Exception ex) {
            throw new DAOException("Failed to find Handbook Mail Queue Entries based on person Id: " + personId, (Throwable)ex);
        }
    }

    @Override
    public List findAnyHandbookSentOrMailedForPersonId(String personId) throws DAOException {
        Object[] personIdParamValues = new BigDecimal[]{new BigDecimal(personId)};
        try {
            return super.getHibernateTemplate().findByNamedQueryAndNamedParam(FIND_ANY_HANDBOOK_SENT_MAILED_BY_PERSON_ID, personIdParamFields, personIdParamValues);
        }
        catch (Exception ex) {
            throw new DAOException("Failed to find Handbook Mail Queue Entries based on person Id: " + personId, (Throwable)ex);
        }
    }

    @Override
    public List findDeliveryPreferenceEditableStatusByPersonId(String personId) throws DAOException {
        Object[] personIdParamValues = new BigDecimal[]{new BigDecimal(personId)};
        try {
            return super.getHibernateTemplate().findByNamedQueryAndNamedParam(FIND_DELIVERYPREFERENCE_EDITABLE_STATUS, personIdParamFields, personIdParamValues);
        }
        catch (Exception ex) {
            throw new DAOException("Failed to find Handbook Mail Queue Entries based on person Id: " + personId, (Throwable)ex);
        }
    }

    @Override
    public List findHandbookSendStatusListByPersonId(BigDecimal personId, BigDecimal handBookRelaseCtl) throws DAOException {
        Object[] paramValues = new BigDecimal[]{personId, handBookRelaseCtl};
        String[] paramFields = new String[]{"personId", "handBookReleaseControl"};
        try {
            return super.getHibernateTemplate().findByNamedQueryAndNamedParam(FIND_HANDBOOK_STATUS_BY_PERSON_ID, paramFields, paramValues);
        }
        catch (Exception ex) {
            throw new DAOException("Failed to find Handbook Mail Queue Entries in Send Status based on person Id: " + personId, (Throwable)ex);
        }
    }

    @Override
    public List lastHandbookReturnPostOffice(String personId) throws DAOException {
        Object[] personIdParamValues = new BigDecimal[]{new BigDecimal(personId)};
        try {
            return super.getHibernateTemplate().findByNamedQueryAndNamedParam(HANDBOOK_STATUS_RETURN_POST_BY_PERSON_ID, personIdParamFields, personIdParamValues);
        }
        catch (Exception ex) {
            throw new DAOException("Failed to find Handbook Queue Entries in Return to Post Office Status based on person Id: " + personId, (Throwable)ex);
        }
    }

    @Override
    public void update(HandBookMailQueue handBookMailQueue) throws DAOException {
        super.getHibernateTemplate().update((Object)handBookMailQueue);
    }

    @Override
    public void merge(HandBookMailQueue handBookMailQueue) throws DAOException {
        super.getHibernateTemplate().merge((Object)handBookMailQueue);
    }

    @Override
    public void insert(HandBookMailQueue handBookMailQueue) throws DAOException {
        this.saveObject((Object)handBookMailQueue);
    }

    @Override
    public List getRawProfileData(String vpid, int receipt_id) throws DAOException {
        Object[] rawDataParamValues = new String[]{vpid};
        try {
            List results = super.getHibernateTemplate().findByNamedQueryAndNamedParam(FIND_RAW_PROFILE_DATA_BY_PERSON_ID, rawDataParamFields, rawDataParamValues);
            if (results != null && results.size() > 0) {
                Iterator iter = results.iterator();
                while (iter.hasNext()) {
                    HealthBenefitPlan hbp = (HealthBenefitPlan)((Object)iter.next());
                    try {
                        int hbp_receipt_id = Integer.valueOf(hbp.getDocumentReceipt().getReceiptString());
                        if (hbp_receipt_id == receipt_id) continue;
                        iter.remove();
                    }
                    catch (Exception ex) {}
                }
                return results;
            }
        }
        catch (Exception ex) {
            throw new DAOException("Failed to find raw profile data: ", (Throwable)ex);
        }
        return null;
    }

    @Override
    public List findHandbookTemplate() throws DAOException {
        try {
            return super.getHibernateTemplate().findByNamedQuery(FIND_HANDBOOK_TEMPLATE);
        }
        catch (Exception ex) {
            throw new DAOException("Failed to find Handbook Template", (Throwable)ex);
        }
    }

    @Override
    public void recordDocumentAccess(DocumentAccessLog documentAccessLog) throws DAOException {
        try {
            this.insertObject((Object)documentAccessLog);
        }
        catch (Exception ex) {
            throw new DAOException("Failed to insert DocumentAccessLog entry", (Throwable)ex);
        }
    }

    @Override
    public List findDocumentAccessLog(BigDecimal fileId) throws DAOException {
        try {
            HibernateTemplate tpl = this.getHibernateTemplate();
            List results = tpl.findByNamedQueryAndNamedParam(FIND_BY_FILE_ID, PARAM_FILEID, (Object)fileId);
            return results;
        }
        catch (Exception ex) {
            throw new DAOException("Failed to get DocumentAccessLog entry", (Throwable)ex);
        }
    }

    @Override
    public HandBookMailQueue findHandBookByIdentifier(BigDecimal identifier) throws DAOException {
        try {
            HibernateTemplate tpl = this.getHibernateTemplate();
            List results = tpl.findByNamedQueryAndNamedParam("HandBookMailQueue_Identifier", "identifier", (Object)identifier);
            if (results != null && results.size() > 0) {
                return (HandBookMailQueue)((Object)results.get(0));
            }
            return null;
        }
        catch (Exception e) {
            throw new DAOException("DAOException - findHandBookByIdentifier UID=" + String.valueOf(identifier) + " : ", (Throwable)e);
        }
    }

    @Override
    public List findHandBookEntryByPersonByTempOnSendStatus(BigDecimal personId, BigDecimal templId, BigDecimal statusTypeId, BigDecimal handBookRelaseCtl) throws DAOException {
        try {
            String[] personIdParamFields = new String[]{"personId", "templId", "statusTypeId", "handBookReleaseControl"};
            Object[] personIdParamValues = new BigDecimal[]{personId, templId, statusTypeId, handBookRelaseCtl};
            return super.getHibernateTemplate().findByNamedQueryAndNamedParam(FIND_HANDBOOK_BY_PERSON_ID_TEMPLATE_ID_STATUSTYPE_ID, personIdParamFields, personIdParamValues);
        }
        catch (Exception ex) {
            throw new DAOException("Failed to find Handbook Mail Queue Entries based on person Id: " + personId, (Throwable)ex);
        }
    }

    @Override
    public List getHandBookMailQueueCountByBatchIdByStatus(BigDecimal batchRequestId, BigDecimal StatusTypeId) throws DAOException {
        try {
            String[] personIdParamFields = new String[]{"batchRequestId", "statusTypeId"};
            Object[] personIdParamValues = new BigDecimal[]{batchRequestId, StatusTypeId};
            return super.getHibernateTemplate().findByNamedQueryAndNamedParam(FIND_HANDBOOK_BY_BATCH_BY_STATUS, personIdParamFields, personIdParamValues);
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to request list by name", (Throwable)e);
        }
    }
}

