/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.persistent.comms.hibernate;

import gov.va.med.esr.common.model.comms.AacLetterRequest;
import gov.va.med.esr.common.persistent.comms.AacLetterRequestDAO;
import gov.va.med.esr.common.persistent.comms.PrintRequestDuplicationException;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.DAOOperations;
import gov.va.med.fw.persistent.hibernate.AbstractDAOImpl;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;

public class AacLetterRequestDAOImpl
extends AbstractDAOImpl
implements AacLetterRequestDAO {
    private static final long serialVersionUID = 6392209931355445693L;
    private DAOOperations dao = null;

    public DAOOperations getDao() {
        return this.dao;
    }

    @Override
    public void setDao(DAOOperations dao) {
        this.dao = dao;
    }

    @Override
    public AacLetterRequest findAacLetterRequestById(BigDecimal requestId) throws DAOException {
        try {
            List lst = super.getHibernateTemplate().find("from AacLetterRequest req where req.identifier = ?", (Object)requestId);
            if (lst != null && lst.size() > 0) {
                return (AacLetterRequest)((Object)lst.get(0));
            }
        }
        catch (Exception e) {
            throw new DAOException("Failed to find AAC letter request by id", (Throwable)e);
        }
        return null;
    }

    @Override
    public List findAacLetterRequestByPartyId(BigDecimal partyId) throws DAOException {
        return null;
    }

    @Override
    public List findAacLetterRequestBetweenRequestIds(BigDecimal startId, BigDecimal endId) throws DAOException {
        try {
            List lst = super.getHibernateTemplate().find("from AacLetterRequest req where req.identifier > ? and req.identifier <= ?", (Object[])new BigDecimal[]{startId, endId});
            return lst;
        }
        catch (Exception e) {
            throw new DAOException("Failed to find AAC letter request by id", (Throwable)e);
        }
    }

    @Override
    public List findAacLetterRequestBetweenRequestIdsByBatch(BigDecimal startId, BigDecimal endId, int fetchSize) throws DAOException {
        try {
            String query = "aacExportCommand.findRequestsBeweenIds";
            int firstRecord = 0;
            int maxRecord = fetchSize;
            String[] paramNames = new String[]{"prevReqId", "curReqId"};
            Object[] paramValues = new BigDecimal[]{startId, endId};
            List lst = this.dao.find(query, paramNames, paramValues, firstRecord, maxRecord, fetchSize);
            return lst;
        }
        catch (Exception e) {
            throw new DAOException("Failed to find AAC letter request by id", (Throwable)e);
        }
    }

    @Override
    public List findCmsLetterRequests() throws DAOException {
        try {
            String query = "cmsExportCommand.findCmsLetterRequests";
            List lst = this.dao.find(query);
            return lst;
        }
        catch (Exception e) {
            throw new DAOException("Failed to find AAC letter request by id", (Throwable)e);
        }
    }

    @Override
    public List findAacLetterRequestsByLogId(BigDecimal logId) throws DAOException {
        try {
            List lst = super.getHibernateTemplate().find("from AacLetterRequest req where req.commsLogEntry.identifier = ?", (Object)logId);
            return lst;
        }
        catch (Exception e) {
            throw new DAOException("Failed to find AAC letter request by log id", (Throwable)e);
        }
    }

    @Override
    public void insert(AacLetterRequest request) throws DAOException {
        try {
            super.insertObject((Object)request);
            super.getHibernateTemplate().flush();
        }
        catch (DataIntegrityViolationException e) {
            throw new PrintRequestDuplicationException("No duplication letter allowed (same form for the same person per batch). Failed dupe check on COMMS_PRINT_REQUEST", e);
        }
        catch (DAOException ex) {
            if (ex.getCause() instanceof DataIntegrityViolationException) {
                throw new PrintRequestDuplicationException("No duplication letter allowed (same form for the same person per batch). Failed dupe check on COMMS_PRINT_REQUEST", ex.getCause());
            }
            throw ex;
        }
    }

    @Override
    public void deleteById(AacLetterRequest request) throws DAOException {
        super.removeObject(request.getEntityKey());
    }

    @Override
    public void mergeObject(AacLetterRequest request) throws DAOException {
        try {
            this.getHibernateTemplate().merge((Object)request);
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to merge request ", (Throwable)e);
        }
    }

    @Override
    public AacLetterRequest findAacLetterRequestByUniqueCode(String uniqueCode) throws DAOException {
        try {
            List lst = super.getHibernateTemplate().find("from AacLetterRequest req where req.commsPrintRequestDupeCheck = ?", (Object)uniqueCode);
            if (lst != null && lst.size() > 0) {
                return (AacLetterRequest)((Object)lst.get(0));
            }
        }
        catch (Exception e) {
            throw new DAOException("Failed to find AAC letter request by unique code", (Throwable)e);
        }
        return null;
    }
}

