/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.model.security;

import gov.va.med.esr.common.model.lookup.Capability;
import gov.va.med.esr.common.model.security.AbstractPermission;
import gov.va.med.esr.common.model.security.CapabilitySet;
import gov.va.med.esr.common.model.security.ESRRolePrincipal;
import gov.va.med.esr.common.model.security.RoleCapability;
import gov.va.med.esr.common.model.security.RoleCapabilitySet;
import gov.va.med.esr.common.model.security.UserRole;
import gov.va.med.fw.model.RolePrincipalImpl;
import gov.va.med.fw.security.UserPrincipal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

public class ESRRolePrincipalImpl
extends RolePrincipalImpl
implements ESRRolePrincipal,
Comparable {
    private static final long serialVersionUID = 7324046791893823968L;
    private Date activeDate = null;
    private Date inactiveDate = null;
    private Boolean assigned = Boolean.FALSE;
    private Set internalCapabilitySets = null;
    private Set internalCapabilities = null;

    public ESRRolePrincipalImpl() {
    }

    public ESRRolePrincipalImpl(String name) {
        super(name);
    }

    public Date getActiveDate() {
        return this.activeDate;
    }

    public void setActiveDate(Date activeDate) {
        this.activeDate = activeDate;
    }

    public Date getInactiveDate() {
        return this.inactiveDate;
    }

    public void setInactiveDate(Date inactiveDate) {
        this.inactiveDate = inactiveDate;
    }

    public Boolean getAssigned() {
        return this.assigned == null ? Boolean.FALSE : this.assigned;
    }

    public void setAssigned(Boolean assigned) {
        this.assigned = assigned;
    }

    public boolean isActive() {
        return AbstractPermission.isActive(this.activeDate, this.inactiveDate);
    }

    public boolean isAssignable() {
        return AbstractPermission.isAssignable(this.activeDate, this.inactiveDate);
    }

    public boolean isCapabilityAssigned(Capability capability) {
        return this.getCapabilities().contains(capability);
    }

    public boolean isCapabilitySetAssigned(CapabilitySet capabilitySet) {
        return this.getCapabilitySets().contains(capabilitySet);
    }

    public Set getCapabilities() {
        HashSet<Capability> capabilities = new HashSet<Capability>();
        Iterator i = this.getInternalCapabilities().iterator();
        while (i.hasNext()) {
            capabilities.add(((RoleCapability)((Object)i.next())).getCapability());
        }
        return capabilities;
    }

    public List getActiveCapabilities() {
        ArrayList capabilities = new ArrayList();
        if (this.isActive()) {
            capabilities.addAll(this.getCapabilities());
            Iterator i = this.getCapabilitySets().iterator();
            while (i.hasNext()) {
                capabilities.addAll(((CapabilitySet)i.next()).getActiveCapabilities());
            }
        }
        return capabilities;
    }

    public Set getCapabilitySets() {
        HashSet<CapabilitySet> capabilitySets = new HashSet<CapabilitySet>();
        Iterator i = this.getInternalCapabilitySets().iterator();
        while (i.hasNext()) {
            capabilitySets.add(((RoleCapabilitySet)((Object)i.next())).getCapabilitySet());
        }
        return capabilitySets;
    }

    public Set getRoleCapabilities() {
        return Collections.unmodifiableSet(this.getInternalCapabilities());
    }

    public void addCapability(Capability capability) {
        if (this.findRoleCapability(capability) == null) {
            RoleCapability roleCapability = new RoleCapability(this, capability);
            this.getInternalCapabilities().add(roleCapability);
        }
    }

    public void removeCapability(RoleCapability roleCapability) {
        this.getInternalCapabilities().remove((Object)roleCapability);
    }

    public void removeCapability(Capability capability) {
        RoleCapability roleCapability = this.findRoleCapability(capability);
        if (roleCapability != null) {
            this.getInternalCapabilities().remove((Object)roleCapability);
        }
    }

    public Set getRoleCapabilitySets() {
        return Collections.unmodifiableSet(this.getInternalCapabilitySets());
    }

    public void addCapabilitySet(CapabilitySet capabilitySet) {
        if (this.findRoleCapabilitySet(capabilitySet) == null) {
            RoleCapabilitySet roleCapabilitySet = new RoleCapabilitySet(this, capabilitySet);
            this.getInternalCapabilitySets().add(roleCapabilitySet);
        }
    }

    public void removeCapabilitySet(CapabilitySet capabilitySet) {
        RoleCapabilitySet roleCapabilitySet = this.findRoleCapabilitySet(capabilitySet);
        if (roleCapabilitySet != null) {
            this.getInternalCapabilitySets().remove((Object)roleCapabilitySet);
        }
    }

    public RoleCapability findRoleCapability(Capability capability) {
        for (RoleCapability roleCapability : this.getInternalCapabilities()) {
            if (!capability.equals(roleCapability.getCapability())) continue;
            return roleCapability;
        }
        return null;
    }

    public int compareTo(Object o) {
        if (o != null && o instanceof ESRRolePrincipalImpl) {
            return this.getName().compareTo(((ESRRolePrincipalImpl)o).getName());
        }
        return 1;
    }

    private RoleCapabilitySet findRoleCapabilitySet(CapabilitySet capabilitySet) {
        for (RoleCapabilitySet roleCapabilitySet : this.getInternalCapabilitySets()) {
            if (!capabilitySet.getEntityKey().getKeyValueAsString().equals(roleCapabilitySet.getCapabilitySet().getEntityKey().getKeyValueAsString())) continue;
            return roleCapabilitySet;
        }
        return null;
    }

    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
    }

    private Set getInternalCapabilities() {
        if (this.internalCapabilities == null) {
            this.internalCapabilities = new HashSet();
        }
        return this.internalCapabilities;
    }

    private void setInternalCapabilities(Set internalCapabilities) {
        this.internalCapabilities = internalCapabilities;
    }

    private Set getInternalCapabilitySets() {
        if (this.internalCapabilitySets == null) {
            this.internalCapabilitySets = new HashSet();
        }
        return this.internalCapabilitySets;
    }

    private void setInternalCapabilitySets(Set internalCapabilitySets) {
        this.internalCapabilitySets = internalCapabilitySets;
    }

    private Set getInternalRoleUsers() {
        return null;
    }

    private void setInternalRoleUsers(Set internalRoleUsers) {
    }

    public Set getRoleUsers() {
        HashSet<UserPrincipal> users = new HashSet<UserPrincipal>();
        Set set = this.getInternalRoleUsers();
        if (set != null && set.size() > 0) {
            for (UserRole userRole : set) {
                UserPrincipal userPrincipal = userRole.getUserPrincipal();
                if (userPrincipal == null) continue;
                users.add(userPrincipal);
            }
        }
        return Collections.unmodifiableSet(users);
    }

    public void addRoleUser(UserPrincipal userPrincipal) {
        Validate.notNull((Object)userPrincipal, (String)"Can not add null UserPrincipal");
        Set set = this.getInternalRoleUsers();
        if (set != null && this.findUserRole(userPrincipal) == null) {
            UserRole userRole = new UserRole(userPrincipal, this);
            set.add(userRole);
        }
    }

    public void removeRoleUser(UserPrincipal userPrincipal) {
        Validate.notNull((Object)userPrincipal, (String)"Can not remove null UserPrincipal");
        UserRole userRoleToDelete = this.findUserRole(userPrincipal);
        Set set = this.getInternalRoleUsers();
        if (set != null && set.size() > 0 && userRoleToDelete != null) {
            set.remove((Object)userRoleToDelete);
        }
    }

    private UserRole findUserRole(UserPrincipal userPrincipal) {
        Set set = this.getInternalRoleUsers();
        if (set != null && set.size() > 0) {
            for (UserRole userRole : set) {
                if (!userPrincipal.equals(userRole.getUserPrincipal())) continue;
                return userRole;
            }
        }
        return null;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.setInternalCapabilities(null);
        this.setInternalCapabilitySets(null);
        this.setInternalRoleUsers(null);
    }
}

