/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.model.person;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.lookup.Gender;
import gov.va.med.esr.common.model.lookup.Relationship;
import gov.va.med.esr.common.model.lookup.SSNType;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.fw.model.AbstractKeyedEntity;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

public class Relation
extends AbstractKeyedEntity {
    private static final long serialVersionUID = -1370346746640850300L;
    private Person person = null;
    private Relationship relationship = null;
    private Name name = null;
    private Gender gender = null;
    private ImpreciseDate dob = null;
    private ImpreciseDate startDate = null;
    private Date endDate = null;
    private Set internalSsns = null;

    public Person getPerson() {
        return this.person;
    }

    public void setPerson(Person person) {
        this.validateOwner(this.person, person);
        this.person = person;
    }

    public ImpreciseDate getDob() {
        return this.dob;
    }

    public void setDob(ImpreciseDate dob) {
        this.dob = dob;
    }

    public Gender getGender() {
        return this.gender;
    }

    public void setGender(Gender gender) {
        this.gender = gender;
    }

    public Name getName() {
        return this.name;
    }

    public void setName(Name name) {
        this.name = name;
    }

    public ImpreciseDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(ImpreciseDate startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    private Set getInternalSsns() {
        if (this.internalSsns == null) {
            this.internalSsns = new HashSet();
        }
        return this.internalSsns;
    }

    private void setInternalSsns(Set internalSsns) {
        this.internalSsns = internalSsns;
    }

    public Set getSsns() {
        return Collections.unmodifiableSet(this.getInternalSsns());
    }

    public void addSsn(SSN ssn) {
        Validate.notNull((Object)((Object)ssn), (String)"SSN cannot be null");
        this.getInternalSsns().add(ssn);
        ssn.setRelation(this);
    }

    public void removeSsn(SSN ssn) {
        Validate.notNull((Object)((Object)ssn), (String)"SSN cannot be null");
        this.getInternalSsns().remove((Object)ssn);
    }

    public void removeAllSsns() {
        this.getInternalSsns().clear();
    }

    public SSN getPseudoSsn() {
        return SSN.getSSNOfType(this.getInternalSsns(), SSNType.CODE_PSEUDO.getName());
    }

    public SSN getOfficialSsn() {
        return SSN.getSSNOfType(this.getInternalSsns(), SSNType.CODE_ACTIVE.getName());
    }

    public Set getOfficialSsns() {
        Set otherSsns = SSN.getSSNsOfType(this.getInternalSsns(), SSNType.CODE_ACTIVE.getName());
        return Collections.unmodifiableSet(otherSsns);
    }

    public Set getOtherSsns() {
        Set otherSsns = SSN.getSSNsOfType(this.getInternalSsns(), SSNType.CODE_ALIAS.getName());
        return Collections.unmodifiableSet(otherSsns);
    }

    public Relationship getRelationship() {
        return this.relationship;
    }

    public void setRelationship(Relationship relationship) {
        this.relationship = relationship;
    }

    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
        builder.append("name", (Object)this.name);
        builder.append("gender", (Object)this.gender);
        builder.append("dob", (Object)this.dob);
        builder.append("relationship", (Object)this.relationship);
        builder.append("internalSsns", (Object)this.internalSsns);
        builder.append("startDate", (Object)this.startDate);
        builder.append("endDate", (Object)this.endDate);
    }
}

