/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.model.person;

import gov.va.med.esr.common.model.lookup.SelfIdentifiedGenderIdentity;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.service.PersonIdentityTraits;
import gov.va.med.fw.model.AbstractKeyedEntity;
import org.apache.commons.lang.builder.ToStringBuilder;

public class PersonTraits
extends AbstractKeyedEntity {
    private static final long serialVersionUID = -8851818840737926706L;
    private String givenName = null;
    private String middleName = null;
    private String familyName = null;
    private String ssn = null;
    private String vpid = null;
    private String gender = null;
    private String birthDate = null;
    private SelfIdentifiedGenderIdentity sigi = null;

    public String getFamilyName() {
        return this.familyName;
    }

    public String getGivenName() {
        return this.givenName;
    }

    public String getMiddleName() {
        return this.middleName;
    }

    public String getSsn() {
        return this.ssn;
    }

    public String getVpid() {
        return this.vpid;
    }

    public String getGender() {
        return this.gender;
    }

    public String getBirthDate() {
        return this.birthDate;
    }

    public void setFamilyName(String familyName) {
        this.familyName = familyName;
    }

    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    public void setSsn(String ssn) {
        this.ssn = ssn;
    }

    public void setVpid(String VPID2) {
        this.vpid = VPID2;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public SelfIdentifiedGenderIdentity getSigi() {
        return this.sigi;
    }

    public void setSigi(SelfIdentifiedGenderIdentity sigi) {
        this.sigi = sigi;
    }

    public void setBirthDate(String birthDate) {
        this.birthDate = birthDate;
    }

    public String getFormattedName() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.familyName == null ? "" : this.familyName + ",");
        buffer.append(this.givenName == null ? "" : this.givenName + " ");
        buffer.append(this.middleName == null ? "" : this.middleName);
        return buffer.toString();
    }

    public void setTraits(PersonIdentityTraits identityTraits) {
        if (identityTraits != null) {
            this.setSsn(identityTraits.getSsn());
            this.setName(identityTraits.getLegalName());
            this.setVpid(identityTraits.getVpid().getVPID());
            if (identityTraits.getGender() != null) {
                this.setGender(identityTraits.getGender().getCode());
            }
            if (identityTraits.getBirthRecord() != null && identityTraits.getBirthRecord().getBirthDate() != null) {
                this.setBirthDate(identityTraits.getBirthRecord().getBirthDate().toStandardFormat());
            }
        }
    }

    private void setSsn(SSN ssn) {
        if (ssn != null) {
            this.ssn = ssn.getSsnText();
        }
    }

    private void setName(Name name) {
        if (name != null) {
            this.givenName = name.getGivenName();
            this.middleName = name.getMiddleName();
            this.familyName = name.getFamilyName();
        }
    }

    protected void buildToString(ToStringBuilder builder) {
    }
}

