/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.model.party;

import gov.va.med.esr.common.model.insurance.InsurancePolicy;
import gov.va.med.esr.common.model.lookup.PhoneSourceOfChange;
import gov.va.med.esr.common.model.lookup.PhoneType;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.Spouse;
import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.util.StringUtils;
import java.util.Date;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.builder.ToStringBuilder;

public class Phone
extends AbstractKeyedEntity {
    private static final long serialVersionUID = 6489355045450738752L;
    private static final String PATTERN_PHONE = "[\\(]?(\\d{3})??[\\)]?[\\-\\.]?(\\d{3})?[\\-\\.]?(\\d{4})?(?:x[\\-]?(\\d{1,4}))?";
    private static final int PATTERN_GROUP_AREA_CODE = 1;
    private static final int PATTERN_GROUP_NPA = 2;
    private static final int PATTERN_GROUP_NXX = 3;
    private static final int PATTERN_GROUP_EXT = 4;
    private PhoneType type;
    private String phoneNumber;
    private PhoneSourceOfChange sourceOfChange;
    private VAFacility siteOfChange;
    private Date changeDate;
    private Person person;
    private Spouse spouse;
    private InsurancePolicy insurancePolicy;

    public PhoneType getType() {
        return this.type;
    }

    public void setType(PhoneType type) {
        this.type = type;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public PhoneSourceOfChange getSourceOfChange() {
        return this.sourceOfChange;
    }

    public void setSourceOfChange(PhoneSourceOfChange sourceOfChange) {
        this.sourceOfChange = sourceOfChange;
    }

    public VAFacility getSiteOfChange() {
        return this.siteOfChange;
    }

    public void setSiteOfChange(VAFacility site) {
        this.siteOfChange = site;
    }

    public Date getChangeDate() {
        return this.changeDate;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }

    public String getFormattedPhone() {
        return Phone.getFormattedPhone(this.getPhoneNumber());
    }

    public static String getFormattedPhone(String phoneNumber) {
        StringBuffer resultBuffer = new StringBuffer();
        if (StringUtils.isNotEmpty((String)phoneNumber)) {
            String areaCode = null;
            String npa = null;
            String nxx = null;
            String ext = null;
            String filteredPhoneNumber = phoneNumber.replaceAll(" ", "");
            Matcher matcher = Pattern.compile(PATTERN_PHONE).matcher(filteredPhoneNumber);
            if (matcher.matches()) {
                areaCode = matcher.group(1);
                npa = matcher.group(2);
                nxx = matcher.group(3);
                ext = matcher.group(4);
            } else {
                filteredPhoneNumber = filteredPhoneNumber.toUpperCase();
                filteredPhoneNumber = filteredPhoneNumber.replaceAll("\\(", "");
                filteredPhoneNumber = filteredPhoneNumber.replaceAll("\\)", "");
                filteredPhoneNumber = filteredPhoneNumber.replaceAll("X", "");
                filteredPhoneNumber = filteredPhoneNumber.replaceAll("x", "");
                filteredPhoneNumber = filteredPhoneNumber.replaceAll("-", "");
                filteredPhoneNumber = filteredPhoneNumber.replaceAll("\\.", "");
                StringBuffer filterBuffer = new StringBuffer(filteredPhoneNumber);
                areaCode = Phone.getPhonePiece(filterBuffer, 3);
                npa = Phone.getPhonePiece(filterBuffer, 3);
                nxx = Phone.getPhonePiece(filterBuffer, 4);
                ext = filterBuffer.toString();
            }
            if (StringUtils.isNotEmpty((String)areaCode)) {
                resultBuffer.append("(");
                resultBuffer.append(areaCode);
                resultBuffer.append(")");
            }
            if (StringUtils.isNotEmpty((String)npa)) {
                resultBuffer.append(npa);
                if (StringUtils.isNotEmpty((String)nxx)) {
                    resultBuffer.append("-");
                }
            }
            if (StringUtils.isNotEmpty((String)nxx)) {
                resultBuffer.append(nxx);
            }
            if (StringUtils.isNotEmpty((String)ext)) {
                resultBuffer.append("X");
                resultBuffer.append(ext);
            }
        }
        return resultBuffer.toString();
    }

    protected static String getPhonePiece(StringBuffer phoneBuffer, int numChars) {
        String returnValue = null;
        if (phoneBuffer.length() > numChars) {
            returnValue = phoneBuffer.substring(0, numChars);
            phoneBuffer.delete(0, numChars);
        } else {
            returnValue = phoneBuffer.toString();
            phoneBuffer.delete(0, phoneBuffer.length());
        }
        return returnValue;
    }

    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
        builder.append("type", (Object)this.type);
        builder.append("phoneNumber", (Object)this.phoneNumber);
        builder.append("changeDate", (Object)this.changeDate);
    }

    public Person getPerson() {
        return this.person;
    }

    public void setPerson(Person person) {
        this.validateOwner(this.person, person);
        this.person = person;
    }

    public Spouse getSpouse() {
        return this.spouse;
    }

    public void setSpouse(Spouse spouse) {
        this.validateOwner(this.spouse, spouse);
        this.spouse = spouse;
    }

    public InsurancePolicy getInsurancePolicy() {
        return this.insurancePolicy;
    }

    public void setInsurancePolicy(InsurancePolicy insurancePolicy) {
        this.insurancePolicy = insurancePolicy;
    }

    public static Phone getPhoneOfType(Set phones, String typeCode) {
        for (Phone phone : phones) {
            if (phone == null || phone.getType() == null || phone.getType().getCode() == null || !phone.getType().getCode().equals(typeCode)) continue;
            return phone;
        }
        return null;
    }
}

